/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.errorreporting.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.GrpcTransport;
import com.google.api.gax.grpc.GrpcTransportProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.SimpleCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.errorreporting.v1beta1.PagedResponseWrappers;
import com.google.cloud.errorreporting.v1beta1.stub.ErrorStatsServiceStub;
import com.google.cloud.errorreporting.v1beta1.stub.GrpcErrorStatsServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.devtools.clouderrorreporting.v1beta1.DeleteEventsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.DeleteEventsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorEvent;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorGroupStats;
import com.google.devtools.clouderrorreporting.v1beta1.ListEventsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ListEventsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ListGroupStatsResponse;
import io.grpc.Status;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ErrorStatsServiceSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/errorreporting/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private final PagedCallSettings<ListGroupStatsRequest, ListGroupStatsResponse, PagedResponseWrappers.ListGroupStatsPagedResponse> listGroupStatsSettings;
    private final PagedCallSettings<ListEventsRequest, ListEventsResponse, PagedResponseWrappers.ListEventsPagedResponse> listEventsSettings;
    private final SimpleCallSettings<DeleteEventsRequest, DeleteEventsResponse> deleteEventsSettings;
    private static final PagedListDescriptor<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats> LIST_GROUP_STATS_PAGE_STR_DESC;
    private static final PagedListDescriptor<ListEventsRequest, ListEventsResponse, ErrorEvent> LIST_EVENTS_PAGE_STR_DESC;
    private static final PagedListResponseFactory<ListGroupStatsRequest, ListGroupStatsResponse, PagedResponseWrappers.ListGroupStatsPagedResponse> LIST_GROUP_STATS_PAGE_STR_FACT;
    private static final PagedListResponseFactory<ListEventsRequest, ListEventsResponse, PagedResponseWrappers.ListEventsPagedResponse> LIST_EVENTS_PAGE_STR_FACT;

    public PagedCallSettings<ListGroupStatsRequest, ListGroupStatsResponse, PagedResponseWrappers.ListGroupStatsPagedResponse> listGroupStatsSettings() {
        return this.listGroupStatsSettings;
    }

    public PagedCallSettings<ListEventsRequest, ListEventsResponse, PagedResponseWrappers.ListEventsPagedResponse> listEventsSettings() {
        return this.listEventsSettings;
    }

    public SimpleCallSettings<DeleteEventsRequest, DeleteEventsResponse> deleteEventsSettings() {
        return this.deleteEventsSettings;
    }

    public ErrorStatsServiceStub createStub() throws IOException {
        if (this.getTransportProvider().getTransportName().equals(GrpcTransport.getGrpcTransportName())) {
            return GrpcErrorStatsServiceStub.create(this);
        }
        String string = String.valueOf(this.getTransportProvider().getTransportName());
        throw new UnsupportedOperationException(string.length() != 0 ? "Transport not supported: ".concat(string) : new String("Transport not supported: "));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "clouderrorreporting.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultGrpcChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(ErrorStatsServiceSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, ErrorStatsServiceSettings.getGapicVersion());
    }

    public static GrpcTransportProvider.Builder defaultGrpcTransportProviderBuilder() {
        return GrpcTransportProvider.newBuilder().setChannelProvider((ChannelProvider)ErrorStatsServiceSettings.defaultGrpcChannelProviderBuilder().build());
    }

    public static TransportProvider defaultTransportProvider() {
        return ErrorStatsServiceSettings.defaultGrpcTransportProviderBuilder().build();
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(ErrorStatsServiceSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    @Deprecated
    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    @Deprecated
    public static Builder defaultBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ErrorStatsServiceSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getTransportProvider(), settingsBuilder.getCredentialsProvider(), settingsBuilder.getClock());
        this.listGroupStatsSettings = settingsBuilder.listGroupStatsSettings().build();
        this.listEventsSettings = settingsBuilder.listEventsSettings().build();
        this.deleteEventsSettings = settingsBuilder.deleteEventsSettings().build();
    }

    static {
        LIST_GROUP_STATS_PAGE_STR_DESC = new PagedListDescriptor<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats>(){

            public String emptyToken() {
                return ErrorStatsServiceSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListGroupStatsRequest injectToken(ListGroupStatsRequest payload, String token) {
                return ListGroupStatsRequest.newBuilder((ListGroupStatsRequest)payload).setPageToken(token).build();
            }

            public ListGroupStatsRequest injectPageSize(ListGroupStatsRequest payload, int pageSize) {
                return ListGroupStatsRequest.newBuilder((ListGroupStatsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListGroupStatsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListGroupStatsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<ErrorGroupStats> extractResources(ListGroupStatsResponse payload) {
                return payload.getErrorGroupStatsList();
            }
        };
        LIST_EVENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEventsRequest, ListEventsResponse, ErrorEvent>(){

            public String emptyToken() {
                return ErrorStatsServiceSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListEventsRequest injectToken(ListEventsRequest payload, String token) {
                return ListEventsRequest.newBuilder((ListEventsRequest)payload).setPageToken(token).build();
            }

            public ListEventsRequest injectPageSize(ListEventsRequest payload, int pageSize) {
                return ListEventsRequest.newBuilder((ListEventsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListEventsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListEventsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<ErrorEvent> extractResources(ListEventsResponse payload) {
                return payload.getErrorEventsList();
            }
        };
        LIST_GROUP_STATS_PAGE_STR_FACT = new PagedListResponseFactory<ListGroupStatsRequest, ListGroupStatsResponse, PagedResponseWrappers.ListGroupStatsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListGroupStatsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGroupStatsRequest, ListGroupStatsResponse> callable, ListGroupStatsRequest request, ApiCallContext context, ApiFuture<ListGroupStatsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GROUP_STATS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
                return PagedResponseWrappers.ListGroupStatsPagedResponse.createAsync((PageContext<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats>)pageContext, futureResponse);
            }
        };
        LIST_EVENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEventsRequest, ListEventsResponse, PagedResponseWrappers.ListEventsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListEventsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEventsRequest, ListEventsResponse> callable, ListEventsRequest request, ApiCallContext context, ApiFuture<ListEventsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EVENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
                return PagedResponseWrappers.ListEventsPagedResponse.createAsync((PageContext<ListEventsRequest, ListEventsResponse, ErrorEvent>)pageContext, futureResponse);
            }
        };
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListGroupStatsRequest, ListGroupStatsResponse, PagedResponseWrappers.ListGroupStatsPagedResponse> listGroupStatsSettings;
        private final PagedCallSettings.Builder<ListEventsRequest, ListEventsResponse, PagedResponseWrappers.ListEventsPagedResponse> listEventsSettings;
        private final SimpleCallSettings.Builder<DeleteEventsRequest, DeleteEventsResponse> deleteEventsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            this((ClientContext)null);
        }

        private Builder(ClientContext clientContext) {
            super(clientContext);
            this.listGroupStatsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GROUP_STATS_PAGE_STR_FACT);
            this.listEventsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EVENTS_PAGE_STR_FACT);
            this.deleteEventsSettings = SimpleCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGroupStatsSettings, this.listEventsSettings, this.deleteEventsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportProvider(ErrorStatsServiceSettings.defaultTransportProvider());
            builder.setCredentialsProvider((CredentialsProvider)ErrorStatsServiceSettings.defaultCredentialsProviderBuilder().build());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listGroupStatsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(ErrorStatsServiceSettings settings) {
            super((ClientSettings)settings);
            this.listGroupStatsSettings = settings.listGroupStatsSettings.toBuilder();
            this.listEventsSettings = settings.listEventsSettings.toBuilder();
            this.deleteEventsSettings = settings.deleteEventsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGroupStatsSettings, this.listEventsSettings, this.deleteEventsSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setTransportProvider(TransportProvider transportProvider) {
            super.setTransportProvider(transportProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            super.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder, Void> settingsUpdater) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public PagedCallSettings.Builder<ListGroupStatsRequest, ListGroupStatsResponse, PagedResponseWrappers.ListGroupStatsPagedResponse> listGroupStatsSettings() {
            return this.listGroupStatsSettings;
        }

        public PagedCallSettings.Builder<ListEventsRequest, ListEventsResponse, PagedResponseWrappers.ListEventsPagedResponse> listEventsSettings() {
            return this.listEventsSettings;
        }

        public SimpleCallSettings.Builder<DeleteEventsRequest, DeleteEventsResponse> deleteEventsSettings() {
            return this.deleteEventsSettings;
        }

        public ErrorStatsServiceSettings build() throws IOException {
            return new ErrorStatsServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode[]{GrpcStatusCode.of((Status.Code)Status.Code.DEADLINE_EXCEEDED), GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE)})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

