/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.errorreporting.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.errorreporting.v1beta1.ErrorGroupServiceSettings;
import com.google.cloud.errorreporting.v1beta1.stub.ErrorGroupServiceStub;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorGroup;
import com.google.devtools.clouderrorreporting.v1beta1.GetGroupRequest;
import com.google.devtools.clouderrorreporting.v1beta1.GroupName;
import com.google.devtools.clouderrorreporting.v1beta1.UpdateGroupRequest;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ErrorGroupServiceClient
implements BackgroundResource {
    private final ErrorGroupServiceSettings settings;
    private final ErrorGroupServiceStub stub;

    public static final ErrorGroupServiceClient create() throws IOException {
        return ErrorGroupServiceClient.create(ErrorGroupServiceSettings.defaultBuilder().build());
    }

    public static final ErrorGroupServiceClient create(ErrorGroupServiceSettings settings) throws IOException {
        return new ErrorGroupServiceClient(settings);
    }

    public static final ErrorGroupServiceClient create(ErrorGroupServiceStub stub) {
        return new ErrorGroupServiceClient(stub);
    }

    protected ErrorGroupServiceClient(ErrorGroupServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    protected ErrorGroupServiceClient(ErrorGroupServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ErrorGroupServiceSettings getSettings() {
        return this.settings;
    }

    public ErrorGroupServiceStub getStub() {
        return this.stub;
    }

    public final ErrorGroup getGroup(GroupName groupName) {
        GetGroupRequest request = GetGroupRequest.newBuilder().setGroupNameWithGroupName(groupName).build();
        return this.getGroup(request);
    }

    private final ErrorGroup getGroup(GetGroupRequest request) {
        return (ErrorGroup)this.getGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetGroupRequest, ErrorGroup> getGroupCallable() {
        return this.stub.getGroupCallable();
    }

    public final ErrorGroup updateGroup(ErrorGroup group) {
        UpdateGroupRequest request = UpdateGroupRequest.newBuilder().setGroup(group).build();
        return this.updateGroup(request);
    }

    private final ErrorGroup updateGroup(UpdateGroupRequest request) {
        return (ErrorGroup)this.updateGroupCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateGroupRequest, ErrorGroup> updateGroupCallable() {
        return this.stub.updateGroupCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

