/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.errorreporting.v1beta1;

import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.errorreporting.v1beta1.ErrorGroupServiceSettings;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorGroup;
import com.google.devtools.clouderrorreporting.v1beta1.GetGroupRequest;
import com.google.devtools.clouderrorreporting.v1beta1.GroupName;
import com.google.devtools.clouderrorreporting.v1beta1.UpdateGroupRequest;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class ErrorGroupServiceClient
implements AutoCloseable {
    private final ErrorGroupServiceSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<GetGroupRequest, ErrorGroup> getGroupCallable;
    private final UnaryCallable<UpdateGroupRequest, ErrorGroup> updateGroupCallable;

    public static final ErrorGroupServiceClient create() throws IOException {
        return ErrorGroupServiceClient.create(ErrorGroupServiceSettings.defaultBuilder().build());
    }

    public static final ErrorGroupServiceClient create(ErrorGroupServiceSettings settings) throws IOException {
        return new ErrorGroupServiceClient(settings);
    }

    protected ErrorGroupServiceClient(ErrorGroupServiceSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        this.getGroupCallable = UnaryCallable.create(settings.getGroupSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.updateGroupCallable = UnaryCallable.create(settings.updateGroupSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ErrorGroupServiceClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ErrorGroupServiceClient.this.executor.shutdown();
                }
            });
        }
    }

    public final ErrorGroupServiceSettings getSettings() {
        return this.settings;
    }

    public final ErrorGroup getGroup(GroupName groupName) {
        GetGroupRequest request = GetGroupRequest.newBuilder().setGroupNameWithGroupName(groupName).build();
        return this.getGroup(request);
    }

    private final ErrorGroup getGroup(GetGroupRequest request) {
        return (ErrorGroup)this.getGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetGroupRequest, ErrorGroup> getGroupCallable() {
        return this.getGroupCallable;
    }

    public final ErrorGroup updateGroup(ErrorGroup group) {
        UpdateGroupRequest request = UpdateGroupRequest.newBuilder().setGroup(group).build();
        return this.updateGroup(request);
    }

    private final ErrorGroup updateGroup(UpdateGroupRequest request) {
        return (ErrorGroup)this.updateGroupCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateGroupRequest, ErrorGroup> updateGroupCallable() {
        return this.updateGroupCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

