/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.enterpriseknowledgegraph.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.enterpriseknowledgegraph.v1.CancelEntityReconciliationJobRequest;
import com.google.cloud.enterpriseknowledgegraph.v1.CreateEntityReconciliationJobRequest;
import com.google.cloud.enterpriseknowledgegraph.v1.DeleteEntityReconciliationJobRequest;
import com.google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphServiceSettings;
import com.google.cloud.enterpriseknowledgegraph.v1.EntityReconciliationJob;
import com.google.cloud.enterpriseknowledgegraph.v1.EntityReconciliationJobName;
import com.google.cloud.enterpriseknowledgegraph.v1.GetEntityReconciliationJobRequest;
import com.google.cloud.enterpriseknowledgegraph.v1.ListEntityReconciliationJobsRequest;
import com.google.cloud.enterpriseknowledgegraph.v1.ListEntityReconciliationJobsResponse;
import com.google.cloud.enterpriseknowledgegraph.v1.LocationName;
import com.google.cloud.enterpriseknowledgegraph.v1.stub.EnterpriseKnowledgeGraphServiceStub;
import com.google.cloud.enterpriseknowledgegraph.v1.stub.EnterpriseKnowledgeGraphServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class EnterpriseKnowledgeGraphServiceClient
implements BackgroundResource {
    private final EnterpriseKnowledgeGraphServiceSettings settings;
    private final EnterpriseKnowledgeGraphServiceStub stub;

    public static final EnterpriseKnowledgeGraphServiceClient create() throws IOException {
        return EnterpriseKnowledgeGraphServiceClient.create(EnterpriseKnowledgeGraphServiceSettings.newBuilder().build());
    }

    public static final EnterpriseKnowledgeGraphServiceClient create(EnterpriseKnowledgeGraphServiceSettings settings) throws IOException {
        return new EnterpriseKnowledgeGraphServiceClient(settings);
    }

    public static final EnterpriseKnowledgeGraphServiceClient create(EnterpriseKnowledgeGraphServiceStub stub) {
        return new EnterpriseKnowledgeGraphServiceClient(stub);
    }

    protected EnterpriseKnowledgeGraphServiceClient(EnterpriseKnowledgeGraphServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EnterpriseKnowledgeGraphServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected EnterpriseKnowledgeGraphServiceClient(EnterpriseKnowledgeGraphServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final EnterpriseKnowledgeGraphServiceSettings getSettings() {
        return this.settings;
    }

    public EnterpriseKnowledgeGraphServiceStub getStub() {
        return this.stub;
    }

    public final EntityReconciliationJob createEntityReconciliationJob(LocationName parent, EntityReconciliationJob entityReconciliationJob) {
        CreateEntityReconciliationJobRequest request = CreateEntityReconciliationJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEntityReconciliationJob(entityReconciliationJob).build();
        return this.createEntityReconciliationJob(request);
    }

    public final EntityReconciliationJob createEntityReconciliationJob(String parent, EntityReconciliationJob entityReconciliationJob) {
        CreateEntityReconciliationJobRequest request = CreateEntityReconciliationJobRequest.newBuilder().setParent(parent).setEntityReconciliationJob(entityReconciliationJob).build();
        return this.createEntityReconciliationJob(request);
    }

    public final EntityReconciliationJob createEntityReconciliationJob(CreateEntityReconciliationJobRequest request) {
        return (EntityReconciliationJob)this.createEntityReconciliationJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEntityReconciliationJobRequest, EntityReconciliationJob> createEntityReconciliationJobCallable() {
        return this.stub.createEntityReconciliationJobCallable();
    }

    public final EntityReconciliationJob getEntityReconciliationJob(EntityReconciliationJobName name) {
        GetEntityReconciliationJobRequest request = GetEntityReconciliationJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEntityReconciliationJob(request);
    }

    public final EntityReconciliationJob getEntityReconciliationJob(String name) {
        GetEntityReconciliationJobRequest request = GetEntityReconciliationJobRequest.newBuilder().setName(name).build();
        return this.getEntityReconciliationJob(request);
    }

    public final EntityReconciliationJob getEntityReconciliationJob(GetEntityReconciliationJobRequest request) {
        return (EntityReconciliationJob)this.getEntityReconciliationJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntityReconciliationJobRequest, EntityReconciliationJob> getEntityReconciliationJobCallable() {
        return this.stub.getEntityReconciliationJobCallable();
    }

    public final ListEntityReconciliationJobsPagedResponse listEntityReconciliationJobs(LocationName parent) {
        ListEntityReconciliationJobsRequest request = ListEntityReconciliationJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntityReconciliationJobs(request);
    }

    public final ListEntityReconciliationJobsPagedResponse listEntityReconciliationJobs(String parent) {
        ListEntityReconciliationJobsRequest request = ListEntityReconciliationJobsRequest.newBuilder().setParent(parent).build();
        return this.listEntityReconciliationJobs(request);
    }

    public final ListEntityReconciliationJobsPagedResponse listEntityReconciliationJobs(ListEntityReconciliationJobsRequest request) {
        return (ListEntityReconciliationJobsPagedResponse)((Object)this.listEntityReconciliationJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntityReconciliationJobsRequest, ListEntityReconciliationJobsPagedResponse> listEntityReconciliationJobsPagedCallable() {
        return this.stub.listEntityReconciliationJobsPagedCallable();
    }

    public final UnaryCallable<ListEntityReconciliationJobsRequest, ListEntityReconciliationJobsResponse> listEntityReconciliationJobsCallable() {
        return this.stub.listEntityReconciliationJobsCallable();
    }

    public final void cancelEntityReconciliationJob(EntityReconciliationJobName name) {
        CancelEntityReconciliationJobRequest request = CancelEntityReconciliationJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.cancelEntityReconciliationJob(request);
    }

    public final void cancelEntityReconciliationJob(String name) {
        CancelEntityReconciliationJobRequest request = CancelEntityReconciliationJobRequest.newBuilder().setName(name).build();
        this.cancelEntityReconciliationJob(request);
    }

    public final void cancelEntityReconciliationJob(CancelEntityReconciliationJobRequest request) {
        this.cancelEntityReconciliationJobCallable().call((Object)request);
    }

    public final UnaryCallable<CancelEntityReconciliationJobRequest, Empty> cancelEntityReconciliationJobCallable() {
        return this.stub.cancelEntityReconciliationJobCallable();
    }

    public final void deleteEntityReconciliationJob(EntityReconciliationJobName name) {
        DeleteEntityReconciliationJobRequest request = DeleteEntityReconciliationJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteEntityReconciliationJob(request);
    }

    public final void deleteEntityReconciliationJob(String name) {
        DeleteEntityReconciliationJobRequest request = DeleteEntityReconciliationJobRequest.newBuilder().setName(name).build();
        this.deleteEntityReconciliationJob(request);
    }

    public final void deleteEntityReconciliationJob(DeleteEntityReconciliationJobRequest request) {
        this.deleteEntityReconciliationJobCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEntityReconciliationJobRequest, Empty> deleteEntityReconciliationJobCallable() {
        return this.stub.deleteEntityReconciliationJobCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListEntityReconciliationJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEntityReconciliationJobsRequest, ListEntityReconciliationJobsResponse, EntityReconciliationJob, ListEntityReconciliationJobsPage, ListEntityReconciliationJobsFixedSizeCollection> {
        private ListEntityReconciliationJobsFixedSizeCollection(List<ListEntityReconciliationJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEntityReconciliationJobsFixedSizeCollection createEmptyCollection() {
            return new ListEntityReconciliationJobsFixedSizeCollection(null, 0);
        }

        protected ListEntityReconciliationJobsFixedSizeCollection createCollection(List<ListEntityReconciliationJobsPage> pages, int collectionSize) {
            return new ListEntityReconciliationJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEntityReconciliationJobsPage
    extends AbstractPage<ListEntityReconciliationJobsRequest, ListEntityReconciliationJobsResponse, EntityReconciliationJob, ListEntityReconciliationJobsPage> {
        private ListEntityReconciliationJobsPage(PageContext<ListEntityReconciliationJobsRequest, ListEntityReconciliationJobsResponse, EntityReconciliationJob> context, ListEntityReconciliationJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListEntityReconciliationJobsPage createEmptyPage() {
            return new ListEntityReconciliationJobsPage(null, null);
        }

        protected ListEntityReconciliationJobsPage createPage(PageContext<ListEntityReconciliationJobsRequest, ListEntityReconciliationJobsResponse, EntityReconciliationJob> context, ListEntityReconciliationJobsResponse response) {
            return new ListEntityReconciliationJobsPage(context, response);
        }

        public ApiFuture<ListEntityReconciliationJobsPage> createPageAsync(PageContext<ListEntityReconciliationJobsRequest, ListEntityReconciliationJobsResponse, EntityReconciliationJob> context, ApiFuture<ListEntityReconciliationJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEntityReconciliationJobsPagedResponse
    extends AbstractPagedListResponse<ListEntityReconciliationJobsRequest, ListEntityReconciliationJobsResponse, EntityReconciliationJob, ListEntityReconciliationJobsPage, ListEntityReconciliationJobsFixedSizeCollection> {
        public static ApiFuture<ListEntityReconciliationJobsPagedResponse> createAsync(PageContext<ListEntityReconciliationJobsRequest, ListEntityReconciliationJobsResponse, EntityReconciliationJob> context, ApiFuture<ListEntityReconciliationJobsResponse> futureResponse) {
            ApiFuture<ListEntityReconciliationJobsPage> futurePage = ListEntityReconciliationJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEntityReconciliationJobsPagedResponse((ListEntityReconciliationJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEntityReconciliationJobsPagedResponse(ListEntityReconciliationJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEntityReconciliationJobsFixedSizeCollection.createEmptyCollection());
        }
    }
}

