/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.documentai.v1beta1.BatchProcessDocumentsRequest;
import com.google.cloud.documentai.v1beta1.BatchProcessDocumentsResponse;
import com.google.cloud.documentai.v1beta1.DocumentUnderstandingServiceSettings;
import com.google.cloud.documentai.v1beta1.OperationMetadata;
import com.google.cloud.documentai.v1beta1.ProcessDocumentRequest;
import com.google.cloud.documentai.v1beta1.stub.DocumentUnderstandingServiceStub;
import com.google.cloud.documentai.v1beta1.stub.DocumentUnderstandingServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DocumentUnderstandingServiceClient
implements BackgroundResource {
    private final DocumentUnderstandingServiceSettings settings;
    private final DocumentUnderstandingServiceStub stub;
    private final OperationsClient operationsClient;

    public static final DocumentUnderstandingServiceClient create() throws IOException {
        return DocumentUnderstandingServiceClient.create(DocumentUnderstandingServiceSettings.newBuilder().build());
    }

    public static final DocumentUnderstandingServiceClient create(DocumentUnderstandingServiceSettings settings) throws IOException {
        return new DocumentUnderstandingServiceClient(settings);
    }

    public static final DocumentUnderstandingServiceClient create(DocumentUnderstandingServiceStub stub) {
        return new DocumentUnderstandingServiceClient(stub);
    }

    protected DocumentUnderstandingServiceClient(DocumentUnderstandingServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DocumentUnderstandingServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected DocumentUnderstandingServiceClient(DocumentUnderstandingServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DocumentUnderstandingServiceSettings getSettings() {
        return this.settings;
    }

    public DocumentUnderstandingServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<BatchProcessDocumentsResponse, OperationMetadata> batchProcessDocumentsAsync(List<ProcessDocumentRequest> requests) {
        BatchProcessDocumentsRequest request = BatchProcessDocumentsRequest.newBuilder().addAllRequests(requests).build();
        return this.batchProcessDocumentsAsync(request);
    }

    public final OperationFuture<BatchProcessDocumentsResponse, OperationMetadata> batchProcessDocumentsAsync(BatchProcessDocumentsRequest request) {
        return this.batchProcessDocumentsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchProcessDocumentsRequest, BatchProcessDocumentsResponse, OperationMetadata> batchProcessDocumentsOperationCallable() {
        return this.stub.batchProcessDocumentsOperationCallable();
    }

    public final UnaryCallable<BatchProcessDocumentsRequest, Operation> batchProcessDocumentsCallable() {
        return this.stub.batchProcessDocumentsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

