/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.documentai.v1beta3.BatchProcessMetadata;
import com.google.cloud.documentai.v1beta3.BatchProcessRequest;
import com.google.cloud.documentai.v1beta3.BatchProcessResponse;
import com.google.cloud.documentai.v1beta3.CreateProcessorRequest;
import com.google.cloud.documentai.v1beta3.DeleteProcessorMetadata;
import com.google.cloud.documentai.v1beta3.DeleteProcessorRequest;
import com.google.cloud.documentai.v1beta3.DisableProcessorMetadata;
import com.google.cloud.documentai.v1beta3.DisableProcessorRequest;
import com.google.cloud.documentai.v1beta3.DisableProcessorResponse;
import com.google.cloud.documentai.v1beta3.DocumentProcessorServiceClient;
import com.google.cloud.documentai.v1beta3.EnableProcessorMetadata;
import com.google.cloud.documentai.v1beta3.EnableProcessorRequest;
import com.google.cloud.documentai.v1beta3.EnableProcessorResponse;
import com.google.cloud.documentai.v1beta3.FetchProcessorTypesRequest;
import com.google.cloud.documentai.v1beta3.FetchProcessorTypesResponse;
import com.google.cloud.documentai.v1beta3.ListProcessorsRequest;
import com.google.cloud.documentai.v1beta3.ListProcessorsResponse;
import com.google.cloud.documentai.v1beta3.ProcessRequest;
import com.google.cloud.documentai.v1beta3.ProcessResponse;
import com.google.cloud.documentai.v1beta3.Processor;
import com.google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata;
import com.google.cloud.documentai.v1beta3.ReviewDocumentRequest;
import com.google.cloud.documentai.v1beta3.ReviewDocumentResponse;
import com.google.cloud.documentai.v1beta3.stub.DocumentProcessorServiceStub;
import com.google.cloud.documentai.v1beta3.stub.DocumentProcessorServiceStubSettings;
import com.google.cloud.documentai.v1beta3.stub.HttpJsonDocumentProcessorServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonDocumentProcessorServiceStub
extends DocumentProcessorServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(BatchProcessMetadata.getDescriptor()).add(Empty.getDescriptor()).add(DisableProcessorMetadata.getDescriptor()).add(EnableProcessorMetadata.getDescriptor()).add(DeleteProcessorMetadata.getDescriptor()).add(ReviewDocumentResponse.getDescriptor()).add(EnableProcessorResponse.getDescriptor()).add(BatchProcessResponse.getDescriptor()).add(DisableProcessorResponse.getDescriptor()).add(ReviewDocumentOperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<ProcessRequest, ProcessResponse> processDocumentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/ProcessDocument").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta3/{name=projects/*/locations/*/processors/*}:process", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ProcessResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchProcessRequest, Operation> batchProcessDocumentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/BatchProcessDocuments").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta3/{name=projects/*/locations/*/processors/*}:batchProcess", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/FetchProcessorTypes").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta3/{parent=projects/*/locations/*}:fetchProcessorTypes", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FetchProcessorTypesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListProcessorsRequest, ListProcessorsResponse> listProcessorsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/ListProcessors").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta3/{parent=projects/*/locations/*}/processors", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListProcessorsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateProcessorRequest, Processor> createProcessorMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/CreateProcessor").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta3/{parent=projects/*/locations/*}/processors", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("processor", (Message)request.getProcessor())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Processor.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteProcessorRequest, Operation> deleteProcessorMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/DeleteProcessor").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta3/{name=projects/*/locations/*/processors/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<EnableProcessorRequest, Operation> enableProcessorMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/EnableProcessor").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta3/{name=projects/*/locations/*/processors/*}:enable", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DisableProcessorRequest, Operation> disableProcessorMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/DisableProcessor").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta3/{name=projects/*/locations/*/processors/*}:disable", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ReviewDocumentRequest, Operation> reviewDocumentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/ReviewDocument").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta3/{humanReviewConfig=projects/*/locations/*/processors/*/humanReviewConfig}:reviewDocument", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "humanReviewConfig", (Object)request.getHumanReviewConfig());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearHumanReviewConfig().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<ProcessRequest, ProcessResponse> processDocumentCallable;
    private final UnaryCallable<BatchProcessRequest, Operation> batchProcessDocumentsCallable;
    private final OperationCallable<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationCallable;
    private final UnaryCallable<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesCallable;
    private final UnaryCallable<ListProcessorsRequest, ListProcessorsResponse> listProcessorsCallable;
    private final UnaryCallable<ListProcessorsRequest, DocumentProcessorServiceClient.ListProcessorsPagedResponse> listProcessorsPagedCallable;
    private final UnaryCallable<CreateProcessorRequest, Processor> createProcessorCallable;
    private final UnaryCallable<DeleteProcessorRequest, Operation> deleteProcessorCallable;
    private final OperationCallable<DeleteProcessorRequest, Empty, DeleteProcessorMetadata> deleteProcessorOperationCallable;
    private final UnaryCallable<EnableProcessorRequest, Operation> enableProcessorCallable;
    private final OperationCallable<EnableProcessorRequest, EnableProcessorResponse, EnableProcessorMetadata> enableProcessorOperationCallable;
    private final UnaryCallable<DisableProcessorRequest, Operation> disableProcessorCallable;
    private final OperationCallable<DisableProcessorRequest, DisableProcessorResponse, DisableProcessorMetadata> disableProcessorOperationCallable;
    private final UnaryCallable<ReviewDocumentRequest, Operation> reviewDocumentCallable;
    private final OperationCallable<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDocumentProcessorServiceStub create(DocumentProcessorServiceStubSettings settings) throws IOException {
        return new HttpJsonDocumentProcessorServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDocumentProcessorServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDocumentProcessorServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDocumentProcessorServiceCallableFactory());
    }

    protected HttpJsonDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings processDocumentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(processDocumentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings batchProcessDocumentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchProcessDocumentsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings fetchProcessorTypesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(fetchProcessorTypesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listProcessorsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listProcessorsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createProcessorTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createProcessorMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteProcessorTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteProcessorMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings enableProcessorTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(enableProcessorMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings disableProcessorTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(disableProcessorMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings reviewDocumentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(reviewDocumentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.processDocumentCallable = callableFactory.createUnaryCallable(processDocumentTransportSettings, settings.processDocumentSettings(), clientContext);
        this.batchProcessDocumentsCallable = callableFactory.createUnaryCallable(batchProcessDocumentsTransportSettings, settings.batchProcessDocumentsSettings(), clientContext);
        this.batchProcessDocumentsOperationCallable = callableFactory.createOperationCallable(batchProcessDocumentsTransportSettings, settings.batchProcessDocumentsOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.fetchProcessorTypesCallable = callableFactory.createUnaryCallable(fetchProcessorTypesTransportSettings, settings.fetchProcessorTypesSettings(), clientContext);
        this.listProcessorsCallable = callableFactory.createUnaryCallable(listProcessorsTransportSettings, settings.listProcessorsSettings(), clientContext);
        this.listProcessorsPagedCallable = callableFactory.createPagedCallable(listProcessorsTransportSettings, settings.listProcessorsSettings(), clientContext);
        this.createProcessorCallable = callableFactory.createUnaryCallable(createProcessorTransportSettings, settings.createProcessorSettings(), clientContext);
        this.deleteProcessorCallable = callableFactory.createUnaryCallable(deleteProcessorTransportSettings, settings.deleteProcessorSettings(), clientContext);
        this.deleteProcessorOperationCallable = callableFactory.createOperationCallable(deleteProcessorTransportSettings, settings.deleteProcessorOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.enableProcessorCallable = callableFactory.createUnaryCallable(enableProcessorTransportSettings, settings.enableProcessorSettings(), clientContext);
        this.enableProcessorOperationCallable = callableFactory.createOperationCallable(enableProcessorTransportSettings, settings.enableProcessorOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.disableProcessorCallable = callableFactory.createUnaryCallable(disableProcessorTransportSettings, settings.disableProcessorSettings(), clientContext);
        this.disableProcessorOperationCallable = callableFactory.createOperationCallable(disableProcessorTransportSettings, settings.disableProcessorOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.reviewDocumentCallable = callableFactory.createUnaryCallable(reviewDocumentTransportSettings, settings.reviewDocumentSettings(), clientContext);
        this.reviewDocumentOperationCallable = callableFactory.createOperationCallable(reviewDocumentTransportSettings, settings.reviewDocumentOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(processDocumentMethodDescriptor);
        methodDescriptors.add(batchProcessDocumentsMethodDescriptor);
        methodDescriptors.add(fetchProcessorTypesMethodDescriptor);
        methodDescriptors.add(listProcessorsMethodDescriptor);
        methodDescriptors.add(createProcessorMethodDescriptor);
        methodDescriptors.add(deleteProcessorMethodDescriptor);
        methodDescriptors.add(enableProcessorMethodDescriptor);
        methodDescriptors.add(disableProcessorMethodDescriptor);
        methodDescriptors.add(reviewDocumentMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ProcessRequest, ProcessResponse> processDocumentCallable() {
        return this.processDocumentCallable;
    }

    @Override
    public UnaryCallable<BatchProcessRequest, Operation> batchProcessDocumentsCallable() {
        return this.batchProcessDocumentsCallable;
    }

    @Override
    public OperationCallable<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationCallable() {
        return this.batchProcessDocumentsOperationCallable;
    }

    @Override
    public UnaryCallable<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesCallable() {
        return this.fetchProcessorTypesCallable;
    }

    @Override
    public UnaryCallable<ListProcessorsRequest, ListProcessorsResponse> listProcessorsCallable() {
        return this.listProcessorsCallable;
    }

    @Override
    public UnaryCallable<ListProcessorsRequest, DocumentProcessorServiceClient.ListProcessorsPagedResponse> listProcessorsPagedCallable() {
        return this.listProcessorsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateProcessorRequest, Processor> createProcessorCallable() {
        return this.createProcessorCallable;
    }

    @Override
    public UnaryCallable<DeleteProcessorRequest, Operation> deleteProcessorCallable() {
        return this.deleteProcessorCallable;
    }

    @Override
    public OperationCallable<DeleteProcessorRequest, Empty, DeleteProcessorMetadata> deleteProcessorOperationCallable() {
        return this.deleteProcessorOperationCallable;
    }

    @Override
    public UnaryCallable<EnableProcessorRequest, Operation> enableProcessorCallable() {
        return this.enableProcessorCallable;
    }

    @Override
    public OperationCallable<EnableProcessorRequest, EnableProcessorResponse, EnableProcessorMetadata> enableProcessorOperationCallable() {
        return this.enableProcessorOperationCallable;
    }

    @Override
    public UnaryCallable<DisableProcessorRequest, Operation> disableProcessorCallable() {
        return this.disableProcessorCallable;
    }

    @Override
    public OperationCallable<DisableProcessorRequest, DisableProcessorResponse, DisableProcessorMetadata> disableProcessorOperationCallable() {
        return this.disableProcessorOperationCallable;
    }

    @Override
    public UnaryCallable<ReviewDocumentRequest, Operation> reviewDocumentCallable() {
        return this.reviewDocumentCallable;
    }

    @Override
    public OperationCallable<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationCallable() {
        return this.reviewDocumentOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

