/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.documentai.v1beta3.BatchProcessMetadata;
import com.google.cloud.documentai.v1beta3.BatchProcessRequest;
import com.google.cloud.documentai.v1beta3.BatchProcessResponse;
import com.google.cloud.documentai.v1beta3.CreateProcessorRequest;
import com.google.cloud.documentai.v1beta3.DeleteProcessorMetadata;
import com.google.cloud.documentai.v1beta3.DeleteProcessorRequest;
import com.google.cloud.documentai.v1beta3.DisableProcessorMetadata;
import com.google.cloud.documentai.v1beta3.DisableProcessorRequest;
import com.google.cloud.documentai.v1beta3.DisableProcessorResponse;
import com.google.cloud.documentai.v1beta3.DocumentProcessorServiceSettings;
import com.google.cloud.documentai.v1beta3.EnableProcessorMetadata;
import com.google.cloud.documentai.v1beta3.EnableProcessorRequest;
import com.google.cloud.documentai.v1beta3.EnableProcessorResponse;
import com.google.cloud.documentai.v1beta3.FetchProcessorTypesRequest;
import com.google.cloud.documentai.v1beta3.FetchProcessorTypesResponse;
import com.google.cloud.documentai.v1beta3.HumanReviewConfigName;
import com.google.cloud.documentai.v1beta3.ListProcessorsRequest;
import com.google.cloud.documentai.v1beta3.ListProcessorsResponse;
import com.google.cloud.documentai.v1beta3.LocationName;
import com.google.cloud.documentai.v1beta3.ProcessRequest;
import com.google.cloud.documentai.v1beta3.ProcessResponse;
import com.google.cloud.documentai.v1beta3.Processor;
import com.google.cloud.documentai.v1beta3.ProcessorName;
import com.google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata;
import com.google.cloud.documentai.v1beta3.ReviewDocumentRequest;
import com.google.cloud.documentai.v1beta3.ReviewDocumentResponse;
import com.google.cloud.documentai.v1beta3.stub.DocumentProcessorServiceStub;
import com.google.cloud.documentai.v1beta3.stub.DocumentProcessorServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DocumentProcessorServiceClient
implements BackgroundResource {
    private final DocumentProcessorServiceSettings settings;
    private final DocumentProcessorServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final DocumentProcessorServiceClient create() throws IOException {
        return DocumentProcessorServiceClient.create(DocumentProcessorServiceSettings.newBuilder().build());
    }

    public static final DocumentProcessorServiceClient create(DocumentProcessorServiceSettings settings) throws IOException {
        return new DocumentProcessorServiceClient(settings);
    }

    public static final DocumentProcessorServiceClient create(DocumentProcessorServiceStub stub) {
        return new DocumentProcessorServiceClient(stub);
    }

    protected DocumentProcessorServiceClient(DocumentProcessorServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DocumentProcessorServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected DocumentProcessorServiceClient(DocumentProcessorServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final DocumentProcessorServiceSettings getSettings() {
        return this.settings;
    }

    public DocumentProcessorServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ProcessResponse processDocument(ProcessorName name) {
        ProcessRequest request = ProcessRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.processDocument(request);
    }

    public final ProcessResponse processDocument(String name) {
        ProcessRequest request = ProcessRequest.newBuilder().setName(name).build();
        return this.processDocument(request);
    }

    public final ProcessResponse processDocument(ProcessRequest request) {
        return (ProcessResponse)this.processDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<ProcessRequest, ProcessResponse> processDocumentCallable() {
        return this.stub.processDocumentCallable();
    }

    public final OperationFuture<BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsAsync(ProcessorName name) {
        BatchProcessRequest request = BatchProcessRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.batchProcessDocumentsAsync(request);
    }

    public final OperationFuture<BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsAsync(String name) {
        BatchProcessRequest request = BatchProcessRequest.newBuilder().setName(name).build();
        return this.batchProcessDocumentsAsync(request);
    }

    public final OperationFuture<BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsAsync(BatchProcessRequest request) {
        return this.batchProcessDocumentsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationCallable() {
        return this.stub.batchProcessDocumentsOperationCallable();
    }

    public final UnaryCallable<BatchProcessRequest, Operation> batchProcessDocumentsCallable() {
        return this.stub.batchProcessDocumentsCallable();
    }

    public final FetchProcessorTypesResponse fetchProcessorTypes(LocationName parent) {
        FetchProcessorTypesRequest request = FetchProcessorTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.fetchProcessorTypes(request);
    }

    public final FetchProcessorTypesResponse fetchProcessorTypes(String parent) {
        FetchProcessorTypesRequest request = FetchProcessorTypesRequest.newBuilder().setParent(parent).build();
        return this.fetchProcessorTypes(request);
    }

    public final FetchProcessorTypesResponse fetchProcessorTypes(FetchProcessorTypesRequest request) {
        return (FetchProcessorTypesResponse)this.fetchProcessorTypesCallable().call((Object)request);
    }

    public final UnaryCallable<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesCallable() {
        return this.stub.fetchProcessorTypesCallable();
    }

    public final ListProcessorsPagedResponse listProcessors(LocationName parent) {
        ListProcessorsRequest request = ListProcessorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProcessors(request);
    }

    public final ListProcessorsPagedResponse listProcessors(String parent) {
        ListProcessorsRequest request = ListProcessorsRequest.newBuilder().setParent(parent).build();
        return this.listProcessors(request);
    }

    public final ListProcessorsPagedResponse listProcessors(ListProcessorsRequest request) {
        return (ListProcessorsPagedResponse)((Object)this.listProcessorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProcessorsRequest, ListProcessorsPagedResponse> listProcessorsPagedCallable() {
        return this.stub.listProcessorsPagedCallable();
    }

    public final UnaryCallable<ListProcessorsRequest, ListProcessorsResponse> listProcessorsCallable() {
        return this.stub.listProcessorsCallable();
    }

    public final Processor createProcessor(LocationName parent, Processor processor) {
        CreateProcessorRequest request = CreateProcessorRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setProcessor(processor).build();
        return this.createProcessor(request);
    }

    public final Processor createProcessor(String parent, Processor processor) {
        CreateProcessorRequest request = CreateProcessorRequest.newBuilder().setParent(parent).setProcessor(processor).build();
        return this.createProcessor(request);
    }

    public final Processor createProcessor(CreateProcessorRequest request) {
        return (Processor)this.createProcessorCallable().call((Object)request);
    }

    public final UnaryCallable<CreateProcessorRequest, Processor> createProcessorCallable() {
        return this.stub.createProcessorCallable();
    }

    public final OperationFuture<Empty, DeleteProcessorMetadata> deleteProcessorAsync(ProcessorName name) {
        DeleteProcessorRequest request = DeleteProcessorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteProcessorAsync(request);
    }

    public final OperationFuture<Empty, DeleteProcessorMetadata> deleteProcessorAsync(String name) {
        DeleteProcessorRequest request = DeleteProcessorRequest.newBuilder().setName(name).build();
        return this.deleteProcessorAsync(request);
    }

    public final OperationFuture<Empty, DeleteProcessorMetadata> deleteProcessorAsync(DeleteProcessorRequest request) {
        return this.deleteProcessorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteProcessorRequest, Empty, DeleteProcessorMetadata> deleteProcessorOperationCallable() {
        return this.stub.deleteProcessorOperationCallable();
    }

    public final UnaryCallable<DeleteProcessorRequest, Operation> deleteProcessorCallable() {
        return this.stub.deleteProcessorCallable();
    }

    public final OperationFuture<EnableProcessorResponse, EnableProcessorMetadata> enableProcessorAsync(EnableProcessorRequest request) {
        return this.enableProcessorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<EnableProcessorRequest, EnableProcessorResponse, EnableProcessorMetadata> enableProcessorOperationCallable() {
        return this.stub.enableProcessorOperationCallable();
    }

    public final UnaryCallable<EnableProcessorRequest, Operation> enableProcessorCallable() {
        return this.stub.enableProcessorCallable();
    }

    public final OperationFuture<DisableProcessorResponse, DisableProcessorMetadata> disableProcessorAsync(DisableProcessorRequest request) {
        return this.disableProcessorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DisableProcessorRequest, DisableProcessorResponse, DisableProcessorMetadata> disableProcessorOperationCallable() {
        return this.stub.disableProcessorOperationCallable();
    }

    public final UnaryCallable<DisableProcessorRequest, Operation> disableProcessorCallable() {
        return this.stub.disableProcessorCallable();
    }

    public final OperationFuture<ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentAsync(HumanReviewConfigName humanReviewConfig) {
        ReviewDocumentRequest request = ReviewDocumentRequest.newBuilder().setHumanReviewConfig(humanReviewConfig == null ? null : humanReviewConfig.toString()).build();
        return this.reviewDocumentAsync(request);
    }

    public final OperationFuture<ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentAsync(String humanReviewConfig) {
        ReviewDocumentRequest request = ReviewDocumentRequest.newBuilder().setHumanReviewConfig(humanReviewConfig).build();
        return this.reviewDocumentAsync(request);
    }

    public final OperationFuture<ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentAsync(ReviewDocumentRequest request) {
        return this.reviewDocumentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationCallable() {
        return this.stub.reviewDocumentOperationCallable();
    }

    public final UnaryCallable<ReviewDocumentRequest, Operation> reviewDocumentCallable() {
        return this.stub.reviewDocumentCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListProcessorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProcessorsRequest, ListProcessorsResponse, Processor, ListProcessorsPage, ListProcessorsFixedSizeCollection> {
        private ListProcessorsFixedSizeCollection(List<ListProcessorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProcessorsFixedSizeCollection createEmptyCollection() {
            return new ListProcessorsFixedSizeCollection(null, 0);
        }

        protected ListProcessorsFixedSizeCollection createCollection(List<ListProcessorsPage> pages, int collectionSize) {
            return new ListProcessorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProcessorsPage
    extends AbstractPage<ListProcessorsRequest, ListProcessorsResponse, Processor, ListProcessorsPage> {
        private ListProcessorsPage(PageContext<ListProcessorsRequest, ListProcessorsResponse, Processor> context, ListProcessorsResponse response) {
            super(context, (Object)response);
        }

        private static ListProcessorsPage createEmptyPage() {
            return new ListProcessorsPage(null, null);
        }

        protected ListProcessorsPage createPage(PageContext<ListProcessorsRequest, ListProcessorsResponse, Processor> context, ListProcessorsResponse response) {
            return new ListProcessorsPage(context, response);
        }

        public ApiFuture<ListProcessorsPage> createPageAsync(PageContext<ListProcessorsRequest, ListProcessorsResponse, Processor> context, ApiFuture<ListProcessorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProcessorsPagedResponse
    extends AbstractPagedListResponse<ListProcessorsRequest, ListProcessorsResponse, Processor, ListProcessorsPage, ListProcessorsFixedSizeCollection> {
        public static ApiFuture<ListProcessorsPagedResponse> createAsync(PageContext<ListProcessorsRequest, ListProcessorsResponse, Processor> context, ApiFuture<ListProcessorsResponse> futureResponse) {
            ApiFuture<ListProcessorsPage> futurePage = ListProcessorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProcessorsPagedResponse((ListProcessorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProcessorsPagedResponse(ListProcessorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProcessorsFixedSizeCollection.createEmptyCollection());
        }
    }
}

