/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.documentai.v1beta3.BatchDeleteDocumentsMetadata;
import com.google.cloud.documentai.v1beta3.BatchDeleteDocumentsRequest;
import com.google.cloud.documentai.v1beta3.BatchDeleteDocumentsResponse;
import com.google.cloud.documentai.v1beta3.Dataset;
import com.google.cloud.documentai.v1beta3.DatasetSchema;
import com.google.cloud.documentai.v1beta3.DocumentMetadata;
import com.google.cloud.documentai.v1beta3.DocumentServiceClient;
import com.google.cloud.documentai.v1beta3.GetDatasetSchemaRequest;
import com.google.cloud.documentai.v1beta3.GetDocumentRequest;
import com.google.cloud.documentai.v1beta3.GetDocumentResponse;
import com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata;
import com.google.cloud.documentai.v1beta3.ImportDocumentsRequest;
import com.google.cloud.documentai.v1beta3.ImportDocumentsResponse;
import com.google.cloud.documentai.v1beta3.ListDocumentsRequest;
import com.google.cloud.documentai.v1beta3.ListDocumentsResponse;
import com.google.cloud.documentai.v1beta3.UpdateDatasetOperationMetadata;
import com.google.cloud.documentai.v1beta3.UpdateDatasetRequest;
import com.google.cloud.documentai.v1beta3.UpdateDatasetSchemaRequest;
import com.google.cloud.documentai.v1beta3.stub.DocumentServiceStub;
import com.google.cloud.documentai.v1beta3.stub.GrpcDocumentServiceStub;
import com.google.cloud.documentai.v1beta3.stub.HttpJsonDocumentServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DocumentServiceStubSettings
extends StubSettings<DocumentServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<UpdateDatasetRequest, Operation> updateDatasetSettings;
    private final OperationCallSettings<UpdateDatasetRequest, Dataset, UpdateDatasetOperationMetadata> updateDatasetOperationSettings;
    private final UnaryCallSettings<ImportDocumentsRequest, Operation> importDocumentsSettings;
    private final OperationCallSettings<ImportDocumentsRequest, ImportDocumentsResponse, ImportDocumentsMetadata> importDocumentsOperationSettings;
    private final UnaryCallSettings<GetDocumentRequest, GetDocumentResponse> getDocumentSettings;
    private final PagedCallSettings<ListDocumentsRequest, ListDocumentsResponse, DocumentServiceClient.ListDocumentsPagedResponse> listDocumentsSettings;
    private final UnaryCallSettings<BatchDeleteDocumentsRequest, Operation> batchDeleteDocumentsSettings;
    private final OperationCallSettings<BatchDeleteDocumentsRequest, BatchDeleteDocumentsResponse, BatchDeleteDocumentsMetadata> batchDeleteDocumentsOperationSettings;
    private final UnaryCallSettings<GetDatasetSchemaRequest, DatasetSchema> getDatasetSchemaSettings;
    private final UnaryCallSettings<UpdateDatasetSchemaRequest, DatasetSchema> updateDatasetSchemaSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DocumentServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListDocumentsRequest, ListDocumentsResponse, DocumentMetadata> LIST_DOCUMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListDocumentsRequest, ListDocumentsResponse, DocumentMetadata>(){

        public String emptyToken() {
            return "";
        }

        public ListDocumentsRequest injectToken(ListDocumentsRequest payload, String token) {
            return ListDocumentsRequest.newBuilder((ListDocumentsRequest)payload).setPageToken(token).build();
        }

        public ListDocumentsRequest injectPageSize(ListDocumentsRequest payload, int pageSize) {
            return ListDocumentsRequest.newBuilder((ListDocumentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDocumentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDocumentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DocumentMetadata> extractResources(ListDocumentsResponse payload) {
            return payload.getDocumentMetadataList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListDocumentsRequest, ListDocumentsResponse, DocumentServiceClient.ListDocumentsPagedResponse> LIST_DOCUMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListDocumentsRequest, ListDocumentsResponse, DocumentServiceClient.ListDocumentsPagedResponse>(){

        public ApiFuture<DocumentServiceClient.ListDocumentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> callable, ListDocumentsRequest request, ApiCallContext context, ApiFuture<ListDocumentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DOCUMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DocumentServiceClient.ListDocumentsPagedResponse.createAsync((PageContext<ListDocumentsRequest, ListDocumentsResponse, DocumentMetadata>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DocumentServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DocumentServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<DocumentServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DocumentServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<UpdateDatasetRequest, Operation> updateDatasetSettings() {
        return this.updateDatasetSettings;
    }

    public OperationCallSettings<UpdateDatasetRequest, Dataset, UpdateDatasetOperationMetadata> updateDatasetOperationSettings() {
        return this.updateDatasetOperationSettings;
    }

    public UnaryCallSettings<ImportDocumentsRequest, Operation> importDocumentsSettings() {
        return this.importDocumentsSettings;
    }

    public OperationCallSettings<ImportDocumentsRequest, ImportDocumentsResponse, ImportDocumentsMetadata> importDocumentsOperationSettings() {
        return this.importDocumentsOperationSettings;
    }

    public UnaryCallSettings<GetDocumentRequest, GetDocumentResponse> getDocumentSettings() {
        return this.getDocumentSettings;
    }

    public PagedCallSettings<ListDocumentsRequest, ListDocumentsResponse, DocumentServiceClient.ListDocumentsPagedResponse> listDocumentsSettings() {
        return this.listDocumentsSettings;
    }

    public UnaryCallSettings<BatchDeleteDocumentsRequest, Operation> batchDeleteDocumentsSettings() {
        return this.batchDeleteDocumentsSettings;
    }

    public OperationCallSettings<BatchDeleteDocumentsRequest, BatchDeleteDocumentsResponse, BatchDeleteDocumentsMetadata> batchDeleteDocumentsOperationSettings() {
        return this.batchDeleteDocumentsOperationSettings;
    }

    public UnaryCallSettings<GetDatasetSchemaRequest, DatasetSchema> getDatasetSchemaSettings() {
        return this.getDatasetSchemaSettings;
    }

    public UnaryCallSettings<UpdateDatasetSchemaRequest, DatasetSchema> updateDatasetSchemaSettings() {
        return this.updateDatasetSchemaSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DocumentServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public DocumentServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDocumentServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDocumentServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "documentai";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "documentai.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "documentai.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DocumentServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DocumentServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DocumentServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DocumentServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DocumentServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.updateDatasetSettings = settingsBuilder.updateDatasetSettings().build();
        this.updateDatasetOperationSettings = settingsBuilder.updateDatasetOperationSettings().build();
        this.importDocumentsSettings = settingsBuilder.importDocumentsSettings().build();
        this.importDocumentsOperationSettings = settingsBuilder.importDocumentsOperationSettings().build();
        this.getDocumentSettings = settingsBuilder.getDocumentSettings().build();
        this.listDocumentsSettings = settingsBuilder.listDocumentsSettings().build();
        this.batchDeleteDocumentsSettings = settingsBuilder.batchDeleteDocumentsSettings().build();
        this.batchDeleteDocumentsOperationSettings = settingsBuilder.batchDeleteDocumentsOperationSettings().build();
        this.getDatasetSchemaSettings = settingsBuilder.getDatasetSchemaSettings().build();
        this.updateDatasetSchemaSettings = settingsBuilder.updateDatasetSchemaSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DocumentServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<UpdateDatasetRequest, Operation> updateDatasetSettings;
        private final OperationCallSettings.Builder<UpdateDatasetRequest, Dataset, UpdateDatasetOperationMetadata> updateDatasetOperationSettings;
        private final UnaryCallSettings.Builder<ImportDocumentsRequest, Operation> importDocumentsSettings;
        private final OperationCallSettings.Builder<ImportDocumentsRequest, ImportDocumentsResponse, ImportDocumentsMetadata> importDocumentsOperationSettings;
        private final UnaryCallSettings.Builder<GetDocumentRequest, GetDocumentResponse> getDocumentSettings;
        private final PagedCallSettings.Builder<ListDocumentsRequest, ListDocumentsResponse, DocumentServiceClient.ListDocumentsPagedResponse> listDocumentsSettings;
        private final UnaryCallSettings.Builder<BatchDeleteDocumentsRequest, Operation> batchDeleteDocumentsSettings;
        private final OperationCallSettings.Builder<BatchDeleteDocumentsRequest, BatchDeleteDocumentsResponse, BatchDeleteDocumentsMetadata> batchDeleteDocumentsOperationSettings;
        private final UnaryCallSettings.Builder<GetDatasetSchemaRequest, DatasetSchema> getDatasetSchemaSettings;
        private final UnaryCallSettings.Builder<UpdateDatasetSchemaRequest, DatasetSchema> updateDatasetSchemaSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DocumentServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.updateDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDatasetOperationSettings = OperationCallSettings.newBuilder();
            this.importDocumentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importDocumentsOperationSettings = OperationCallSettings.newBuilder();
            this.getDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDocumentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DOCUMENTS_PAGE_STR_FACT);
            this.batchDeleteDocumentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchDeleteDocumentsOperationSettings = OperationCallSettings.newBuilder();
            this.getDatasetSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDatasetSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.updateDatasetSettings, this.importDocumentsSettings, this.getDocumentSettings, this.listDocumentsSettings, this.batchDeleteDocumentsSettings, this.getDatasetSchemaSettings, this.updateDatasetSchemaSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DocumentServiceStubSettings settings) {
            super((StubSettings)settings);
            this.updateDatasetSettings = settings.updateDatasetSettings.toBuilder();
            this.updateDatasetOperationSettings = settings.updateDatasetOperationSettings.toBuilder();
            this.importDocumentsSettings = settings.importDocumentsSettings.toBuilder();
            this.importDocumentsOperationSettings = settings.importDocumentsOperationSettings.toBuilder();
            this.getDocumentSettings = settings.getDocumentSettings.toBuilder();
            this.listDocumentsSettings = settings.listDocumentsSettings.toBuilder();
            this.batchDeleteDocumentsSettings = settings.batchDeleteDocumentsSettings.toBuilder();
            this.batchDeleteDocumentsOperationSettings = settings.batchDeleteDocumentsOperationSettings.toBuilder();
            this.getDatasetSchemaSettings = settings.getDatasetSchemaSettings.toBuilder();
            this.updateDatasetSchemaSettings = settings.updateDatasetSchemaSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.updateDatasetSettings, this.importDocumentsSettings, this.getDocumentSettings, this.listDocumentsSettings, this.batchDeleteDocumentsSettings, this.getDatasetSchemaSettings, this.updateDatasetSchemaSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DocumentServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DocumentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DocumentServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DocumentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DocumentServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DocumentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DocumentServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DocumentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.updateDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.importDocumentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDocumentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchDeleteDocumentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDatasetSchemaSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateDatasetSchemaSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateDatasetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Dataset.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateDatasetOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importDocumentsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportDocumentsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportDocumentsMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchDeleteDocumentsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchDeleteDocumentsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchDeleteDocumentsMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<UpdateDatasetRequest, Operation> updateDatasetSettings() {
            return this.updateDatasetSettings;
        }

        public OperationCallSettings.Builder<UpdateDatasetRequest, Dataset, UpdateDatasetOperationMetadata> updateDatasetOperationSettings() {
            return this.updateDatasetOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportDocumentsRequest, Operation> importDocumentsSettings() {
            return this.importDocumentsSettings;
        }

        public OperationCallSettings.Builder<ImportDocumentsRequest, ImportDocumentsResponse, ImportDocumentsMetadata> importDocumentsOperationSettings() {
            return this.importDocumentsOperationSettings;
        }

        public UnaryCallSettings.Builder<GetDocumentRequest, GetDocumentResponse> getDocumentSettings() {
            return this.getDocumentSettings;
        }

        public PagedCallSettings.Builder<ListDocumentsRequest, ListDocumentsResponse, DocumentServiceClient.ListDocumentsPagedResponse> listDocumentsSettings() {
            return this.listDocumentsSettings;
        }

        public UnaryCallSettings.Builder<BatchDeleteDocumentsRequest, Operation> batchDeleteDocumentsSettings() {
            return this.batchDeleteDocumentsSettings;
        }

        public OperationCallSettings.Builder<BatchDeleteDocumentsRequest, BatchDeleteDocumentsResponse, BatchDeleteDocumentsMetadata> batchDeleteDocumentsOperationSettings() {
            return this.batchDeleteDocumentsOperationSettings;
        }

        public UnaryCallSettings.Builder<GetDatasetSchemaRequest, DatasetSchema> getDatasetSchemaSettings() {
            return this.getDatasetSchemaSettings;
        }

        public UnaryCallSettings.Builder<UpdateDatasetSchemaRequest, DatasetSchema> updateDatasetSchemaSettings() {
            return this.updateDatasetSchemaSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DocumentServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public DocumentServiceStubSettings build() throws IOException {
            return new DocumentServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

