/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.documentai.v1beta3.BatchProcessMetadata;
import com.google.cloud.documentai.v1beta3.BatchProcessRequest;
import com.google.cloud.documentai.v1beta3.BatchProcessResponse;
import com.google.cloud.documentai.v1beta3.ProcessRequest;
import com.google.cloud.documentai.v1beta3.ProcessResponse;
import com.google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata;
import com.google.cloud.documentai.v1beta3.ReviewDocumentRequest;
import com.google.cloud.documentai.v1beta3.ReviewDocumentResponse;
import com.google.cloud.documentai.v1beta3.stub.DocumentProcessorServiceStub;
import com.google.cloud.documentai.v1beta3.stub.GrpcDocumentProcessorServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DocumentProcessorServiceStubSettings
extends StubSettings<DocumentProcessorServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ProcessRequest, ProcessResponse> processDocumentSettings;
    private final UnaryCallSettings<BatchProcessRequest, Operation> batchProcessDocumentsSettings;
    private final OperationCallSettings<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationSettings;
    private final UnaryCallSettings<ReviewDocumentRequest, Operation> reviewDocumentSettings;
    private final OperationCallSettings<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationSettings;

    public UnaryCallSettings<ProcessRequest, ProcessResponse> processDocumentSettings() {
        return this.processDocumentSettings;
    }

    public UnaryCallSettings<BatchProcessRequest, Operation> batchProcessDocumentsSettings() {
        return this.batchProcessDocumentsSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationSettings() {
        return this.batchProcessDocumentsOperationSettings;
    }

    public UnaryCallSettings<ReviewDocumentRequest, Operation> reviewDocumentSettings() {
        return this.reviewDocumentSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationSettings() {
        return this.reviewDocumentOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DocumentProcessorServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDocumentProcessorServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "us-documentai.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DocumentProcessorServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DocumentProcessorServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DocumentProcessorServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.processDocumentSettings = settingsBuilder.processDocumentSettings().build();
        this.batchProcessDocumentsSettings = settingsBuilder.batchProcessDocumentsSettings().build();
        this.batchProcessDocumentsOperationSettings = settingsBuilder.batchProcessDocumentsOperationSettings().build();
        this.reviewDocumentSettings = settingsBuilder.reviewDocumentSettings().build();
        this.reviewDocumentOperationSettings = settingsBuilder.reviewDocumentOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DocumentProcessorServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ProcessRequest, ProcessResponse> processDocumentSettings;
        private final UnaryCallSettings.Builder<BatchProcessRequest, Operation> batchProcessDocumentsSettings;
        private final OperationCallSettings.Builder<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationSettings;
        private final UnaryCallSettings.Builder<ReviewDocumentRequest, Operation> reviewDocumentSettings;
        private final OperationCallSettings.Builder<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.processDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchProcessDocumentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchProcessDocumentsOperationSettings = OperationCallSettings.newBuilder();
            this.reviewDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.reviewDocumentOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.processDocumentSettings, this.batchProcessDocumentsSettings, this.reviewDocumentSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DocumentProcessorServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DocumentProcessorServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DocumentProcessorServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DocumentProcessorServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.processDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.batchProcessDocumentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.reviewDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.batchProcessDocumentsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchProcessResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchProcessMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.reviewDocumentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ReviewDocumentResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ReviewDocumentOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(DocumentProcessorServiceStubSettings settings) {
            super((StubSettings)settings);
            this.processDocumentSettings = settings.processDocumentSettings.toBuilder();
            this.batchProcessDocumentsSettings = settings.batchProcessDocumentsSettings.toBuilder();
            this.batchProcessDocumentsOperationSettings = settings.batchProcessDocumentsOperationSettings.toBuilder();
            this.reviewDocumentSettings = settings.reviewDocumentSettings.toBuilder();
            this.reviewDocumentOperationSettings = settings.reviewDocumentOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.processDocumentSettings, this.batchProcessDocumentsSettings, this.reviewDocumentSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ProcessRequest, ProcessResponse> processDocumentSettings() {
            return this.processDocumentSettings;
        }

        public UnaryCallSettings.Builder<BatchProcessRequest, Operation> batchProcessDocumentsSettings() {
            return this.batchProcessDocumentsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationSettings() {
            return this.batchProcessDocumentsOperationSettings;
        }

        public UnaryCallSettings.Builder<ReviewDocumentRequest, Operation> reviewDocumentSettings() {
            return this.reviewDocumentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationSettings() {
            return this.reviewDocumentOperationSettings;
        }

        public DocumentProcessorServiceStubSettings build() throws IOException {
            return new DocumentProcessorServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

