/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns.testing;

import com.google.api.client.http.HttpMediaType;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.dns.model.Change;
import com.google.api.services.dns.model.ManagedZone;
import com.google.api.services.dns.model.Project;
import com.google.api.services.dns.model.Quota;
import com.google.api.services.dns.model.ResourceRecordSet;
import com.google.cloud.AuthCredentials;
import com.google.cloud.dns.DnsOptions;
import com.google.cloud.dns.testing.OptionParsers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.net.InetAddresses;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.fileupload.MultipartStream;
import org.joda.time.format.ISODateTimeFormat;

public class LocalDnsHelper {
    private final ConcurrentSkipListMap<String, ProjectContainer> projects = new ConcurrentSkipListMap();
    private static final URI BASE_CONTEXT;
    private static final Logger log;
    private static final JsonFactory jsonFactory;
    private static final Random ID_GENERATOR;
    private static final String VERSION = "v1";
    private static final String CONTEXT = "/dns/v1/projects";
    private static final Set<String> ENCODINGS;
    private static final List<String> TYPES;
    private static final TreeSet<String> FORBIDDEN;
    private static final Pattern ZONE_NAME_RE;
    private static final ScheduledExecutorService EXECUTORS;
    private static final String PROJECT_ID = "dummyprojectid";
    private static final String RESPONSE_BOUNDARY = "____THIS_IS_HELPERS_BOUNDARY____";
    private static final String RESPONSE_SEPARATOR = "--____THIS_IS_HELPERS_BOUNDARY____\r\n";
    private static final String RESPONSE_END = "--____THIS_IS_HELPERS_BOUNDARY____--\r\n\r\n";
    private final long delayChange;
    private final HttpServer server;
    private final int port;

    private LocalDnsHelper(long delay) {
        this.delayChange = delay;
        try {
            this.server = HttpServer.create(new InetSocketAddress(0), 0);
            this.port = this.server.getAddress().getPort();
            this.server.setExecutor(Executors.newCachedThreadPool());
            this.server.createContext("/", new RequestHandler());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not bind the mock DNS server.", e);
        }
    }

    ConcurrentSkipListMap<String, ProjectContainer> projects() {
        return this.projects;
    }

    public static LocalDnsHelper create(Long delay) {
        return new LocalDnsHelper(delay);
    }

    @Deprecated
    public DnsOptions options() {
        return this.getOptions();
    }

    public DnsOptions getOptions() {
        return ((DnsOptions.Builder)((DnsOptions.Builder)((DnsOptions.Builder)DnsOptions.newBuilder().setProjectId(PROJECT_ID)).setHost("http://localhost:" + this.port)).setAuthCredentials(AuthCredentials.noAuth())).build();
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.server.stop(1);
    }

    private static void writeResponse(HttpExchange exchange, Response response) {
        exchange.getResponseHeaders().set("Content-type", "application/json; charset=UTF-8");
        OutputStream outputStream = exchange.getResponseBody();
        try {
            exchange.getResponseHeaders().add("Connection", "close");
            exchange.sendResponseHeaders(response.code(), response.body().length());
            if (response.code() != 204) {
                outputStream.write(response.body().getBytes(StandardCharsets.UTF_8));
            }
            outputStream.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "IOException encountered when sending response.", e);
        }
    }

    private static void writeBatchResponse(HttpExchange exchange, ByteArrayOutputStream output) {
        exchange.getResponseHeaders().set("Content-type", "multipart/mixed; boundary=____THIS_IS_HELPERS_BOUNDARY____");
        try {
            exchange.getResponseHeaders().add("Connection", "close");
            exchange.sendResponseHeaders(200, output.toByteArray().length);
            OutputStream responseBody = exchange.getResponseBody();
            output.writeTo(responseBody);
            responseBody.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "IOException encountered when sending response.", e);
        }
    }

    private static String decodeContent(Headers headers, InputStream inputStream) throws IOException {
        Object contentEncoding = headers.get("Content-encoding");
        InputStream input = inputStream;
        try {
            if (contentEncoding != null && !contentEncoding.isEmpty()) {
                String encoding = (String)contentEncoding.get(0);
                if (ENCODINGS.contains(encoding)) {
                    input = new GZIPInputStream(inputStream);
                } else if (!"identity".equals(encoding)) {
                    throw new IOException("The request has the following unsupported HTTP content encoding: " + encoding);
                }
            }
            return new String(ByteStreams.toByteArray((InputStream)input), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IOException("Exception encountered when decoding request content.", e);
        }
    }

    @VisibleForTesting
    static Response toListResponse(List<String> serializedObjects, String context, String pageToken, boolean includePageToken) {
        StringBuilder responseBody = new StringBuilder();
        responseBody.append("{\"").append(context).append("\": [");
        Joiner.on((String)",").appendTo(responseBody, serializedObjects);
        responseBody.append(']');
        if (pageToken != null && includePageToken) {
            responseBody.append(",\"nextPageToken\": \"").append(pageToken).append('\"');
        }
        responseBody.append('}');
        return new Response(200, responseBody.toString());
    }

    private static ImmutableSortedMap<String, ResourceRecordSet> defaultRecords(ManagedZone zone) {
        ResourceRecordSet soa = new ResourceRecordSet();
        soa.setTtl(Integer.valueOf(21600));
        soa.setName(zone.getDnsName());
        soa.setRrdatas((List)ImmutableList.of((Object)"ns-cloud-c1.googledomains.com. cloud-dns-hostmaster.google.com. 0 21600 3600 1209600 312"));
        soa.setType("SOA");
        ResourceRecordSet ns = new ResourceRecordSet();
        ns.setTtl(Integer.valueOf(21600));
        ns.setName(zone.getDnsName());
        ns.setRrdatas(zone.getNameServers());
        ns.setType("NS");
        String nsId = LocalDnsHelper.getUniqueId((Set<String>)ImmutableSet.of());
        String soaId = LocalDnsHelper.getUniqueId((Set<String>)ImmutableSet.of((Object)nsId));
        return ImmutableSortedMap.of((Comparable)((Object)nsId), (Object)ns, (Comparable)((Object)soaId), (Object)soa);
    }

    @VisibleForTesting
    static List<String> randomNameservers() {
        ArrayList nameservers = Lists.newArrayList((Object[])new String[]{"dns1.googlecloud.com", "dns2.googlecloud.com", "dns3.googlecloud.com", "dns4.googlecloud.com", "dns5.googlecloud.com", "dns6.googlecloud.com"});
        while (nameservers.size() != 4) {
            int index = ID_GENERATOR.nextInt(nameservers.size());
            nameservers.remove(index);
        }
        return nameservers;
    }

    @VisibleForTesting
    static String getUniqueId(Set<String> ids) {
        String id;
        while (ids.contains(id = Long.toHexString(System.currentTimeMillis()) + Long.toHexString(Math.abs(ID_GENERATOR.nextLong())))) {
        }
        return id;
    }

    @VisibleForTesting
    static boolean matchesCriteria(ResourceRecordSet recordSet, String name, String type) {
        if (type != null && !recordSet.getType().equals(type)) {
            return false;
        }
        return name == null || recordSet.getName().equals(name);
    }

    private ProjectContainer findProject(String projectId) {
        ProjectContainer defaultProject = this.createProject(projectId);
        this.projects.putIfAbsent(projectId, defaultProject);
        return this.projects.get(projectId);
    }

    @VisibleForTesting
    ZoneContainer findZone(String projectId, String zoneName) {
        ProjectContainer projectContainer = this.findProject(projectId);
        return projectContainer.zones().get(zoneName);
    }

    @VisibleForTesting
    Change findChange(String projectId, String zoneName, String changeId) {
        ZoneContainer wrapper = this.findZone(projectId, zoneName);
        return wrapper == null ? null : wrapper.findChange(changeId);
    }

    @VisibleForTesting
    Response getChange(String projectId, String zoneName, String changeId, String query) {
        Change change = this.findChange(projectId, zoneName, changeId);
        if (change == null) {
            ZoneContainer zone = this.findZone(projectId, zoneName);
            if (zone == null) {
                return Error.NOT_FOUND.response(String.format("The 'parameters.managedZone' resource named '%s' does not exist.", zoneName));
            }
            return Error.NOT_FOUND.response(String.format("The 'parameters.changeId' resource named '%s' does not exist.", changeId));
        }
        String[] fields = OptionParsers.parseGetOptions(query);
        Change result = OptionParsers.extractFields(change, fields);
        try {
            return new Response(200, jsonFactory.toString((Object)result));
        }
        catch (IOException e) {
            return Error.INTERNAL_ERROR.response(String.format("Error when serializing change %s in managed zone %s in project %s.", changeId, zoneName, projectId));
        }
    }

    @VisibleForTesting
    Response getZone(String projectId, String zoneName, String query) {
        ZoneContainer container = this.findZone(projectId, zoneName);
        if (container == null) {
            return Error.NOT_FOUND.response(String.format("The 'parameters.managedZone' resource named '%s' does not exist.", zoneName));
        }
        String[] fields = OptionParsers.parseGetOptions(query);
        ManagedZone result = OptionParsers.extractFields(container.zone(), fields);
        try {
            return new Response(200, jsonFactory.toString((Object)result));
        }
        catch (IOException e) {
            return Error.INTERNAL_ERROR.response(String.format("Error when serializing managed zone %s in project %s.", zoneName, projectId));
        }
    }

    @VisibleForTesting
    Response getProject(String projectId, String query) {
        String[] fields = OptionParsers.parseGetOptions(query);
        Project project = this.findProject(projectId).project();
        Project result = OptionParsers.extractFields(project, fields);
        try {
            return new Response(200, jsonFactory.toString((Object)result));
        }
        catch (IOException e) {
            return Error.INTERNAL_ERROR.response(String.format("Error when serializing project %s.", projectId));
        }
    }

    private ProjectContainer createProject(String projectId) {
        Quota quota = new Quota();
        quota.setManagedZones(Integer.valueOf(10000));
        quota.setRrsetsPerManagedZone(Integer.valueOf(10000));
        quota.setRrsetAdditionsPerChange(Integer.valueOf(100));
        quota.setRrsetDeletionsPerChange(Integer.valueOf(100));
        quota.setTotalRrdataSizePerChange(Integer.valueOf(10000));
        quota.setResourceRecordsPerRrset(Integer.valueOf(100));
        Project project = new Project();
        project.setId(projectId);
        project.setNumber(new BigInteger(String.valueOf(Math.abs(ID_GENERATOR.nextLong() % Long.MAX_VALUE))));
        project.setQuota(quota);
        return new ProjectContainer(project);
    }

    @VisibleForTesting
    Response deleteZone(String projectId, String zoneName) {
        ZoneContainer zone = this.findZone(projectId, zoneName);
        ImmutableSortedMap<String, ResourceRecordSet> rrsets = zone == null ? ImmutableSortedMap.of() : zone.dnsRecords().get();
        ImmutableList defaults = ImmutableList.of((Object)"NS", (Object)"SOA");
        for (ResourceRecordSet current : rrsets.values()) {
            if (defaults.contains((Object)current.getType())) continue;
            return Error.CONTAINER_NOT_EMPTY.response(String.format("The resource named '%s' cannot be deleted because it is not empty", zoneName));
        }
        ProjectContainer projectContainer = this.projects.get(projectId);
        ZoneContainer previous = (ZoneContainer)projectContainer.zones.remove(zoneName);
        return previous == null ? Error.NOT_FOUND.response(String.format("The 'parameters.managedZone' resource named '%s' does not exist.", zoneName)) : new Response(204, "{}");
    }

    @VisibleForTesting
    Response createZone(String projectId, ManagedZone zone, String ... fields) {
        Response errorResponse = LocalDnsHelper.checkZone(zone);
        if (errorResponse != null) {
            return errorResponse;
        }
        ManagedZone completeZone = new ManagedZone();
        completeZone.setName(zone.getName());
        completeZone.setDnsName(zone.getDnsName());
        completeZone.setDescription(zone.getDescription());
        completeZone.setNameServerSet(zone.getNameServerSet());
        completeZone.setCreationTime(ISODateTimeFormat.dateTime().withZoneUTC().print(System.currentTimeMillis()));
        completeZone.setId(BigInteger.valueOf(Math.abs(ID_GENERATOR.nextLong() % Long.MAX_VALUE)));
        completeZone.setNameServers(LocalDnsHelper.randomNameservers());
        ZoneContainer zoneContainer = new ZoneContainer(completeZone);
        ImmutableSortedMap<String, ResourceRecordSet> defaultsRecords = LocalDnsHelper.defaultRecords(completeZone);
        zoneContainer.dnsRecords().set(defaultsRecords);
        Change change = new Change();
        change.setAdditions((List)ImmutableList.copyOf((Collection)defaultsRecords.values()));
        change.setStatus("done");
        change.setId("0");
        change.setStartTime(ISODateTimeFormat.dateTime().withZoneUTC().print(System.currentTimeMillis()));
        zoneContainer.changes().add(change);
        ProjectContainer projectContainer = this.findProject(projectId);
        ZoneContainer oldValue = projectContainer.zones().putIfAbsent(completeZone.getName(), zoneContainer);
        if (oldValue != null) {
            return Error.ALREADY_EXISTS.response(String.format("The resource 'entity.managedZone' named '%s' already exists", completeZone.getName()));
        }
        ManagedZone result = OptionParsers.extractFields(completeZone, fields);
        try {
            return new Response(200, jsonFactory.toString((Object)result));
        }
        catch (IOException e) {
            return Error.INTERNAL_ERROR.response(String.format("Error when serializing managed zone %s.", result.getName()));
        }
    }

    Response createChange(String projectId, String zoneName, Change change, String ... fields) {
        ZoneContainer zoneContainer = this.findZone(projectId, zoneName);
        if (zoneContainer == null) {
            return Error.NOT_FOUND.response(String.format("The 'parameters.managedZone' resource named %s does not exist.", zoneName));
        }
        Response response = LocalDnsHelper.checkChange(change, zoneContainer);
        if (response != null) {
            return response;
        }
        Change completeChange = new Change();
        if (change.getAdditions() != null) {
            completeChange.setAdditions((List)ImmutableList.copyOf((Collection)change.getAdditions()));
        }
        if (change.getDeletions() != null) {
            completeChange.setDeletions((List)ImmutableList.copyOf((Collection)change.getDeletions()));
        }
        ConcurrentLinkedQueue<Change> changeSequence = zoneContainer.changes();
        changeSequence.add(completeChange);
        int maxId = changeSequence.size();
        int index = 0;
        for (Change c : changeSequence) {
            if (index == maxId) break;
            c.setId(String.valueOf(index++));
        }
        completeChange.setStatus("pending");
        completeChange.setStartTime(ISODateTimeFormat.dateTime().withZoneUTC().print(System.currentTimeMillis()));
        this.invokeChange(projectId, zoneName, completeChange.getId());
        Change result = OptionParsers.extractFields(completeChange, fields);
        try {
            return new Response(200, jsonFactory.toString((Object)result));
        }
        catch (IOException e) {
            return Error.INTERNAL_ERROR.response(String.format("Error when serializing change %s in managed zone %s in project %s.", result.getId(), zoneName, projectId));
        }
    }

    private void invokeChange(final String projectId, final String zoneName, final String changeId) {
        if (this.delayChange > 0L) {
            EXECUTORS.schedule(new Runnable(){

                @Override
                public void run() {
                    LocalDnsHelper.this.applyExistingChange(projectId, zoneName, changeId);
                }
            }, this.delayChange, TimeUnit.MILLISECONDS);
        } else {
            this.applyExistingChange(projectId, zoneName, changeId);
        }
    }

    private void applyExistingChange(String projectId, String zoneName, String changeId) {
        TreeMap copy;
        ImmutableSortedMap<String, ResourceRecordSet> original;
        boolean success;
        Change change = this.findChange(projectId, zoneName, changeId);
        if (change == null) {
            return;
        }
        ZoneContainer wrapper = this.findZone(projectId, zoneName);
        if (wrapper == null) {
            return;
        }
        AtomicReference<ImmutableSortedMap<String, ResourceRecordSet>> dnsRecords = wrapper.dnsRecords();
        do {
            original = dnsRecords.get();
            copy = new TreeMap();
            List deletions = change.getDeletions();
            if (deletions != null) {
                for (Map.Entry entry : original.entrySet()) {
                    if (deletions.contains(entry.getValue())) continue;
                    copy.put(entry.getKey(), entry.getValue());
                }
            } else {
                copy.putAll(original);
            }
            List additions = change.getAdditions();
            if (additions == null) continue;
            for (ResourceRecordSet addition : additions) {
                ResourceRecordSet rrset = new ResourceRecordSet();
                rrset.setName(addition.getName());
                rrset.setRrdatas((List)ImmutableList.copyOf((Collection)addition.getRrdatas()));
                rrset.setTtl(addition.getTtl());
                rrset.setType(addition.getType());
                String id = LocalDnsHelper.getUniqueId(copy.keySet());
                copy.put(id, rrset);
            }
        } while (!(success = dnsRecords.compareAndSet(original, (ImmutableSortedMap<String, ResourceRecordSet>)ImmutableSortedMap.copyOf(copy))));
        change.setStatus("done");
    }

    @VisibleForTesting
    Response listZones(String projectId, String query) {
        Map<String, Object> options = OptionParsers.parseListZonesOptions(query);
        Response response = LocalDnsHelper.checkListOptions(options);
        if (response != null) {
            return response;
        }
        ConcurrentSkipListMap<String, ZoneContainer> containers = this.findProject(projectId).zones();
        String[] fields = (String[])options.get("fields");
        String dnsName = (String)options.get("dnsName");
        String pageToken = (String)options.get("pageToken");
        Integer maxResults = options.get("maxResults") == null ? null : Integer.valueOf((String)options.get("maxResults"));
        boolean sizeReached = false;
        boolean hasMorePages = false;
        LinkedList<String> serializedZones = new LinkedList<String>();
        String lastZoneName = null;
        ConcurrentSkipListMap<String, ZoneContainer> fragment = pageToken != null ? containers.tailMap((Object)pageToken, false) : containers;
        for (ZoneContainer zoneContainer : fragment.values()) {
            ManagedZone zone = zoneContainer.zone();
            if (dnsName == null || zone.getDnsName().equals(dnsName)) {
                if (sizeReached) {
                    hasMorePages = true;
                    break;
                }
                try {
                    lastZoneName = zone.getName();
                    serializedZones.addLast(jsonFactory.toString((Object)OptionParsers.extractFields(zone, fields)));
                }
                catch (IOException e) {
                    return Error.INTERNAL_ERROR.response(String.format("Error when serializing managed zone %s in project %s", lastZoneName, projectId));
                }
            }
            sizeReached = maxResults != null && maxResults.equals(serializedZones.size());
        }
        boolean includePageToken = hasMorePages && (fields == null || Arrays.asList(fields).contains("nextPageToken"));
        return LocalDnsHelper.toListResponse(serializedZones, "managedZones", lastZoneName, includePageToken);
    }

    @VisibleForTesting
    Response listDnsRecords(String projectId, String zoneName, String query) {
        Map<String, Object> options = OptionParsers.parseListDnsRecordsOptions(query);
        Response response = LocalDnsHelper.checkListOptions(options);
        if (response != null) {
            return response;
        }
        ZoneContainer zoneContainer = this.findZone(projectId, zoneName);
        if (zoneContainer == null) {
            return Error.NOT_FOUND.response(String.format("The 'parameters.managedZone' resource named '%s' does not exist.", zoneName));
        }
        ImmutableSortedMap dnsRecords = zoneContainer.dnsRecords().get();
        String[] fields = (String[])options.get("fields");
        String name = (String)options.get("name");
        String type = (String)options.get("type");
        String pageToken = (String)options.get("pageToken");
        ImmutableSortedMap fragment = pageToken != null ? dnsRecords.tailMap((Object)pageToken, false) : dnsRecords;
        Integer maxResults = options.get("maxResults") == null ? null : Integer.valueOf((String)options.get("maxResults"));
        boolean sizeReached = false;
        boolean hasMorePages = false;
        LinkedList<String> serializedRrsets = new LinkedList<String>();
        String lastRecordId = null;
        for (String recordSetId : fragment.keySet()) {
            ResourceRecordSet recordSet = (ResourceRecordSet)fragment.get((Object)recordSetId);
            if (LocalDnsHelper.matchesCriteria(recordSet, name, type)) {
                if (sizeReached) {
                    hasMorePages = true;
                    break;
                }
                lastRecordId = recordSetId;
                try {
                    serializedRrsets.addLast(jsonFactory.toString((Object)OptionParsers.extractFields(recordSet, fields)));
                }
                catch (IOException e) {
                    return Error.INTERNAL_ERROR.response(String.format("Error when serializing resource record set in managed zone %s in project %s", zoneName, projectId));
                }
            }
            sizeReached = maxResults != null && maxResults.equals(serializedRrsets.size());
        }
        boolean includePageToken = hasMorePages && (fields == null || Arrays.asList(fields).contains("nextPageToken"));
        return LocalDnsHelper.toListResponse(serializedRrsets, "rrsets", lastRecordId, includePageToken);
    }

    @VisibleForTesting
    Response listChanges(String projectId, String zoneName, String query) {
        Map<String, Object> options = OptionParsers.parseListChangesOptions(query);
        Response response = LocalDnsHelper.checkListOptions(options);
        if (response != null) {
            return response;
        }
        ZoneContainer zoneContainer = this.findZone(projectId, zoneName);
        if (zoneContainer == null) {
            return Error.NOT_FOUND.response(String.format("The 'parameters.managedZone' resource named '%s' does not exist", zoneName));
        }
        TreeMap<Integer, Change> changes = new TreeMap<Integer, Change>();
        for (Change c : zoneContainer.changes()) {
            if (c.getId() == null) continue;
            changes.put(Integer.valueOf(c.getId()), c);
        }
        String[] fields = (String[])options.get("fields");
        String sortOrder = (String)options.get("sortOrder");
        String pageToken = (String)options.get("pageToken");
        Integer maxResults = options.get("maxResults") == null ? null : Integer.valueOf((String)options.get("maxResults"));
        NavigableSet keys = "descending".equals(sortOrder) ? changes.descendingKeySet() : changes.navigableKeySet();
        Integer from = null;
        try {
            from = Integer.valueOf(pageToken);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        keys = from != null ? keys.tailSet(from, false) : keys;
        TreeMap<Integer, Change> fragment = from != null && changes.containsKey(from) ? changes.tailMap(from, false) : changes;
        boolean sizeReached = false;
        boolean hasMorePages = false;
        LinkedList<String> serializedResults = new LinkedList<String>();
        String lastChangeId = null;
        for (Integer key : keys) {
            Change change = (Change)fragment.get(key);
            if (sizeReached) {
                hasMorePages = true;
                break;
            }
            lastChangeId = change.getId();
            try {
                serializedResults.addLast(jsonFactory.toString((Object)OptionParsers.extractFields(change, fields)));
            }
            catch (IOException e) {
                return Error.INTERNAL_ERROR.response(String.format("Error when serializing change %s in managed zone %s in project %s", lastChangeId, zoneName, projectId));
            }
            sizeReached = maxResults != null && maxResults.equals(serializedResults.size());
        }
        boolean includePageToken = hasMorePages && (fields == null || Arrays.asList(fields).contains("nextPageToken"));
        return LocalDnsHelper.toListResponse(serializedResults, "changes", lastChangeId, includePageToken);
    }

    private static Response checkZone(ManagedZone zone) {
        if (zone.getName() == null) {
            return Error.REQUIRED.response("The 'entity.managedZone.name' parameter is required but was missing.");
        }
        if (zone.getDnsName() == null) {
            return Error.REQUIRED.response("The 'entity.managedZone.dnsName' parameter is required but was missing.");
        }
        if (zone.getDescription() == null) {
            return Error.REQUIRED.response("The 'entity.managedZone.description' parameter is required but was missing.");
        }
        try {
            int number = Integer.valueOf(zone.getName());
            return Error.INVALID.response(String.format("Invalid value for 'entity.managedZone.name': '%s'", number));
        }
        catch (NumberFormatException numberFormatException) {
            if (zone.getName().isEmpty() || zone.getName().length() > 32 || !ZONE_NAME_RE.matcher(zone.getName()).matches()) {
                return Error.INVALID.response(String.format("Invalid value for 'entity.managedZone.name': '%s'", zone.getName()));
            }
            if (zone.getDnsName().isEmpty() || !zone.getDnsName().endsWith(".")) {
                return Error.INVALID.response(String.format("Invalid value for 'entity.managedZone.dnsName': '%s'", zone.getDnsName()));
            }
            if (FORBIDDEN.contains(zone.getDnsName())) {
                return Error.NOT_AVAILABLE.response(String.format("The '%s' managed zone is not available to be created.", zone.getDnsName()));
            }
            return null;
        }
    }

    @VisibleForTesting
    static Response checkChange(Change change, ZoneContainer zone) {
        Response response;
        int counter;
        if (!(change.getDeletions() != null && change.getDeletions().size() > 0 || change.getAdditions() != null && change.getAdditions().size() > 0)) {
            return Error.REQUIRED.response("The 'entity.change' parameter is required but was missing.");
        }
        if (change.getAdditions() != null) {
            counter = 0;
            for (ResourceRecordSet addition : change.getAdditions()) {
                response = LocalDnsHelper.checkRrset(addition, zone, counter, "additions");
                if (response != null) {
                    return response;
                }
                ++counter;
            }
        }
        if (change.getDeletions() != null) {
            counter = 0;
            for (ResourceRecordSet deletion : change.getDeletions()) {
                response = LocalDnsHelper.checkRrset(deletion, zone, counter, "deletions");
                if (response != null) {
                    return response;
                }
                ++counter;
            }
        }
        return LocalDnsHelper.checkAdditionsDeletions(change.getAdditions(), change.getDeletions(), zone);
    }

    @VisibleForTesting
    static Response checkRrset(ResourceRecordSet rrset, ZoneContainer zone, int index, String type) {
        if (rrset.getName() == null || !rrset.getName().endsWith(zone.zone().getDnsName())) {
            return Error.INVALID.response(String.format("Invalid value for 'entity.change.%s[%s].name': '%s'", type, index, rrset.getName()));
        }
        if (rrset.getType() == null || !TYPES.contains(rrset.getType())) {
            return Error.INVALID.response(String.format("Invalid value for 'entity.change.%s[%s].type': '%s'", type, index, rrset.getType()));
        }
        if (rrset.getTtl() != null && rrset.getTtl() != 0 && rrset.getTtl() < 0) {
            return Error.INVALID.response(String.format("Invalid value for 'entity.change.%s[%s].ttl': '%s'", type, index, rrset.getTtl()));
        }
        if (rrset.getRrdatas() == null || rrset.isEmpty()) {
            return Error.INVALID.response(String.format("Invalid value for 'entity.change.%s[%s].rrdata': '%s'", type, index, "<empty>"));
        }
        int counter = 0;
        for (String record : rrset.getRrdatas()) {
            if (!LocalDnsHelper.checkRrData(record, rrset.getType())) {
                return Error.INVALID.response(String.format("Invalid value for 'entity.change.%s[%s].rrdata[%s]': '%s'", type, index, counter, record));
            }
            ++counter;
        }
        if ("deletions".equals(type)) {
            boolean found = false;
            for (ResourceRecordSet wrappedRrset : zone.dnsRecords().get().values()) {
                if (!rrset.getName().equals(wrappedRrset.getName()) || !rrset.getType().equals(wrappedRrset.getType())) continue;
                found = true;
                break;
            }
            if (!found) {
                return Error.NOT_FOUND.response(String.format("The 'entity.change.deletions[%s]' resource named '%s (%s)' does not exist.", index, rrset.getName(), rrset.getType()));
            }
            if ("deletions".equals(type) && !zone.dnsRecords().get().containsValue((Object)rrset)) {
                return Error.CONDITION_NOT_MET.response(String.format("Precondition not met for 'entity.change.deletions[%s]", index));
            }
        }
        return null;
    }

    static Response checkAdditionsDeletions(List<ResourceRecordSet> additions, List<ResourceRecordSet> deletions, ZoneContainer zone) {
        int index;
        if (additions != null) {
            index = 0;
            for (ResourceRecordSet rrset : additions) {
                for (ResourceRecordSet wrappedRrset : zone.dnsRecords().get().values()) {
                    if (!rrset.getName().equals(wrappedRrset.getName()) || !rrset.getType().equals(wrappedRrset.getType()) || deletions != null && deletions.contains(wrappedRrset)) continue;
                    return Error.ALREADY_EXISTS.response(String.format("The 'entity.change.additions[%s]' resource named '%s (%s)' already exists.", index, rrset.getName(), rrset.getType()));
                }
                if (rrset.getType().equals("SOA") && LocalDnsHelper.findByNameAndType(deletions, null, "SOA") == null) {
                    return Error.INVALID_ZONE_APEX.response(String.format("The resource record set 'entity.change.additions[%s]' is invalid because a zone must contain exactly one resource record set of type 'SOA' at the apex.", index));
                }
                if (rrset.getType().equals("NS") && LocalDnsHelper.findByNameAndType(deletions, null, "NS") == null) {
                    return Error.INVALID_ZONE_APEX.response(String.format("The resource record set 'entity.change.additions[%s]' is invalid because a zone must contain exactly one resource record set of type 'NS' at the apex.", index));
                }
                ++index;
            }
        }
        if (deletions != null) {
            index = 0;
            for (ResourceRecordSet rrset : deletions) {
                if (rrset.getType().equals("SOA") && LocalDnsHelper.findByNameAndType(additions, null, "SOA") == null) {
                    return Error.INVALID_ZONE_APEX.response(String.format("The resource record set 'entity.change.deletions[%s]' is invalid because a zone must contain exactly one resource record set of type 'SOA' at the apex.", index));
                }
                if (rrset.getType().equals("NS") && LocalDnsHelper.findByNameAndType(additions, null, "NS") == null) {
                    return Error.INVALID_ZONE_APEX.response(String.format("The resource record set 'entity.change.deletions[%s]' is invalid because a zone must contain exactly one resource record set of type 'NS' at the apex.", index));
                }
                ++index;
            }
        }
        return null;
    }

    private static ResourceRecordSet findByNameAndType(Iterable<ResourceRecordSet> recordSets, String name, String type) {
        if (recordSets != null) {
            for (ResourceRecordSet rrset : recordSets) {
                if (name != null && !name.equals(rrset.getName()) || type != null && !type.equals(rrset.getType())) continue;
                return rrset;
            }
        }
        return null;
    }

    static boolean checkRrData(String data, String type) {
        switch (type) {
            case "A": {
                return !data.contains(":") && InetAddresses.isInetAddress((String)data);
            }
            case "AAAA": {
                return data.contains(":") && InetAddresses.isInetAddress((String)data);
            }
        }
        return true;
    }

    @VisibleForTesting
    static Response checkListOptions(Map<String, Object> options) {
        String order;
        String dnsName;
        String maxResultsString = (String)options.get("maxResults");
        if (maxResultsString != null) {
            Integer maxResults;
            try {
                maxResults = Integer.valueOf(maxResultsString);
            }
            catch (NumberFormatException ex) {
                return Error.INVALID.response(String.format("Invalid integer value': '%s'.", maxResultsString));
            }
            if (maxResults <= 0) {
                return Error.INVALID.response(String.format("Invalid value for 'parameters.maxResults': '%s'", maxResults));
            }
        }
        if ((dnsName = (String)options.get("dnsName")) != null && !dnsName.endsWith(".")) {
            return Error.INVALID.response(String.format("Invalid value for 'parameters.dnsName': '%s'", dnsName));
        }
        String name = (String)options.get("name");
        if (name != null && !name.endsWith(".")) {
            return Error.INVALID.response(String.format("Invalid value for 'parameters.name': '%s'", name));
        }
        String type = (String)options.get("type");
        if (type != null) {
            if (name == null) {
                return Error.INVALID.response("Invalid value for 'parameters.name': '' (name must be specified if type is specified)");
            }
            if (!TYPES.contains(type)) {
                return Error.INVALID.response(String.format("Invalid value for 'parameters.type': '%s'", type));
            }
        }
        if ((order = (String)options.get("sortOrder")) != null && !"ascending".equals(order) && !"descending".equals(order)) {
            return Error.INVALID.response(String.format("Invalid value for 'parameters.sortOrder': '%s'", order));
        }
        String sortBy = (String)options.get("sortBy");
        if (sortBy != null && !"changesequence".equals(sortBy.toLowerCase())) {
            return Error.INVALID.response(String.format("Invalid string value: '%s'. Allowed values: [changesequence]", sortBy));
        }
        return null;
    }

    static {
        log = Logger.getLogger(LocalDnsHelper.class.getName());
        jsonFactory = new JacksonFactory();
        ID_GENERATOR = new Random();
        ENCODINGS = ImmutableSet.of((Object)"gzip", (Object)"x-gzip");
        TYPES = ImmutableList.of((Object)"A", (Object)"AAAA", (Object)"CNAME", (Object)"MX", (Object)"NAPTR", (Object)"NS", (Object)"PTR", (Object)"SOA", (Object)"SPF", (Object)"SRV", (Object)"TXT");
        FORBIDDEN = Sets.newTreeSet((Iterable)ImmutableList.of((Object)"google.com.", (Object)"com.", (Object)"example.com.", (Object)"net.", (Object)"org."));
        ZONE_NAME_RE = Pattern.compile("[a-z][a-z0-9-]*");
        EXECUTORS = Executors.newScheduledThreadPool(2, Executors.defaultThreadFactory());
        try {
            BASE_CONTEXT = new URI(CONTEXT);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not initialize LocalDnsHelper due to URISyntaxException.", e);
        }
    }

    private class RequestHandler
    implements HttpHandler {
        private RequestHandler() {
        }

        private Response pickHandler(HttpExchange exchange, CallRegex regex) {
            URI relative = BASE_CONTEXT.relativize(exchange.getRequestURI());
            String path = relative.getPath();
            String[] tokens = path.split("/");
            String projectId = tokens.length > 0 ? tokens[0] : null;
            String zoneName = tokens.length > 2 ? tokens[2] : null;
            String changeId = tokens.length > 4 ? tokens[4] : null;
            String query = relative.getQuery();
            switch (regex) {
                case CHANGE_GET: {
                    return LocalDnsHelper.this.getChange(projectId, zoneName, changeId, query);
                }
                case CHANGE_LIST: {
                    return LocalDnsHelper.this.listChanges(projectId, zoneName, query);
                }
                case ZONE_GET: {
                    return LocalDnsHelper.this.getZone(projectId, zoneName, query);
                }
                case ZONE_DELETE: {
                    return LocalDnsHelper.this.deleteZone(projectId, zoneName);
                }
                case ZONE_LIST: {
                    return LocalDnsHelper.this.listZones(projectId, query);
                }
                case PROJECT_GET: {
                    return LocalDnsHelper.this.getProject(projectId, query);
                }
                case RECORD_LIST: {
                    return LocalDnsHelper.this.listDnsRecords(projectId, zoneName, query);
                }
                case ZONE_CREATE: {
                    try {
                        return this.handleZoneCreate(exchange, projectId, query);
                    }
                    catch (IOException ex) {
                        return Error.BAD_REQUEST.response(ex.getMessage());
                    }
                }
                case CHANGE_CREATE: {
                    try {
                        return this.handleChangeCreate(exchange, projectId, zoneName, query);
                    }
                    catch (IOException ex) {
                        return Error.BAD_REQUEST.response(ex.getMessage());
                    }
                }
                case BATCH: {
                    try {
                        return this.handleBatch(exchange);
                    }
                    catch (IOException | URISyntaxException ex) {
                        return Error.BAD_REQUEST.response(ex.getMessage());
                    }
                }
            }
            return Error.INTERNAL_ERROR.response("Operation without a handler.");
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String requestMethod = exchange.getRequestMethod();
            String rawPath = exchange.getRequestURI().getRawPath();
            for (CallRegex regex : CallRegex.values()) {
                if (!requestMethod.equals(regex.method) || !rawPath.matches(regex.pathRegex)) continue;
                Response response = this.pickHandler(exchange, regex);
                if (response != null) {
                    LocalDnsHelper.writeResponse(exchange, response);
                }
                return;
            }
            LocalDnsHelper.writeResponse(exchange, Error.NOT_FOUND.response(String.format("The url %s for %s method does not match any API call.", requestMethod, exchange.getRequestURI())));
        }

        private Response handleBatch(HttpExchange exchange) throws IOException, URISyntaxException {
            ByteArrayOutputStream out;
            String contentType = exchange.getRequestHeaders().getFirst("Content-type");
            if (contentType != null) {
                HttpMediaType httpMediaType = new HttpMediaType(contentType);
                String boundary = httpMediaType.getParameter("boundary");
                MultipartStream multipartStream = new MultipartStream(exchange.getRequestBody(), boundary.getBytes(), 1024, null);
                out = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                boolean nextPart = multipartStream.skipPreamble();
                while (nextPart) {
                    int length;
                    String contentId = null;
                    String headers = multipartStream.readHeaders();
                    Scanner scanner = new Scanner(headers);
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        if (!line.toLowerCase().startsWith("content-id")) continue;
                        contentId = line.split(":")[1].trim();
                    }
                    ByteArrayOutputStream bouts = new ByteArrayOutputStream();
                    multipartStream.readBodyData((OutputStream)bouts);
                    byte[] contentBytes = bouts.toByteArray();
                    int indexOfCr = -1;
                    for (int i = 0; i < contentBytes.length; ++i) {
                        if (contentBytes[i] != 13) continue;
                        indexOfCr = i;
                        break;
                    }
                    Socket socket = new Socket("127.0.0.1", LocalDnsHelper.this.server.getAddress().getPort());
                    OutputStream socketOutput = socket.getOutputStream();
                    InputStream socketInput = socket.getInputStream();
                    if (indexOfCr < 0) {
                        socketOutput.write(contentBytes);
                    } else {
                        String[] requestLine = new String(contentBytes, 0, indexOfCr, StandardCharsets.UTF_8).split(" ");
                        socketOutput.write(requestLine[0].getBytes());
                        socketOutput.write(32);
                        URI uri = new URI(requestLine[1]);
                        socketOutput.write(uri.getRawPath().getBytes());
                        if (uri.getRawQuery() != null) {
                            socketOutput.write(63);
                            socketOutput.write(uri.getRawQuery().getBytes());
                        }
                        if (uri.getRawFragment() != null) {
                            socketOutput.write(35);
                            socketOutput.write(uri.getRawFragment().getBytes());
                        }
                        socketOutput.write(" HTTP/1.0".getBytes());
                        socketOutput.write(contentBytes, indexOfCr, contentBytes.length - indexOfCr);
                    }
                    socketOutput.flush();
                    out.write(LocalDnsHelper.RESPONSE_SEPARATOR.getBytes());
                    out.write("Content-Type: application/http\r\n".getBytes());
                    out.write(("Content-ID: " + contentId + "\r\n\r\n").getBytes());
                    while ((length = socketInput.read(bytes)) != -1) {
                        out.write(bytes, 0, length);
                    }
                    socket.close();
                    nextPart = multipartStream.skipPreamble();
                }
            } else {
                return Error.BAD_REQUEST.response("Content-type header was not provided for batch.");
            }
            out.write(LocalDnsHelper.RESPONSE_END.getBytes());
            LocalDnsHelper.writeBatchResponse(exchange, out);
            return null;
        }

        private Response handleChangeCreate(HttpExchange exchange, String projectId, String zoneName, String query) throws IOException {
            Change change;
            String requestBody = LocalDnsHelper.decodeContent(exchange.getRequestHeaders(), exchange.getRequestBody());
            try {
                change = (Change)jsonFactory.fromString(requestBody, Change.class);
            }
            catch (IllegalArgumentException ex) {
                return Error.REQUIRED.response("The 'entity.change' parameter is required but was missing.");
            }
            String[] fields = OptionParsers.parseGetOptions(query);
            return LocalDnsHelper.this.createChange(projectId, zoneName, change, fields);
        }

        private Response handleZoneCreate(HttpExchange exchange, String projectId, String query) throws IOException {
            ManagedZone zone;
            String requestBody = LocalDnsHelper.decodeContent(exchange.getRequestHeaders(), exchange.getRequestBody());
            try {
                zone = (ManagedZone)jsonFactory.fromString(requestBody, ManagedZone.class);
            }
            catch (IllegalArgumentException ex) {
                return Error.REQUIRED.response("The 'entity.managedZone' parameter is required but was missing.");
            }
            String[] options = OptionParsers.parseGetOptions(query);
            return LocalDnsHelper.this.createZone(projectId, zone, options);
        }
    }

    private static enum Error {
        REQUIRED(400, "global", "required", "REQUIRED"),
        INTERNAL_ERROR(500, "global", "internalError", "INTERNAL_ERROR"),
        BAD_REQUEST(400, "global", "badRequest", "BAD_REQUEST"),
        INVALID(400, "global", "invalid", "INVALID"),
        CONTAINER_NOT_EMPTY(400, "global", "containerNotEmpty", "CONTAINER_NOT_EMPTY"),
        NOT_AVAILABLE(400, "global", "managedZoneDnsNameNotAvailable", "NOT_AVAILABLE"),
        NOT_FOUND(404, "global", "notFound", "NOT_FOUND"),
        ALREADY_EXISTS(409, "global", "alreadyExists", "ALREADY_EXISTS"),
        CONDITION_NOT_MET(412, "global", "conditionNotMet", "CONDITION_NOT_MET"),
        INVALID_ZONE_APEX(400, "global", "invalidZoneApex", "INVALID_ZONE_APEX");

        private final int code;
        private final String domain;
        private final String reason;
        private final String status;

        private Error(int code, String domain, String reason, String status) {
            this.code = code;
            this.domain = domain;
            this.reason = reason;
            this.status = status;
        }

        Response response(String message) {
            try {
                return new Response(this.code, this.toJson(message));
            }
            catch (IOException e) {
                return INTERNAL_ERROR.response("Error when generating JSON error response.");
            }
        }

        private String toJson(String message) throws IOException {
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("domain", this.domain);
            errors.put("message", message);
            errors.put("reason", this.reason);
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("errors", ImmutableList.of(errors));
            args.put("code", this.code);
            args.put("message", message);
            args.put("status", this.status);
            return jsonFactory.toString((Object)ImmutableMap.of((Object)"error", args));
        }
    }

    static class Response {
        private final int code;
        private final String body;

        Response(int code, String body) {
            this.code = code;
            this.body = body;
        }

        int code() {
            return this.code;
        }

        String body() {
            return this.body;
        }
    }

    static class ZoneContainer {
        private final ManagedZone zone;
        private final AtomicReference<ImmutableSortedMap<String, ResourceRecordSet>> dnsRecords = new AtomicReference<ImmutableSortedMap>(ImmutableSortedMap.of());
        private final ConcurrentLinkedQueue<Change> changes = new ConcurrentLinkedQueue();

        ZoneContainer(ManagedZone zone) {
            this.zone = zone;
            this.dnsRecords.set((ImmutableSortedMap<String, ResourceRecordSet>)ImmutableSortedMap.of());
        }

        ManagedZone zone() {
            return this.zone;
        }

        AtomicReference<ImmutableSortedMap<String, ResourceRecordSet>> dnsRecords() {
            return this.dnsRecords;
        }

        ConcurrentLinkedQueue<Change> changes() {
            return this.changes;
        }

        Change findChange(String changeId) {
            for (Change current : this.changes) {
                if (!changeId.equals(current.getId())) continue;
                return current;
            }
            return null;
        }
    }

    static class ProjectContainer {
        private final Project project;
        private final ConcurrentSkipListMap<String, ZoneContainer> zones = new ConcurrentSkipListMap();

        ProjectContainer(Project project) {
            this.project = project;
        }

        Project project() {
            return this.project;
        }

        ConcurrentSkipListMap<String, ZoneContainer> zones() {
            return this.zones;
        }
    }

    private static enum CallRegex {
        CHANGE_CREATE("POST", "/dns/v1/projects/[^/]+/managedZones/[^/]+/changes"),
        CHANGE_GET("GET", "/dns/v1/projects/[^/]+/managedZones/[^/]+/changes/[^/]+"),
        CHANGE_LIST("GET", "/dns/v1/projects/[^/]+/managedZones/[^/]+/changes"),
        ZONE_CREATE("POST", "/dns/v1/projects/[^/]+/managedZones"),
        ZONE_DELETE("DELETE", "/dns/v1/projects/[^/]+/managedZones/[^/]+"),
        ZONE_GET("GET", "/dns/v1/projects/[^/]+/managedZones/[^/]+"),
        ZONE_LIST("GET", "/dns/v1/projects/[^/]+/managedZones"),
        PROJECT_GET("GET", "/dns/v1/projects/[^/]+"),
        RECORD_LIST("GET", "/dns/v1/projects/[^/]+/managedZones/[^/]+/rrsets"),
        BATCH("POST", "/batch");

        private final String method;
        private final String pathRegex;

        private CallRegex(String method, String pathRegex) {
            this.pathRegex = pathRegex;
            this.method = method;
        }
    }
}

