/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns;

import com.google.api.services.dns.model.Change;
import com.google.cloud.dns.ChangeRequestInfo;
import com.google.cloud.dns.Dns;
import com.google.cloud.dns.DnsOptions;
import com.google.cloud.dns.RecordSet;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Objects;

public class ChangeRequest
extends ChangeRequestInfo {
    private static final long serialVersionUID = 5335667200595081449L;
    private final DnsOptions options;
    private final String zone;
    private transient Dns dns;

    ChangeRequest(Dns dns, String zone, ChangeRequestInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.zone = (String)Preconditions.checkNotNull((Object)zone);
        this.dns = (Dns)Preconditions.checkNotNull((Object)dns);
        this.options = (DnsOptions)dns.options();
    }

    public String zone() {
        return this.zone;
    }

    public Dns dns() {
        return this.dns;
    }

    public ChangeRequest applyTo(String zoneName, Dns.ChangeRequestOption ... options) {
        return this.dns.applyChangeRequest(zoneName, this, options);
    }

    public ChangeRequest reload(Dns.ChangeRequestOption ... options) {
        return this.dns.getChangeRequest(this.zone, this.generatedId(), options);
    }

    public boolean isDone() {
        if (this.status() == ChangeRequestInfo.Status.DONE) {
            return true;
        }
        ChangeRequest updated = this.reload(Dns.ChangeRequestOption.fields(Dns.ChangeRequestField.STATUS));
        return updated == null || updated.status() == ChangeRequestInfo.Status.DONE;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(ChangeRequest.class)) {
            return false;
        }
        ChangeRequest other = (ChangeRequest)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options) && Objects.equals(this.zone, other.zone);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options, this.zone});
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.dns = (Dns)this.options.service();
    }

    static ChangeRequest fromPb(Dns dns, String zoneName, Change pb) {
        ChangeRequestInfo info = ChangeRequestInfo.fromPb(pb);
        return new ChangeRequest(dns, zoneName, new ChangeRequestInfo.BuilderImpl(info));
    }

    static Function<Change, ChangeRequest> fromPbFunction(final Dns dns, final String zoneName) {
        return new Function<Change, ChangeRequest>(){

            public ChangeRequest apply(Change pb) {
                return ChangeRequest.fromPb(dns, zoneName, pb);
            }
        };
    }

    public static class Builder
    extends ChangeRequestInfo.Builder {
        private final Dns dns;
        private final String zone;
        private final ChangeRequestInfo.BuilderImpl infoBuilder;

        private Builder(ChangeRequest cr) {
            this.dns = cr.dns;
            this.zone = cr.zone;
            this.infoBuilder = new ChangeRequestInfo.BuilderImpl(cr);
        }

        @Override
        public Builder additions(List<RecordSet> additions) {
            this.infoBuilder.additions(additions);
            return this;
        }

        @Override
        public Builder deletions(List<RecordSet> deletions) {
            this.infoBuilder.deletions(deletions);
            return this;
        }

        @Override
        public Builder add(RecordSet recordSet) {
            this.infoBuilder.add(recordSet);
            return this;
        }

        @Override
        public Builder delete(RecordSet recordSet) {
            this.infoBuilder.delete(recordSet);
            return this;
        }

        @Override
        public Builder clearAdditions() {
            this.infoBuilder.clearAdditions();
            return this;
        }

        @Override
        public Builder clearDeletions() {
            this.infoBuilder.clearDeletions();
            return this;
        }

        @Override
        public Builder removeAddition(RecordSet recordSet) {
            this.infoBuilder.removeAddition(recordSet);
            return this;
        }

        @Override
        public Builder removeDeletion(RecordSet recordSet) {
            this.infoBuilder.removeDeletion(recordSet);
            return this;
        }

        @Override
        Builder generatedId(String generatedId) {
            this.infoBuilder.generatedId(generatedId);
            return this;
        }

        @Override
        Builder startTimeMillis(long startTimeMillis) {
            this.infoBuilder.startTimeMillis(startTimeMillis);
            return this;
        }

        @Override
        Builder status(ChangeRequestInfo.Status status) {
            this.infoBuilder.status(status);
            return this;
        }

        @Override
        public ChangeRequest build() {
            return new ChangeRequest(this.dns, this.zone, this.infoBuilder);
        }
    }
}

