/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns;

import com.google.api.services.dns.model.ManagedZone;
import com.google.cloud.Page;
import com.google.cloud.dns.ChangeRequest;
import com.google.cloud.dns.ChangeRequestInfo;
import com.google.cloud.dns.Dns;
import com.google.cloud.dns.DnsOptions;
import com.google.cloud.dns.RecordSet;
import com.google.cloud.dns.ZoneInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Objects;

public class Zone
extends ZoneInfo {
    private static final long serialVersionUID = -5817771337847861598L;
    private final DnsOptions options;
    private transient Dns dns;

    Zone(Dns dns, ZoneInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.dns = dns;
        this.options = (DnsOptions)dns.options();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public Zone reload(Dns.ZoneOption ... options) {
        return this.dns.getZone(this.name(), options);
    }

    public boolean delete() {
        return this.dns.delete(this.name());
    }

    public Page<RecordSet> listRecordSets(Dns.RecordSetListOption ... options) {
        return this.dns.listRecordSets(this.name(), options);
    }

    public ChangeRequest applyChangeRequest(ChangeRequestInfo changeRequest, Dns.ChangeRequestOption ... options) {
        Preconditions.checkNotNull((Object)changeRequest);
        return this.dns.applyChangeRequest(this.name(), changeRequest, options);
    }

    public ChangeRequest getChangeRequest(String changeRequestId, Dns.ChangeRequestOption ... options) {
        Preconditions.checkNotNull((Object)changeRequestId);
        return this.dns.getChangeRequest(this.name(), changeRequestId, options);
    }

    public Page<ChangeRequest> listChangeRequests(Dns.ChangeRequestListOption ... options) {
        return this.dns.listChangeRequests(this.name(), options);
    }

    public Dns dns() {
        return this.dns;
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Zone.class)) {
            return false;
        }
        Zone other = (Zone)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.dns = (Dns)this.options.service();
    }

    static Zone fromPb(Dns dns, ManagedZone zone) {
        ZoneInfo info = ZoneInfo.fromPb(zone);
        return new Zone(dns, new ZoneInfo.BuilderImpl(info));
    }

    public static class Builder
    extends ZoneInfo.Builder {
        private final Dns dns;
        private final ZoneInfo.BuilderImpl infoBuilder;

        private Builder(Zone zone) {
            this.dns = zone.dns;
            this.infoBuilder = new ZoneInfo.BuilderImpl(zone);
        }

        @Override
        public Builder name(String name) {
            this.infoBuilder.name(name);
            return this;
        }

        @Override
        Builder generatedId(String generatedId) {
            this.infoBuilder.generatedId(generatedId);
            return this;
        }

        @Override
        Builder creationTimeMillis(long creationTimeMillis) {
            this.infoBuilder.creationTimeMillis(creationTimeMillis);
            return this;
        }

        @Override
        public Builder dnsName(String dnsName) {
            this.infoBuilder.dnsName(dnsName);
            return this;
        }

        @Override
        public Builder description(String description) {
            this.infoBuilder.description(description);
            return this;
        }

        @Override
        Builder nameServerSet(String nameServerSet) {
            this.infoBuilder.nameServerSet(nameServerSet);
            return this;
        }

        @Override
        Builder nameServers(List<String> nameServers) {
            this.infoBuilder.nameServers(nameServers);
            return this;
        }

        @Override
        public Zone build() {
            return new Zone(this.dns, this.infoBuilder);
        }
    }
}

