/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns;

import com.google.api.services.dns.model.Change;
import com.google.api.services.dns.model.ManagedZone;
import com.google.api.services.dns.model.Project;
import com.google.api.services.dns.model.ResourceRecordSet;
import com.google.cloud.BaseService;
import com.google.cloud.Clock;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.Page;
import com.google.cloud.PageImpl;
import com.google.cloud.RetryHelper;
import com.google.cloud.RetryParams;
import com.google.cloud.ServiceOptions;
import com.google.cloud.dns.ChangeRequest;
import com.google.cloud.dns.ChangeRequestInfo;
import com.google.cloud.dns.Dns;
import com.google.cloud.dns.DnsBatch;
import com.google.cloud.dns.DnsException;
import com.google.cloud.dns.DnsOptions;
import com.google.cloud.dns.Option;
import com.google.cloud.dns.ProjectInfo;
import com.google.cloud.dns.RecordSet;
import com.google.cloud.dns.Zone;
import com.google.cloud.dns.ZoneInfo;
import com.google.cloud.dns.spi.DnsRpc;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.Callable;

final class DnsImpl
extends BaseService<DnsOptions>
implements Dns {
    private final DnsRpc dnsRpc;

    DnsImpl(DnsOptions options) {
        super((ServiceOptions)options);
        this.dnsRpc = (DnsRpc)options.rpc();
    }

    static Function<ManagedZone, Zone> zoneFromPb(final DnsOptions options) {
        return new Function<ManagedZone, Zone>(){

            public Zone apply(ManagedZone zonePb) {
                return Zone.fromPb((Dns)options.service(), zonePb);
            }
        };
    }

    @Override
    public Page<Zone> listZones(Dns.ZoneListOption ... options) {
        return DnsImpl.listZones((DnsOptions)this.options(), DnsImpl.optionMap(options));
    }

    private static Page<Zone> listZones(DnsOptions serviceOptions, final Map<DnsRpc.Option, ?> optionsMap) {
        try {
            final DnsRpc rpc = (DnsRpc)serviceOptions.rpc();
            DnsRpc.ListResult result = (DnsRpc.ListResult)RetryHelper.runWithRetries((Callable)new Callable<DnsRpc.ListResult<ManagedZone>>(){

                @Override
                public DnsRpc.ListResult<ManagedZone> call() {
                    return rpc.listZones(optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)serviceOptions.clock());
            String cursor = result.pageToken();
            ImmutableList zones = result.results() == null ? ImmutableList.of() : Iterables.transform(result.results(), DnsImpl.zoneFromPb(serviceOptions));
            return new PageImpl((PageImpl.NextPageFetcher)new ZonePageFetcher(serviceOptions, cursor, optionsMap), cursor, (Iterable)zones);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DnsException.translateAndThrow(e);
        }
    }

    @Override
    public Page<ChangeRequest> listChangeRequests(String zoneName, Dns.ChangeRequestListOption ... options) {
        return DnsImpl.listChangeRequests(zoneName, (DnsOptions)this.options(), DnsImpl.optionMap(options));
    }

    private static Page<ChangeRequest> listChangeRequests(final String zoneName, DnsOptions serviceOptions, final Map<DnsRpc.Option, ?> optionsMap) {
        try {
            final DnsRpc rpc = (DnsRpc)serviceOptions.rpc();
            DnsRpc.ListResult result = (DnsRpc.ListResult)RetryHelper.runWithRetries((Callable)new Callable<DnsRpc.ListResult<Change>>(){

                @Override
                public DnsRpc.ListResult<Change> call() {
                    return rpc.listChangeRequests(zoneName, optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)serviceOptions.clock());
            String cursor = result.pageToken();
            ImmutableList changes = result.results() == null ? ImmutableList.of() : Iterables.transform(result.results(), ChangeRequest.fromPbFunction((Dns)serviceOptions.service(), zoneName));
            return new PageImpl((PageImpl.NextPageFetcher)new ChangeRequestPageFetcher(zoneName, serviceOptions, cursor, optionsMap), cursor, (Iterable)changes);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DnsException.translateAndThrow(e);
        }
    }

    @Override
    public Page<RecordSet> listRecordSets(String zoneName, Dns.RecordSetListOption ... options) {
        return DnsImpl.listRecordSets(zoneName, (DnsOptions)this.options(), DnsImpl.optionMap(options));
    }

    private static Page<RecordSet> listRecordSets(final String zoneName, DnsOptions serviceOptions, final Map<DnsRpc.Option, ?> optionsMap) {
        try {
            final DnsRpc rpc = (DnsRpc)serviceOptions.rpc();
            DnsRpc.ListResult result = (DnsRpc.ListResult)RetryHelper.runWithRetries((Callable)new Callable<DnsRpc.ListResult<ResourceRecordSet>>(){

                @Override
                public DnsRpc.ListResult<ResourceRecordSet> call() {
                    return rpc.listRecordSets(zoneName, optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)serviceOptions.clock());
            String cursor = result.pageToken();
            ImmutableList recordSets = result.results() == null ? ImmutableList.of() : Iterables.transform(result.results(), RecordSet.FROM_PB_FUNCTION);
            return new PageImpl((PageImpl.NextPageFetcher)new RecordSetPageFetcher(zoneName, serviceOptions, cursor, optionsMap), cursor, (Iterable)recordSets);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DnsException.translateAndThrow(e);
        }
    }

    @Override
    public Zone create(final ZoneInfo zoneInfo, Dns.ZoneOption ... options) {
        final Map<DnsRpc.Option, ?> optionsMap = DnsImpl.optionMap(options);
        try {
            ManagedZone answer = (ManagedZone)RetryHelper.runWithRetries((Callable)new Callable<ManagedZone>(){

                @Override
                public ManagedZone call() {
                    return DnsImpl.this.dnsRpc.create(zoneInfo.toPb(), optionsMap);
                }
            }, (RetryParams)((DnsOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((DnsOptions)this.options()).clock());
            return answer == null ? null : Zone.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw DnsException.translateAndThrow(ex);
        }
    }

    @Override
    public Zone getZone(final String zoneName, Dns.ZoneOption ... options) {
        final Map<DnsRpc.Option, ?> optionsMap = DnsImpl.optionMap(options);
        try {
            ManagedZone answer = (ManagedZone)RetryHelper.runWithRetries((Callable)new Callable<ManagedZone>(){

                @Override
                public ManagedZone call() {
                    return DnsImpl.this.dnsRpc.getZone(zoneName, optionsMap);
                }
            }, (RetryParams)((DnsOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((DnsOptions)this.options()).clock());
            return answer == null ? null : Zone.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw DnsException.translateAndThrow(ex);
        }
    }

    @Override
    public boolean delete(final String zoneName) {
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return DnsImpl.this.dnsRpc.deleteZone(zoneName);
                }
            }, (RetryParams)((DnsOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((DnsOptions)this.options()).clock());
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw DnsException.translateAndThrow(ex);
        }
    }

    @Override
    public ProjectInfo getProject(Dns.ProjectOption ... fields) {
        final Map<DnsRpc.Option, ?> optionsMap = DnsImpl.optionMap(fields);
        try {
            Project answer = (Project)RetryHelper.runWithRetries((Callable)new Callable<Project>(){

                @Override
                public Project call() {
                    return DnsImpl.this.dnsRpc.getProject(optionsMap);
                }
            }, (RetryParams)((DnsOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((DnsOptions)this.options()).clock());
            return answer == null ? null : ProjectInfo.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw DnsException.translateAndThrow(ex);
        }
    }

    @Override
    public ChangeRequest applyChangeRequest(final String zoneName, final ChangeRequestInfo changeRequest, Dns.ChangeRequestOption ... options) {
        final Map<DnsRpc.Option, ?> optionsMap = DnsImpl.optionMap(options);
        try {
            Change answer = (Change)RetryHelper.runWithRetries((Callable)new Callable<Change>(){

                @Override
                public Change call() {
                    return DnsImpl.this.dnsRpc.applyChangeRequest(zoneName, changeRequest.toPb(), optionsMap);
                }
            }, (RetryParams)((DnsOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((DnsOptions)this.options()).clock());
            return answer == null ? null : ChangeRequest.fromPb(this, zoneName, answer);
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw DnsException.translateAndThrow(ex);
        }
    }

    @Override
    public ChangeRequest getChangeRequest(final String zoneName, final String changeRequestId, Dns.ChangeRequestOption ... options) {
        final Map<DnsRpc.Option, ?> optionsMap = DnsImpl.optionMap(options);
        try {
            Change answer = (Change)RetryHelper.runWithRetries((Callable)new Callable<Change>(){

                @Override
                public Change call() {
                    return DnsImpl.this.dnsRpc.getChangeRequest(zoneName, changeRequestId, optionsMap);
                }
            }, (RetryParams)((DnsOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((DnsOptions)this.options()).clock());
            return answer == null ? null : ChangeRequest.fromPb(this, zoneName, answer);
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw DnsException.translateAndThrow(ex);
        }
    }

    @Override
    public DnsBatch batch() {
        return new DnsBatch((DnsOptions)this.options());
    }

    static Map<DnsRpc.Option, ?> optionMap(Option ... options) {
        EnumMap temp = Maps.newEnumMap(DnsRpc.Option.class);
        for (Option option : options) {
            Object prev = temp.put(option.rpcOption(), option.value());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object[])new Object[]{option});
        }
        return ImmutableMap.copyOf((Map)temp);
    }

    static class RecordSetPageFetcher
    implements PageImpl.NextPageFetcher<RecordSet> {
        private static final long serialVersionUID = -6039369212511530846L;
        private final Map<DnsRpc.Option, ?> requestOptions;
        private final DnsOptions serviceOptions;
        private final String zoneName;

        RecordSetPageFetcher(String zoneName, DnsOptions serviceOptions, String cursor, Map<DnsRpc.Option, ?> optionMap) {
            this.zoneName = zoneName;
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)DnsRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<RecordSet> nextPage() {
            return DnsImpl.listRecordSets(this.zoneName, this.serviceOptions, this.requestOptions);
        }
    }

    static class ChangeRequestPageFetcher
    implements PageImpl.NextPageFetcher<ChangeRequest> {
        private static final long serialVersionUID = 4473265130673029139L;
        private final String zoneName;
        private final Map<DnsRpc.Option, ?> requestOptions;
        private final DnsOptions serviceOptions;

        ChangeRequestPageFetcher(String zoneName, DnsOptions serviceOptions, String cursor, Map<DnsRpc.Option, ?> optionMap) {
            this.zoneName = zoneName;
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)DnsRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<ChangeRequest> nextPage() {
            return DnsImpl.listChangeRequests(this.zoneName, this.serviceOptions, this.requestOptions);
        }
    }

    static class ZonePageFetcher
    implements PageImpl.NextPageFetcher<Zone> {
        private static final long serialVersionUID = 2158209410430566961L;
        private final Map<DnsRpc.Option, ?> requestOptions;
        private final DnsOptions serviceOptions;

        ZonePageFetcher(DnsOptions serviceOptions, String cursor, Map<DnsRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)DnsRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Zone> nextPage() {
            return DnsImpl.listZones(this.serviceOptions, this.requestOptions);
        }
    }
}

