/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.edgecontainer.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.edgecontainer.v1.Cluster;
import com.google.cloud.edgecontainer.v1.CreateClusterRequest;
import com.google.cloud.edgecontainer.v1.CreateNodePoolRequest;
import com.google.cloud.edgecontainer.v1.CreateVpnConnectionRequest;
import com.google.cloud.edgecontainer.v1.DeleteClusterRequest;
import com.google.cloud.edgecontainer.v1.DeleteNodePoolRequest;
import com.google.cloud.edgecontainer.v1.DeleteVpnConnectionRequest;
import com.google.cloud.edgecontainer.v1.EdgeContainerClient;
import com.google.cloud.edgecontainer.v1.GenerateAccessTokenRequest;
import com.google.cloud.edgecontainer.v1.GenerateAccessTokenResponse;
import com.google.cloud.edgecontainer.v1.GenerateOfflineCredentialRequest;
import com.google.cloud.edgecontainer.v1.GenerateOfflineCredentialResponse;
import com.google.cloud.edgecontainer.v1.GetClusterRequest;
import com.google.cloud.edgecontainer.v1.GetMachineRequest;
import com.google.cloud.edgecontainer.v1.GetNodePoolRequest;
import com.google.cloud.edgecontainer.v1.GetServerConfigRequest;
import com.google.cloud.edgecontainer.v1.GetVpnConnectionRequest;
import com.google.cloud.edgecontainer.v1.ListClustersRequest;
import com.google.cloud.edgecontainer.v1.ListClustersResponse;
import com.google.cloud.edgecontainer.v1.ListMachinesRequest;
import com.google.cloud.edgecontainer.v1.ListMachinesResponse;
import com.google.cloud.edgecontainer.v1.ListNodePoolsRequest;
import com.google.cloud.edgecontainer.v1.ListNodePoolsResponse;
import com.google.cloud.edgecontainer.v1.ListVpnConnectionsRequest;
import com.google.cloud.edgecontainer.v1.ListVpnConnectionsResponse;
import com.google.cloud.edgecontainer.v1.Machine;
import com.google.cloud.edgecontainer.v1.NodePool;
import com.google.cloud.edgecontainer.v1.OperationMetadata;
import com.google.cloud.edgecontainer.v1.ServerConfig;
import com.google.cloud.edgecontainer.v1.UpdateClusterRequest;
import com.google.cloud.edgecontainer.v1.UpdateNodePoolRequest;
import com.google.cloud.edgecontainer.v1.UpgradeClusterRequest;
import com.google.cloud.edgecontainer.v1.VpnConnection;
import com.google.cloud.edgecontainer.v1.stub.EdgeContainerStub;
import com.google.cloud.edgecontainer.v1.stub.GrpcEdgeContainerStub;
import com.google.cloud.edgecontainer.v1.stub.HttpJsonEdgeContainerStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class EdgeContainerStubSettings
extends StubSettings<EdgeContainerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListClustersRequest, ListClustersResponse, EdgeContainerClient.ListClustersPagedResponse> listClustersSettings;
    private final UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings;
    private final UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings;
    private final OperationCallSettings<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings;
    private final UnaryCallSettings<UpdateClusterRequest, Operation> updateClusterSettings;
    private final OperationCallSettings<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings;
    private final UnaryCallSettings<UpgradeClusterRequest, Operation> upgradeClusterSettings;
    private final OperationCallSettings<UpgradeClusterRequest, Cluster, OperationMetadata> upgradeClusterOperationSettings;
    private final UnaryCallSettings<DeleteClusterRequest, Operation> deleteClusterSettings;
    private final OperationCallSettings<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings;
    private final UnaryCallSettings<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenSettings;
    private final UnaryCallSettings<GenerateOfflineCredentialRequest, GenerateOfflineCredentialResponse> generateOfflineCredentialSettings;
    private final PagedCallSettings<ListNodePoolsRequest, ListNodePoolsResponse, EdgeContainerClient.ListNodePoolsPagedResponse> listNodePoolsSettings;
    private final UnaryCallSettings<GetNodePoolRequest, NodePool> getNodePoolSettings;
    private final UnaryCallSettings<CreateNodePoolRequest, Operation> createNodePoolSettings;
    private final OperationCallSettings<CreateNodePoolRequest, NodePool, OperationMetadata> createNodePoolOperationSettings;
    private final UnaryCallSettings<UpdateNodePoolRequest, Operation> updateNodePoolSettings;
    private final OperationCallSettings<UpdateNodePoolRequest, NodePool, OperationMetadata> updateNodePoolOperationSettings;
    private final UnaryCallSettings<DeleteNodePoolRequest, Operation> deleteNodePoolSettings;
    private final OperationCallSettings<DeleteNodePoolRequest, Empty, OperationMetadata> deleteNodePoolOperationSettings;
    private final PagedCallSettings<ListMachinesRequest, ListMachinesResponse, EdgeContainerClient.ListMachinesPagedResponse> listMachinesSettings;
    private final UnaryCallSettings<GetMachineRequest, Machine> getMachineSettings;
    private final PagedCallSettings<ListVpnConnectionsRequest, ListVpnConnectionsResponse, EdgeContainerClient.ListVpnConnectionsPagedResponse> listVpnConnectionsSettings;
    private final UnaryCallSettings<GetVpnConnectionRequest, VpnConnection> getVpnConnectionSettings;
    private final UnaryCallSettings<CreateVpnConnectionRequest, Operation> createVpnConnectionSettings;
    private final OperationCallSettings<CreateVpnConnectionRequest, VpnConnection, OperationMetadata> createVpnConnectionOperationSettings;
    private final UnaryCallSettings<DeleteVpnConnectionRequest, Operation> deleteVpnConnectionSettings;
    private final OperationCallSettings<DeleteVpnConnectionRequest, Empty, OperationMetadata> deleteVpnConnectionOperationSettings;
    private final UnaryCallSettings<GetServerConfigRequest, ServerConfig> getServerConfigSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EdgeContainerClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListClustersRequest, ListClustersResponse, Cluster> LIST_CLUSTERS_PAGE_STR_DESC = new PagedListDescriptor<ListClustersRequest, ListClustersResponse, Cluster>(){

        public String emptyToken() {
            return "";
        }

        public ListClustersRequest injectToken(ListClustersRequest payload, String token) {
            return ListClustersRequest.newBuilder((ListClustersRequest)payload).setPageToken(token).build();
        }

        public ListClustersRequest injectPageSize(ListClustersRequest payload, int pageSize) {
            return ListClustersRequest.newBuilder((ListClustersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListClustersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListClustersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Cluster> extractResources(ListClustersResponse payload) {
            return payload.getClustersList();
        }
    };
    private static final PagedListDescriptor<ListNodePoolsRequest, ListNodePoolsResponse, NodePool> LIST_NODE_POOLS_PAGE_STR_DESC = new PagedListDescriptor<ListNodePoolsRequest, ListNodePoolsResponse, NodePool>(){

        public String emptyToken() {
            return "";
        }

        public ListNodePoolsRequest injectToken(ListNodePoolsRequest payload, String token) {
            return ListNodePoolsRequest.newBuilder((ListNodePoolsRequest)payload).setPageToken(token).build();
        }

        public ListNodePoolsRequest injectPageSize(ListNodePoolsRequest payload, int pageSize) {
            return ListNodePoolsRequest.newBuilder((ListNodePoolsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListNodePoolsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListNodePoolsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NodePool> extractResources(ListNodePoolsResponse payload) {
            return payload.getNodePoolsList();
        }
    };
    private static final PagedListDescriptor<ListMachinesRequest, ListMachinesResponse, Machine> LIST_MACHINES_PAGE_STR_DESC = new PagedListDescriptor<ListMachinesRequest, ListMachinesResponse, Machine>(){

        public String emptyToken() {
            return "";
        }

        public ListMachinesRequest injectToken(ListMachinesRequest payload, String token) {
            return ListMachinesRequest.newBuilder((ListMachinesRequest)payload).setPageToken(token).build();
        }

        public ListMachinesRequest injectPageSize(ListMachinesRequest payload, int pageSize) {
            return ListMachinesRequest.newBuilder((ListMachinesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMachinesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMachinesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Machine> extractResources(ListMachinesResponse payload) {
            return payload.getMachinesList();
        }
    };
    private static final PagedListDescriptor<ListVpnConnectionsRequest, ListVpnConnectionsResponse, VpnConnection> LIST_VPN_CONNECTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListVpnConnectionsRequest, ListVpnConnectionsResponse, VpnConnection>(){

        public String emptyToken() {
            return "";
        }

        public ListVpnConnectionsRequest injectToken(ListVpnConnectionsRequest payload, String token) {
            return ListVpnConnectionsRequest.newBuilder((ListVpnConnectionsRequest)payload).setPageToken(token).build();
        }

        public ListVpnConnectionsRequest injectPageSize(ListVpnConnectionsRequest payload, int pageSize) {
            return ListVpnConnectionsRequest.newBuilder((ListVpnConnectionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListVpnConnectionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListVpnConnectionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<VpnConnection> extractResources(ListVpnConnectionsResponse payload) {
            return payload.getVpnConnectionsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListClustersRequest, ListClustersResponse, EdgeContainerClient.ListClustersPagedResponse> LIST_CLUSTERS_PAGE_STR_FACT = new PagedListResponseFactory<ListClustersRequest, ListClustersResponse, EdgeContainerClient.ListClustersPagedResponse>(){

        public ApiFuture<EdgeContainerClient.ListClustersPagedResponse> getFuturePagedResponse(UnaryCallable<ListClustersRequest, ListClustersResponse> callable, ListClustersRequest request, ApiCallContext context, ApiFuture<ListClustersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CLUSTERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EdgeContainerClient.ListClustersPagedResponse.createAsync((PageContext<ListClustersRequest, ListClustersResponse, Cluster>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNodePoolsRequest, ListNodePoolsResponse, EdgeContainerClient.ListNodePoolsPagedResponse> LIST_NODE_POOLS_PAGE_STR_FACT = new PagedListResponseFactory<ListNodePoolsRequest, ListNodePoolsResponse, EdgeContainerClient.ListNodePoolsPagedResponse>(){

        public ApiFuture<EdgeContainerClient.ListNodePoolsPagedResponse> getFuturePagedResponse(UnaryCallable<ListNodePoolsRequest, ListNodePoolsResponse> callable, ListNodePoolsRequest request, ApiCallContext context, ApiFuture<ListNodePoolsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NODE_POOLS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EdgeContainerClient.ListNodePoolsPagedResponse.createAsync((PageContext<ListNodePoolsRequest, ListNodePoolsResponse, NodePool>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMachinesRequest, ListMachinesResponse, EdgeContainerClient.ListMachinesPagedResponse> LIST_MACHINES_PAGE_STR_FACT = new PagedListResponseFactory<ListMachinesRequest, ListMachinesResponse, EdgeContainerClient.ListMachinesPagedResponse>(){

        public ApiFuture<EdgeContainerClient.ListMachinesPagedResponse> getFuturePagedResponse(UnaryCallable<ListMachinesRequest, ListMachinesResponse> callable, ListMachinesRequest request, ApiCallContext context, ApiFuture<ListMachinesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MACHINES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EdgeContainerClient.ListMachinesPagedResponse.createAsync((PageContext<ListMachinesRequest, ListMachinesResponse, Machine>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListVpnConnectionsRequest, ListVpnConnectionsResponse, EdgeContainerClient.ListVpnConnectionsPagedResponse> LIST_VPN_CONNECTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListVpnConnectionsRequest, ListVpnConnectionsResponse, EdgeContainerClient.ListVpnConnectionsPagedResponse>(){

        public ApiFuture<EdgeContainerClient.ListVpnConnectionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListVpnConnectionsRequest, ListVpnConnectionsResponse> callable, ListVpnConnectionsRequest request, ApiCallContext context, ApiFuture<ListVpnConnectionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VPN_CONNECTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EdgeContainerClient.ListVpnConnectionsPagedResponse.createAsync((PageContext<ListVpnConnectionsRequest, ListVpnConnectionsResponse, VpnConnection>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EdgeContainerClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EdgeContainerClient.ListLocationsPagedResponse>(){

        public ApiFuture<EdgeContainerClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EdgeContainerClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListClustersRequest, ListClustersResponse, EdgeContainerClient.ListClustersPagedResponse> listClustersSettings() {
        return this.listClustersSettings;
    }

    public UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings() {
        return this.getClusterSettings;
    }

    public UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings() {
        return this.createClusterSettings;
    }

    public OperationCallSettings<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings() {
        return this.createClusterOperationSettings;
    }

    public UnaryCallSettings<UpdateClusterRequest, Operation> updateClusterSettings() {
        return this.updateClusterSettings;
    }

    public OperationCallSettings<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings() {
        return this.updateClusterOperationSettings;
    }

    public UnaryCallSettings<UpgradeClusterRequest, Operation> upgradeClusterSettings() {
        return this.upgradeClusterSettings;
    }

    public OperationCallSettings<UpgradeClusterRequest, Cluster, OperationMetadata> upgradeClusterOperationSettings() {
        return this.upgradeClusterOperationSettings;
    }

    public UnaryCallSettings<DeleteClusterRequest, Operation> deleteClusterSettings() {
        return this.deleteClusterSettings;
    }

    public OperationCallSettings<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings() {
        return this.deleteClusterOperationSettings;
    }

    public UnaryCallSettings<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenSettings() {
        return this.generateAccessTokenSettings;
    }

    public UnaryCallSettings<GenerateOfflineCredentialRequest, GenerateOfflineCredentialResponse> generateOfflineCredentialSettings() {
        return this.generateOfflineCredentialSettings;
    }

    public PagedCallSettings<ListNodePoolsRequest, ListNodePoolsResponse, EdgeContainerClient.ListNodePoolsPagedResponse> listNodePoolsSettings() {
        return this.listNodePoolsSettings;
    }

    public UnaryCallSettings<GetNodePoolRequest, NodePool> getNodePoolSettings() {
        return this.getNodePoolSettings;
    }

    public UnaryCallSettings<CreateNodePoolRequest, Operation> createNodePoolSettings() {
        return this.createNodePoolSettings;
    }

    public OperationCallSettings<CreateNodePoolRequest, NodePool, OperationMetadata> createNodePoolOperationSettings() {
        return this.createNodePoolOperationSettings;
    }

    public UnaryCallSettings<UpdateNodePoolRequest, Operation> updateNodePoolSettings() {
        return this.updateNodePoolSettings;
    }

    public OperationCallSettings<UpdateNodePoolRequest, NodePool, OperationMetadata> updateNodePoolOperationSettings() {
        return this.updateNodePoolOperationSettings;
    }

    public UnaryCallSettings<DeleteNodePoolRequest, Operation> deleteNodePoolSettings() {
        return this.deleteNodePoolSettings;
    }

    public OperationCallSettings<DeleteNodePoolRequest, Empty, OperationMetadata> deleteNodePoolOperationSettings() {
        return this.deleteNodePoolOperationSettings;
    }

    public PagedCallSettings<ListMachinesRequest, ListMachinesResponse, EdgeContainerClient.ListMachinesPagedResponse> listMachinesSettings() {
        return this.listMachinesSettings;
    }

    public UnaryCallSettings<GetMachineRequest, Machine> getMachineSettings() {
        return this.getMachineSettings;
    }

    public PagedCallSettings<ListVpnConnectionsRequest, ListVpnConnectionsResponse, EdgeContainerClient.ListVpnConnectionsPagedResponse> listVpnConnectionsSettings() {
        return this.listVpnConnectionsSettings;
    }

    public UnaryCallSettings<GetVpnConnectionRequest, VpnConnection> getVpnConnectionSettings() {
        return this.getVpnConnectionSettings;
    }

    public UnaryCallSettings<CreateVpnConnectionRequest, Operation> createVpnConnectionSettings() {
        return this.createVpnConnectionSettings;
    }

    public OperationCallSettings<CreateVpnConnectionRequest, VpnConnection, OperationMetadata> createVpnConnectionOperationSettings() {
        return this.createVpnConnectionOperationSettings;
    }

    public UnaryCallSettings<DeleteVpnConnectionRequest, Operation> deleteVpnConnectionSettings() {
        return this.deleteVpnConnectionSettings;
    }

    public OperationCallSettings<DeleteVpnConnectionRequest, Empty, OperationMetadata> deleteVpnConnectionOperationSettings() {
        return this.deleteVpnConnectionOperationSettings;
    }

    public UnaryCallSettings<GetServerConfigRequest, ServerConfig> getServerConfigSettings() {
        return this.getServerConfigSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EdgeContainerClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public EdgeContainerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEdgeContainerStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonEdgeContainerStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "edgecontainer";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "edgecontainer.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "edgecontainer.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EdgeContainerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EdgeContainerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EdgeContainerStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return EdgeContainerStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EdgeContainerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listClustersSettings = settingsBuilder.listClustersSettings().build();
        this.getClusterSettings = settingsBuilder.getClusterSettings().build();
        this.createClusterSettings = settingsBuilder.createClusterSettings().build();
        this.createClusterOperationSettings = settingsBuilder.createClusterOperationSettings().build();
        this.updateClusterSettings = settingsBuilder.updateClusterSettings().build();
        this.updateClusterOperationSettings = settingsBuilder.updateClusterOperationSettings().build();
        this.upgradeClusterSettings = settingsBuilder.upgradeClusterSettings().build();
        this.upgradeClusterOperationSettings = settingsBuilder.upgradeClusterOperationSettings().build();
        this.deleteClusterSettings = settingsBuilder.deleteClusterSettings().build();
        this.deleteClusterOperationSettings = settingsBuilder.deleteClusterOperationSettings().build();
        this.generateAccessTokenSettings = settingsBuilder.generateAccessTokenSettings().build();
        this.generateOfflineCredentialSettings = settingsBuilder.generateOfflineCredentialSettings().build();
        this.listNodePoolsSettings = settingsBuilder.listNodePoolsSettings().build();
        this.getNodePoolSettings = settingsBuilder.getNodePoolSettings().build();
        this.createNodePoolSettings = settingsBuilder.createNodePoolSettings().build();
        this.createNodePoolOperationSettings = settingsBuilder.createNodePoolOperationSettings().build();
        this.updateNodePoolSettings = settingsBuilder.updateNodePoolSettings().build();
        this.updateNodePoolOperationSettings = settingsBuilder.updateNodePoolOperationSettings().build();
        this.deleteNodePoolSettings = settingsBuilder.deleteNodePoolSettings().build();
        this.deleteNodePoolOperationSettings = settingsBuilder.deleteNodePoolOperationSettings().build();
        this.listMachinesSettings = settingsBuilder.listMachinesSettings().build();
        this.getMachineSettings = settingsBuilder.getMachineSettings().build();
        this.listVpnConnectionsSettings = settingsBuilder.listVpnConnectionsSettings().build();
        this.getVpnConnectionSettings = settingsBuilder.getVpnConnectionSettings().build();
        this.createVpnConnectionSettings = settingsBuilder.createVpnConnectionSettings().build();
        this.createVpnConnectionOperationSettings = settingsBuilder.createVpnConnectionOperationSettings().build();
        this.deleteVpnConnectionSettings = settingsBuilder.deleteVpnConnectionSettings().build();
        this.deleteVpnConnectionOperationSettings = settingsBuilder.deleteVpnConnectionOperationSettings().build();
        this.getServerConfigSettings = settingsBuilder.getServerConfigSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EdgeContainerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListClustersRequest, ListClustersResponse, EdgeContainerClient.ListClustersPagedResponse> listClustersSettings;
        private final UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings;
        private final UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings;
        private final OperationCallSettings.Builder<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings;
        private final UnaryCallSettings.Builder<UpdateClusterRequest, Operation> updateClusterSettings;
        private final OperationCallSettings.Builder<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings;
        private final UnaryCallSettings.Builder<UpgradeClusterRequest, Operation> upgradeClusterSettings;
        private final OperationCallSettings.Builder<UpgradeClusterRequest, Cluster, OperationMetadata> upgradeClusterOperationSettings;
        private final UnaryCallSettings.Builder<DeleteClusterRequest, Operation> deleteClusterSettings;
        private final OperationCallSettings.Builder<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings;
        private final UnaryCallSettings.Builder<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenSettings;
        private final UnaryCallSettings.Builder<GenerateOfflineCredentialRequest, GenerateOfflineCredentialResponse> generateOfflineCredentialSettings;
        private final PagedCallSettings.Builder<ListNodePoolsRequest, ListNodePoolsResponse, EdgeContainerClient.ListNodePoolsPagedResponse> listNodePoolsSettings;
        private final UnaryCallSettings.Builder<GetNodePoolRequest, NodePool> getNodePoolSettings;
        private final UnaryCallSettings.Builder<CreateNodePoolRequest, Operation> createNodePoolSettings;
        private final OperationCallSettings.Builder<CreateNodePoolRequest, NodePool, OperationMetadata> createNodePoolOperationSettings;
        private final UnaryCallSettings.Builder<UpdateNodePoolRequest, Operation> updateNodePoolSettings;
        private final OperationCallSettings.Builder<UpdateNodePoolRequest, NodePool, OperationMetadata> updateNodePoolOperationSettings;
        private final UnaryCallSettings.Builder<DeleteNodePoolRequest, Operation> deleteNodePoolSettings;
        private final OperationCallSettings.Builder<DeleteNodePoolRequest, Empty, OperationMetadata> deleteNodePoolOperationSettings;
        private final PagedCallSettings.Builder<ListMachinesRequest, ListMachinesResponse, EdgeContainerClient.ListMachinesPagedResponse> listMachinesSettings;
        private final UnaryCallSettings.Builder<GetMachineRequest, Machine> getMachineSettings;
        private final PagedCallSettings.Builder<ListVpnConnectionsRequest, ListVpnConnectionsResponse, EdgeContainerClient.ListVpnConnectionsPagedResponse> listVpnConnectionsSettings;
        private final UnaryCallSettings.Builder<GetVpnConnectionRequest, VpnConnection> getVpnConnectionSettings;
        private final UnaryCallSettings.Builder<CreateVpnConnectionRequest, Operation> createVpnConnectionSettings;
        private final OperationCallSettings.Builder<CreateVpnConnectionRequest, VpnConnection, OperationMetadata> createVpnConnectionOperationSettings;
        private final UnaryCallSettings.Builder<DeleteVpnConnectionRequest, Operation> deleteVpnConnectionSettings;
        private final OperationCallSettings.Builder<DeleteVpnConnectionRequest, Empty, OperationMetadata> deleteVpnConnectionOperationSettings;
        private final UnaryCallSettings.Builder<GetServerConfigRequest, ServerConfig> getServerConfigSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EdgeContainerClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listClustersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CLUSTERS_PAGE_STR_FACT);
            this.getClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClusterOperationSettings = OperationCallSettings.newBuilder();
            this.updateClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateClusterOperationSettings = OperationCallSettings.newBuilder();
            this.upgradeClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.upgradeClusterOperationSettings = OperationCallSettings.newBuilder();
            this.deleteClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteClusterOperationSettings = OperationCallSettings.newBuilder();
            this.generateAccessTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateOfflineCredentialSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listNodePoolsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NODE_POOLS_PAGE_STR_FACT);
            this.getNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createNodePoolOperationSettings = OperationCallSettings.newBuilder();
            this.updateNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateNodePoolOperationSettings = OperationCallSettings.newBuilder();
            this.deleteNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteNodePoolOperationSettings = OperationCallSettings.newBuilder();
            this.listMachinesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MACHINES_PAGE_STR_FACT);
            this.getMachineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listVpnConnectionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VPN_CONNECTIONS_PAGE_STR_FACT);
            this.getVpnConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createVpnConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createVpnConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.deleteVpnConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteVpnConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.getServerConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listClustersSettings, this.getClusterSettings, this.createClusterSettings, this.updateClusterSettings, this.upgradeClusterSettings, this.deleteClusterSettings, this.generateAccessTokenSettings, this.generateOfflineCredentialSettings, this.listNodePoolsSettings, this.getNodePoolSettings, this.createNodePoolSettings, this.updateNodePoolSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteNodePoolSettings, this.listMachinesSettings, this.getMachineSettings, this.listVpnConnectionsSettings, this.getVpnConnectionSettings, this.createVpnConnectionSettings, this.deleteVpnConnectionSettings, this.getServerConfigSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(EdgeContainerStubSettings settings) {
            super((StubSettings)settings);
            this.listClustersSettings = settings.listClustersSettings.toBuilder();
            this.getClusterSettings = settings.getClusterSettings.toBuilder();
            this.createClusterSettings = settings.createClusterSettings.toBuilder();
            this.createClusterOperationSettings = settings.createClusterOperationSettings.toBuilder();
            this.updateClusterSettings = settings.updateClusterSettings.toBuilder();
            this.updateClusterOperationSettings = settings.updateClusterOperationSettings.toBuilder();
            this.upgradeClusterSettings = settings.upgradeClusterSettings.toBuilder();
            this.upgradeClusterOperationSettings = settings.upgradeClusterOperationSettings.toBuilder();
            this.deleteClusterSettings = settings.deleteClusterSettings.toBuilder();
            this.deleteClusterOperationSettings = settings.deleteClusterOperationSettings.toBuilder();
            this.generateAccessTokenSettings = settings.generateAccessTokenSettings.toBuilder();
            this.generateOfflineCredentialSettings = settings.generateOfflineCredentialSettings.toBuilder();
            this.listNodePoolsSettings = settings.listNodePoolsSettings.toBuilder();
            this.getNodePoolSettings = settings.getNodePoolSettings.toBuilder();
            this.createNodePoolSettings = settings.createNodePoolSettings.toBuilder();
            this.createNodePoolOperationSettings = settings.createNodePoolOperationSettings.toBuilder();
            this.updateNodePoolSettings = settings.updateNodePoolSettings.toBuilder();
            this.updateNodePoolOperationSettings = settings.updateNodePoolOperationSettings.toBuilder();
            this.deleteNodePoolSettings = settings.deleteNodePoolSettings.toBuilder();
            this.deleteNodePoolOperationSettings = settings.deleteNodePoolOperationSettings.toBuilder();
            this.listMachinesSettings = settings.listMachinesSettings.toBuilder();
            this.getMachineSettings = settings.getMachineSettings.toBuilder();
            this.listVpnConnectionsSettings = settings.listVpnConnectionsSettings.toBuilder();
            this.getVpnConnectionSettings = settings.getVpnConnectionSettings.toBuilder();
            this.createVpnConnectionSettings = settings.createVpnConnectionSettings.toBuilder();
            this.createVpnConnectionOperationSettings = settings.createVpnConnectionOperationSettings.toBuilder();
            this.deleteVpnConnectionSettings = settings.deleteVpnConnectionSettings.toBuilder();
            this.deleteVpnConnectionOperationSettings = settings.deleteVpnConnectionOperationSettings.toBuilder();
            this.getServerConfigSettings = settings.getServerConfigSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listClustersSettings, this.getClusterSettings, this.createClusterSettings, this.updateClusterSettings, this.upgradeClusterSettings, this.deleteClusterSettings, this.generateAccessTokenSettings, this.generateOfflineCredentialSettings, this.listNodePoolsSettings, this.getNodePoolSettings, this.createNodePoolSettings, this.updateNodePoolSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteNodePoolSettings, this.listMachinesSettings, this.getMachineSettings, this.listVpnConnectionsSettings, this.getVpnConnectionSettings, this.createVpnConnectionSettings, this.deleteVpnConnectionSettings, this.getServerConfigSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EdgeContainerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EdgeContainerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EdgeContainerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EdgeContainerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)EdgeContainerStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)EdgeContainerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EdgeContainerStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EdgeContainerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listClustersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.upgradeClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.generateAccessTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.generateOfflineCredentialSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listNodePoolsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listMachinesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getMachineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listVpnConnectionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getVpnConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createVpnConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteVpnConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getServerConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(2700000L)).build()));
            builder.updateClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.upgradeClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(1800000L)).build()));
            builder.createNodePoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(NodePool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(68400000L)).build()));
            builder.updateNodePoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(NodePool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(68400000L)).build()));
            builder.deleteNodePoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(1800000L)).build()));
            builder.createVpnConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(VpnConnection.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteVpnConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListClustersRequest, ListClustersResponse, EdgeContainerClient.ListClustersPagedResponse> listClustersSettings() {
            return this.listClustersSettings;
        }

        public UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings() {
            return this.getClusterSettings;
        }

        public UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings() {
            return this.createClusterSettings;
        }

        public OperationCallSettings.Builder<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings() {
            return this.createClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateClusterRequest, Operation> updateClusterSettings() {
            return this.updateClusterSettings;
        }

        public OperationCallSettings.Builder<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings() {
            return this.updateClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<UpgradeClusterRequest, Operation> upgradeClusterSettings() {
            return this.upgradeClusterSettings;
        }

        public OperationCallSettings.Builder<UpgradeClusterRequest, Cluster, OperationMetadata> upgradeClusterOperationSettings() {
            return this.upgradeClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteClusterRequest, Operation> deleteClusterSettings() {
            return this.deleteClusterSettings;
        }

        public OperationCallSettings.Builder<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings() {
            return this.deleteClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenSettings() {
            return this.generateAccessTokenSettings;
        }

        public UnaryCallSettings.Builder<GenerateOfflineCredentialRequest, GenerateOfflineCredentialResponse> generateOfflineCredentialSettings() {
            return this.generateOfflineCredentialSettings;
        }

        public PagedCallSettings.Builder<ListNodePoolsRequest, ListNodePoolsResponse, EdgeContainerClient.ListNodePoolsPagedResponse> listNodePoolsSettings() {
            return this.listNodePoolsSettings;
        }

        public UnaryCallSettings.Builder<GetNodePoolRequest, NodePool> getNodePoolSettings() {
            return this.getNodePoolSettings;
        }

        public UnaryCallSettings.Builder<CreateNodePoolRequest, Operation> createNodePoolSettings() {
            return this.createNodePoolSettings;
        }

        public OperationCallSettings.Builder<CreateNodePoolRequest, NodePool, OperationMetadata> createNodePoolOperationSettings() {
            return this.createNodePoolOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateNodePoolRequest, Operation> updateNodePoolSettings() {
            return this.updateNodePoolSettings;
        }

        public OperationCallSettings.Builder<UpdateNodePoolRequest, NodePool, OperationMetadata> updateNodePoolOperationSettings() {
            return this.updateNodePoolOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteNodePoolRequest, Operation> deleteNodePoolSettings() {
            return this.deleteNodePoolSettings;
        }

        public OperationCallSettings.Builder<DeleteNodePoolRequest, Empty, OperationMetadata> deleteNodePoolOperationSettings() {
            return this.deleteNodePoolOperationSettings;
        }

        public PagedCallSettings.Builder<ListMachinesRequest, ListMachinesResponse, EdgeContainerClient.ListMachinesPagedResponse> listMachinesSettings() {
            return this.listMachinesSettings;
        }

        public UnaryCallSettings.Builder<GetMachineRequest, Machine> getMachineSettings() {
            return this.getMachineSettings;
        }

        public PagedCallSettings.Builder<ListVpnConnectionsRequest, ListVpnConnectionsResponse, EdgeContainerClient.ListVpnConnectionsPagedResponse> listVpnConnectionsSettings() {
            return this.listVpnConnectionsSettings;
        }

        public UnaryCallSettings.Builder<GetVpnConnectionRequest, VpnConnection> getVpnConnectionSettings() {
            return this.getVpnConnectionSettings;
        }

        public UnaryCallSettings.Builder<CreateVpnConnectionRequest, Operation> createVpnConnectionSettings() {
            return this.createVpnConnectionSettings;
        }

        public OperationCallSettings.Builder<CreateVpnConnectionRequest, VpnConnection, OperationMetadata> createVpnConnectionOperationSettings() {
            return this.createVpnConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteVpnConnectionRequest, Operation> deleteVpnConnectionSettings() {
            return this.deleteVpnConnectionSettings;
        }

        public OperationCallSettings.Builder<DeleteVpnConnectionRequest, Empty, OperationMetadata> deleteVpnConnectionOperationSettings() {
            return this.deleteVpnConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<GetServerConfigRequest, ServerConfig> getServerConfigSettings() {
            return this.getServerConfigSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EdgeContainerClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public EdgeContainerStubSettings build() throws IOException {
            return new EdgeContainerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

