/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.CreateEngineMetadata;
import com.google.cloud.discoveryengine.v1alpha.CreateEngineRequest;
import com.google.cloud.discoveryengine.v1alpha.DeleteEngineMetadata;
import com.google.cloud.discoveryengine.v1alpha.DeleteEngineRequest;
import com.google.cloud.discoveryengine.v1alpha.Engine;
import com.google.cloud.discoveryengine.v1alpha.EngineServiceClient;
import com.google.cloud.discoveryengine.v1alpha.GetEngineRequest;
import com.google.cloud.discoveryengine.v1alpha.ListEnginesRequest;
import com.google.cloud.discoveryengine.v1alpha.ListEnginesResponse;
import com.google.cloud.discoveryengine.v1alpha.PauseEngineRequest;
import com.google.cloud.discoveryengine.v1alpha.ResumeEngineRequest;
import com.google.cloud.discoveryengine.v1alpha.TuneEngineMetadata;
import com.google.cloud.discoveryengine.v1alpha.TuneEngineRequest;
import com.google.cloud.discoveryengine.v1alpha.TuneEngineResponse;
import com.google.cloud.discoveryengine.v1alpha.UpdateEngineRequest;
import com.google.cloud.discoveryengine.v1alpha.stub.EngineServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.EngineServiceStubSettings;
import com.google.cloud.discoveryengine.v1alpha.stub.GrpcEngineServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcEngineServiceStub
extends EngineServiceStub {
    private static final MethodDescriptor<CreateEngineRequest, Operation> createEngineMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.EngineService/CreateEngine").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateEngineRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteEngineRequest, Operation> deleteEngineMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.EngineService/DeleteEngine").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteEngineRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateEngineRequest, Engine> updateEngineMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.EngineService/UpdateEngine").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateEngineRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Engine.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetEngineRequest, Engine> getEngineMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.EngineService/GetEngine").setRequestMarshaller(ProtoUtils.marshaller((Message)GetEngineRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Engine.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListEnginesRequest, ListEnginesResponse> listEnginesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.EngineService/ListEngines").setRequestMarshaller(ProtoUtils.marshaller((Message)ListEnginesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListEnginesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<PauseEngineRequest, Engine> pauseEngineMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.EngineService/PauseEngine").setRequestMarshaller(ProtoUtils.marshaller((Message)PauseEngineRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Engine.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ResumeEngineRequest, Engine> resumeEngineMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.EngineService/ResumeEngine").setRequestMarshaller(ProtoUtils.marshaller((Message)ResumeEngineRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Engine.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TuneEngineRequest, Operation> tuneEngineMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.EngineService/TuneEngine").setRequestMarshaller(ProtoUtils.marshaller((Message)TuneEngineRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateEngineRequest, Operation> createEngineCallable;
    private final OperationCallable<CreateEngineRequest, Engine, CreateEngineMetadata> createEngineOperationCallable;
    private final UnaryCallable<DeleteEngineRequest, Operation> deleteEngineCallable;
    private final OperationCallable<DeleteEngineRequest, Empty, DeleteEngineMetadata> deleteEngineOperationCallable;
    private final UnaryCallable<UpdateEngineRequest, Engine> updateEngineCallable;
    private final UnaryCallable<GetEngineRequest, Engine> getEngineCallable;
    private final UnaryCallable<ListEnginesRequest, ListEnginesResponse> listEnginesCallable;
    private final UnaryCallable<ListEnginesRequest, EngineServiceClient.ListEnginesPagedResponse> listEnginesPagedCallable;
    private final UnaryCallable<PauseEngineRequest, Engine> pauseEngineCallable;
    private final UnaryCallable<ResumeEngineRequest, Engine> resumeEngineCallable;
    private final UnaryCallable<TuneEngineRequest, Operation> tuneEngineCallable;
    private final OperationCallable<TuneEngineRequest, TuneEngineResponse, TuneEngineMetadata> tuneEngineOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcEngineServiceStub create(EngineServiceStubSettings settings) throws IOException {
        return new GrpcEngineServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcEngineServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcEngineServiceStub(EngineServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcEngineServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcEngineServiceStub(EngineServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcEngineServiceStub(EngineServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcEngineServiceCallableFactory());
    }

    protected GrpcEngineServiceStub(EngineServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createEngineTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createEngineMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteEngineTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteEngineMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateEngineTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateEngineMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("engine.name", String.valueOf(request.getEngine().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getEngineTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEngineMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listEnginesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listEnginesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings pauseEngineTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(pauseEngineMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings resumeEngineTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(resumeEngineMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings tuneEngineTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(tuneEngineMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createEngineCallable = callableFactory.createUnaryCallable(createEngineTransportSettings, settings.createEngineSettings(), clientContext);
        this.createEngineOperationCallable = callableFactory.createOperationCallable(createEngineTransportSettings, settings.createEngineOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteEngineCallable = callableFactory.createUnaryCallable(deleteEngineTransportSettings, settings.deleteEngineSettings(), clientContext);
        this.deleteEngineOperationCallable = callableFactory.createOperationCallable(deleteEngineTransportSettings, settings.deleteEngineOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateEngineCallable = callableFactory.createUnaryCallable(updateEngineTransportSettings, settings.updateEngineSettings(), clientContext);
        this.getEngineCallable = callableFactory.createUnaryCallable(getEngineTransportSettings, settings.getEngineSettings(), clientContext);
        this.listEnginesCallable = callableFactory.createUnaryCallable(listEnginesTransportSettings, settings.listEnginesSettings(), clientContext);
        this.listEnginesPagedCallable = callableFactory.createPagedCallable(listEnginesTransportSettings, settings.listEnginesSettings(), clientContext);
        this.pauseEngineCallable = callableFactory.createUnaryCallable(pauseEngineTransportSettings, settings.pauseEngineSettings(), clientContext);
        this.resumeEngineCallable = callableFactory.createUnaryCallable(resumeEngineTransportSettings, settings.resumeEngineSettings(), clientContext);
        this.tuneEngineCallable = callableFactory.createUnaryCallable(tuneEngineTransportSettings, settings.tuneEngineSettings(), clientContext);
        this.tuneEngineOperationCallable = callableFactory.createOperationCallable(tuneEngineTransportSettings, settings.tuneEngineOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateEngineRequest, Operation> createEngineCallable() {
        return this.createEngineCallable;
    }

    @Override
    public OperationCallable<CreateEngineRequest, Engine, CreateEngineMetadata> createEngineOperationCallable() {
        return this.createEngineOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteEngineRequest, Operation> deleteEngineCallable() {
        return this.deleteEngineCallable;
    }

    @Override
    public OperationCallable<DeleteEngineRequest, Empty, DeleteEngineMetadata> deleteEngineOperationCallable() {
        return this.deleteEngineOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateEngineRequest, Engine> updateEngineCallable() {
        return this.updateEngineCallable;
    }

    @Override
    public UnaryCallable<GetEngineRequest, Engine> getEngineCallable() {
        return this.getEngineCallable;
    }

    @Override
    public UnaryCallable<ListEnginesRequest, ListEnginesResponse> listEnginesCallable() {
        return this.listEnginesCallable;
    }

    @Override
    public UnaryCallable<ListEnginesRequest, EngineServiceClient.ListEnginesPagedResponse> listEnginesPagedCallable() {
        return this.listEnginesPagedCallable;
    }

    @Override
    public UnaryCallable<PauseEngineRequest, Engine> pauseEngineCallable() {
        return this.pauseEngineCallable;
    }

    @Override
    public UnaryCallable<ResumeEngineRequest, Engine> resumeEngineCallable() {
        return this.resumeEngineCallable;
    }

    @Override
    public UnaryCallable<TuneEngineRequest, Operation> tuneEngineCallable() {
        return this.tuneEngineCallable;
    }

    @Override
    public OperationCallable<TuneEngineRequest, TuneEngineResponse, TuneEngineMetadata> tuneEngineOperationCallable() {
        return this.tuneEngineOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

