/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.CreateSessionRequest;
import com.google.cloud.discoveryengine.v1beta.DeleteSessionRequest;
import com.google.cloud.discoveryengine.v1beta.GetSessionRequest;
import com.google.cloud.discoveryengine.v1beta.ListSessionsRequest;
import com.google.cloud.discoveryengine.v1beta.ListSessionsResponse;
import com.google.cloud.discoveryengine.v1beta.Session;
import com.google.cloud.discoveryengine.v1beta.SessionServiceClient;
import com.google.cloud.discoveryengine.v1beta.UpdateSessionRequest;
import com.google.cloud.discoveryengine.v1beta.stub.HttpJsonSessionServiceCallableFactory;
import com.google.cloud.discoveryengine.v1beta.stub.SessionServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.SessionServiceStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonSessionServiceStub
extends SessionServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateSessionRequest, Session> createSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.SessionService/CreateSession").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*/dataStores/*}/sessions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{parent=projects/*/locations/*/collections/*/dataStores/*}/sessions", "/v1beta/{parent=projects/*/locations/*/collections/*/engines/*}/sessions"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("session", (Message)request.getSession(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Session.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteSessionRequest, Empty> deleteSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.SessionService/DeleteSession").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/dataStores/*/sessions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/sessions/*}", "/v1beta/{name=projects/*/locations/*/collections/*/engines/*/sessions/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateSessionRequest, Session> updateSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.SessionService/UpdateSession").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{session.name=projects/*/locations/*/dataStores/*/sessions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "session.name", (Object)request.getSession().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{session.name=projects/*/locations/*/collections/*/dataStores/*/sessions/*}", "/v1beta/{session.name=projects/*/locations/*/collections/*/engines/*/sessions/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("session", (Message)request.getSession(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Session.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetSessionRequest, Session> getSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.SessionService/GetSession").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/dataStores/*/sessions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/sessions/*}", "/v1beta/{name=projects/*/locations/*/collections/*/engines/*/sessions/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "includeAnswerDetails", (Object)request.getIncludeAnswerDetails());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Session.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListSessionsRequest, ListSessionsResponse> listSessionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.SessionService/ListSessions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*/dataStores/*}/sessions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{parent=projects/*/locations/*/collections/*/dataStores/*}/sessions", "/v1beta/{parent=projects/*/locations/*/collections/*/engines/*}/sessions"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListSessionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateSessionRequest, Session> createSessionCallable;
    private final UnaryCallable<DeleteSessionRequest, Empty> deleteSessionCallable;
    private final UnaryCallable<UpdateSessionRequest, Session> updateSessionCallable;
    private final UnaryCallable<GetSessionRequest, Session> getSessionCallable;
    private final UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable;
    private final UnaryCallable<ListSessionsRequest, SessionServiceClient.ListSessionsPagedResponse> listSessionsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSessionServiceStub create(SessionServiceStubSettings settings) throws IOException {
        return new HttpJsonSessionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSessionServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSessionServiceStub(SessionServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonSessionServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSessionServiceStub(SessionServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSessionServiceStub(SessionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSessionServiceCallableFactory());
    }

    protected HttpJsonSessionServiceStub(SessionServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSessionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteSessionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateSessionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("session.name", String.valueOf(request.getSession().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSessionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listSessionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listSessionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.createSessionCallable = callableFactory.createUnaryCallable(createSessionTransportSettings, settings.createSessionSettings(), clientContext);
        this.deleteSessionCallable = callableFactory.createUnaryCallable(deleteSessionTransportSettings, settings.deleteSessionSettings(), clientContext);
        this.updateSessionCallable = callableFactory.createUnaryCallable(updateSessionTransportSettings, settings.updateSessionSettings(), clientContext);
        this.getSessionCallable = callableFactory.createUnaryCallable(getSessionTransportSettings, settings.getSessionSettings(), clientContext);
        this.listSessionsCallable = callableFactory.createUnaryCallable(listSessionsTransportSettings, settings.listSessionsSettings(), clientContext);
        this.listSessionsPagedCallable = callableFactory.createPagedCallable(listSessionsTransportSettings, settings.listSessionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createSessionMethodDescriptor);
        methodDescriptors.add(deleteSessionMethodDescriptor);
        methodDescriptors.add(updateSessionMethodDescriptor);
        methodDescriptors.add(getSessionMethodDescriptor);
        methodDescriptors.add(listSessionsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateSessionRequest, Session> createSessionCallable() {
        return this.createSessionCallable;
    }

    @Override
    public UnaryCallable<DeleteSessionRequest, Empty> deleteSessionCallable() {
        return this.deleteSessionCallable;
    }

    @Override
    public UnaryCallable<UpdateSessionRequest, Session> updateSessionCallable() {
        return this.updateSessionCallable;
    }

    @Override
    public UnaryCallable<GetSessionRequest, Session> getSessionCallable() {
        return this.getSessionCallable;
    }

    @Override
    public UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable() {
        return this.listSessionsCallable;
    }

    @Override
    public UnaryCallable<ListSessionsRequest, SessionServiceClient.ListSessionsPagedResponse> listSessionsPagedCallable() {
        return this.listSessionsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

