/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.cloud.discoveryengine.v1.StreamAssistRequest;
import com.google.cloud.discoveryengine.v1.StreamAssistResponse;
import com.google.cloud.discoveryengine.v1.stub.AssistantServiceStub;
import com.google.cloud.discoveryengine.v1.stub.AssistantServiceStubSettings;
import com.google.cloud.discoveryengine.v1.stub.GrpcAssistantServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAssistantServiceStub
extends AssistantServiceStub {
    private static final MethodDescriptor<StreamAssistRequest, StreamAssistResponse> streamAssistMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.cloud.discoveryengine.v1.AssistantService/StreamAssist").setRequestMarshaller(ProtoUtils.marshaller((Message)StreamAssistRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StreamAssistResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final ServerStreamingCallable<StreamAssistRequest, StreamAssistResponse> streamAssistCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAssistantServiceStub create(AssistantServiceStubSettings settings) throws IOException {
        return new GrpcAssistantServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAssistantServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAssistantServiceStub(AssistantServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAssistantServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAssistantServiceStub(AssistantServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAssistantServiceStub(AssistantServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAssistantServiceCallableFactory());
    }

    protected GrpcAssistantServiceStub(AssistantServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings streamAssistTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(streamAssistMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.streamAssistCallable = callableFactory.createServerStreamingCallable(streamAssistTransportSettings, settings.streamAssistSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public ServerStreamingCallable<StreamAssistRequest, StreamAssistResponse> streamAssistCallable() {
        return this.streamAssistCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

