/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.CreateDocumentRequest;
import com.google.cloud.discoveryengine.v1beta.DeleteDocumentRequest;
import com.google.cloud.discoveryengine.v1beta.Document;
import com.google.cloud.discoveryengine.v1beta.DocumentServiceClient;
import com.google.cloud.discoveryengine.v1beta.GetDocumentRequest;
import com.google.cloud.discoveryengine.v1beta.ImportDocumentsMetadata;
import com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest;
import com.google.cloud.discoveryengine.v1beta.ImportDocumentsResponse;
import com.google.cloud.discoveryengine.v1beta.ListDocumentsRequest;
import com.google.cloud.discoveryengine.v1beta.ListDocumentsResponse;
import com.google.cloud.discoveryengine.v1beta.UpdateDocumentRequest;
import com.google.cloud.discoveryengine.v1beta.stub.DocumentServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.DocumentServiceStubSettings;
import com.google.cloud.discoveryengine.v1beta.stub.GrpcDocumentServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcDocumentServiceStub
extends DocumentServiceStub {
    private static final MethodDescriptor<GetDocumentRequest, Document> getDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.DocumentService/GetDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Document.getDefaultInstance())).build();
    private static final MethodDescriptor<ListDocumentsRequest, ListDocumentsResponse> listDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.DocumentService/ListDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDocumentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateDocumentRequest, Document> createDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.DocumentService/CreateDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Document.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateDocumentRequest, Document> updateDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.DocumentService/UpdateDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Document.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteDocumentRequest, Empty> deleteDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.DocumentService/DeleteDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportDocumentsRequest, Operation> importDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.DocumentService/ImportDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<GetDocumentRequest, Document> getDocumentCallable;
    private final UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable;
    private final UnaryCallable<ListDocumentsRequest, DocumentServiceClient.ListDocumentsPagedResponse> listDocumentsPagedCallable;
    private final UnaryCallable<CreateDocumentRequest, Document> createDocumentCallable;
    private final UnaryCallable<UpdateDocumentRequest, Document> updateDocumentCallable;
    private final UnaryCallable<DeleteDocumentRequest, Empty> deleteDocumentCallable;
    private final UnaryCallable<ImportDocumentsRequest, Operation> importDocumentsCallable;
    private final OperationCallable<ImportDocumentsRequest, ImportDocumentsResponse, ImportDocumentsMetadata> importDocumentsOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDocumentServiceStub create(DocumentServiceStubSettings settings) throws IOException {
        return new GrpcDocumentServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDocumentServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDocumentServiceStub(DocumentServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDocumentServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDocumentServiceStub(DocumentServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDocumentServiceStub(DocumentServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDocumentServiceCallableFactory());
    }

    protected GrpcDocumentServiceStub(DocumentServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDocumentsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings createDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"document.name", (Object)String.valueOf(request.getDocument().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings importDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importDocumentsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        this.getDocumentCallable = callableFactory.createUnaryCallable(getDocumentTransportSettings, settings.getDocumentSettings(), clientContext);
        this.listDocumentsCallable = callableFactory.createUnaryCallable(listDocumentsTransportSettings, settings.listDocumentsSettings(), clientContext);
        this.listDocumentsPagedCallable = callableFactory.createPagedCallable(listDocumentsTransportSettings, settings.listDocumentsSettings(), clientContext);
        this.createDocumentCallable = callableFactory.createUnaryCallable(createDocumentTransportSettings, settings.createDocumentSettings(), clientContext);
        this.updateDocumentCallable = callableFactory.createUnaryCallable(updateDocumentTransportSettings, settings.updateDocumentSettings(), clientContext);
        this.deleteDocumentCallable = callableFactory.createUnaryCallable(deleteDocumentTransportSettings, settings.deleteDocumentSettings(), clientContext);
        this.importDocumentsCallable = callableFactory.createUnaryCallable(importDocumentsTransportSettings, settings.importDocumentsSettings(), clientContext);
        this.importDocumentsOperationCallable = callableFactory.createOperationCallable(importDocumentsTransportSettings, settings.importDocumentsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetDocumentRequest, Document> getDocumentCallable() {
        return this.getDocumentCallable;
    }

    @Override
    public UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable() {
        return this.listDocumentsCallable;
    }

    @Override
    public UnaryCallable<ListDocumentsRequest, DocumentServiceClient.ListDocumentsPagedResponse> listDocumentsPagedCallable() {
        return this.listDocumentsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateDocumentRequest, Document> createDocumentCallable() {
        return this.createDocumentCallable;
    }

    @Override
    public UnaryCallable<UpdateDocumentRequest, Document> updateDocumentCallable() {
        return this.updateDocumentCallable;
    }

    @Override
    public UnaryCallable<DeleteDocumentRequest, Empty> deleteDocumentCallable() {
        return this.deleteDocumentCallable;
    }

    @Override
    public UnaryCallable<ImportDocumentsRequest, Operation> importDocumentsCallable() {
        return this.importDocumentsCallable;
    }

    @Override
    public OperationCallable<ImportDocumentsRequest, ImportDocumentsResponse, ImportDocumentsMetadata> importDocumentsOperationCallable() {
        return this.importDocumentsOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

