/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.Answer;
import com.google.cloud.discoveryengine.v1.AnswerName;
import com.google.cloud.discoveryengine.v1.AnswerQueryRequest;
import com.google.cloud.discoveryengine.v1.AnswerQueryResponse;
import com.google.cloud.discoveryengine.v1.Conversation;
import com.google.cloud.discoveryengine.v1.ConversationName;
import com.google.cloud.discoveryengine.v1.ConversationalSearchServiceSettings;
import com.google.cloud.discoveryengine.v1.ConverseConversationRequest;
import com.google.cloud.discoveryengine.v1.ConverseConversationResponse;
import com.google.cloud.discoveryengine.v1.CreateConversationRequest;
import com.google.cloud.discoveryengine.v1.CreateSessionRequest;
import com.google.cloud.discoveryengine.v1.DataStoreName;
import com.google.cloud.discoveryengine.v1.DeleteConversationRequest;
import com.google.cloud.discoveryengine.v1.DeleteSessionRequest;
import com.google.cloud.discoveryengine.v1.GetAnswerRequest;
import com.google.cloud.discoveryengine.v1.GetConversationRequest;
import com.google.cloud.discoveryengine.v1.GetSessionRequest;
import com.google.cloud.discoveryengine.v1.ListConversationsRequest;
import com.google.cloud.discoveryengine.v1.ListConversationsResponse;
import com.google.cloud.discoveryengine.v1.ListSessionsRequest;
import com.google.cloud.discoveryengine.v1.ListSessionsResponse;
import com.google.cloud.discoveryengine.v1.Session;
import com.google.cloud.discoveryengine.v1.SessionName;
import com.google.cloud.discoveryengine.v1.TextInput;
import com.google.cloud.discoveryengine.v1.UpdateConversationRequest;
import com.google.cloud.discoveryengine.v1.UpdateSessionRequest;
import com.google.cloud.discoveryengine.v1.stub.ConversationalSearchServiceStub;
import com.google.cloud.discoveryengine.v1.stub.ConversationalSearchServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ConversationalSearchServiceClient
implements BackgroundResource {
    private final ConversationalSearchServiceSettings settings;
    private final ConversationalSearchServiceStub stub;

    public static final ConversationalSearchServiceClient create() throws IOException {
        return ConversationalSearchServiceClient.create(ConversationalSearchServiceSettings.newBuilder().build());
    }

    public static final ConversationalSearchServiceClient create(ConversationalSearchServiceSettings settings) throws IOException {
        return new ConversationalSearchServiceClient(settings);
    }

    public static final ConversationalSearchServiceClient create(ConversationalSearchServiceStub stub) {
        return new ConversationalSearchServiceClient(stub);
    }

    protected ConversationalSearchServiceClient(ConversationalSearchServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConversationalSearchServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ConversationalSearchServiceClient(ConversationalSearchServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConversationalSearchServiceSettings getSettings() {
        return this.settings;
    }

    public ConversationalSearchServiceStub getStub() {
        return this.stub;
    }

    public final ConverseConversationResponse converseConversation(ConversationName name, TextInput query) {
        ConverseConversationRequest request = ConverseConversationRequest.newBuilder().setName(name == null ? null : name.toString()).setQuery(query).build();
        return this.converseConversation(request);
    }

    public final ConverseConversationResponse converseConversation(String name, TextInput query) {
        ConverseConversationRequest request = ConverseConversationRequest.newBuilder().setName(name).setQuery(query).build();
        return this.converseConversation(request);
    }

    public final ConverseConversationResponse converseConversation(ConverseConversationRequest request) {
        return (ConverseConversationResponse)this.converseConversationCallable().call((Object)request);
    }

    public final UnaryCallable<ConverseConversationRequest, ConverseConversationResponse> converseConversationCallable() {
        return this.stub.converseConversationCallable();
    }

    public final Conversation createConversation(DataStoreName parent, Conversation conversation) {
        CreateConversationRequest request = CreateConversationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConversation(conversation).build();
        return this.createConversation(request);
    }

    public final Conversation createConversation(String parent, Conversation conversation) {
        CreateConversationRequest request = CreateConversationRequest.newBuilder().setParent(parent).setConversation(conversation).build();
        return this.createConversation(request);
    }

    public final Conversation createConversation(CreateConversationRequest request) {
        return (Conversation)this.createConversationCallable().call((Object)request);
    }

    public final UnaryCallable<CreateConversationRequest, Conversation> createConversationCallable() {
        return this.stub.createConversationCallable();
    }

    public final void deleteConversation(ConversationName name) {
        DeleteConversationRequest request = DeleteConversationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteConversation(request);
    }

    public final void deleteConversation(String name) {
        DeleteConversationRequest request = DeleteConversationRequest.newBuilder().setName(name).build();
        this.deleteConversation(request);
    }

    public final void deleteConversation(DeleteConversationRequest request) {
        this.deleteConversationCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteConversationRequest, Empty> deleteConversationCallable() {
        return this.stub.deleteConversationCallable();
    }

    public final Conversation updateConversation(Conversation conversation, FieldMask updateMask) {
        UpdateConversationRequest request = UpdateConversationRequest.newBuilder().setConversation(conversation).setUpdateMask(updateMask).build();
        return this.updateConversation(request);
    }

    public final Conversation updateConversation(UpdateConversationRequest request) {
        return (Conversation)this.updateConversationCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateConversationRequest, Conversation> updateConversationCallable() {
        return this.stub.updateConversationCallable();
    }

    public final Conversation getConversation(ConversationName name) {
        GetConversationRequest request = GetConversationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConversation(request);
    }

    public final Conversation getConversation(String name) {
        GetConversationRequest request = GetConversationRequest.newBuilder().setName(name).build();
        return this.getConversation(request);
    }

    public final Conversation getConversation(GetConversationRequest request) {
        return (Conversation)this.getConversationCallable().call((Object)request);
    }

    public final UnaryCallable<GetConversationRequest, Conversation> getConversationCallable() {
        return this.stub.getConversationCallable();
    }

    public final ListConversationsPagedResponse listConversations(DataStoreName parent) {
        ListConversationsRequest request = ListConversationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConversations(request);
    }

    public final ListConversationsPagedResponse listConversations(String parent) {
        ListConversationsRequest request = ListConversationsRequest.newBuilder().setParent(parent).build();
        return this.listConversations(request);
    }

    public final ListConversationsPagedResponse listConversations(ListConversationsRequest request) {
        return (ListConversationsPagedResponse)((Object)this.listConversationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConversationsRequest, ListConversationsPagedResponse> listConversationsPagedCallable() {
        return this.stub.listConversationsPagedCallable();
    }

    public final UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable() {
        return this.stub.listConversationsCallable();
    }

    public final AnswerQueryResponse answerQuery(AnswerQueryRequest request) {
        return (AnswerQueryResponse)this.answerQueryCallable().call((Object)request);
    }

    public final UnaryCallable<AnswerQueryRequest, AnswerQueryResponse> answerQueryCallable() {
        return this.stub.answerQueryCallable();
    }

    public final Answer getAnswer(AnswerName name) {
        GetAnswerRequest request = GetAnswerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAnswer(request);
    }

    public final Answer getAnswer(String name) {
        GetAnswerRequest request = GetAnswerRequest.newBuilder().setName(name).build();
        return this.getAnswer(request);
    }

    public final Answer getAnswer(GetAnswerRequest request) {
        return (Answer)this.getAnswerCallable().call((Object)request);
    }

    public final UnaryCallable<GetAnswerRequest, Answer> getAnswerCallable() {
        return this.stub.getAnswerCallable();
    }

    public final Session createSession(DataStoreName parent, Session session) {
        CreateSessionRequest request = CreateSessionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSession(session).build();
        return this.createSession(request);
    }

    public final Session createSession(String parent, Session session) {
        CreateSessionRequest request = CreateSessionRequest.newBuilder().setParent(parent).setSession(session).build();
        return this.createSession(request);
    }

    public final Session createSession(CreateSessionRequest request) {
        return (Session)this.createSessionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSessionRequest, Session> createSessionCallable() {
        return this.stub.createSessionCallable();
    }

    public final void deleteSession(SessionName name) {
        DeleteSessionRequest request = DeleteSessionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSession(request);
    }

    public final void deleteSession(String name) {
        DeleteSessionRequest request = DeleteSessionRequest.newBuilder().setName(name).build();
        this.deleteSession(request);
    }

    public final void deleteSession(DeleteSessionRequest request) {
        this.deleteSessionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSessionRequest, Empty> deleteSessionCallable() {
        return this.stub.deleteSessionCallable();
    }

    public final Session updateSession(Session session, FieldMask updateMask) {
        UpdateSessionRequest request = UpdateSessionRequest.newBuilder().setSession(session).setUpdateMask(updateMask).build();
        return this.updateSession(request);
    }

    public final Session updateSession(UpdateSessionRequest request) {
        return (Session)this.updateSessionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSessionRequest, Session> updateSessionCallable() {
        return this.stub.updateSessionCallable();
    }

    public final Session getSession(SessionName name) {
        GetSessionRequest request = GetSessionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSession(request);
    }

    public final Session getSession(String name) {
        GetSessionRequest request = GetSessionRequest.newBuilder().setName(name).build();
        return this.getSession(request);
    }

    public final Session getSession(GetSessionRequest request) {
        return (Session)this.getSessionCallable().call((Object)request);
    }

    public final UnaryCallable<GetSessionRequest, Session> getSessionCallable() {
        return this.stub.getSessionCallable();
    }

    public final ListSessionsPagedResponse listSessions(DataStoreName parent) {
        ListSessionsRequest request = ListSessionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSessions(request);
    }

    public final ListSessionsPagedResponse listSessions(String parent) {
        ListSessionsRequest request = ListSessionsRequest.newBuilder().setParent(parent).build();
        return this.listSessions(request);
    }

    public final ListSessionsPagedResponse listSessions(ListSessionsRequest request) {
        return (ListSessionsPagedResponse)((Object)this.listSessionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSessionsRequest, ListSessionsPagedResponse> listSessionsPagedCallable() {
        return this.stub.listSessionsPagedCallable();
    }

    public final UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable() {
        return this.stub.listSessionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSessionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage, ListSessionsFixedSizeCollection> {
        private ListSessionsFixedSizeCollection(List<ListSessionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSessionsFixedSizeCollection createEmptyCollection() {
            return new ListSessionsFixedSizeCollection(null, 0);
        }

        protected ListSessionsFixedSizeCollection createCollection(List<ListSessionsPage> pages, int collectionSize) {
            return new ListSessionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSessionsPage
    extends AbstractPage<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage> {
        private ListSessionsPage(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ListSessionsResponse response) {
            super(context, (Object)response);
        }

        private static ListSessionsPage createEmptyPage() {
            return new ListSessionsPage(null, null);
        }

        protected ListSessionsPage createPage(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ListSessionsResponse response) {
            return new ListSessionsPage(context, response);
        }

        public ApiFuture<ListSessionsPage> createPageAsync(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ApiFuture<ListSessionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSessionsPagedResponse
    extends AbstractPagedListResponse<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage, ListSessionsFixedSizeCollection> {
        public static ApiFuture<ListSessionsPagedResponse> createAsync(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ApiFuture<ListSessionsResponse> futureResponse) {
            ApiFuture<ListSessionsPage> futurePage = ListSessionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSessionsPagedResponse((ListSessionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSessionsPagedResponse(ListSessionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSessionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConversationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage, ListConversationsFixedSizeCollection> {
        private ListConversationsFixedSizeCollection(List<ListConversationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConversationsFixedSizeCollection createEmptyCollection() {
            return new ListConversationsFixedSizeCollection(null, 0);
        }

        protected ListConversationsFixedSizeCollection createCollection(List<ListConversationsPage> pages, int collectionSize) {
            return new ListConversationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConversationsPage
    extends AbstractPage<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage> {
        private ListConversationsPage(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ListConversationsResponse response) {
            super(context, (Object)response);
        }

        private static ListConversationsPage createEmptyPage() {
            return new ListConversationsPage(null, null);
        }

        protected ListConversationsPage createPage(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ListConversationsResponse response) {
            return new ListConversationsPage(context, response);
        }

        public ApiFuture<ListConversationsPage> createPageAsync(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ApiFuture<ListConversationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConversationsPagedResponse
    extends AbstractPagedListResponse<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage, ListConversationsFixedSizeCollection> {
        public static ApiFuture<ListConversationsPagedResponse> createAsync(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ApiFuture<ListConversationsResponse> futureResponse) {
            ApiFuture<ListConversationsPage> futurePage = ListConversationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConversationsPagedResponse((ListConversationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConversationsPagedResponse(ListConversationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConversationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

