/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.CreateSchemaMetadata;
import com.google.cloud.discoveryengine.v1.CreateSchemaRequest;
import com.google.cloud.discoveryengine.v1.DataStoreName;
import com.google.cloud.discoveryengine.v1.DeleteSchemaMetadata;
import com.google.cloud.discoveryengine.v1.DeleteSchemaRequest;
import com.google.cloud.discoveryengine.v1.GetSchemaRequest;
import com.google.cloud.discoveryengine.v1.ListSchemasRequest;
import com.google.cloud.discoveryengine.v1.ListSchemasResponse;
import com.google.cloud.discoveryengine.v1.Schema;
import com.google.cloud.discoveryengine.v1.SchemaName;
import com.google.cloud.discoveryengine.v1.SchemaServiceSettings;
import com.google.cloud.discoveryengine.v1.UpdateSchemaMetadata;
import com.google.cloud.discoveryengine.v1.UpdateSchemaRequest;
import com.google.cloud.discoveryengine.v1.stub.SchemaServiceStub;
import com.google.cloud.discoveryengine.v1.stub.SchemaServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SchemaServiceClient
implements BackgroundResource {
    private final SchemaServiceSettings settings;
    private final SchemaServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final SchemaServiceClient create() throws IOException {
        return SchemaServiceClient.create(SchemaServiceSettings.newBuilder().build());
    }

    public static final SchemaServiceClient create(SchemaServiceSettings settings) throws IOException {
        return new SchemaServiceClient(settings);
    }

    public static final SchemaServiceClient create(SchemaServiceStub stub) {
        return new SchemaServiceClient(stub);
    }

    protected SchemaServiceClient(SchemaServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SchemaServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected SchemaServiceClient(SchemaServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final SchemaServiceSettings getSettings() {
        return this.settings;
    }

    public SchemaServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Schema getSchema(SchemaName name) {
        GetSchemaRequest request = GetSchemaRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSchema(request);
    }

    public final Schema getSchema(String name) {
        GetSchemaRequest request = GetSchemaRequest.newBuilder().setName(name).build();
        return this.getSchema(request);
    }

    public final Schema getSchema(GetSchemaRequest request) {
        return (Schema)this.getSchemaCallable().call((Object)request);
    }

    public final UnaryCallable<GetSchemaRequest, Schema> getSchemaCallable() {
        return this.stub.getSchemaCallable();
    }

    public final ListSchemasPagedResponse listSchemas(DataStoreName parent) {
        ListSchemasRequest request = ListSchemasRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSchemas(request);
    }

    public final ListSchemasPagedResponse listSchemas(String parent) {
        ListSchemasRequest request = ListSchemasRequest.newBuilder().setParent(parent).build();
        return this.listSchemas(request);
    }

    public final ListSchemasPagedResponse listSchemas(ListSchemasRequest request) {
        return (ListSchemasPagedResponse)((Object)this.listSchemasPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSchemasRequest, ListSchemasPagedResponse> listSchemasPagedCallable() {
        return this.stub.listSchemasPagedCallable();
    }

    public final UnaryCallable<ListSchemasRequest, ListSchemasResponse> listSchemasCallable() {
        return this.stub.listSchemasCallable();
    }

    public final OperationFuture<Schema, CreateSchemaMetadata> createSchemaAsync(DataStoreName parent, Schema schema, String schemaId) {
        CreateSchemaRequest request = CreateSchemaRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSchema(schema).setSchemaId(schemaId).build();
        return this.createSchemaAsync(request);
    }

    public final OperationFuture<Schema, CreateSchemaMetadata> createSchemaAsync(String parent, Schema schema, String schemaId) {
        CreateSchemaRequest request = CreateSchemaRequest.newBuilder().setParent(parent).setSchema(schema).setSchemaId(schemaId).build();
        return this.createSchemaAsync(request);
    }

    public final OperationFuture<Schema, CreateSchemaMetadata> createSchemaAsync(CreateSchemaRequest request) {
        return this.createSchemaOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSchemaRequest, Schema, CreateSchemaMetadata> createSchemaOperationCallable() {
        return this.stub.createSchemaOperationCallable();
    }

    public final UnaryCallable<CreateSchemaRequest, Operation> createSchemaCallable() {
        return this.stub.createSchemaCallable();
    }

    public final OperationFuture<Schema, UpdateSchemaMetadata> updateSchemaAsync(UpdateSchemaRequest request) {
        return this.updateSchemaOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSchemaRequest, Schema, UpdateSchemaMetadata> updateSchemaOperationCallable() {
        return this.stub.updateSchemaOperationCallable();
    }

    public final UnaryCallable<UpdateSchemaRequest, Operation> updateSchemaCallable() {
        return this.stub.updateSchemaCallable();
    }

    public final OperationFuture<Empty, DeleteSchemaMetadata> deleteSchemaAsync(SchemaName name) {
        DeleteSchemaRequest request = DeleteSchemaRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteSchemaAsync(request);
    }

    public final OperationFuture<Empty, DeleteSchemaMetadata> deleteSchemaAsync(String name) {
        DeleteSchemaRequest request = DeleteSchemaRequest.newBuilder().setName(name).build();
        return this.deleteSchemaAsync(request);
    }

    public final OperationFuture<Empty, DeleteSchemaMetadata> deleteSchemaAsync(DeleteSchemaRequest request) {
        return this.deleteSchemaOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSchemaRequest, Empty, DeleteSchemaMetadata> deleteSchemaOperationCallable() {
        return this.stub.deleteSchemaOperationCallable();
    }

    public final UnaryCallable<DeleteSchemaRequest, Operation> deleteSchemaCallable() {
        return this.stub.deleteSchemaCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSchemasFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSchemasRequest, ListSchemasResponse, Schema, ListSchemasPage, ListSchemasFixedSizeCollection> {
        private ListSchemasFixedSizeCollection(List<ListSchemasPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSchemasFixedSizeCollection createEmptyCollection() {
            return new ListSchemasFixedSizeCollection(null, 0);
        }

        protected ListSchemasFixedSizeCollection createCollection(List<ListSchemasPage> pages, int collectionSize) {
            return new ListSchemasFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSchemasPage
    extends AbstractPage<ListSchemasRequest, ListSchemasResponse, Schema, ListSchemasPage> {
        private ListSchemasPage(PageContext<ListSchemasRequest, ListSchemasResponse, Schema> context, ListSchemasResponse response) {
            super(context, (Object)response);
        }

        private static ListSchemasPage createEmptyPage() {
            return new ListSchemasPage(null, null);
        }

        protected ListSchemasPage createPage(PageContext<ListSchemasRequest, ListSchemasResponse, Schema> context, ListSchemasResponse response) {
            return new ListSchemasPage(context, response);
        }

        public ApiFuture<ListSchemasPage> createPageAsync(PageContext<ListSchemasRequest, ListSchemasResponse, Schema> context, ApiFuture<ListSchemasResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSchemasPagedResponse
    extends AbstractPagedListResponse<ListSchemasRequest, ListSchemasResponse, Schema, ListSchemasPage, ListSchemasFixedSizeCollection> {
        public static ApiFuture<ListSchemasPagedResponse> createAsync(PageContext<ListSchemasRequest, ListSchemasResponse, Schema> context, ApiFuture<ListSchemasResponse> futureResponse) {
            ApiFuture<ListSchemasPage> futurePage = ListSchemasPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSchemasPagedResponse((ListSchemasPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSchemasPagedResponse(ListSchemasPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSchemasFixedSizeCollection.createEmptyCollection());
        }
    }
}

