/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.CompleteQueryRequest;
import com.google.cloud.discoveryengine.v1.CompleteQueryResponse;
import com.google.cloud.discoveryengine.v1.CompletionServiceSettings;
import com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesMetadata;
import com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest;
import com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesResponse;
import com.google.cloud.discoveryengine.v1.PurgeSuggestionDenyListEntriesMetadata;
import com.google.cloud.discoveryengine.v1.PurgeSuggestionDenyListEntriesRequest;
import com.google.cloud.discoveryengine.v1.PurgeSuggestionDenyListEntriesResponse;
import com.google.cloud.discoveryengine.v1.stub.CompletionServiceStub;
import com.google.cloud.discoveryengine.v1.stub.CompletionServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class CompletionServiceClient
implements BackgroundResource {
    private final CompletionServiceSettings settings;
    private final CompletionServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final CompletionServiceClient create() throws IOException {
        return CompletionServiceClient.create(CompletionServiceSettings.newBuilder().build());
    }

    public static final CompletionServiceClient create(CompletionServiceSettings settings) throws IOException {
        return new CompletionServiceClient(settings);
    }

    public static final CompletionServiceClient create(CompletionServiceStub stub) {
        return new CompletionServiceClient(stub);
    }

    protected CompletionServiceClient(CompletionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CompletionServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected CompletionServiceClient(CompletionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final CompletionServiceSettings getSettings() {
        return this.settings;
    }

    public CompletionServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final CompleteQueryResponse completeQuery(CompleteQueryRequest request) {
        return (CompleteQueryResponse)this.completeQueryCallable().call((Object)request);
    }

    public final UnaryCallable<CompleteQueryRequest, CompleteQueryResponse> completeQueryCallable() {
        return this.stub.completeQueryCallable();
    }

    public final OperationFuture<ImportSuggestionDenyListEntriesResponse, ImportSuggestionDenyListEntriesMetadata> importSuggestionDenyListEntriesAsync(ImportSuggestionDenyListEntriesRequest request) {
        return this.importSuggestionDenyListEntriesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportSuggestionDenyListEntriesRequest, ImportSuggestionDenyListEntriesResponse, ImportSuggestionDenyListEntriesMetadata> importSuggestionDenyListEntriesOperationCallable() {
        return this.stub.importSuggestionDenyListEntriesOperationCallable();
    }

    public final UnaryCallable<ImportSuggestionDenyListEntriesRequest, Operation> importSuggestionDenyListEntriesCallable() {
        return this.stub.importSuggestionDenyListEntriesCallable();
    }

    public final OperationFuture<PurgeSuggestionDenyListEntriesResponse, PurgeSuggestionDenyListEntriesMetadata> purgeSuggestionDenyListEntriesAsync(PurgeSuggestionDenyListEntriesRequest request) {
        return this.purgeSuggestionDenyListEntriesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PurgeSuggestionDenyListEntriesRequest, PurgeSuggestionDenyListEntriesResponse, PurgeSuggestionDenyListEntriesMetadata> purgeSuggestionDenyListEntriesOperationCallable() {
        return this.stub.purgeSuggestionDenyListEntriesOperationCallable();
    }

    public final UnaryCallable<PurgeSuggestionDenyListEntriesRequest, Operation> purgeSuggestionDenyListEntriesCallable() {
        return this.stub.purgeSuggestionDenyListEntriesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

