/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.Conversation;
import com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceClient;
import com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest;
import com.google.cloud.discoveryengine.v1beta.ConverseConversationResponse;
import com.google.cloud.discoveryengine.v1beta.CreateConversationRequest;
import com.google.cloud.discoveryengine.v1beta.DeleteConversationRequest;
import com.google.cloud.discoveryengine.v1beta.GetConversationRequest;
import com.google.cloud.discoveryengine.v1beta.ListConversationsRequest;
import com.google.cloud.discoveryengine.v1beta.ListConversationsResponse;
import com.google.cloud.discoveryengine.v1beta.UpdateConversationRequest;
import com.google.cloud.discoveryengine.v1beta.stub.ConversationalSearchServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.ConversationalSearchServiceStubSettings;
import com.google.cloud.discoveryengine.v1beta.stub.GrpcConversationalSearchServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcConversationalSearchServiceStub
extends ConversationalSearchServiceStub {
    private static final MethodDescriptor<ConverseConversationRequest, ConverseConversationResponse> converseConversationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.ConversationalSearchService/ConverseConversation").setRequestMarshaller(ProtoUtils.marshaller((Message)ConverseConversationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ConverseConversationResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateConversationRequest, Conversation> createConversationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.ConversationalSearchService/CreateConversation").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateConversationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Conversation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteConversationRequest, Empty> deleteConversationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.ConversationalSearchService/DeleteConversation").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteConversationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateConversationRequest, Conversation> updateConversationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.ConversationalSearchService/UpdateConversation").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateConversationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Conversation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetConversationRequest, Conversation> getConversationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.ConversationalSearchService/GetConversation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetConversationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Conversation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListConversationsRequest, ListConversationsResponse> listConversationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.ConversationalSearchService/ListConversations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListConversationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListConversationsResponse.getDefaultInstance())).build();
    private final UnaryCallable<ConverseConversationRequest, ConverseConversationResponse> converseConversationCallable;
    private final UnaryCallable<CreateConversationRequest, Conversation> createConversationCallable;
    private final UnaryCallable<DeleteConversationRequest, Empty> deleteConversationCallable;
    private final UnaryCallable<UpdateConversationRequest, Conversation> updateConversationCallable;
    private final UnaryCallable<GetConversationRequest, Conversation> getConversationCallable;
    private final UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable;
    private final UnaryCallable<ListConversationsRequest, ConversationalSearchServiceClient.ListConversationsPagedResponse> listConversationsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcConversationalSearchServiceStub create(ConversationalSearchServiceStubSettings settings) throws IOException {
        return new GrpcConversationalSearchServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcConversationalSearchServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcConversationalSearchServiceStub(ConversationalSearchServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcConversationalSearchServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcConversationalSearchServiceStub(ConversationalSearchServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcConversationalSearchServiceStub(ConversationalSearchServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcConversationalSearchServiceCallableFactory());
    }

    protected GrpcConversationalSearchServiceStub(ConversationalSearchServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings converseConversationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(converseConversationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createConversationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createConversationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteConversationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteConversationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateConversationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateConversationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("conversation.name", String.valueOf(request.getConversation().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getConversationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConversationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listConversationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConversationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.converseConversationCallable = callableFactory.createUnaryCallable(converseConversationTransportSettings, settings.converseConversationSettings(), clientContext);
        this.createConversationCallable = callableFactory.createUnaryCallable(createConversationTransportSettings, settings.createConversationSettings(), clientContext);
        this.deleteConversationCallable = callableFactory.createUnaryCallable(deleteConversationTransportSettings, settings.deleteConversationSettings(), clientContext);
        this.updateConversationCallable = callableFactory.createUnaryCallable(updateConversationTransportSettings, settings.updateConversationSettings(), clientContext);
        this.getConversationCallable = callableFactory.createUnaryCallable(getConversationTransportSettings, settings.getConversationSettings(), clientContext);
        this.listConversationsCallable = callableFactory.createUnaryCallable(listConversationsTransportSettings, settings.listConversationsSettings(), clientContext);
        this.listConversationsPagedCallable = callableFactory.createPagedCallable(listConversationsTransportSettings, settings.listConversationsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ConverseConversationRequest, ConverseConversationResponse> converseConversationCallable() {
        return this.converseConversationCallable;
    }

    @Override
    public UnaryCallable<CreateConversationRequest, Conversation> createConversationCallable() {
        return this.createConversationCallable;
    }

    @Override
    public UnaryCallable<DeleteConversationRequest, Empty> deleteConversationCallable() {
        return this.deleteConversationCallable;
    }

    @Override
    public UnaryCallable<UpdateConversationRequest, Conversation> updateConversationCallable() {
        return this.updateConversationCallable;
    }

    @Override
    public UnaryCallable<GetConversationRequest, Conversation> getConversationCallable() {
        return this.getConversationCallable;
    }

    @Override
    public UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable() {
        return this.listConversationsCallable;
    }

    @Override
    public UnaryCallable<ListConversationsRequest, ConversationalSearchServiceClient.ListConversationsPagedResponse> listConversationsPagedCallable() {
        return this.listConversationsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

