/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.CompleteQueryRequest;
import com.google.cloud.discoveryengine.v1alpha.CompleteQueryResponse;
import com.google.cloud.discoveryengine.v1alpha.stub.CompletionServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.CompletionServiceStubSettings;
import com.google.cloud.discoveryengine.v1alpha.stub.GrpcCompletionServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcCompletionServiceStub
extends CompletionServiceStub {
    private static final MethodDescriptor<CompleteQueryRequest, CompleteQueryResponse> completeQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.CompletionService/CompleteQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)CompleteQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CompleteQueryResponse.getDefaultInstance())).build();
    private final UnaryCallable<CompleteQueryRequest, CompleteQueryResponse> completeQueryCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCompletionServiceStub create(CompletionServiceStubSettings settings) throws IOException {
        return new GrpcCompletionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCompletionServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCompletionServiceStub(CompletionServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCompletionServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCompletionServiceStub(CompletionServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCompletionServiceStub(CompletionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCompletionServiceCallableFactory());
    }

    protected GrpcCompletionServiceStub(CompletionServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings completeQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(completeQueryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("data_store", String.valueOf(request.getDataStore()));
            return builder.build();
        }).build();
        this.completeQueryCallable = callableFactory.createUnaryCallable(completeQueryTransportSettings, settings.completeQuerySettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CompleteQueryRequest, CompleteQueryResponse> completeQueryCallable() {
        return this.completeQueryCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

