/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.ConversationDataset;
import com.google.cloud.dialogflow.v2.ConversationDatasetsClient;
import com.google.cloud.dialogflow.v2.CreateConversationDatasetOperationMetadata;
import com.google.cloud.dialogflow.v2.CreateConversationDatasetRequest;
import com.google.cloud.dialogflow.v2.DeleteConversationDatasetOperationMetadata;
import com.google.cloud.dialogflow.v2.DeleteConversationDatasetRequest;
import com.google.cloud.dialogflow.v2.GetConversationDatasetRequest;
import com.google.cloud.dialogflow.v2.ImportConversationDataOperationMetadata;
import com.google.cloud.dialogflow.v2.ImportConversationDataOperationResponse;
import com.google.cloud.dialogflow.v2.ImportConversationDataRequest;
import com.google.cloud.dialogflow.v2.ListConversationDatasetsRequest;
import com.google.cloud.dialogflow.v2.ListConversationDatasetsResponse;
import com.google.cloud.dialogflow.v2.stub.ConversationDatasetsStub;
import com.google.cloud.dialogflow.v2.stub.ConversationDatasetsStubSettings;
import com.google.cloud.dialogflow.v2.stub.GrpcConversationDatasetsCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcConversationDatasetsStub
extends ConversationDatasetsStub {
    private static final MethodDescriptor<CreateConversationDatasetRequest, Operation> createConversationDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.ConversationDatasets/CreateConversationDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateConversationDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetConversationDatasetRequest, ConversationDataset> getConversationDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.ConversationDatasets/GetConversationDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)GetConversationDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ConversationDataset.getDefaultInstance())).build();
    private static final MethodDescriptor<ListConversationDatasetsRequest, ListConversationDatasetsResponse> listConversationDatasetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.ConversationDatasets/ListConversationDatasets").setRequestMarshaller(ProtoUtils.marshaller((Message)ListConversationDatasetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListConversationDatasetsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteConversationDatasetRequest, Operation> deleteConversationDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.ConversationDatasets/DeleteConversationDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteConversationDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportConversationDataRequest, Operation> importConversationDataMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.ConversationDatasets/ImportConversationData").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportConversationDataRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<CreateConversationDatasetRequest, Operation> createConversationDatasetCallable;
    private final OperationCallable<CreateConversationDatasetRequest, ConversationDataset, CreateConversationDatasetOperationMetadata> createConversationDatasetOperationCallable;
    private final UnaryCallable<GetConversationDatasetRequest, ConversationDataset> getConversationDatasetCallable;
    private final UnaryCallable<ListConversationDatasetsRequest, ListConversationDatasetsResponse> listConversationDatasetsCallable;
    private final UnaryCallable<ListConversationDatasetsRequest, ConversationDatasetsClient.ListConversationDatasetsPagedResponse> listConversationDatasetsPagedCallable;
    private final UnaryCallable<DeleteConversationDatasetRequest, Operation> deleteConversationDatasetCallable;
    private final OperationCallable<DeleteConversationDatasetRequest, Empty, DeleteConversationDatasetOperationMetadata> deleteConversationDatasetOperationCallable;
    private final UnaryCallable<ImportConversationDataRequest, Operation> importConversationDataCallable;
    private final OperationCallable<ImportConversationDataRequest, ImportConversationDataOperationResponse, ImportConversationDataOperationMetadata> importConversationDataOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcConversationDatasetsStub create(ConversationDatasetsStubSettings settings) throws IOException {
        return new GrpcConversationDatasetsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcConversationDatasetsStub create(ClientContext clientContext) throws IOException {
        return new GrpcConversationDatasetsStub(ConversationDatasetsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcConversationDatasetsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcConversationDatasetsStub(ConversationDatasetsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcConversationDatasetsStub(ConversationDatasetsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcConversationDatasetsCallableFactory());
    }

    protected GrpcConversationDatasetsStub(ConversationDatasetsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createConversationDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createConversationDatasetMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getConversationDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConversationDatasetMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listConversationDatasetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConversationDatasetsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings deleteConversationDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteConversationDatasetMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings importConversationDataTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importConversationDataMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.createConversationDatasetCallable = callableFactory.createUnaryCallable(createConversationDatasetTransportSettings, settings.createConversationDatasetSettings(), clientContext);
        this.createConversationDatasetOperationCallable = callableFactory.createOperationCallable(createConversationDatasetTransportSettings, settings.createConversationDatasetOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getConversationDatasetCallable = callableFactory.createUnaryCallable(getConversationDatasetTransportSettings, settings.getConversationDatasetSettings(), clientContext);
        this.listConversationDatasetsCallable = callableFactory.createUnaryCallable(listConversationDatasetsTransportSettings, settings.listConversationDatasetsSettings(), clientContext);
        this.listConversationDatasetsPagedCallable = callableFactory.createPagedCallable(listConversationDatasetsTransportSettings, settings.listConversationDatasetsSettings(), clientContext);
        this.deleteConversationDatasetCallable = callableFactory.createUnaryCallable(deleteConversationDatasetTransportSettings, settings.deleteConversationDatasetSettings(), clientContext);
        this.deleteConversationDatasetOperationCallable = callableFactory.createOperationCallable(deleteConversationDatasetTransportSettings, settings.deleteConversationDatasetOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.importConversationDataCallable = callableFactory.createUnaryCallable(importConversationDataTransportSettings, settings.importConversationDataSettings(), clientContext);
        this.importConversationDataOperationCallable = callableFactory.createOperationCallable(importConversationDataTransportSettings, settings.importConversationDataOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateConversationDatasetRequest, Operation> createConversationDatasetCallable() {
        return this.createConversationDatasetCallable;
    }

    @Override
    public OperationCallable<CreateConversationDatasetRequest, ConversationDataset, CreateConversationDatasetOperationMetadata> createConversationDatasetOperationCallable() {
        return this.createConversationDatasetOperationCallable;
    }

    @Override
    public UnaryCallable<GetConversationDatasetRequest, ConversationDataset> getConversationDatasetCallable() {
        return this.getConversationDatasetCallable;
    }

    @Override
    public UnaryCallable<ListConversationDatasetsRequest, ListConversationDatasetsResponse> listConversationDatasetsCallable() {
        return this.listConversationDatasetsCallable;
    }

    @Override
    public UnaryCallable<ListConversationDatasetsRequest, ConversationDatasetsClient.ListConversationDatasetsPagedResponse> listConversationDatasetsPagedCallable() {
        return this.listConversationDatasetsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteConversationDatasetRequest, Operation> deleteConversationDatasetCallable() {
        return this.deleteConversationDatasetCallable;
    }

    @Override
    public OperationCallable<DeleteConversationDatasetRequest, Empty, DeleteConversationDatasetOperationMetadata> deleteConversationDatasetOperationCallable() {
        return this.deleteConversationDatasetOperationCallable;
    }

    @Override
    public UnaryCallable<ImportConversationDataRequest, Operation> importConversationDataCallable() {
        return this.importConversationDataCallable;
    }

    @Override
    public OperationCallable<ImportConversationDataRequest, ImportConversationDataOperationResponse, ImportConversationDataOperationMetadata> importConversationDataOperationCallable() {
        return this.importConversationDataOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

