/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.AnswerRecord;
import com.google.cloud.dialogflow.v2beta1.AnswerRecordsClient;
import com.google.cloud.dialogflow.v2beta1.GetAnswerRecordRequest;
import com.google.cloud.dialogflow.v2beta1.ListAnswerRecordsRequest;
import com.google.cloud.dialogflow.v2beta1.ListAnswerRecordsResponse;
import com.google.cloud.dialogflow.v2beta1.UpdateAnswerRecordRequest;
import com.google.cloud.dialogflow.v2beta1.stub.AnswerRecordsStub;
import com.google.cloud.dialogflow.v2beta1.stub.AnswerRecordsStubSettings;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcAnswerRecordsCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcAnswerRecordsStub
extends AnswerRecordsStub {
    private static final MethodDescriptor<GetAnswerRecordRequest, AnswerRecord> getAnswerRecordMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.AnswerRecords/GetAnswerRecord").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAnswerRecordRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnswerRecord.getDefaultInstance())).build();
    private static final MethodDescriptor<ListAnswerRecordsRequest, ListAnswerRecordsResponse> listAnswerRecordsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.AnswerRecords/ListAnswerRecords").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAnswerRecordsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAnswerRecordsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateAnswerRecordRequest, AnswerRecord> updateAnswerRecordMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.AnswerRecords/UpdateAnswerRecord").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateAnswerRecordRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnswerRecord.getDefaultInstance())).build();
    private final UnaryCallable<GetAnswerRecordRequest, AnswerRecord> getAnswerRecordCallable;
    private final UnaryCallable<ListAnswerRecordsRequest, ListAnswerRecordsResponse> listAnswerRecordsCallable;
    private final UnaryCallable<ListAnswerRecordsRequest, AnswerRecordsClient.ListAnswerRecordsPagedResponse> listAnswerRecordsPagedCallable;
    private final UnaryCallable<UpdateAnswerRecordRequest, AnswerRecord> updateAnswerRecordCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAnswerRecordsStub create(AnswerRecordsStubSettings settings) throws IOException {
        return new GrpcAnswerRecordsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAnswerRecordsStub create(ClientContext clientContext) throws IOException {
        return new GrpcAnswerRecordsStub(AnswerRecordsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAnswerRecordsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAnswerRecordsStub(AnswerRecordsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAnswerRecordsStub(AnswerRecordsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAnswerRecordsCallableFactory());
    }

    protected GrpcAnswerRecordsStub(AnswerRecordsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getAnswerRecordTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAnswerRecordMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listAnswerRecordsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAnswerRecordsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateAnswerRecordTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateAnswerRecordMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"answer_record.name", (Object)String.valueOf(request.getAnswerRecord().getName()));
            return params.build();
        }).build();
        this.getAnswerRecordCallable = callableFactory.createUnaryCallable(getAnswerRecordTransportSettings, settings.getAnswerRecordSettings(), clientContext);
        this.listAnswerRecordsCallable = callableFactory.createUnaryCallable(listAnswerRecordsTransportSettings, settings.listAnswerRecordsSettings(), clientContext);
        this.listAnswerRecordsPagedCallable = callableFactory.createPagedCallable(listAnswerRecordsTransportSettings, settings.listAnswerRecordsSettings(), clientContext);
        this.updateAnswerRecordCallable = callableFactory.createUnaryCallable(updateAnswerRecordTransportSettings, settings.updateAnswerRecordSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetAnswerRecordRequest, AnswerRecord> getAnswerRecordCallable() {
        return this.getAnswerRecordCallable;
    }

    @Override
    public UnaryCallable<ListAnswerRecordsRequest, ListAnswerRecordsResponse> listAnswerRecordsCallable() {
        return this.listAnswerRecordsCallable;
    }

    @Override
    public UnaryCallable<ListAnswerRecordsRequest, AnswerRecordsClient.ListAnswerRecordsPagedResponse> listAnswerRecordsPagedCallable() {
        return this.listAnswerRecordsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateAnswerRecordRequest, AnswerRecord> updateAnswerRecordCallable() {
        return this.updateAnswerRecordCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

