/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.BatchCreateEntitiesRequest;
import com.google.cloud.dialogflow.v2.BatchDeleteEntitiesRequest;
import com.google.cloud.dialogflow.v2.BatchDeleteEntityTypesRequest;
import com.google.cloud.dialogflow.v2.BatchUpdateEntitiesRequest;
import com.google.cloud.dialogflow.v2.BatchUpdateEntityTypesRequest;
import com.google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse;
import com.google.cloud.dialogflow.v2.CreateEntityTypeRequest;
import com.google.cloud.dialogflow.v2.DeleteEntityTypeRequest;
import com.google.cloud.dialogflow.v2.EntityType;
import com.google.cloud.dialogflow.v2.EntityTypesClient;
import com.google.cloud.dialogflow.v2.GetEntityTypeRequest;
import com.google.cloud.dialogflow.v2.ListEntityTypesRequest;
import com.google.cloud.dialogflow.v2.ListEntityTypesResponse;
import com.google.cloud.dialogflow.v2.UpdateEntityTypeRequest;
import com.google.cloud.dialogflow.v2.stub.EntityTypesStub;
import com.google.cloud.dialogflow.v2.stub.GrpcEntityTypesStub;
import com.google.cloud.dialogflow.v2.stub.HttpJsonEntityTypesStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class EntityTypesStubSettings
extends StubSettings<EntityTypesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse> listEntityTypesSettings;
    private final UnaryCallSettings<GetEntityTypeRequest, EntityType> getEntityTypeSettings;
    private final UnaryCallSettings<CreateEntityTypeRequest, EntityType> createEntityTypeSettings;
    private final UnaryCallSettings<UpdateEntityTypeRequest, EntityType> updateEntityTypeSettings;
    private final UnaryCallSettings<DeleteEntityTypeRequest, Empty> deleteEntityTypeSettings;
    private final UnaryCallSettings<BatchUpdateEntityTypesRequest, Operation> batchUpdateEntityTypesSettings;
    private final OperationCallSettings<BatchUpdateEntityTypesRequest, BatchUpdateEntityTypesResponse, Struct> batchUpdateEntityTypesOperationSettings;
    private final UnaryCallSettings<BatchDeleteEntityTypesRequest, Operation> batchDeleteEntityTypesSettings;
    private final OperationCallSettings<BatchDeleteEntityTypesRequest, Empty, Struct> batchDeleteEntityTypesOperationSettings;
    private final UnaryCallSettings<BatchCreateEntitiesRequest, Operation> batchCreateEntitiesSettings;
    private final OperationCallSettings<BatchCreateEntitiesRequest, Empty, Struct> batchCreateEntitiesOperationSettings;
    private final UnaryCallSettings<BatchUpdateEntitiesRequest, Operation> batchUpdateEntitiesSettings;
    private final OperationCallSettings<BatchUpdateEntitiesRequest, Empty, Struct> batchUpdateEntitiesOperationSettings;
    private final UnaryCallSettings<BatchDeleteEntitiesRequest, Operation> batchDeleteEntitiesSettings;
    private final OperationCallSettings<BatchDeleteEntitiesRequest, Empty, Struct> batchDeleteEntitiesOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EntityTypesClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListEntityTypesRequest, ListEntityTypesResponse, EntityType> LIST_ENTITY_TYPES_PAGE_STR_DESC = new PagedListDescriptor<ListEntityTypesRequest, ListEntityTypesResponse, EntityType>(){

        public String emptyToken() {
            return "";
        }

        public ListEntityTypesRequest injectToken(ListEntityTypesRequest payload, String token) {
            return ListEntityTypesRequest.newBuilder((ListEntityTypesRequest)payload).setPageToken(token).build();
        }

        public ListEntityTypesRequest injectPageSize(ListEntityTypesRequest payload, int pageSize) {
            return ListEntityTypesRequest.newBuilder((ListEntityTypesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEntityTypesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEntityTypesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<EntityType> extractResources(ListEntityTypesResponse payload) {
            return payload.getEntityTypesList() == null ? ImmutableList.of() : payload.getEntityTypesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse> LIST_ENTITY_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse>(){

        public ApiFuture<EntityTypesClient.ListEntityTypesPagedResponse> getFuturePagedResponse(UnaryCallable<ListEntityTypesRequest, ListEntityTypesResponse> callable, ListEntityTypesRequest request, ApiCallContext context, ApiFuture<ListEntityTypesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENTITY_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EntityTypesClient.ListEntityTypesPagedResponse.createAsync((PageContext<ListEntityTypesRequest, ListEntityTypesResponse, EntityType>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EntityTypesClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EntityTypesClient.ListLocationsPagedResponse>(){

        public ApiFuture<EntityTypesClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EntityTypesClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse> listEntityTypesSettings() {
        return this.listEntityTypesSettings;
    }

    public UnaryCallSettings<GetEntityTypeRequest, EntityType> getEntityTypeSettings() {
        return this.getEntityTypeSettings;
    }

    public UnaryCallSettings<CreateEntityTypeRequest, EntityType> createEntityTypeSettings() {
        return this.createEntityTypeSettings;
    }

    public UnaryCallSettings<UpdateEntityTypeRequest, EntityType> updateEntityTypeSettings() {
        return this.updateEntityTypeSettings;
    }

    public UnaryCallSettings<DeleteEntityTypeRequest, Empty> deleteEntityTypeSettings() {
        return this.deleteEntityTypeSettings;
    }

    public UnaryCallSettings<BatchUpdateEntityTypesRequest, Operation> batchUpdateEntityTypesSettings() {
        return this.batchUpdateEntityTypesSettings;
    }

    public OperationCallSettings<BatchUpdateEntityTypesRequest, BatchUpdateEntityTypesResponse, Struct> batchUpdateEntityTypesOperationSettings() {
        return this.batchUpdateEntityTypesOperationSettings;
    }

    public UnaryCallSettings<BatchDeleteEntityTypesRequest, Operation> batchDeleteEntityTypesSettings() {
        return this.batchDeleteEntityTypesSettings;
    }

    public OperationCallSettings<BatchDeleteEntityTypesRequest, Empty, Struct> batchDeleteEntityTypesOperationSettings() {
        return this.batchDeleteEntityTypesOperationSettings;
    }

    public UnaryCallSettings<BatchCreateEntitiesRequest, Operation> batchCreateEntitiesSettings() {
        return this.batchCreateEntitiesSettings;
    }

    public OperationCallSettings<BatchCreateEntitiesRequest, Empty, Struct> batchCreateEntitiesOperationSettings() {
        return this.batchCreateEntitiesOperationSettings;
    }

    public UnaryCallSettings<BatchUpdateEntitiesRequest, Operation> batchUpdateEntitiesSettings() {
        return this.batchUpdateEntitiesSettings;
    }

    public OperationCallSettings<BatchUpdateEntitiesRequest, Empty, Struct> batchUpdateEntitiesOperationSettings() {
        return this.batchUpdateEntitiesOperationSettings;
    }

    public UnaryCallSettings<BatchDeleteEntitiesRequest, Operation> batchDeleteEntitiesSettings() {
        return this.batchDeleteEntitiesSettings;
    }

    public OperationCallSettings<BatchDeleteEntitiesRequest, Empty, Struct> batchDeleteEntitiesOperationSettings() {
        return this.batchDeleteEntitiesOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EntityTypesClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public EntityTypesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEntityTypesStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonEntityTypesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return EntityTypesStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EntityTypesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EntityTypesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EntityTypesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return EntityTypesStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EntityTypesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listEntityTypesSettings = settingsBuilder.listEntityTypesSettings().build();
        this.getEntityTypeSettings = settingsBuilder.getEntityTypeSettings().build();
        this.createEntityTypeSettings = settingsBuilder.createEntityTypeSettings().build();
        this.updateEntityTypeSettings = settingsBuilder.updateEntityTypeSettings().build();
        this.deleteEntityTypeSettings = settingsBuilder.deleteEntityTypeSettings().build();
        this.batchUpdateEntityTypesSettings = settingsBuilder.batchUpdateEntityTypesSettings().build();
        this.batchUpdateEntityTypesOperationSettings = settingsBuilder.batchUpdateEntityTypesOperationSettings().build();
        this.batchDeleteEntityTypesSettings = settingsBuilder.batchDeleteEntityTypesSettings().build();
        this.batchDeleteEntityTypesOperationSettings = settingsBuilder.batchDeleteEntityTypesOperationSettings().build();
        this.batchCreateEntitiesSettings = settingsBuilder.batchCreateEntitiesSettings().build();
        this.batchCreateEntitiesOperationSettings = settingsBuilder.batchCreateEntitiesOperationSettings().build();
        this.batchUpdateEntitiesSettings = settingsBuilder.batchUpdateEntitiesSettings().build();
        this.batchUpdateEntitiesOperationSettings = settingsBuilder.batchUpdateEntitiesOperationSettings().build();
        this.batchDeleteEntitiesSettings = settingsBuilder.batchDeleteEntitiesSettings().build();
        this.batchDeleteEntitiesOperationSettings = settingsBuilder.batchDeleteEntitiesOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EntityTypesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse> listEntityTypesSettings;
        private final UnaryCallSettings.Builder<GetEntityTypeRequest, EntityType> getEntityTypeSettings;
        private final UnaryCallSettings.Builder<CreateEntityTypeRequest, EntityType> createEntityTypeSettings;
        private final UnaryCallSettings.Builder<UpdateEntityTypeRequest, EntityType> updateEntityTypeSettings;
        private final UnaryCallSettings.Builder<DeleteEntityTypeRequest, Empty> deleteEntityTypeSettings;
        private final UnaryCallSettings.Builder<BatchUpdateEntityTypesRequest, Operation> batchUpdateEntityTypesSettings;
        private final OperationCallSettings.Builder<BatchUpdateEntityTypesRequest, BatchUpdateEntityTypesResponse, Struct> batchUpdateEntityTypesOperationSettings;
        private final UnaryCallSettings.Builder<BatchDeleteEntityTypesRequest, Operation> batchDeleteEntityTypesSettings;
        private final OperationCallSettings.Builder<BatchDeleteEntityTypesRequest, Empty, Struct> batchDeleteEntityTypesOperationSettings;
        private final UnaryCallSettings.Builder<BatchCreateEntitiesRequest, Operation> batchCreateEntitiesSettings;
        private final OperationCallSettings.Builder<BatchCreateEntitiesRequest, Empty, Struct> batchCreateEntitiesOperationSettings;
        private final UnaryCallSettings.Builder<BatchUpdateEntitiesRequest, Operation> batchUpdateEntitiesSettings;
        private final OperationCallSettings.Builder<BatchUpdateEntitiesRequest, Empty, Struct> batchUpdateEntitiesOperationSettings;
        private final UnaryCallSettings.Builder<BatchDeleteEntitiesRequest, Operation> batchDeleteEntitiesSettings;
        private final OperationCallSettings.Builder<BatchDeleteEntitiesRequest, Empty, Struct> batchDeleteEntitiesOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EntityTypesClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listEntityTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENTITY_TYPES_PAGE_STR_FACT);
            this.getEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateEntityTypesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateEntityTypesOperationSettings = OperationCallSettings.newBuilder();
            this.batchDeleteEntityTypesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchDeleteEntityTypesOperationSettings = OperationCallSettings.newBuilder();
            this.batchCreateEntitiesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateEntitiesOperationSettings = OperationCallSettings.newBuilder();
            this.batchUpdateEntitiesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateEntitiesOperationSettings = OperationCallSettings.newBuilder();
            this.batchDeleteEntitiesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchDeleteEntitiesOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listEntityTypesSettings, this.getEntityTypeSettings, this.createEntityTypeSettings, this.updateEntityTypeSettings, this.deleteEntityTypeSettings, this.batchUpdateEntityTypesSettings, this.batchDeleteEntityTypesSettings, this.batchCreateEntitiesSettings, this.batchUpdateEntitiesSettings, this.batchDeleteEntitiesSettings, this.listLocationsSettings, this.getLocationSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(EntityTypesStubSettings settings) {
            super((StubSettings)settings);
            this.listEntityTypesSettings = settings.listEntityTypesSettings.toBuilder();
            this.getEntityTypeSettings = settings.getEntityTypeSettings.toBuilder();
            this.createEntityTypeSettings = settings.createEntityTypeSettings.toBuilder();
            this.updateEntityTypeSettings = settings.updateEntityTypeSettings.toBuilder();
            this.deleteEntityTypeSettings = settings.deleteEntityTypeSettings.toBuilder();
            this.batchUpdateEntityTypesSettings = settings.batchUpdateEntityTypesSettings.toBuilder();
            this.batchUpdateEntityTypesOperationSettings = settings.batchUpdateEntityTypesOperationSettings.toBuilder();
            this.batchDeleteEntityTypesSettings = settings.batchDeleteEntityTypesSettings.toBuilder();
            this.batchDeleteEntityTypesOperationSettings = settings.batchDeleteEntityTypesOperationSettings.toBuilder();
            this.batchCreateEntitiesSettings = settings.batchCreateEntitiesSettings.toBuilder();
            this.batchCreateEntitiesOperationSettings = settings.batchCreateEntitiesOperationSettings.toBuilder();
            this.batchUpdateEntitiesSettings = settings.batchUpdateEntitiesSettings.toBuilder();
            this.batchUpdateEntitiesOperationSettings = settings.batchUpdateEntitiesOperationSettings.toBuilder();
            this.batchDeleteEntitiesSettings = settings.batchDeleteEntitiesSettings.toBuilder();
            this.batchDeleteEntitiesOperationSettings = settings.batchDeleteEntitiesOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listEntityTypesSettings, this.getEntityTypeSettings, this.createEntityTypeSettings, this.updateEntityTypeSettings, this.deleteEntityTypeSettings, this.batchUpdateEntityTypesSettings, this.batchDeleteEntityTypesSettings, this.batchCreateEntitiesSettings, this.batchUpdateEntitiesSettings, this.batchDeleteEntitiesSettings, this.listLocationsSettings, this.getLocationSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EntityTypesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EntityTypesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EntityTypesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EntityTypesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)EntityTypesStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)EntityTypesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EntityTypesStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EntityTypesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listEntityTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchUpdateEntityTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchDeleteEntityTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchCreateEntitiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchUpdateEntitiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchDeleteEntitiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchUpdateEntityTypesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchUpdateEntityTypesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchDeleteEntityTypesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchCreateEntitiesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchUpdateEntitiesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchDeleteEntitiesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse> listEntityTypesSettings() {
            return this.listEntityTypesSettings;
        }

        public UnaryCallSettings.Builder<GetEntityTypeRequest, EntityType> getEntityTypeSettings() {
            return this.getEntityTypeSettings;
        }

        public UnaryCallSettings.Builder<CreateEntityTypeRequest, EntityType> createEntityTypeSettings() {
            return this.createEntityTypeSettings;
        }

        public UnaryCallSettings.Builder<UpdateEntityTypeRequest, EntityType> updateEntityTypeSettings() {
            return this.updateEntityTypeSettings;
        }

        public UnaryCallSettings.Builder<DeleteEntityTypeRequest, Empty> deleteEntityTypeSettings() {
            return this.deleteEntityTypeSettings;
        }

        public UnaryCallSettings.Builder<BatchUpdateEntityTypesRequest, Operation> batchUpdateEntityTypesSettings() {
            return this.batchUpdateEntityTypesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchUpdateEntityTypesRequest, BatchUpdateEntityTypesResponse, Struct> batchUpdateEntityTypesOperationSettings() {
            return this.batchUpdateEntityTypesOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchDeleteEntityTypesRequest, Operation> batchDeleteEntityTypesSettings() {
            return this.batchDeleteEntityTypesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchDeleteEntityTypesRequest, Empty, Struct> batchDeleteEntityTypesOperationSettings() {
            return this.batchDeleteEntityTypesOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchCreateEntitiesRequest, Operation> batchCreateEntitiesSettings() {
            return this.batchCreateEntitiesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchCreateEntitiesRequest, Empty, Struct> batchCreateEntitiesOperationSettings() {
            return this.batchCreateEntitiesOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchUpdateEntitiesRequest, Operation> batchUpdateEntitiesSettings() {
            return this.batchUpdateEntitiesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchUpdateEntitiesRequest, Empty, Struct> batchUpdateEntitiesOperationSettings() {
            return this.batchUpdateEntitiesOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchDeleteEntitiesRequest, Operation> batchDeleteEntitiesSettings() {
            return this.batchDeleteEntitiesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchDeleteEntitiesRequest, Empty, Struct> batchDeleteEntitiesOperationSettings() {
            return this.batchDeleteEntitiesOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EntityTypesClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return EntityTypesStubSettings.getDefaultEndpoint();
        }

        public EntityTypesStubSettings build() throws IOException {
            return new EntityTypesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

