/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.CreateEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.Environment;
import com.google.cloud.dialogflow.v2beta1.EnvironmentHistory;
import com.google.cloud.dialogflow.v2beta1.EnvironmentsClient;
import com.google.cloud.dialogflow.v2beta1.GetEnvironmentHistoryRequest;
import com.google.cloud.dialogflow.v2beta1.GetEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.ListEnvironmentsRequest;
import com.google.cloud.dialogflow.v2beta1.ListEnvironmentsResponse;
import com.google.cloud.dialogflow.v2beta1.UpdateEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.stub.EnvironmentsStub;
import com.google.cloud.dialogflow.v2beta1.stub.EnvironmentsStubSettings;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcEnvironmentsCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcEnvironmentsStub
extends EnvironmentsStub {
    private static final MethodDescriptor<ListEnvironmentsRequest, ListEnvironmentsResponse> listEnvironmentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Environments/ListEnvironments").setRequestMarshaller(ProtoUtils.marshaller((Message)ListEnvironmentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListEnvironmentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetEnvironmentRequest, Environment> getEnvironmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Environments/GetEnvironment").setRequestMarshaller(ProtoUtils.marshaller((Message)GetEnvironmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Environment.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateEnvironmentRequest, Environment> createEnvironmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Environments/CreateEnvironment").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateEnvironmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Environment.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateEnvironmentRequest, Environment> updateEnvironmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Environments/UpdateEnvironment").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateEnvironmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Environment.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteEnvironmentRequest, Empty> deleteEnvironmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Environments/DeleteEnvironment").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteEnvironmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetEnvironmentHistoryRequest, EnvironmentHistory> getEnvironmentHistoryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Environments/GetEnvironmentHistory").setRequestMarshaller(ProtoUtils.marshaller((Message)GetEnvironmentHistoryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)EnvironmentHistory.getDefaultInstance())).build();
    private final UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> listEnvironmentsCallable;
    private final UnaryCallable<ListEnvironmentsRequest, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsPagedCallable;
    private final UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable;
    private final UnaryCallable<CreateEnvironmentRequest, Environment> createEnvironmentCallable;
    private final UnaryCallable<UpdateEnvironmentRequest, Environment> updateEnvironmentCallable;
    private final UnaryCallable<DeleteEnvironmentRequest, Empty> deleteEnvironmentCallable;
    private final UnaryCallable<GetEnvironmentHistoryRequest, EnvironmentHistory> getEnvironmentHistoryCallable;
    private final UnaryCallable<GetEnvironmentHistoryRequest, EnvironmentsClient.GetEnvironmentHistoryPagedResponse> getEnvironmentHistoryPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcEnvironmentsStub create(EnvironmentsStubSettings settings) throws IOException {
        return new GrpcEnvironmentsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcEnvironmentsStub create(ClientContext clientContext) throws IOException {
        return new GrpcEnvironmentsStub(EnvironmentsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcEnvironmentsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcEnvironmentsStub(EnvironmentsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcEnvironmentsStub(EnvironmentsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcEnvironmentsCallableFactory());
    }

    protected GrpcEnvironmentsStub(EnvironmentsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listEnvironmentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listEnvironmentsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getEnvironmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEnvironmentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createEnvironmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createEnvironmentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateEnvironmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateEnvironmentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"environment.name", (Object)String.valueOf(request.getEnvironment().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteEnvironmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteEnvironmentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getEnvironmentHistoryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEnvironmentHistoryMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        this.listEnvironmentsCallable = callableFactory.createUnaryCallable(listEnvironmentsTransportSettings, settings.listEnvironmentsSettings(), clientContext);
        this.listEnvironmentsPagedCallable = callableFactory.createPagedCallable(listEnvironmentsTransportSettings, settings.listEnvironmentsSettings(), clientContext);
        this.getEnvironmentCallable = callableFactory.createUnaryCallable(getEnvironmentTransportSettings, settings.getEnvironmentSettings(), clientContext);
        this.createEnvironmentCallable = callableFactory.createUnaryCallable(createEnvironmentTransportSettings, settings.createEnvironmentSettings(), clientContext);
        this.updateEnvironmentCallable = callableFactory.createUnaryCallable(updateEnvironmentTransportSettings, settings.updateEnvironmentSettings(), clientContext);
        this.deleteEnvironmentCallable = callableFactory.createUnaryCallable(deleteEnvironmentTransportSettings, settings.deleteEnvironmentSettings(), clientContext);
        this.getEnvironmentHistoryCallable = callableFactory.createUnaryCallable(getEnvironmentHistoryTransportSettings, settings.getEnvironmentHistorySettings(), clientContext);
        this.getEnvironmentHistoryPagedCallable = callableFactory.createPagedCallable(getEnvironmentHistoryTransportSettings, settings.getEnvironmentHistorySettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> listEnvironmentsCallable() {
        return this.listEnvironmentsCallable;
    }

    @Override
    public UnaryCallable<ListEnvironmentsRequest, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsPagedCallable() {
        return this.listEnvironmentsPagedCallable;
    }

    @Override
    public UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable() {
        return this.getEnvironmentCallable;
    }

    @Override
    public UnaryCallable<CreateEnvironmentRequest, Environment> createEnvironmentCallable() {
        return this.createEnvironmentCallable;
    }

    @Override
    public UnaryCallable<UpdateEnvironmentRequest, Environment> updateEnvironmentCallable() {
        return this.updateEnvironmentCallable;
    }

    @Override
    public UnaryCallable<DeleteEnvironmentRequest, Empty> deleteEnvironmentCallable() {
        return this.deleteEnvironmentCallable;
    }

    @Override
    public UnaryCallable<GetEnvironmentHistoryRequest, EnvironmentHistory> getEnvironmentHistoryCallable() {
        return this.getEnvironmentHistoryCallable;
    }

    @Override
    public UnaryCallable<GetEnvironmentHistoryRequest, EnvironmentsClient.GetEnvironmentHistoryPagedResponse> getEnvironmentHistoryPagedCallable() {
        return this.getEnvironmentHistoryPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

