/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.ConversationProfile;
import com.google.cloud.dialogflow.v2.ConversationProfilesClient;
import com.google.cloud.dialogflow.v2.CreateConversationProfileRequest;
import com.google.cloud.dialogflow.v2.DeleteConversationProfileRequest;
import com.google.cloud.dialogflow.v2.GetConversationProfileRequest;
import com.google.cloud.dialogflow.v2.ListConversationProfilesRequest;
import com.google.cloud.dialogflow.v2.ListConversationProfilesResponse;
import com.google.cloud.dialogflow.v2.UpdateConversationProfileRequest;
import com.google.cloud.dialogflow.v2.stub.ConversationProfilesStub;
import com.google.cloud.dialogflow.v2.stub.ConversationProfilesStubSettings;
import com.google.cloud.dialogflow.v2.stub.GrpcConversationProfilesCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcConversationProfilesStub
extends ConversationProfilesStub {
    private static final MethodDescriptor<ListConversationProfilesRequest, ListConversationProfilesResponse> listConversationProfilesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.ConversationProfiles/ListConversationProfiles").setRequestMarshaller(ProtoUtils.marshaller((Message)ListConversationProfilesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListConversationProfilesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetConversationProfileRequest, ConversationProfile> getConversationProfileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.ConversationProfiles/GetConversationProfile").setRequestMarshaller(ProtoUtils.marshaller((Message)GetConversationProfileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ConversationProfile.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateConversationProfileRequest, ConversationProfile> createConversationProfileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.ConversationProfiles/CreateConversationProfile").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateConversationProfileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ConversationProfile.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateConversationProfileRequest, ConversationProfile> updateConversationProfileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.ConversationProfiles/UpdateConversationProfile").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateConversationProfileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ConversationProfile.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteConversationProfileRequest, Empty> deleteConversationProfileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.ConversationProfiles/DeleteConversationProfile").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteConversationProfileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final UnaryCallable<ListConversationProfilesRequest, ListConversationProfilesResponse> listConversationProfilesCallable;
    private final UnaryCallable<ListConversationProfilesRequest, ConversationProfilesClient.ListConversationProfilesPagedResponse> listConversationProfilesPagedCallable;
    private final UnaryCallable<GetConversationProfileRequest, ConversationProfile> getConversationProfileCallable;
    private final UnaryCallable<CreateConversationProfileRequest, ConversationProfile> createConversationProfileCallable;
    private final UnaryCallable<UpdateConversationProfileRequest, ConversationProfile> updateConversationProfileCallable;
    private final UnaryCallable<DeleteConversationProfileRequest, Empty> deleteConversationProfileCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcConversationProfilesStub create(ConversationProfilesStubSettings settings) throws IOException {
        return new GrpcConversationProfilesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcConversationProfilesStub create(ClientContext clientContext) throws IOException {
        return new GrpcConversationProfilesStub(ConversationProfilesStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcConversationProfilesStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcConversationProfilesStub(ConversationProfilesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcConversationProfilesStub(ConversationProfilesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcConversationProfilesCallableFactory());
    }

    protected GrpcConversationProfilesStub(ConversationProfilesStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listConversationProfilesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConversationProfilesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListConversationProfilesRequest>(){

            public Map<String, String> extract(ListConversationProfilesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getConversationProfileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConversationProfileMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetConversationProfileRequest>(){

            public Map<String, String> extract(GetConversationProfileRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createConversationProfileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createConversationProfileMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateConversationProfileRequest>(){

            public Map<String, String> extract(CreateConversationProfileRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateConversationProfileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateConversationProfileMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateConversationProfileRequest>(){

            public Map<String, String> extract(UpdateConversationProfileRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"conversation_profile.name", (Object)String.valueOf(request.getConversationProfile().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteConversationProfileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteConversationProfileMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteConversationProfileRequest>(){

            public Map<String, String> extract(DeleteConversationProfileRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.listConversationProfilesCallable = callableFactory.createUnaryCallable(listConversationProfilesTransportSettings, settings.listConversationProfilesSettings(), clientContext);
        this.listConversationProfilesPagedCallable = callableFactory.createPagedCallable(listConversationProfilesTransportSettings, settings.listConversationProfilesSettings(), clientContext);
        this.getConversationProfileCallable = callableFactory.createUnaryCallable(getConversationProfileTransportSettings, settings.getConversationProfileSettings(), clientContext);
        this.createConversationProfileCallable = callableFactory.createUnaryCallable(createConversationProfileTransportSettings, settings.createConversationProfileSettings(), clientContext);
        this.updateConversationProfileCallable = callableFactory.createUnaryCallable(updateConversationProfileTransportSettings, settings.updateConversationProfileSettings(), clientContext);
        this.deleteConversationProfileCallable = callableFactory.createUnaryCallable(deleteConversationProfileTransportSettings, settings.deleteConversationProfileSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListConversationProfilesRequest, ListConversationProfilesResponse> listConversationProfilesCallable() {
        return this.listConversationProfilesCallable;
    }

    @Override
    public UnaryCallable<ListConversationProfilesRequest, ConversationProfilesClient.ListConversationProfilesPagedResponse> listConversationProfilesPagedCallable() {
        return this.listConversationProfilesPagedCallable;
    }

    @Override
    public UnaryCallable<GetConversationProfileRequest, ConversationProfile> getConversationProfileCallable() {
        return this.getConversationProfileCallable;
    }

    @Override
    public UnaryCallable<CreateConversationProfileRequest, ConversationProfile> createConversationProfileCallable() {
        return this.createConversationProfileCallable;
    }

    @Override
    public UnaryCallable<UpdateConversationProfileRequest, ConversationProfile> updateConversationProfileCallable() {
        return this.updateConversationProfileCallable;
    }

    @Override
    public UnaryCallable<DeleteConversationProfileRequest, Empty> deleteConversationProfileCallable() {
        return this.deleteConversationProfileCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

