/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.Agent;
import com.google.cloud.dialogflow.v2.AgentsSettings;
import com.google.cloud.dialogflow.v2.DeleteAgentRequest;
import com.google.cloud.dialogflow.v2.ExportAgentRequest;
import com.google.cloud.dialogflow.v2.ExportAgentResponse;
import com.google.cloud.dialogflow.v2.GetAgentRequest;
import com.google.cloud.dialogflow.v2.GetValidationResultRequest;
import com.google.cloud.dialogflow.v2.ImportAgentRequest;
import com.google.cloud.dialogflow.v2.LocationName;
import com.google.cloud.dialogflow.v2.ProjectName;
import com.google.cloud.dialogflow.v2.RestoreAgentRequest;
import com.google.cloud.dialogflow.v2.SearchAgentsRequest;
import com.google.cloud.dialogflow.v2.SearchAgentsResponse;
import com.google.cloud.dialogflow.v2.SetAgentRequest;
import com.google.cloud.dialogflow.v2.TrainAgentRequest;
import com.google.cloud.dialogflow.v2.ValidationResult;
import com.google.cloud.dialogflow.v2.stub.AgentsStub;
import com.google.cloud.dialogflow.v2.stub.AgentsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AgentsClient
implements BackgroundResource {
    private final AgentsSettings settings;
    private final AgentsStub stub;
    private final OperationsClient operationsClient;

    public static final AgentsClient create() throws IOException {
        return AgentsClient.create(AgentsSettings.newBuilder().build());
    }

    public static final AgentsClient create(AgentsSettings settings) throws IOException {
        return new AgentsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AgentsClient create(AgentsStub stub) {
        return new AgentsClient(stub);
    }

    protected AgentsClient(AgentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AgentsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AgentsClient(AgentsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final AgentsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AgentsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Agent getAgent(LocationName parent) {
        GetAgentRequest request = GetAgentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.getAgent(request);
    }

    public final Agent getAgent(ProjectName parent) {
        GetAgentRequest request = GetAgentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.getAgent(request);
    }

    public final Agent getAgent(String parent) {
        GetAgentRequest request = GetAgentRequest.newBuilder().setParent(parent).build();
        return this.getAgent(request);
    }

    public final Agent getAgent(GetAgentRequest request) {
        return (Agent)this.getAgentCallable().call((Object)request);
    }

    public final UnaryCallable<GetAgentRequest, Agent> getAgentCallable() {
        return this.stub.getAgentCallable();
    }

    public final Agent setAgent(Agent agent) {
        SetAgentRequest request = SetAgentRequest.newBuilder().setAgent(agent).build();
        return this.setAgent(request);
    }

    public final Agent setAgent(SetAgentRequest request) {
        return (Agent)this.setAgentCallable().call((Object)request);
    }

    public final UnaryCallable<SetAgentRequest, Agent> setAgentCallable() {
        return this.stub.setAgentCallable();
    }

    public final void deleteAgent(LocationName parent) {
        DeleteAgentRequest request = DeleteAgentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        this.deleteAgent(request);
    }

    public final void deleteAgent(ProjectName parent) {
        DeleteAgentRequest request = DeleteAgentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        this.deleteAgent(request);
    }

    public final void deleteAgent(String parent) {
        DeleteAgentRequest request = DeleteAgentRequest.newBuilder().setParent(parent).build();
        this.deleteAgent(request);
    }

    public final void deleteAgent(DeleteAgentRequest request) {
        this.deleteAgentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAgentRequest, Empty> deleteAgentCallable() {
        return this.stub.deleteAgentCallable();
    }

    public final SearchAgentsPagedResponse searchAgents(LocationName parent) {
        SearchAgentsRequest request = SearchAgentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.searchAgents(request);
    }

    public final SearchAgentsPagedResponse searchAgents(ProjectName parent) {
        SearchAgentsRequest request = SearchAgentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.searchAgents(request);
    }

    public final SearchAgentsPagedResponse searchAgents(String parent) {
        SearchAgentsRequest request = SearchAgentsRequest.newBuilder().setParent(parent).build();
        return this.searchAgents(request);
    }

    public final SearchAgentsPagedResponse searchAgents(SearchAgentsRequest request) {
        return (SearchAgentsPagedResponse)((Object)this.searchAgentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchAgentsRequest, SearchAgentsPagedResponse> searchAgentsPagedCallable() {
        return this.stub.searchAgentsPagedCallable();
    }

    public final UnaryCallable<SearchAgentsRequest, SearchAgentsResponse> searchAgentsCallable() {
        return this.stub.searchAgentsCallable();
    }

    public final OperationFuture<Empty, Struct> trainAgentAsync(LocationName parent) {
        TrainAgentRequest request = TrainAgentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.trainAgentAsync(request);
    }

    public final OperationFuture<Empty, Struct> trainAgentAsync(ProjectName parent) {
        TrainAgentRequest request = TrainAgentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.trainAgentAsync(request);
    }

    public final OperationFuture<Empty, Struct> trainAgentAsync(String parent) {
        TrainAgentRequest request = TrainAgentRequest.newBuilder().setParent(parent).build();
        return this.trainAgentAsync(request);
    }

    public final OperationFuture<Empty, Struct> trainAgentAsync(TrainAgentRequest request) {
        return this.trainAgentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<TrainAgentRequest, Empty, Struct> trainAgentOperationCallable() {
        return this.stub.trainAgentOperationCallable();
    }

    public final UnaryCallable<TrainAgentRequest, Operation> trainAgentCallable() {
        return this.stub.trainAgentCallable();
    }

    public final OperationFuture<ExportAgentResponse, Struct> exportAgentAsync(LocationName parent) {
        ExportAgentRequest request = ExportAgentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.exportAgentAsync(request);
    }

    public final OperationFuture<ExportAgentResponse, Struct> exportAgentAsync(ProjectName parent) {
        ExportAgentRequest request = ExportAgentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.exportAgentAsync(request);
    }

    public final OperationFuture<ExportAgentResponse, Struct> exportAgentAsync(String parent) {
        ExportAgentRequest request = ExportAgentRequest.newBuilder().setParent(parent).build();
        return this.exportAgentAsync(request);
    }

    public final OperationFuture<ExportAgentResponse, Struct> exportAgentAsync(ExportAgentRequest request) {
        return this.exportAgentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportAgentRequest, ExportAgentResponse, Struct> exportAgentOperationCallable() {
        return this.stub.exportAgentOperationCallable();
    }

    public final UnaryCallable<ExportAgentRequest, Operation> exportAgentCallable() {
        return this.stub.exportAgentCallable();
    }

    public final OperationFuture<Empty, Struct> importAgentAsync(ImportAgentRequest request) {
        return this.importAgentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportAgentRequest, Empty, Struct> importAgentOperationCallable() {
        return this.stub.importAgentOperationCallable();
    }

    public final UnaryCallable<ImportAgentRequest, Operation> importAgentCallable() {
        return this.stub.importAgentCallable();
    }

    public final OperationFuture<Empty, Struct> restoreAgentAsync(RestoreAgentRequest request) {
        return this.restoreAgentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestoreAgentRequest, Empty, Struct> restoreAgentOperationCallable() {
        return this.stub.restoreAgentOperationCallable();
    }

    public final UnaryCallable<RestoreAgentRequest, Operation> restoreAgentCallable() {
        return this.stub.restoreAgentCallable();
    }

    public final ValidationResult getValidationResult(GetValidationResultRequest request) {
        return (ValidationResult)this.getValidationResultCallable().call((Object)request);
    }

    public final UnaryCallable<GetValidationResultRequest, ValidationResult> getValidationResultCallable() {
        return this.stub.getValidationResultCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchAgentsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchAgentsRequest, SearchAgentsResponse, Agent, SearchAgentsPage, SearchAgentsFixedSizeCollection> {
        private SearchAgentsFixedSizeCollection(List<SearchAgentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchAgentsFixedSizeCollection createEmptyCollection() {
            return new SearchAgentsFixedSizeCollection(null, 0);
        }

        protected SearchAgentsFixedSizeCollection createCollection(List<SearchAgentsPage> pages, int collectionSize) {
            return new SearchAgentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchAgentsPage
    extends AbstractPage<SearchAgentsRequest, SearchAgentsResponse, Agent, SearchAgentsPage> {
        private SearchAgentsPage(PageContext<SearchAgentsRequest, SearchAgentsResponse, Agent> context, SearchAgentsResponse response) {
            super(context, (Object)response);
        }

        private static SearchAgentsPage createEmptyPage() {
            return new SearchAgentsPage(null, null);
        }

        protected SearchAgentsPage createPage(PageContext<SearchAgentsRequest, SearchAgentsResponse, Agent> context, SearchAgentsResponse response) {
            return new SearchAgentsPage(context, response);
        }

        public ApiFuture<SearchAgentsPage> createPageAsync(PageContext<SearchAgentsRequest, SearchAgentsResponse, Agent> context, ApiFuture<SearchAgentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchAgentsPagedResponse
    extends AbstractPagedListResponse<SearchAgentsRequest, SearchAgentsResponse, Agent, SearchAgentsPage, SearchAgentsFixedSizeCollection> {
        public static ApiFuture<SearchAgentsPagedResponse> createAsync(PageContext<SearchAgentsRequest, SearchAgentsResponse, Agent> context, ApiFuture<SearchAgentsResponse> futureResponse) {
            ApiFuture<SearchAgentsPage> futurePage = SearchAgentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<SearchAgentsPage, SearchAgentsPagedResponse>(){

                public SearchAgentsPagedResponse apply(SearchAgentsPage input) {
                    return new SearchAgentsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private SearchAgentsPagedResponse(SearchAgentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchAgentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

