/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.AgentName;
import com.google.cloud.dialogflow.v2beta1.CreateVersionRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteVersionRequest;
import com.google.cloud.dialogflow.v2beta1.GetVersionRequest;
import com.google.cloud.dialogflow.v2beta1.ListVersionsRequest;
import com.google.cloud.dialogflow.v2beta1.ListVersionsResponse;
import com.google.cloud.dialogflow.v2beta1.UpdateVersionRequest;
import com.google.cloud.dialogflow.v2beta1.Version;
import com.google.cloud.dialogflow.v2beta1.VersionName;
import com.google.cloud.dialogflow.v2beta1.VersionsSettings;
import com.google.cloud.dialogflow.v2beta1.stub.VersionsStub;
import com.google.cloud.dialogflow.v2beta1.stub.VersionsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class VersionsClient
implements BackgroundResource {
    private final VersionsSettings settings;
    private final VersionsStub stub;

    public static final VersionsClient create() throws IOException {
        return VersionsClient.create(VersionsSettings.newBuilder().build());
    }

    public static final VersionsClient create(VersionsSettings settings) throws IOException {
        return new VersionsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final VersionsClient create(VersionsStub stub) {
        return new VersionsClient(stub);
    }

    protected VersionsClient(VersionsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VersionsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected VersionsClient(VersionsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final VersionsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public VersionsStub getStub() {
        return this.stub;
    }

    public final ListVersionsPagedResponse listVersions(AgentName parent) {
        ListVersionsRequest request = ListVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVersions(request);
    }

    public final ListVersionsPagedResponse listVersions(String parent) {
        ListVersionsRequest request = ListVersionsRequest.newBuilder().setParent(parent).build();
        return this.listVersions(request);
    }

    public final ListVersionsPagedResponse listVersions(ListVersionsRequest request) {
        return (ListVersionsPagedResponse)((Object)this.listVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVersionsRequest, ListVersionsPagedResponse> listVersionsPagedCallable() {
        return this.stub.listVersionsPagedCallable();
    }

    public final UnaryCallable<ListVersionsRequest, ListVersionsResponse> listVersionsCallable() {
        return this.stub.listVersionsCallable();
    }

    public final Version getVersion(VersionName name) {
        GetVersionRequest request = GetVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVersion(request);
    }

    public final Version getVersion(String name) {
        GetVersionRequest request = GetVersionRequest.newBuilder().setName(name).build();
        return this.getVersion(request);
    }

    public final Version getVersion(GetVersionRequest request) {
        return (Version)this.getVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetVersionRequest, Version> getVersionCallable() {
        return this.stub.getVersionCallable();
    }

    public final Version createVersion(AgentName parent, Version version) {
        CreateVersionRequest request = CreateVersionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setVersion(version).build();
        return this.createVersion(request);
    }

    public final Version createVersion(String parent, Version version) {
        CreateVersionRequest request = CreateVersionRequest.newBuilder().setParent(parent).setVersion(version).build();
        return this.createVersion(request);
    }

    public final Version createVersion(CreateVersionRequest request) {
        return (Version)this.createVersionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateVersionRequest, Version> createVersionCallable() {
        return this.stub.createVersionCallable();
    }

    public final Version updateVersion(Version version, FieldMask updateMask) {
        UpdateVersionRequest request = UpdateVersionRequest.newBuilder().setVersion(version).setUpdateMask(updateMask).build();
        return this.updateVersion(request);
    }

    public final Version updateVersion(UpdateVersionRequest request) {
        return (Version)this.updateVersionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateVersionRequest, Version> updateVersionCallable() {
        return this.stub.updateVersionCallable();
    }

    public final void deleteVersion(VersionName name) {
        DeleteVersionRequest request = DeleteVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteVersion(request);
    }

    public final void deleteVersion(String name) {
        DeleteVersionRequest request = DeleteVersionRequest.newBuilder().setName(name).build();
        this.deleteVersion(request);
    }

    public final void deleteVersion(DeleteVersionRequest request) {
        this.deleteVersionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteVersionRequest, Empty> deleteVersionCallable() {
        return this.stub.deleteVersionCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVersionsRequest, ListVersionsResponse, Version, ListVersionsPage, ListVersionsFixedSizeCollection> {
        private ListVersionsFixedSizeCollection(List<ListVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVersionsFixedSizeCollection createEmptyCollection() {
            return new ListVersionsFixedSizeCollection(null, 0);
        }

        protected ListVersionsFixedSizeCollection createCollection(List<ListVersionsPage> pages, int collectionSize) {
            return new ListVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVersionsPage
    extends AbstractPage<ListVersionsRequest, ListVersionsResponse, Version, ListVersionsPage> {
        private ListVersionsPage(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ListVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListVersionsPage createEmptyPage() {
            return new ListVersionsPage(null, null);
        }

        protected ListVersionsPage createPage(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ListVersionsResponse response) {
            return new ListVersionsPage(context, response);
        }

        public ApiFuture<ListVersionsPage> createPageAsync(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ApiFuture<ListVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVersionsPagedResponse
    extends AbstractPagedListResponse<ListVersionsRequest, ListVersionsResponse, Version, ListVersionsPage, ListVersionsFixedSizeCollection> {
        public static ApiFuture<ListVersionsPagedResponse> createAsync(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ApiFuture<ListVersionsResponse> futureResponse) {
            ApiFuture<ListVersionsPage> futurePage = ListVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListVersionsPage, ListVersionsPagedResponse>(){

                public ListVersionsPagedResponse apply(ListVersionsPage input) {
                    return new ListVersionsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListVersionsPagedResponse(ListVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVersionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

