/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.BatchDeleteIntentsRequest;
import com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest;
import com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsResponse;
import com.google.cloud.dialogflow.v2beta1.CreateIntentRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteIntentRequest;
import com.google.cloud.dialogflow.v2beta1.GetIntentRequest;
import com.google.cloud.dialogflow.v2beta1.Intent;
import com.google.cloud.dialogflow.v2beta1.IntentName;
import com.google.cloud.dialogflow.v2beta1.IntentsSettings;
import com.google.cloud.dialogflow.v2beta1.ListIntentsRequest;
import com.google.cloud.dialogflow.v2beta1.ListIntentsResponse;
import com.google.cloud.dialogflow.v2beta1.ProjectAgentName;
import com.google.cloud.dialogflow.v2beta1.ProjectName;
import com.google.cloud.dialogflow.v2beta1.UpdateIntentRequest;
import com.google.cloud.dialogflow.v2beta1.stub.IntentsStub;
import com.google.cloud.dialogflow.v2beta1.stub.IntentsStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class IntentsClient
implements BackgroundResource {
    private final IntentsSettings settings;
    private final IntentsStub stub;
    private final OperationsClient operationsClient;

    public static final IntentsClient create() throws IOException {
        return IntentsClient.create(IntentsSettings.newBuilder().build());
    }

    public static final IntentsClient create(IntentsSettings settings) throws IOException {
        return new IntentsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final IntentsClient create(IntentsStub stub) {
        return new IntentsClient(stub);
    }

    protected IntentsClient(IntentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((IntentsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected IntentsClient(IntentsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final IntentsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public IntentsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListIntentsPagedResponse listIntents(ProjectAgentName parent) {
        ListIntentsRequest request = ListIntentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listIntents(request);
    }

    public final ListIntentsPagedResponse listIntents(String parent) {
        ListIntentsRequest request = ListIntentsRequest.newBuilder().setParent(parent).build();
        return this.listIntents(request);
    }

    public final ListIntentsPagedResponse listIntents(ProjectAgentName parent, String languageCode) {
        ListIntentsRequest request = ListIntentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setLanguageCode(languageCode).build();
        return this.listIntents(request);
    }

    public final ListIntentsPagedResponse listIntents(String parent, String languageCode) {
        ListIntentsRequest request = ListIntentsRequest.newBuilder().setParent(parent).setLanguageCode(languageCode).build();
        return this.listIntents(request);
    }

    public final ListIntentsPagedResponse listIntents(ListIntentsRequest request) {
        return (ListIntentsPagedResponse)((Object)this.listIntentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListIntentsRequest, ListIntentsPagedResponse> listIntentsPagedCallable() {
        return this.stub.listIntentsPagedCallable();
    }

    public final UnaryCallable<ListIntentsRequest, ListIntentsResponse> listIntentsCallable() {
        return this.stub.listIntentsCallable();
    }

    public final Intent getIntent(IntentName name) {
        GetIntentRequest request = GetIntentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getIntent(request);
    }

    public final Intent getIntent(String name) {
        GetIntentRequest request = GetIntentRequest.newBuilder().setName(name).build();
        return this.getIntent(request);
    }

    public final Intent getIntent(IntentName name, String languageCode) {
        GetIntentRequest request = GetIntentRequest.newBuilder().setName(name == null ? null : name.toString()).setLanguageCode(languageCode).build();
        return this.getIntent(request);
    }

    public final Intent getIntent(String name, String languageCode) {
        GetIntentRequest request = GetIntentRequest.newBuilder().setName(name).setLanguageCode(languageCode).build();
        return this.getIntent(request);
    }

    public final Intent getIntent(GetIntentRequest request) {
        return (Intent)this.getIntentCallable().call((Object)request);
    }

    public final UnaryCallable<GetIntentRequest, Intent> getIntentCallable() {
        return this.stub.getIntentCallable();
    }

    public final Intent createIntent(ProjectAgentName parent, Intent intent) {
        CreateIntentRequest request = CreateIntentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setIntent(intent).build();
        return this.createIntent(request);
    }

    public final Intent createIntent(String parent, Intent intent) {
        CreateIntentRequest request = CreateIntentRequest.newBuilder().setParent(parent).setIntent(intent).build();
        return this.createIntent(request);
    }

    public final Intent createIntent(ProjectAgentName parent, Intent intent, String languageCode) {
        CreateIntentRequest request = CreateIntentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setIntent(intent).setLanguageCode(languageCode).build();
        return this.createIntent(request);
    }

    public final Intent createIntent(String parent, Intent intent, String languageCode) {
        CreateIntentRequest request = CreateIntentRequest.newBuilder().setParent(parent).setIntent(intent).setLanguageCode(languageCode).build();
        return this.createIntent(request);
    }

    public final Intent createIntent(CreateIntentRequest request) {
        return (Intent)this.createIntentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateIntentRequest, Intent> createIntentCallable() {
        return this.stub.createIntentCallable();
    }

    public final Intent updateIntent(Intent intent, String languageCode) {
        UpdateIntentRequest request = UpdateIntentRequest.newBuilder().setIntent(intent).setLanguageCode(languageCode).build();
        return this.updateIntent(request);
    }

    public final Intent updateIntent(Intent intent, String languageCode, FieldMask updateMask) {
        UpdateIntentRequest request = UpdateIntentRequest.newBuilder().setIntent(intent).setLanguageCode(languageCode).setUpdateMask(updateMask).build();
        return this.updateIntent(request);
    }

    public final Intent updateIntent(UpdateIntentRequest request) {
        return (Intent)this.updateIntentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateIntentRequest, Intent> updateIntentCallable() {
        return this.stub.updateIntentCallable();
    }

    public final void deleteIntent(IntentName name) {
        DeleteIntentRequest request = DeleteIntentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteIntent(request);
    }

    public final void deleteIntent(String name) {
        DeleteIntentRequest request = DeleteIntentRequest.newBuilder().setName(name).build();
        this.deleteIntent(request);
    }

    private final void deleteIntent(DeleteIntentRequest request) {
        this.deleteIntentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteIntentRequest, Empty> deleteIntentCallable() {
        return this.stub.deleteIntentCallable();
    }

    public final OperationFuture<BatchUpdateIntentsResponse, Struct> batchUpdateIntentsAsync(BatchUpdateIntentsRequest request) {
        return this.batchUpdateIntentsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchUpdateIntentsRequest, BatchUpdateIntentsResponse, Struct> batchUpdateIntentsOperationCallable() {
        return this.stub.batchUpdateIntentsOperationCallable();
    }

    public final UnaryCallable<BatchUpdateIntentsRequest, Operation> batchUpdateIntentsCallable() {
        return this.stub.batchUpdateIntentsCallable();
    }

    public final OperationFuture<Empty, Struct> batchDeleteIntentsAsync(ProjectName parent, List<Intent> intents) {
        BatchDeleteIntentsRequest request = BatchDeleteIntentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllIntents(intents).build();
        return this.batchDeleteIntentsAsync(request);
    }

    public final OperationFuture<Empty, Struct> batchDeleteIntentsAsync(String parent, List<Intent> intents) {
        BatchDeleteIntentsRequest request = BatchDeleteIntentsRequest.newBuilder().setParent(parent).addAllIntents(intents).build();
        return this.batchDeleteIntentsAsync(request);
    }

    public final OperationFuture<Empty, Struct> batchDeleteIntentsAsync(BatchDeleteIntentsRequest request) {
        return this.batchDeleteIntentsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchDeleteIntentsRequest, Empty, Struct> batchDeleteIntentsOperationCallable() {
        return this.stub.batchDeleteIntentsOperationCallable();
    }

    public final UnaryCallable<BatchDeleteIntentsRequest, Operation> batchDeleteIntentsCallable() {
        return this.stub.batchDeleteIntentsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListIntentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListIntentsRequest, ListIntentsResponse, Intent, ListIntentsPage, ListIntentsFixedSizeCollection> {
        private ListIntentsFixedSizeCollection(List<ListIntentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListIntentsFixedSizeCollection createEmptyCollection() {
            return new ListIntentsFixedSizeCollection(null, 0);
        }

        protected ListIntentsFixedSizeCollection createCollection(List<ListIntentsPage> pages, int collectionSize) {
            return new ListIntentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListIntentsPage
    extends AbstractPage<ListIntentsRequest, ListIntentsResponse, Intent, ListIntentsPage> {
        private ListIntentsPage(PageContext<ListIntentsRequest, ListIntentsResponse, Intent> context, ListIntentsResponse response) {
            super(context, (Object)response);
        }

        private static ListIntentsPage createEmptyPage() {
            return new ListIntentsPage(null, null);
        }

        protected ListIntentsPage createPage(PageContext<ListIntentsRequest, ListIntentsResponse, Intent> context, ListIntentsResponse response) {
            return new ListIntentsPage(context, response);
        }

        public ApiFuture<ListIntentsPage> createPageAsync(PageContext<ListIntentsRequest, ListIntentsResponse, Intent> context, ApiFuture<ListIntentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListIntentsPagedResponse
    extends AbstractPagedListResponse<ListIntentsRequest, ListIntentsResponse, Intent, ListIntentsPage, ListIntentsFixedSizeCollection> {
        public static ApiFuture<ListIntentsPagedResponse> createAsync(PageContext<ListIntentsRequest, ListIntentsResponse, Intent> context, ApiFuture<ListIntentsResponse> futureResponse) {
            ApiFuture<ListIntentsPage> futurePage = ListIntentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListIntentsPage, ListIntentsPagedResponse>(){

                public ListIntentsPagedResponse apply(ListIntentsPage input) {
                    return new ListIntentsPagedResponse(input);
                }
            });
        }

        private ListIntentsPagedResponse(ListIntentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListIntentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

