/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreateSecuritySettingsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteSecuritySettingsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetSecuritySettingsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListSecuritySettingsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListSecuritySettingsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.SecuritySettings;
import com.google.cloud.dialogflow.cx.v3beta1.SecuritySettingsServiceClient;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateSecuritySettingsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GrpcSecuritySettingsServiceStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.SecuritySettingsServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SecuritySettingsServiceStubSettings
extends StubSettings<SecuritySettingsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final UnaryCallSettings<CreateSecuritySettingsRequest, SecuritySettings> createSecuritySettingsSettings;
    private final UnaryCallSettings<GetSecuritySettingsRequest, SecuritySettings> getSecuritySettingsSettings;
    private final UnaryCallSettings<UpdateSecuritySettingsRequest, SecuritySettings> updateSecuritySettingsSettings;
    private final PagedCallSettings<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettingsServiceClient.ListSecuritySettingsPagedResponse> listSecuritySettingsSettings;
    private final UnaryCallSettings<DeleteSecuritySettingsRequest, Empty> deleteSecuritySettingsSettings;
    private static final PagedListDescriptor<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettings> LIST_SECURITY_SETTINGS_PAGE_STR_DESC = new PagedListDescriptor<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettings>(){

        public String emptyToken() {
            return "";
        }

        public ListSecuritySettingsRequest injectToken(ListSecuritySettingsRequest payload, String token) {
            return ListSecuritySettingsRequest.newBuilder((ListSecuritySettingsRequest)payload).setPageToken(token).build();
        }

        public ListSecuritySettingsRequest injectPageSize(ListSecuritySettingsRequest payload, int pageSize) {
            return ListSecuritySettingsRequest.newBuilder((ListSecuritySettingsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSecuritySettingsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSecuritySettingsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SecuritySettings> extractResources(ListSecuritySettingsResponse payload) {
            return payload.getSecuritySettingsList() == null ? ImmutableList.of() : payload.getSecuritySettingsList();
        }
    };
    private static final PagedListResponseFactory<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettingsServiceClient.ListSecuritySettingsPagedResponse> LIST_SECURITY_SETTINGS_PAGE_STR_FACT = new PagedListResponseFactory<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettingsServiceClient.ListSecuritySettingsPagedResponse>(){

        public ApiFuture<SecuritySettingsServiceClient.ListSecuritySettingsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSecuritySettingsRequest, ListSecuritySettingsResponse> callable, ListSecuritySettingsRequest request, ApiCallContext context, ApiFuture<ListSecuritySettingsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SECURITY_SETTINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecuritySettingsServiceClient.ListSecuritySettingsPagedResponse.createAsync((PageContext<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettings>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSecuritySettingsRequest, SecuritySettings> createSecuritySettingsSettings() {
        return this.createSecuritySettingsSettings;
    }

    public UnaryCallSettings<GetSecuritySettingsRequest, SecuritySettings> getSecuritySettingsSettings() {
        return this.getSecuritySettingsSettings;
    }

    public UnaryCallSettings<UpdateSecuritySettingsRequest, SecuritySettings> updateSecuritySettingsSettings() {
        return this.updateSecuritySettingsSettings;
    }

    public PagedCallSettings<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettingsServiceClient.ListSecuritySettingsPagedResponse> listSecuritySettingsSettings() {
        return this.listSecuritySettingsSettings;
    }

    public UnaryCallSettings<DeleteSecuritySettingsRequest, Empty> deleteSecuritySettingsSettings() {
        return this.deleteSecuritySettingsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SecuritySettingsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSecuritySettingsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SecuritySettingsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SecuritySettingsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SecuritySettingsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSecuritySettingsSettings = settingsBuilder.createSecuritySettingsSettings().build();
        this.getSecuritySettingsSettings = settingsBuilder.getSecuritySettingsSettings().build();
        this.updateSecuritySettingsSettings = settingsBuilder.updateSecuritySettingsSettings().build();
        this.listSecuritySettingsSettings = settingsBuilder.listSecuritySettingsSettings().build();
        this.deleteSecuritySettingsSettings = settingsBuilder.deleteSecuritySettingsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SecuritySettingsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSecuritySettingsRequest, SecuritySettings> createSecuritySettingsSettings;
        private final UnaryCallSettings.Builder<GetSecuritySettingsRequest, SecuritySettings> getSecuritySettingsSettings;
        private final UnaryCallSettings.Builder<UpdateSecuritySettingsRequest, SecuritySettings> updateSecuritySettingsSettings;
        private final PagedCallSettings.Builder<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettingsServiceClient.ListSecuritySettingsPagedResponse> listSecuritySettingsSettings;
        private final UnaryCallSettings.Builder<DeleteSecuritySettingsRequest, Empty> deleteSecuritySettingsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSecuritySettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSecuritySettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSecuritySettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSecuritySettingsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SECURITY_SETTINGS_PAGE_STR_FACT);
            this.deleteSecuritySettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSecuritySettingsSettings, this.getSecuritySettingsSettings, this.updateSecuritySettingsSettings, this.listSecuritySettingsSettings, this.deleteSecuritySettingsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SecuritySettingsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createSecuritySettingsSettings = settings.createSecuritySettingsSettings.toBuilder();
            this.getSecuritySettingsSettings = settings.getSecuritySettingsSettings.toBuilder();
            this.updateSecuritySettingsSettings = settings.updateSecuritySettingsSettings.toBuilder();
            this.listSecuritySettingsSettings = settings.listSecuritySettingsSettings.toBuilder();
            this.deleteSecuritySettingsSettings = settings.deleteSecuritySettingsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSecuritySettingsSettings, this.getSecuritySettingsSettings, this.updateSecuritySettingsSettings, this.listSecuritySettingsSettings, this.deleteSecuritySettingsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SecuritySettingsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SecuritySettingsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SecuritySettingsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SecuritySettingsServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(SecuritySettingsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSecuritySettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSecuritySettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateSecuritySettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSecuritySettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSecuritySettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSecuritySettingsRequest, SecuritySettings> createSecuritySettingsSettings() {
            return this.createSecuritySettingsSettings;
        }

        public UnaryCallSettings.Builder<GetSecuritySettingsRequest, SecuritySettings> getSecuritySettingsSettings() {
            return this.getSecuritySettingsSettings;
        }

        public UnaryCallSettings.Builder<UpdateSecuritySettingsRequest, SecuritySettings> updateSecuritySettingsSettings() {
            return this.updateSecuritySettingsSettings;
        }

        public PagedCallSettings.Builder<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettingsServiceClient.ListSecuritySettingsPagedResponse> listSecuritySettingsSettings() {
            return this.listSecuritySettingsSettings;
        }

        public UnaryCallSettings.Builder<DeleteSecuritySettingsRequest, Empty> deleteSecuritySettingsSettings() {
            return this.deleteSecuritySettingsSettings;
        }

        public SecuritySettingsServiceStubSettings build() throws IOException {
            return new SecuritySettingsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

