/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.AgentName;
import com.google.cloud.dialogflow.cx.v3beta1.CreatePlaybookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.CreatePlaybookVersionRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeletePlaybookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeletePlaybookVersionRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetPlaybookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetPlaybookVersionRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListPlaybookVersionsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListPlaybookVersionsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.ListPlaybooksRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListPlaybooksResponse;
import com.google.cloud.dialogflow.cx.v3beta1.Playbook;
import com.google.cloud.dialogflow.cx.v3beta1.PlaybookName;
import com.google.cloud.dialogflow.cx.v3beta1.PlaybookVersion;
import com.google.cloud.dialogflow.cx.v3beta1.PlaybookVersionName;
import com.google.cloud.dialogflow.cx.v3beta1.PlaybooksSettings;
import com.google.cloud.dialogflow.cx.v3beta1.UpdatePlaybookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.PlaybooksStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.PlaybooksStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PlaybooksClient
implements BackgroundResource {
    private final PlaybooksSettings settings;
    private final PlaybooksStub stub;

    public static final PlaybooksClient create() throws IOException {
        return PlaybooksClient.create(PlaybooksSettings.newBuilder().build());
    }

    public static final PlaybooksClient create(PlaybooksSettings settings) throws IOException {
        return new PlaybooksClient(settings);
    }

    public static final PlaybooksClient create(PlaybooksStub stub) {
        return new PlaybooksClient(stub);
    }

    protected PlaybooksClient(PlaybooksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PlaybooksStubSettings)settings.getStubSettings()).createStub();
    }

    protected PlaybooksClient(PlaybooksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PlaybooksSettings getSettings() {
        return this.settings;
    }

    public PlaybooksStub getStub() {
        return this.stub;
    }

    public final Playbook createPlaybook(AgentName parent, Playbook playbook) {
        CreatePlaybookRequest request = CreatePlaybookRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPlaybook(playbook).build();
        return this.createPlaybook(request);
    }

    public final Playbook createPlaybook(String parent, Playbook playbook) {
        CreatePlaybookRequest request = CreatePlaybookRequest.newBuilder().setParent(parent).setPlaybook(playbook).build();
        return this.createPlaybook(request);
    }

    public final Playbook createPlaybook(CreatePlaybookRequest request) {
        return (Playbook)this.createPlaybookCallable().call((Object)request);
    }

    public final UnaryCallable<CreatePlaybookRequest, Playbook> createPlaybookCallable() {
        return this.stub.createPlaybookCallable();
    }

    public final void deletePlaybook(PlaybookName name) {
        DeletePlaybookRequest request = DeletePlaybookRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deletePlaybook(request);
    }

    public final void deletePlaybook(String name) {
        DeletePlaybookRequest request = DeletePlaybookRequest.newBuilder().setName(name).build();
        this.deletePlaybook(request);
    }

    public final void deletePlaybook(DeletePlaybookRequest request) {
        this.deletePlaybookCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePlaybookRequest, Empty> deletePlaybookCallable() {
        return this.stub.deletePlaybookCallable();
    }

    public final ListPlaybooksPagedResponse listPlaybooks(AgentName parent) {
        ListPlaybooksRequest request = ListPlaybooksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPlaybooks(request);
    }

    public final ListPlaybooksPagedResponse listPlaybooks(String parent) {
        ListPlaybooksRequest request = ListPlaybooksRequest.newBuilder().setParent(parent).build();
        return this.listPlaybooks(request);
    }

    public final ListPlaybooksPagedResponse listPlaybooks(ListPlaybooksRequest request) {
        return (ListPlaybooksPagedResponse)((Object)this.listPlaybooksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPlaybooksRequest, ListPlaybooksPagedResponse> listPlaybooksPagedCallable() {
        return this.stub.listPlaybooksPagedCallable();
    }

    public final UnaryCallable<ListPlaybooksRequest, ListPlaybooksResponse> listPlaybooksCallable() {
        return this.stub.listPlaybooksCallable();
    }

    public final Playbook getPlaybook(PlaybookName name) {
        GetPlaybookRequest request = GetPlaybookRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPlaybook(request);
    }

    public final Playbook getPlaybook(String name) {
        GetPlaybookRequest request = GetPlaybookRequest.newBuilder().setName(name).build();
        return this.getPlaybook(request);
    }

    public final Playbook getPlaybook(GetPlaybookRequest request) {
        return (Playbook)this.getPlaybookCallable().call((Object)request);
    }

    public final UnaryCallable<GetPlaybookRequest, Playbook> getPlaybookCallable() {
        return this.stub.getPlaybookCallable();
    }

    public final Playbook updatePlaybook(Playbook playbook, FieldMask updateMask) {
        UpdatePlaybookRequest request = UpdatePlaybookRequest.newBuilder().setPlaybook(playbook).setUpdateMask(updateMask).build();
        return this.updatePlaybook(request);
    }

    public final Playbook updatePlaybook(UpdatePlaybookRequest request) {
        return (Playbook)this.updatePlaybookCallable().call((Object)request);
    }

    public final UnaryCallable<UpdatePlaybookRequest, Playbook> updatePlaybookCallable() {
        return this.stub.updatePlaybookCallable();
    }

    public final PlaybookVersion createPlaybookVersion(PlaybookName parent, PlaybookVersion playbookVersion) {
        CreatePlaybookVersionRequest request = CreatePlaybookVersionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPlaybookVersion(playbookVersion).build();
        return this.createPlaybookVersion(request);
    }

    public final PlaybookVersion createPlaybookVersion(String parent, PlaybookVersion playbookVersion) {
        CreatePlaybookVersionRequest request = CreatePlaybookVersionRequest.newBuilder().setParent(parent).setPlaybookVersion(playbookVersion).build();
        return this.createPlaybookVersion(request);
    }

    public final PlaybookVersion createPlaybookVersion(CreatePlaybookVersionRequest request) {
        return (PlaybookVersion)this.createPlaybookVersionCallable().call((Object)request);
    }

    public final UnaryCallable<CreatePlaybookVersionRequest, PlaybookVersion> createPlaybookVersionCallable() {
        return this.stub.createPlaybookVersionCallable();
    }

    public final PlaybookVersion getPlaybookVersion(PlaybookVersionName name) {
        GetPlaybookVersionRequest request = GetPlaybookVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPlaybookVersion(request);
    }

    public final PlaybookVersion getPlaybookVersion(String name) {
        GetPlaybookVersionRequest request = GetPlaybookVersionRequest.newBuilder().setName(name).build();
        return this.getPlaybookVersion(request);
    }

    public final PlaybookVersion getPlaybookVersion(GetPlaybookVersionRequest request) {
        return (PlaybookVersion)this.getPlaybookVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetPlaybookVersionRequest, PlaybookVersion> getPlaybookVersionCallable() {
        return this.stub.getPlaybookVersionCallable();
    }

    public final ListPlaybookVersionsPagedResponse listPlaybookVersions(PlaybookName parent) {
        ListPlaybookVersionsRequest request = ListPlaybookVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPlaybookVersions(request);
    }

    public final ListPlaybookVersionsPagedResponse listPlaybookVersions(String parent) {
        ListPlaybookVersionsRequest request = ListPlaybookVersionsRequest.newBuilder().setParent(parent).build();
        return this.listPlaybookVersions(request);
    }

    public final ListPlaybookVersionsPagedResponse listPlaybookVersions(ListPlaybookVersionsRequest request) {
        return (ListPlaybookVersionsPagedResponse)((Object)this.listPlaybookVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPlaybookVersionsRequest, ListPlaybookVersionsPagedResponse> listPlaybookVersionsPagedCallable() {
        return this.stub.listPlaybookVersionsPagedCallable();
    }

    public final UnaryCallable<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse> listPlaybookVersionsCallable() {
        return this.stub.listPlaybookVersionsCallable();
    }

    public final void deletePlaybookVersion(PlaybookVersionName name) {
        DeletePlaybookVersionRequest request = DeletePlaybookVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deletePlaybookVersion(request);
    }

    public final void deletePlaybookVersion(String name) {
        DeletePlaybookVersionRequest request = DeletePlaybookVersionRequest.newBuilder().setName(name).build();
        this.deletePlaybookVersion(request);
    }

    public final void deletePlaybookVersion(DeletePlaybookVersionRequest request) {
        this.deletePlaybookVersionCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePlaybookVersionRequest, Empty> deletePlaybookVersionCallable() {
        return this.stub.deletePlaybookVersionCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPlaybookVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybookVersion, ListPlaybookVersionsPage, ListPlaybookVersionsFixedSizeCollection> {
        private ListPlaybookVersionsFixedSizeCollection(List<ListPlaybookVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPlaybookVersionsFixedSizeCollection createEmptyCollection() {
            return new ListPlaybookVersionsFixedSizeCollection(null, 0);
        }

        protected ListPlaybookVersionsFixedSizeCollection createCollection(List<ListPlaybookVersionsPage> pages, int collectionSize) {
            return new ListPlaybookVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPlaybookVersionsPage
    extends AbstractPage<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybookVersion, ListPlaybookVersionsPage> {
        private ListPlaybookVersionsPage(PageContext<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybookVersion> context, ListPlaybookVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListPlaybookVersionsPage createEmptyPage() {
            return new ListPlaybookVersionsPage(null, null);
        }

        protected ListPlaybookVersionsPage createPage(PageContext<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybookVersion> context, ListPlaybookVersionsResponse response) {
            return new ListPlaybookVersionsPage(context, response);
        }

        public ApiFuture<ListPlaybookVersionsPage> createPageAsync(PageContext<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybookVersion> context, ApiFuture<ListPlaybookVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPlaybookVersionsPagedResponse
    extends AbstractPagedListResponse<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybookVersion, ListPlaybookVersionsPage, ListPlaybookVersionsFixedSizeCollection> {
        public static ApiFuture<ListPlaybookVersionsPagedResponse> createAsync(PageContext<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybookVersion> context, ApiFuture<ListPlaybookVersionsResponse> futureResponse) {
            ApiFuture<ListPlaybookVersionsPage> futurePage = ListPlaybookVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPlaybookVersionsPagedResponse((ListPlaybookVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPlaybookVersionsPagedResponse(ListPlaybookVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPlaybookVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPlaybooksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPlaybooksRequest, ListPlaybooksResponse, Playbook, ListPlaybooksPage, ListPlaybooksFixedSizeCollection> {
        private ListPlaybooksFixedSizeCollection(List<ListPlaybooksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPlaybooksFixedSizeCollection createEmptyCollection() {
            return new ListPlaybooksFixedSizeCollection(null, 0);
        }

        protected ListPlaybooksFixedSizeCollection createCollection(List<ListPlaybooksPage> pages, int collectionSize) {
            return new ListPlaybooksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPlaybooksPage
    extends AbstractPage<ListPlaybooksRequest, ListPlaybooksResponse, Playbook, ListPlaybooksPage> {
        private ListPlaybooksPage(PageContext<ListPlaybooksRequest, ListPlaybooksResponse, Playbook> context, ListPlaybooksResponse response) {
            super(context, (Object)response);
        }

        private static ListPlaybooksPage createEmptyPage() {
            return new ListPlaybooksPage(null, null);
        }

        protected ListPlaybooksPage createPage(PageContext<ListPlaybooksRequest, ListPlaybooksResponse, Playbook> context, ListPlaybooksResponse response) {
            return new ListPlaybooksPage(context, response);
        }

        public ApiFuture<ListPlaybooksPage> createPageAsync(PageContext<ListPlaybooksRequest, ListPlaybooksResponse, Playbook> context, ApiFuture<ListPlaybooksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPlaybooksPagedResponse
    extends AbstractPagedListResponse<ListPlaybooksRequest, ListPlaybooksResponse, Playbook, ListPlaybooksPage, ListPlaybooksFixedSizeCollection> {
        public static ApiFuture<ListPlaybooksPagedResponse> createAsync(PageContext<ListPlaybooksRequest, ListPlaybooksResponse, Playbook> context, ApiFuture<ListPlaybooksResponse> futureResponse) {
            ApiFuture<ListPlaybooksPage> futurePage = ListPlaybooksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPlaybooksPagedResponse((ListPlaybooksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPlaybooksPagedResponse(ListPlaybooksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPlaybooksFixedSizeCollection.createEmptyCollection());
        }
    }
}

