/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.CreateSecuritySettingsRequest;
import com.google.cloud.dialogflow.cx.v3.DeleteSecuritySettingsRequest;
import com.google.cloud.dialogflow.cx.v3.GetSecuritySettingsRequest;
import com.google.cloud.dialogflow.cx.v3.ListSecuritySettingsRequest;
import com.google.cloud.dialogflow.cx.v3.ListSecuritySettingsResponse;
import com.google.cloud.dialogflow.cx.v3.LocationName;
import com.google.cloud.dialogflow.cx.v3.SecuritySettings;
import com.google.cloud.dialogflow.cx.v3.SecuritySettingsName;
import com.google.cloud.dialogflow.cx.v3.SecuritySettingsServiceSettings;
import com.google.cloud.dialogflow.cx.v3.UpdateSecuritySettingsRequest;
import com.google.cloud.dialogflow.cx.v3.stub.SecuritySettingsServiceStub;
import com.google.cloud.dialogflow.cx.v3.stub.SecuritySettingsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SecuritySettingsServiceClient
implements BackgroundResource {
    private final SecuritySettingsServiceSettings settings;
    private final SecuritySettingsServiceStub stub;

    public static final SecuritySettingsServiceClient create() throws IOException {
        return SecuritySettingsServiceClient.create(SecuritySettingsServiceSettings.newBuilder().build());
    }

    public static final SecuritySettingsServiceClient create(SecuritySettingsServiceSettings settings) throws IOException {
        return new SecuritySettingsServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SecuritySettingsServiceClient create(SecuritySettingsServiceStub stub) {
        return new SecuritySettingsServiceClient(stub);
    }

    protected SecuritySettingsServiceClient(SecuritySettingsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SecuritySettingsServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SecuritySettingsServiceClient(SecuritySettingsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SecuritySettingsServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SecuritySettingsServiceStub getStub() {
        return this.stub;
    }

    public final SecuritySettings createSecuritySettings(LocationName parent, SecuritySettings securitySettings) {
        CreateSecuritySettingsRequest request = CreateSecuritySettingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSecuritySettings(securitySettings).build();
        return this.createSecuritySettings(request);
    }

    public final SecuritySettings createSecuritySettings(String parent, SecuritySettings securitySettings) {
        CreateSecuritySettingsRequest request = CreateSecuritySettingsRequest.newBuilder().setParent(parent).setSecuritySettings(securitySettings).build();
        return this.createSecuritySettings(request);
    }

    public final SecuritySettings createSecuritySettings(CreateSecuritySettingsRequest request) {
        return (SecuritySettings)this.createSecuritySettingsCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSecuritySettingsRequest, SecuritySettings> createSecuritySettingsCallable() {
        return this.stub.createSecuritySettingsCallable();
    }

    public final SecuritySettings getSecuritySettings(SecuritySettingsName name) {
        GetSecuritySettingsRequest request = GetSecuritySettingsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSecuritySettings(request);
    }

    public final SecuritySettings getSecuritySettings(String name) {
        GetSecuritySettingsRequest request = GetSecuritySettingsRequest.newBuilder().setName(name).build();
        return this.getSecuritySettings(request);
    }

    public final SecuritySettings getSecuritySettings(GetSecuritySettingsRequest request) {
        return (SecuritySettings)this.getSecuritySettingsCallable().call((Object)request);
    }

    public final UnaryCallable<GetSecuritySettingsRequest, SecuritySettings> getSecuritySettingsCallable() {
        return this.stub.getSecuritySettingsCallable();
    }

    public final SecuritySettings updateSecuritySettings(SecuritySettings securitySettings, FieldMask updateMask) {
        UpdateSecuritySettingsRequest request = UpdateSecuritySettingsRequest.newBuilder().setSecuritySettings(securitySettings).setUpdateMask(updateMask).build();
        return this.updateSecuritySettings(request);
    }

    public final SecuritySettings updateSecuritySettings(UpdateSecuritySettingsRequest request) {
        return (SecuritySettings)this.updateSecuritySettingsCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSecuritySettingsRequest, SecuritySettings> updateSecuritySettingsCallable() {
        return this.stub.updateSecuritySettingsCallable();
    }

    public final ListSecuritySettingsPagedResponse listSecuritySettings(LocationName parent) {
        ListSecuritySettingsRequest request = ListSecuritySettingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSecuritySettings(request);
    }

    public final ListSecuritySettingsPagedResponse listSecuritySettings(String parent) {
        ListSecuritySettingsRequest request = ListSecuritySettingsRequest.newBuilder().setParent(parent).build();
        return this.listSecuritySettings(request);
    }

    public final ListSecuritySettingsPagedResponse listSecuritySettings(ListSecuritySettingsRequest request) {
        return (ListSecuritySettingsPagedResponse)((Object)this.listSecuritySettingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSecuritySettingsRequest, ListSecuritySettingsPagedResponse> listSecuritySettingsPagedCallable() {
        return this.stub.listSecuritySettingsPagedCallable();
    }

    public final UnaryCallable<ListSecuritySettingsRequest, ListSecuritySettingsResponse> listSecuritySettingsCallable() {
        return this.stub.listSecuritySettingsCallable();
    }

    public final void deleteSecuritySettings(SecuritySettingsName name) {
        DeleteSecuritySettingsRequest request = DeleteSecuritySettingsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSecuritySettings(request);
    }

    public final void deleteSecuritySettings(String name) {
        DeleteSecuritySettingsRequest request = DeleteSecuritySettingsRequest.newBuilder().setName(name).build();
        this.deleteSecuritySettings(request);
    }

    public final void deleteSecuritySettings(DeleteSecuritySettingsRequest request) {
        this.deleteSecuritySettingsCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSecuritySettingsRequest, Empty> deleteSecuritySettingsCallable() {
        return this.stub.deleteSecuritySettingsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSecuritySettingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettings, ListSecuritySettingsPage, ListSecuritySettingsFixedSizeCollection> {
        private ListSecuritySettingsFixedSizeCollection(List<ListSecuritySettingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSecuritySettingsFixedSizeCollection createEmptyCollection() {
            return new ListSecuritySettingsFixedSizeCollection(null, 0);
        }

        protected ListSecuritySettingsFixedSizeCollection createCollection(List<ListSecuritySettingsPage> pages, int collectionSize) {
            return new ListSecuritySettingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSecuritySettingsPage
    extends AbstractPage<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettings, ListSecuritySettingsPage> {
        private ListSecuritySettingsPage(PageContext<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettings> context, ListSecuritySettingsResponse response) {
            super(context, (Object)response);
        }

        private static ListSecuritySettingsPage createEmptyPage() {
            return new ListSecuritySettingsPage(null, null);
        }

        protected ListSecuritySettingsPage createPage(PageContext<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettings> context, ListSecuritySettingsResponse response) {
            return new ListSecuritySettingsPage(context, response);
        }

        public ApiFuture<ListSecuritySettingsPage> createPageAsync(PageContext<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettings> context, ApiFuture<ListSecuritySettingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSecuritySettingsPagedResponse
    extends AbstractPagedListResponse<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettings, ListSecuritySettingsPage, ListSecuritySettingsFixedSizeCollection> {
        public static ApiFuture<ListSecuritySettingsPagedResponse> createAsync(PageContext<ListSecuritySettingsRequest, ListSecuritySettingsResponse, SecuritySettings> context, ApiFuture<ListSecuritySettingsResponse> futureResponse) {
            ApiFuture<ListSecuritySettingsPage> futurePage = ListSecuritySettingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSecuritySettingsPage, ListSecuritySettingsPagedResponse>(){

                public ListSecuritySettingsPagedResponse apply(ListSecuritySettingsPage input) {
                    return new ListSecuritySettingsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListSecuritySettingsPagedResponse(ListSecuritySettingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSecuritySettingsFixedSizeCollection.createEmptyCollection());
        }
    }
}

