/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreateSessionEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteSessionEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetSessionEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListSessionEntityTypesRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListSessionEntityTypesResponse;
import com.google.cloud.dialogflow.cx.v3beta1.SessionEntityType;
import com.google.cloud.dialogflow.cx.v3beta1.SessionEntityTypesClient;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateSessionEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GrpcSessionEntityTypesStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.HttpJsonSessionEntityTypesStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.SessionEntityTypesStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SessionEntityTypesStubSettings
extends StubSettings<SessionEntityTypesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityTypesClient.ListSessionEntityTypesPagedResponse> listSessionEntityTypesSettings;
    private final UnaryCallSettings<GetSessionEntityTypeRequest, SessionEntityType> getSessionEntityTypeSettings;
    private final UnaryCallSettings<CreateSessionEntityTypeRequest, SessionEntityType> createSessionEntityTypeSettings;
    private final UnaryCallSettings<UpdateSessionEntityTypeRequest, SessionEntityType> updateSessionEntityTypeSettings;
    private final UnaryCallSettings<DeleteSessionEntityTypeRequest, Empty> deleteSessionEntityTypeSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, SessionEntityTypesClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityType> LIST_SESSION_ENTITY_TYPES_PAGE_STR_DESC = new PagedListDescriptor<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityType>(){

        public String emptyToken() {
            return "";
        }

        public ListSessionEntityTypesRequest injectToken(ListSessionEntityTypesRequest payload, String token) {
            return ListSessionEntityTypesRequest.newBuilder((ListSessionEntityTypesRequest)payload).setPageToken(token).build();
        }

        public ListSessionEntityTypesRequest injectPageSize(ListSessionEntityTypesRequest payload, int pageSize) {
            return ListSessionEntityTypesRequest.newBuilder((ListSessionEntityTypesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSessionEntityTypesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSessionEntityTypesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SessionEntityType> extractResources(ListSessionEntityTypesResponse payload) {
            return payload.getSessionEntityTypesList() == null ? ImmutableList.of() : payload.getSessionEntityTypesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityTypesClient.ListSessionEntityTypesPagedResponse> LIST_SESSION_ENTITY_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityTypesClient.ListSessionEntityTypesPagedResponse>(){

        public ApiFuture<SessionEntityTypesClient.ListSessionEntityTypesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse> callable, ListSessionEntityTypesRequest request, ApiCallContext context, ApiFuture<ListSessionEntityTypesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SESSION_ENTITY_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SessionEntityTypesClient.ListSessionEntityTypesPagedResponse.createAsync((PageContext<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityType>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, SessionEntityTypesClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, SessionEntityTypesClient.ListLocationsPagedResponse>(){

        public ApiFuture<SessionEntityTypesClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SessionEntityTypesClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityTypesClient.ListSessionEntityTypesPagedResponse> listSessionEntityTypesSettings() {
        return this.listSessionEntityTypesSettings;
    }

    public UnaryCallSettings<GetSessionEntityTypeRequest, SessionEntityType> getSessionEntityTypeSettings() {
        return this.getSessionEntityTypeSettings;
    }

    public UnaryCallSettings<CreateSessionEntityTypeRequest, SessionEntityType> createSessionEntityTypeSettings() {
        return this.createSessionEntityTypeSettings;
    }

    public UnaryCallSettings<UpdateSessionEntityTypeRequest, SessionEntityType> updateSessionEntityTypeSettings() {
        return this.updateSessionEntityTypeSettings;
    }

    public UnaryCallSettings<DeleteSessionEntityTypeRequest, Empty> deleteSessionEntityTypeSettings() {
        return this.deleteSessionEntityTypeSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, SessionEntityTypesClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public SessionEntityTypesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSessionEntityTypesStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSessionEntityTypesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SessionEntityTypesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SessionEntityTypesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SessionEntityTypesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SessionEntityTypesStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SessionEntityTypesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listSessionEntityTypesSettings = settingsBuilder.listSessionEntityTypesSettings().build();
        this.getSessionEntityTypeSettings = settingsBuilder.getSessionEntityTypeSettings().build();
        this.createSessionEntityTypeSettings = settingsBuilder.createSessionEntityTypeSettings().build();
        this.updateSessionEntityTypeSettings = settingsBuilder.updateSessionEntityTypeSettings().build();
        this.deleteSessionEntityTypeSettings = settingsBuilder.deleteSessionEntityTypeSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SessionEntityTypesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityTypesClient.ListSessionEntityTypesPagedResponse> listSessionEntityTypesSettings;
        private final UnaryCallSettings.Builder<GetSessionEntityTypeRequest, SessionEntityType> getSessionEntityTypeSettings;
        private final UnaryCallSettings.Builder<CreateSessionEntityTypeRequest, SessionEntityType> createSessionEntityTypeSettings;
        private final UnaryCallSettings.Builder<UpdateSessionEntityTypeRequest, SessionEntityType> updateSessionEntityTypeSettings;
        private final UnaryCallSettings.Builder<DeleteSessionEntityTypeRequest, Empty> deleteSessionEntityTypeSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, SessionEntityTypesClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listSessionEntityTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SESSION_ENTITY_TYPES_PAGE_STR_FACT);
            this.getSessionEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSessionEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSessionEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSessionEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listSessionEntityTypesSettings, this.getSessionEntityTypeSettings, this.createSessionEntityTypeSettings, this.updateSessionEntityTypeSettings, this.deleteSessionEntityTypeSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SessionEntityTypesStubSettings settings) {
            super((StubSettings)settings);
            this.listSessionEntityTypesSettings = settings.listSessionEntityTypesSettings.toBuilder();
            this.getSessionEntityTypeSettings = settings.getSessionEntityTypeSettings.toBuilder();
            this.createSessionEntityTypeSettings = settings.createSessionEntityTypeSettings.toBuilder();
            this.updateSessionEntityTypeSettings = settings.updateSessionEntityTypeSettings.toBuilder();
            this.deleteSessionEntityTypeSettings = settings.deleteSessionEntityTypeSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listSessionEntityTypesSettings, this.getSessionEntityTypeSettings, this.createSessionEntityTypeSettings, this.updateSessionEntityTypeSettings, this.deleteSessionEntityTypeSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SessionEntityTypesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SessionEntityTypesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SessionEntityTypesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SessionEntityTypesStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(SessionEntityTypesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SessionEntityTypesStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SessionEntityTypesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SessionEntityTypesStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SessionEntityTypesStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(SessionEntityTypesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listSessionEntityTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSessionEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createSessionEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateSessionEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSessionEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityTypesClient.ListSessionEntityTypesPagedResponse> listSessionEntityTypesSettings() {
            return this.listSessionEntityTypesSettings;
        }

        public UnaryCallSettings.Builder<GetSessionEntityTypeRequest, SessionEntityType> getSessionEntityTypeSettings() {
            return this.getSessionEntityTypeSettings;
        }

        public UnaryCallSettings.Builder<CreateSessionEntityTypeRequest, SessionEntityType> createSessionEntityTypeSettings() {
            return this.createSessionEntityTypeSettings;
        }

        public UnaryCallSettings.Builder<UpdateSessionEntityTypeRequest, SessionEntityType> updateSessionEntityTypeSettings() {
            return this.updateSessionEntityTypeSettings;
        }

        public UnaryCallSettings.Builder<DeleteSessionEntityTypeRequest, Empty> deleteSessionEntityTypeSettings() {
            return this.deleteSessionEntityTypeSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, SessionEntityTypesClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public SessionEntityTypesStubSettings build() throws IOException {
            return new SessionEntityTypesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

