/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.Deployment;
import com.google.cloud.dialogflow.cx.v3.DeploymentsClient;
import com.google.cloud.dialogflow.cx.v3.GetDeploymentRequest;
import com.google.cloud.dialogflow.cx.v3.ListDeploymentsRequest;
import com.google.cloud.dialogflow.cx.v3.ListDeploymentsResponse;
import com.google.cloud.dialogflow.cx.v3.stub.DeploymentsStub;
import com.google.cloud.dialogflow.cx.v3.stub.DeploymentsStubSettings;
import com.google.cloud.dialogflow.cx.v3.stub.HttpJsonDeploymentsCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonDeploymentsStub
extends DeploymentsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListDeploymentsRequest, ListDeploymentsResponse> listDeploymentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3.Deployments/ListDeployments").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{parent=projects/*/locations/*/agents/*/environments/*}/deployments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListDeploymentsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetDeploymentRequest, Deployment> getDeploymentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3.Deployments/GetDeployment").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=projects/*/locations/*/agents/*/environments/*/deployments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Deployment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListDeploymentsRequest, ListDeploymentsResponse> listDeploymentsCallable;
    private final UnaryCallable<ListDeploymentsRequest, DeploymentsClient.ListDeploymentsPagedResponse> listDeploymentsPagedCallable;
    private final UnaryCallable<GetDeploymentRequest, Deployment> getDeploymentCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DeploymentsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDeploymentsStub create(DeploymentsStubSettings settings) throws IOException {
        return new HttpJsonDeploymentsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDeploymentsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDeploymentsStub(DeploymentsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDeploymentsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDeploymentsStub(DeploymentsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDeploymentsStub(DeploymentsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDeploymentsCallableFactory());
    }

    protected HttpJsonDeploymentsStub(DeploymentsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listDeploymentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listDeploymentsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getDeploymentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDeploymentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listDeploymentsCallable = callableFactory.createUnaryCallable(listDeploymentsTransportSettings, settings.listDeploymentsSettings(), clientContext);
        this.listDeploymentsPagedCallable = callableFactory.createPagedCallable(listDeploymentsTransportSettings, settings.listDeploymentsSettings(), clientContext);
        this.getDeploymentCallable = callableFactory.createUnaryCallable(getDeploymentTransportSettings, settings.getDeploymentSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listDeploymentsMethodDescriptor);
        methodDescriptors.add(getDeploymentMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListDeploymentsRequest, ListDeploymentsResponse> listDeploymentsCallable() {
        return this.listDeploymentsCallable;
    }

    @Override
    public UnaryCallable<ListDeploymentsRequest, DeploymentsClient.ListDeploymentsPagedResponse> listDeploymentsPagedCallable() {
        return this.listDeploymentsPagedCallable;
    }

    @Override
    public UnaryCallable<GetDeploymentRequest, Deployment> getDeploymentCallable() {
        return this.getDeploymentCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DeploymentsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

