/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devicestreaming.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.devicestreaming.v1.AdbMessage;
import com.google.cloud.devicestreaming.v1.CancelDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.CreateDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.DeviceMessage;
import com.google.cloud.devicestreaming.v1.DeviceSession;
import com.google.cloud.devicestreaming.v1.DeviceSessionName;
import com.google.cloud.devicestreaming.v1.DirectAccessServiceSettings;
import com.google.cloud.devicestreaming.v1.GetDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.ListDeviceSessionsRequest;
import com.google.cloud.devicestreaming.v1.ListDeviceSessionsResponse;
import com.google.cloud.devicestreaming.v1.ProjectName;
import com.google.cloud.devicestreaming.v1.UpdateDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.stub.DirectAccessServiceStub;
import com.google.cloud.devicestreaming.v1.stub.DirectAccessServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DirectAccessServiceClient
implements BackgroundResource {
    private final DirectAccessServiceSettings settings;
    private final DirectAccessServiceStub stub;

    public static final DirectAccessServiceClient create() throws IOException {
        return DirectAccessServiceClient.create(DirectAccessServiceSettings.newBuilder().build());
    }

    public static final DirectAccessServiceClient create(DirectAccessServiceSettings settings) throws IOException {
        return new DirectAccessServiceClient(settings);
    }

    public static final DirectAccessServiceClient create(DirectAccessServiceStub stub) {
        return new DirectAccessServiceClient(stub);
    }

    protected DirectAccessServiceClient(DirectAccessServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DirectAccessServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DirectAccessServiceClient(DirectAccessServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DirectAccessServiceSettings getSettings() {
        return this.settings;
    }

    public DirectAccessServiceStub getStub() {
        return this.stub;
    }

    public final DeviceSession createDeviceSession(ProjectName parent, DeviceSession deviceSession, String deviceSessionId) {
        CreateDeviceSessionRequest request = CreateDeviceSessionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDeviceSession(deviceSession).setDeviceSessionId(deviceSessionId).build();
        return this.createDeviceSession(request);
    }

    public final DeviceSession createDeviceSession(String parent, DeviceSession deviceSession, String deviceSessionId) {
        CreateDeviceSessionRequest request = CreateDeviceSessionRequest.newBuilder().setParent(parent).setDeviceSession(deviceSession).setDeviceSessionId(deviceSessionId).build();
        return this.createDeviceSession(request);
    }

    public final DeviceSession createDeviceSession(CreateDeviceSessionRequest request) {
        return (DeviceSession)this.createDeviceSessionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDeviceSessionRequest, DeviceSession> createDeviceSessionCallable() {
        return this.stub.createDeviceSessionCallable();
    }

    public final ListDeviceSessionsPagedResponse listDeviceSessions(ProjectName parent) {
        ListDeviceSessionsRequest request = ListDeviceSessionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeviceSessions(request);
    }

    public final ListDeviceSessionsPagedResponse listDeviceSessions(String parent) {
        ListDeviceSessionsRequest request = ListDeviceSessionsRequest.newBuilder().setParent(parent).build();
        return this.listDeviceSessions(request);
    }

    public final ListDeviceSessionsPagedResponse listDeviceSessions(ListDeviceSessionsRequest request) {
        return (ListDeviceSessionsPagedResponse)((Object)this.listDeviceSessionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeviceSessionsRequest, ListDeviceSessionsPagedResponse> listDeviceSessionsPagedCallable() {
        return this.stub.listDeviceSessionsPagedCallable();
    }

    public final UnaryCallable<ListDeviceSessionsRequest, ListDeviceSessionsResponse> listDeviceSessionsCallable() {
        return this.stub.listDeviceSessionsCallable();
    }

    public final DeviceSession getDeviceSession(DeviceSessionName name) {
        GetDeviceSessionRequest request = GetDeviceSessionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeviceSession(request);
    }

    public final DeviceSession getDeviceSession(String name) {
        GetDeviceSessionRequest request = GetDeviceSessionRequest.newBuilder().setName(name).build();
        return this.getDeviceSession(request);
    }

    public final DeviceSession getDeviceSession(GetDeviceSessionRequest request) {
        return (DeviceSession)this.getDeviceSessionCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeviceSessionRequest, DeviceSession> getDeviceSessionCallable() {
        return this.stub.getDeviceSessionCallable();
    }

    public final void cancelDeviceSession(CancelDeviceSessionRequest request) {
        this.cancelDeviceSessionCallable().call((Object)request);
    }

    public final UnaryCallable<CancelDeviceSessionRequest, Empty> cancelDeviceSessionCallable() {
        return this.stub.cancelDeviceSessionCallable();
    }

    public final DeviceSession updateDeviceSession(DeviceSession deviceSession, FieldMask updateMask) {
        UpdateDeviceSessionRequest request = UpdateDeviceSessionRequest.newBuilder().setDeviceSession(deviceSession).setUpdateMask(updateMask).build();
        return this.updateDeviceSession(request);
    }

    public final DeviceSession updateDeviceSession(UpdateDeviceSessionRequest request) {
        return (DeviceSession)this.updateDeviceSessionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDeviceSessionRequest, DeviceSession> updateDeviceSessionCallable() {
        return this.stub.updateDeviceSessionCallable();
    }

    public final BidiStreamingCallable<AdbMessage, DeviceMessage> adbConnectCallable() {
        return this.stub.adbConnectCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDeviceSessionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DeviceSession, ListDeviceSessionsPage, ListDeviceSessionsFixedSizeCollection> {
        private ListDeviceSessionsFixedSizeCollection(List<ListDeviceSessionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeviceSessionsFixedSizeCollection createEmptyCollection() {
            return new ListDeviceSessionsFixedSizeCollection(null, 0);
        }

        protected ListDeviceSessionsFixedSizeCollection createCollection(List<ListDeviceSessionsPage> pages, int collectionSize) {
            return new ListDeviceSessionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeviceSessionsPage
    extends AbstractPage<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DeviceSession, ListDeviceSessionsPage> {
        private ListDeviceSessionsPage(PageContext<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DeviceSession> context, ListDeviceSessionsResponse response) {
            super(context, (Object)response);
        }

        private static ListDeviceSessionsPage createEmptyPage() {
            return new ListDeviceSessionsPage(null, null);
        }

        protected ListDeviceSessionsPage createPage(PageContext<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DeviceSession> context, ListDeviceSessionsResponse response) {
            return new ListDeviceSessionsPage(context, response);
        }

        public ApiFuture<ListDeviceSessionsPage> createPageAsync(PageContext<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DeviceSession> context, ApiFuture<ListDeviceSessionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeviceSessionsPagedResponse
    extends AbstractPagedListResponse<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DeviceSession, ListDeviceSessionsPage, ListDeviceSessionsFixedSizeCollection> {
        public static ApiFuture<ListDeviceSessionsPagedResponse> createAsync(PageContext<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DeviceSession> context, ApiFuture<ListDeviceSessionsResponse> futureResponse) {
            ApiFuture<ListDeviceSessionsPage> futurePage = ListDeviceSessionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeviceSessionsPagedResponse((ListDeviceSessionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeviceSessionsPagedResponse(ListDeviceSessionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeviceSessionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

