/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devicestreaming.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.devicestreaming.v1.AdbMessage;
import com.google.cloud.devicestreaming.v1.CancelDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.CreateDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.DeviceMessage;
import com.google.cloud.devicestreaming.v1.DeviceSession;
import com.google.cloud.devicestreaming.v1.DirectAccessServiceClient;
import com.google.cloud.devicestreaming.v1.GetDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.ListDeviceSessionsRequest;
import com.google.cloud.devicestreaming.v1.ListDeviceSessionsResponse;
import com.google.cloud.devicestreaming.v1.UpdateDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.stub.DirectAccessServiceStub;
import com.google.cloud.devicestreaming.v1.stub.DirectAccessServiceStubSettings;
import com.google.cloud.devicestreaming.v1.stub.GrpcDirectAccessServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcDirectAccessServiceStub
extends DirectAccessServiceStub {
    private static final MethodDescriptor<CreateDeviceSessionRequest, DeviceSession> createDeviceSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.devicestreaming.v1.DirectAccessService/CreateDeviceSession").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDeviceSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DeviceSession.getDefaultInstance())).build();
    private static final MethodDescriptor<ListDeviceSessionsRequest, ListDeviceSessionsResponse> listDeviceSessionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.devicestreaming.v1.DirectAccessService/ListDeviceSessions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDeviceSessionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDeviceSessionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetDeviceSessionRequest, DeviceSession> getDeviceSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.devicestreaming.v1.DirectAccessService/GetDeviceSession").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDeviceSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DeviceSession.getDefaultInstance())).build();
    private static final MethodDescriptor<CancelDeviceSessionRequest, Empty> cancelDeviceSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.devicestreaming.v1.DirectAccessService/CancelDeviceSession").setRequestMarshaller(ProtoUtils.marshaller((Message)CancelDeviceSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateDeviceSessionRequest, DeviceSession> updateDeviceSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.devicestreaming.v1.DirectAccessService/UpdateDeviceSession").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDeviceSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DeviceSession.getDefaultInstance())).build();
    private static final MethodDescriptor<AdbMessage, DeviceMessage> adbConnectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.cloud.devicestreaming.v1.DirectAccessService/AdbConnect").setRequestMarshaller(ProtoUtils.marshaller((Message)AdbMessage.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DeviceMessage.getDefaultInstance())).build();
    private final UnaryCallable<CreateDeviceSessionRequest, DeviceSession> createDeviceSessionCallable;
    private final UnaryCallable<ListDeviceSessionsRequest, ListDeviceSessionsResponse> listDeviceSessionsCallable;
    private final UnaryCallable<ListDeviceSessionsRequest, DirectAccessServiceClient.ListDeviceSessionsPagedResponse> listDeviceSessionsPagedCallable;
    private final UnaryCallable<GetDeviceSessionRequest, DeviceSession> getDeviceSessionCallable;
    private final UnaryCallable<CancelDeviceSessionRequest, Empty> cancelDeviceSessionCallable;
    private final UnaryCallable<UpdateDeviceSessionRequest, DeviceSession> updateDeviceSessionCallable;
    private final BidiStreamingCallable<AdbMessage, DeviceMessage> adbConnectCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDirectAccessServiceStub create(DirectAccessServiceStubSettings settings) throws IOException {
        return new GrpcDirectAccessServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDirectAccessServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDirectAccessServiceStub(DirectAccessServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDirectAccessServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDirectAccessServiceStub(DirectAccessServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDirectAccessServiceStub(DirectAccessServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDirectAccessServiceCallableFactory());
    }

    protected GrpcDirectAccessServiceStub(DirectAccessServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createDeviceSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDeviceSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listDeviceSessionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDeviceSessionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getDeviceSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDeviceSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings cancelDeviceSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(cancelDeviceSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateDeviceSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDeviceSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("device_session.name", String.valueOf(request.getDeviceSession().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings adbConnectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(adbConnectMethodDescriptor).build();
        this.createDeviceSessionCallable = callableFactory.createUnaryCallable(createDeviceSessionTransportSettings, settings.createDeviceSessionSettings(), clientContext);
        this.listDeviceSessionsCallable = callableFactory.createUnaryCallable(listDeviceSessionsTransportSettings, settings.listDeviceSessionsSettings(), clientContext);
        this.listDeviceSessionsPagedCallable = callableFactory.createPagedCallable(listDeviceSessionsTransportSettings, settings.listDeviceSessionsSettings(), clientContext);
        this.getDeviceSessionCallable = callableFactory.createUnaryCallable(getDeviceSessionTransportSettings, settings.getDeviceSessionSettings(), clientContext);
        this.cancelDeviceSessionCallable = callableFactory.createUnaryCallable(cancelDeviceSessionTransportSettings, settings.cancelDeviceSessionSettings(), clientContext);
        this.updateDeviceSessionCallable = callableFactory.createUnaryCallable(updateDeviceSessionTransportSettings, settings.updateDeviceSessionSettings(), clientContext);
        this.adbConnectCallable = callableFactory.createBidiStreamingCallable(adbConnectTransportSettings, settings.adbConnectSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateDeviceSessionRequest, DeviceSession> createDeviceSessionCallable() {
        return this.createDeviceSessionCallable;
    }

    @Override
    public UnaryCallable<ListDeviceSessionsRequest, ListDeviceSessionsResponse> listDeviceSessionsCallable() {
        return this.listDeviceSessionsCallable;
    }

    @Override
    public UnaryCallable<ListDeviceSessionsRequest, DirectAccessServiceClient.ListDeviceSessionsPagedResponse> listDeviceSessionsPagedCallable() {
        return this.listDeviceSessionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetDeviceSessionRequest, DeviceSession> getDeviceSessionCallable() {
        return this.getDeviceSessionCallable;
    }

    @Override
    public UnaryCallable<CancelDeviceSessionRequest, Empty> cancelDeviceSessionCallable() {
        return this.cancelDeviceSessionCallable;
    }

    @Override
    public UnaryCallable<UpdateDeviceSessionRequest, DeviceSession> updateDeviceSessionCallable() {
        return this.updateDeviceSessionCallable;
    }

    @Override
    public BidiStreamingCallable<AdbMessage, DeviceMessage> adbConnectCallable() {
        return this.adbConnectCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

