/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CreateWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1.DeleteWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1.GetWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1.InstantiateInlineWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1.InstantiateWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1.ListWorkflowTemplatesRequest;
import com.google.cloud.dataproc.v1.ListWorkflowTemplatesResponse;
import com.google.cloud.dataproc.v1.UpdateWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1.WorkflowMetadata;
import com.google.cloud.dataproc.v1.WorkflowTemplate;
import com.google.cloud.dataproc.v1.WorkflowTemplateServiceClient;
import com.google.cloud.dataproc.v1.stub.HttpJsonWorkflowTemplateServiceCallableFactory;
import com.google.cloud.dataproc.v1.stub.WorkflowTemplateServiceStub;
import com.google.cloud.dataproc.v1.stub.WorkflowTemplateServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonWorkflowTemplateServiceStub
extends WorkflowTemplateServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(WorkflowMetadata.getDescriptor()).add(Empty.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateWorkflowTemplateRequest, WorkflowTemplate> createWorkflowTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.WorkflowTemplateService/CreateWorkflowTemplate").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/workflowTemplates", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*/regions/*}/workflowTemplates"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("template", (Message)request.getTemplate(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)WorkflowTemplate.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetWorkflowTemplateRequest, WorkflowTemplate> getWorkflowTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.WorkflowTemplateService/GetWorkflowTemplate").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/workflowTemplates/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/regions/*/workflowTemplates/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "version", (Object)request.getVersion());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)WorkflowTemplate.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<InstantiateWorkflowTemplateRequest, Operation> instantiateWorkflowTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.WorkflowTemplateService/InstantiateWorkflowTemplate").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/workflowTemplates/*}:instantiate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/regions/*/workflowTemplates/*}:instantiate"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<InstantiateInlineWorkflowTemplateRequest, Operation> instantiateInlineWorkflowTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.WorkflowTemplateService/InstantiateInlineWorkflowTemplate").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/workflowTemplates:instantiateInline", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*/regions/*}/workflowTemplates:instantiateInline"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("template", (Message)request.getTemplate(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateWorkflowTemplateRequest, WorkflowTemplate> updateWorkflowTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.WorkflowTemplateService/UpdateWorkflowTemplate").setHttpMethod("PUT").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{template.name=projects/*/locations/*/workflowTemplates/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "template.name", (Object)request.getTemplate().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{template.name=projects/*/regions/*/workflowTemplates/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("template", (Message)request.getTemplate(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)WorkflowTemplate.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse> listWorkflowTemplatesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.WorkflowTemplateService/ListWorkflowTemplates").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/workflowTemplates", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*/regions/*}/workflowTemplates"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListWorkflowTemplatesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteWorkflowTemplateRequest, Empty> deleteWorkflowTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.WorkflowTemplateService/DeleteWorkflowTemplate").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/workflowTemplates/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/regions/*/workflowTemplates/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "version", (Object)request.getVersion());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateWorkflowTemplateRequest, WorkflowTemplate> createWorkflowTemplateCallable;
    private final UnaryCallable<GetWorkflowTemplateRequest, WorkflowTemplate> getWorkflowTemplateCallable;
    private final UnaryCallable<InstantiateWorkflowTemplateRequest, Operation> instantiateWorkflowTemplateCallable;
    private final OperationCallable<InstantiateWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateWorkflowTemplateOperationCallable;
    private final UnaryCallable<InstantiateInlineWorkflowTemplateRequest, Operation> instantiateInlineWorkflowTemplateCallable;
    private final OperationCallable<InstantiateInlineWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateInlineWorkflowTemplateOperationCallable;
    private final UnaryCallable<UpdateWorkflowTemplateRequest, WorkflowTemplate> updateWorkflowTemplateCallable;
    private final UnaryCallable<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse> listWorkflowTemplatesCallable;
    private final UnaryCallable<ListWorkflowTemplatesRequest, WorkflowTemplateServiceClient.ListWorkflowTemplatesPagedResponse> listWorkflowTemplatesPagedCallable;
    private final UnaryCallable<DeleteWorkflowTemplateRequest, Empty> deleteWorkflowTemplateCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonWorkflowTemplateServiceStub create(WorkflowTemplateServiceStubSettings settings) throws IOException {
        return new HttpJsonWorkflowTemplateServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonWorkflowTemplateServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonWorkflowTemplateServiceStub(WorkflowTemplateServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonWorkflowTemplateServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonWorkflowTemplateServiceStub(WorkflowTemplateServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonWorkflowTemplateServiceStub(WorkflowTemplateServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonWorkflowTemplateServiceCallableFactory());
    }

    protected HttpJsonWorkflowTemplateServiceStub(WorkflowTemplateServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings createWorkflowTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createWorkflowTemplateMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getWorkflowTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getWorkflowTemplateMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings instantiateWorkflowTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(instantiateWorkflowTemplateMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings instantiateInlineWorkflowTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(instantiateInlineWorkflowTemplateMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateWorkflowTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateWorkflowTemplateMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listWorkflowTemplatesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listWorkflowTemplatesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteWorkflowTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteWorkflowTemplateMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createWorkflowTemplateCallable = callableFactory.createUnaryCallable(createWorkflowTemplateTransportSettings, settings.createWorkflowTemplateSettings(), clientContext);
        this.getWorkflowTemplateCallable = callableFactory.createUnaryCallable(getWorkflowTemplateTransportSettings, settings.getWorkflowTemplateSettings(), clientContext);
        this.instantiateWorkflowTemplateCallable = callableFactory.createUnaryCallable(instantiateWorkflowTemplateTransportSettings, settings.instantiateWorkflowTemplateSettings(), clientContext);
        this.instantiateWorkflowTemplateOperationCallable = callableFactory.createOperationCallable(instantiateWorkflowTemplateTransportSettings, settings.instantiateWorkflowTemplateOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.instantiateInlineWorkflowTemplateCallable = callableFactory.createUnaryCallable(instantiateInlineWorkflowTemplateTransportSettings, settings.instantiateInlineWorkflowTemplateSettings(), clientContext);
        this.instantiateInlineWorkflowTemplateOperationCallable = callableFactory.createOperationCallable(instantiateInlineWorkflowTemplateTransportSettings, settings.instantiateInlineWorkflowTemplateOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateWorkflowTemplateCallable = callableFactory.createUnaryCallable(updateWorkflowTemplateTransportSettings, settings.updateWorkflowTemplateSettings(), clientContext);
        this.listWorkflowTemplatesCallable = callableFactory.createUnaryCallable(listWorkflowTemplatesTransportSettings, settings.listWorkflowTemplatesSettings(), clientContext);
        this.listWorkflowTemplatesPagedCallable = callableFactory.createPagedCallable(listWorkflowTemplatesTransportSettings, settings.listWorkflowTemplatesSettings(), clientContext);
        this.deleteWorkflowTemplateCallable = callableFactory.createUnaryCallable(deleteWorkflowTemplateTransportSettings, settings.deleteWorkflowTemplateSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createWorkflowTemplateMethodDescriptor);
        methodDescriptors.add(getWorkflowTemplateMethodDescriptor);
        methodDescriptors.add(instantiateWorkflowTemplateMethodDescriptor);
        methodDescriptors.add(instantiateInlineWorkflowTemplateMethodDescriptor);
        methodDescriptors.add(updateWorkflowTemplateMethodDescriptor);
        methodDescriptors.add(listWorkflowTemplatesMethodDescriptor);
        methodDescriptors.add(deleteWorkflowTemplateMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateWorkflowTemplateRequest, WorkflowTemplate> createWorkflowTemplateCallable() {
        return this.createWorkflowTemplateCallable;
    }

    @Override
    public UnaryCallable<GetWorkflowTemplateRequest, WorkflowTemplate> getWorkflowTemplateCallable() {
        return this.getWorkflowTemplateCallable;
    }

    @Override
    public UnaryCallable<InstantiateWorkflowTemplateRequest, Operation> instantiateWorkflowTemplateCallable() {
        return this.instantiateWorkflowTemplateCallable;
    }

    @Override
    public OperationCallable<InstantiateWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateWorkflowTemplateOperationCallable() {
        return this.instantiateWorkflowTemplateOperationCallable;
    }

    @Override
    public UnaryCallable<InstantiateInlineWorkflowTemplateRequest, Operation> instantiateInlineWorkflowTemplateCallable() {
        return this.instantiateInlineWorkflowTemplateCallable;
    }

    @Override
    public OperationCallable<InstantiateInlineWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateInlineWorkflowTemplateOperationCallable() {
        return this.instantiateInlineWorkflowTemplateOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateWorkflowTemplateRequest, WorkflowTemplate> updateWorkflowTemplateCallable() {
        return this.updateWorkflowTemplateCallable;
    }

    @Override
    public UnaryCallable<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse> listWorkflowTemplatesCallable() {
        return this.listWorkflowTemplatesCallable;
    }

    @Override
    public UnaryCallable<ListWorkflowTemplatesRequest, WorkflowTemplateServiceClient.ListWorkflowTemplatesPagedResponse> listWorkflowTemplatesPagedCallable() {
        return this.listWorkflowTemplatesPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteWorkflowTemplateRequest, Empty> deleteWorkflowTemplateCallable() {
        return this.deleteWorkflowTemplateCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

