/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.Batch;
import com.google.cloud.dataproc.v1.BatchControllerSettings;
import com.google.cloud.dataproc.v1.BatchName;
import com.google.cloud.dataproc.v1.BatchOperationMetadata;
import com.google.cloud.dataproc.v1.CreateBatchRequest;
import com.google.cloud.dataproc.v1.DeleteBatchRequest;
import com.google.cloud.dataproc.v1.GetBatchRequest;
import com.google.cloud.dataproc.v1.ListBatchesRequest;
import com.google.cloud.dataproc.v1.ListBatchesResponse;
import com.google.cloud.dataproc.v1.LocationName;
import com.google.cloud.dataproc.v1.stub.BatchControllerStub;
import com.google.cloud.dataproc.v1.stub.BatchControllerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BatchControllerClient
implements BackgroundResource {
    private final BatchControllerSettings settings;
    private final BatchControllerStub stub;
    private final OperationsClient operationsClient;

    public static final BatchControllerClient create() throws IOException {
        return BatchControllerClient.create(BatchControllerSettings.newBuilder().build());
    }

    public static final BatchControllerClient create(BatchControllerSettings settings) throws IOException {
        return new BatchControllerClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BatchControllerClient create(BatchControllerStub stub) {
        return new BatchControllerClient(stub);
    }

    protected BatchControllerClient(BatchControllerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BatchControllerStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BatchControllerClient(BatchControllerStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final BatchControllerSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BatchControllerStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Batch, BatchOperationMetadata> createBatchAsync(LocationName parent, Batch batch, String batchId) {
        CreateBatchRequest request = CreateBatchRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBatch(batch).setBatchId(batchId).build();
        return this.createBatchAsync(request);
    }

    public final OperationFuture<Batch, BatchOperationMetadata> createBatchAsync(String parent, Batch batch, String batchId) {
        CreateBatchRequest request = CreateBatchRequest.newBuilder().setParent(parent).setBatch(batch).setBatchId(batchId).build();
        return this.createBatchAsync(request);
    }

    public final OperationFuture<Batch, BatchOperationMetadata> createBatchAsync(CreateBatchRequest request) {
        return this.createBatchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateBatchRequest, Batch, BatchOperationMetadata> createBatchOperationCallable() {
        return this.stub.createBatchOperationCallable();
    }

    public final UnaryCallable<CreateBatchRequest, Operation> createBatchCallable() {
        return this.stub.createBatchCallable();
    }

    public final Batch getBatch(BatchName name) {
        GetBatchRequest request = GetBatchRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBatch(request);
    }

    public final Batch getBatch(String name) {
        GetBatchRequest request = GetBatchRequest.newBuilder().setName(name).build();
        return this.getBatch(request);
    }

    public final Batch getBatch(GetBatchRequest request) {
        return (Batch)this.getBatchCallable().call((Object)request);
    }

    public final UnaryCallable<GetBatchRequest, Batch> getBatchCallable() {
        return this.stub.getBatchCallable();
    }

    public final ListBatchesPagedResponse listBatches(LocationName parent) {
        ListBatchesRequest request = ListBatchesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBatches(request);
    }

    public final ListBatchesPagedResponse listBatches(String parent) {
        ListBatchesRequest request = ListBatchesRequest.newBuilder().setParent(parent).build();
        return this.listBatches(request);
    }

    public final ListBatchesPagedResponse listBatches(ListBatchesRequest request) {
        return (ListBatchesPagedResponse)((Object)this.listBatchesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBatchesRequest, ListBatchesPagedResponse> listBatchesPagedCallable() {
        return this.stub.listBatchesPagedCallable();
    }

    public final UnaryCallable<ListBatchesRequest, ListBatchesResponse> listBatchesCallable() {
        return this.stub.listBatchesCallable();
    }

    public final void deleteBatch(BatchName name) {
        DeleteBatchRequest request = DeleteBatchRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteBatch(request);
    }

    public final void deleteBatch(String name) {
        DeleteBatchRequest request = DeleteBatchRequest.newBuilder().setName(name).build();
        this.deleteBatch(request);
    }

    public final void deleteBatch(DeleteBatchRequest request) {
        this.deleteBatchCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteBatchRequest, Empty> deleteBatchCallable() {
        return this.stub.deleteBatchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListBatchesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBatchesRequest, ListBatchesResponse, Batch, ListBatchesPage, ListBatchesFixedSizeCollection> {
        private ListBatchesFixedSizeCollection(List<ListBatchesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBatchesFixedSizeCollection createEmptyCollection() {
            return new ListBatchesFixedSizeCollection(null, 0);
        }

        protected ListBatchesFixedSizeCollection createCollection(List<ListBatchesPage> pages, int collectionSize) {
            return new ListBatchesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBatchesPage
    extends AbstractPage<ListBatchesRequest, ListBatchesResponse, Batch, ListBatchesPage> {
        private ListBatchesPage(PageContext<ListBatchesRequest, ListBatchesResponse, Batch> context, ListBatchesResponse response) {
            super(context, (Object)response);
        }

        private static ListBatchesPage createEmptyPage() {
            return new ListBatchesPage(null, null);
        }

        protected ListBatchesPage createPage(PageContext<ListBatchesRequest, ListBatchesResponse, Batch> context, ListBatchesResponse response) {
            return new ListBatchesPage(context, response);
        }

        public ApiFuture<ListBatchesPage> createPageAsync(PageContext<ListBatchesRequest, ListBatchesResponse, Batch> context, ApiFuture<ListBatchesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBatchesPagedResponse
    extends AbstractPagedListResponse<ListBatchesRequest, ListBatchesResponse, Batch, ListBatchesPage, ListBatchesFixedSizeCollection> {
        public static ApiFuture<ListBatchesPagedResponse> createAsync(PageContext<ListBatchesRequest, ListBatchesResponse, Batch> context, ApiFuture<ListBatchesResponse> futureResponse) {
            ApiFuture<ListBatchesPage> futurePage = ListBatchesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBatchesPagedResponse((ListBatchesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBatchesPagedResponse(ListBatchesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBatchesFixedSizeCollection.createEmptyCollection());
        }
    }
}

