/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1beta2;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1beta2.CreateWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1beta2.DeleteWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1beta2.GetWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1beta2.InstantiateInlineWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1beta2.InstantiateWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1beta2.ListWorkflowTemplatesRequest;
import com.google.cloud.dataproc.v1beta2.ListWorkflowTemplatesResponse;
import com.google.cloud.dataproc.v1beta2.RegionName;
import com.google.cloud.dataproc.v1beta2.UpdateWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1beta2.WorkflowMetadata;
import com.google.cloud.dataproc.v1beta2.WorkflowTemplate;
import com.google.cloud.dataproc.v1beta2.WorkflowTemplateName;
import com.google.cloud.dataproc.v1beta2.WorkflowTemplateServiceSettings;
import com.google.cloud.dataproc.v1beta2.stub.WorkflowTemplateServiceStub;
import com.google.cloud.dataproc.v1beta2.stub.WorkflowTemplateServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class WorkflowTemplateServiceClient
implements BackgroundResource {
    private final WorkflowTemplateServiceSettings settings;
    private final WorkflowTemplateServiceStub stub;
    private final OperationsClient operationsClient;

    public static final WorkflowTemplateServiceClient create() throws IOException {
        return WorkflowTemplateServiceClient.create(WorkflowTemplateServiceSettings.newBuilder().build());
    }

    public static final WorkflowTemplateServiceClient create(WorkflowTemplateServiceSettings settings) throws IOException {
        return new WorkflowTemplateServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final WorkflowTemplateServiceClient create(WorkflowTemplateServiceStub stub) {
        return new WorkflowTemplateServiceClient(stub);
    }

    protected WorkflowTemplateServiceClient(WorkflowTemplateServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((WorkflowTemplateServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected WorkflowTemplateServiceClient(WorkflowTemplateServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final WorkflowTemplateServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public WorkflowTemplateServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final WorkflowTemplate createWorkflowTemplate(RegionName parent, WorkflowTemplate template) {
        CreateWorkflowTemplateRequest request = CreateWorkflowTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTemplate(template).build();
        return this.createWorkflowTemplate(request);
    }

    public final WorkflowTemplate createWorkflowTemplate(String parent, WorkflowTemplate template) {
        CreateWorkflowTemplateRequest request = CreateWorkflowTemplateRequest.newBuilder().setParent(parent).setTemplate(template).build();
        return this.createWorkflowTemplate(request);
    }

    public final WorkflowTemplate createWorkflowTemplate(CreateWorkflowTemplateRequest request) {
        return (WorkflowTemplate)this.createWorkflowTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<CreateWorkflowTemplateRequest, WorkflowTemplate> createWorkflowTemplateCallable() {
        return this.stub.createWorkflowTemplateCallable();
    }

    public final WorkflowTemplate getWorkflowTemplate(WorkflowTemplateName name) {
        GetWorkflowTemplateRequest request = GetWorkflowTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkflowTemplate(request);
    }

    public final WorkflowTemplate getWorkflowTemplate(String name) {
        GetWorkflowTemplateRequest request = GetWorkflowTemplateRequest.newBuilder().setName(name).build();
        return this.getWorkflowTemplate(request);
    }

    public final WorkflowTemplate getWorkflowTemplate(GetWorkflowTemplateRequest request) {
        return (WorkflowTemplate)this.getWorkflowTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkflowTemplateRequest, WorkflowTemplate> getWorkflowTemplateCallable() {
        return this.stub.getWorkflowTemplateCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, WorkflowMetadata> instantiateWorkflowTemplateAsync(WorkflowTemplateName name) {
        InstantiateWorkflowTemplateRequest request = InstantiateWorkflowTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.instantiateWorkflowTemplateAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, WorkflowMetadata> instantiateWorkflowTemplateAsync(String name) {
        InstantiateWorkflowTemplateRequest request = InstantiateWorkflowTemplateRequest.newBuilder().setName(name).build();
        return this.instantiateWorkflowTemplateAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, WorkflowMetadata> instantiateWorkflowTemplateAsync(WorkflowTemplateName name, Map<String, String> parameters) {
        InstantiateWorkflowTemplateRequest request = InstantiateWorkflowTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).putAllParameters(parameters).build();
        return this.instantiateWorkflowTemplateAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, WorkflowMetadata> instantiateWorkflowTemplateAsync(String name, Map<String, String> parameters) {
        InstantiateWorkflowTemplateRequest request = InstantiateWorkflowTemplateRequest.newBuilder().setName(name).putAllParameters(parameters).build();
        return this.instantiateWorkflowTemplateAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, WorkflowMetadata> instantiateWorkflowTemplateAsync(InstantiateWorkflowTemplateRequest request) {
        return this.instantiateWorkflowTemplateOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<InstantiateWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateWorkflowTemplateOperationCallable() {
        return this.stub.instantiateWorkflowTemplateOperationCallable();
    }

    public final UnaryCallable<InstantiateWorkflowTemplateRequest, Operation> instantiateWorkflowTemplateCallable() {
        return this.stub.instantiateWorkflowTemplateCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, WorkflowMetadata> instantiateInlineWorkflowTemplateAsync(RegionName parent, WorkflowTemplate template) {
        InstantiateInlineWorkflowTemplateRequest request = InstantiateInlineWorkflowTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTemplate(template).build();
        return this.instantiateInlineWorkflowTemplateAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, WorkflowMetadata> instantiateInlineWorkflowTemplateAsync(String parent, WorkflowTemplate template) {
        InstantiateInlineWorkflowTemplateRequest request = InstantiateInlineWorkflowTemplateRequest.newBuilder().setParent(parent).setTemplate(template).build();
        return this.instantiateInlineWorkflowTemplateAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, WorkflowMetadata> instantiateInlineWorkflowTemplateAsync(InstantiateInlineWorkflowTemplateRequest request) {
        return this.instantiateInlineWorkflowTemplateOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<InstantiateInlineWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateInlineWorkflowTemplateOperationCallable() {
        return this.stub.instantiateInlineWorkflowTemplateOperationCallable();
    }

    public final UnaryCallable<InstantiateInlineWorkflowTemplateRequest, Operation> instantiateInlineWorkflowTemplateCallable() {
        return this.stub.instantiateInlineWorkflowTemplateCallable();
    }

    public final WorkflowTemplate updateWorkflowTemplate(WorkflowTemplate template) {
        UpdateWorkflowTemplateRequest request = UpdateWorkflowTemplateRequest.newBuilder().setTemplate(template).build();
        return this.updateWorkflowTemplate(request);
    }

    public final WorkflowTemplate updateWorkflowTemplate(UpdateWorkflowTemplateRequest request) {
        return (WorkflowTemplate)this.updateWorkflowTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateWorkflowTemplateRequest, WorkflowTemplate> updateWorkflowTemplateCallable() {
        return this.stub.updateWorkflowTemplateCallable();
    }

    public final ListWorkflowTemplatesPagedResponse listWorkflowTemplates(RegionName parent) {
        ListWorkflowTemplatesRequest request = ListWorkflowTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkflowTemplates(request);
    }

    public final ListWorkflowTemplatesPagedResponse listWorkflowTemplates(String parent) {
        ListWorkflowTemplatesRequest request = ListWorkflowTemplatesRequest.newBuilder().setParent(parent).build();
        return this.listWorkflowTemplates(request);
    }

    public final ListWorkflowTemplatesPagedResponse listWorkflowTemplates(ListWorkflowTemplatesRequest request) {
        return (ListWorkflowTemplatesPagedResponse)((Object)this.listWorkflowTemplatesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkflowTemplatesRequest, ListWorkflowTemplatesPagedResponse> listWorkflowTemplatesPagedCallable() {
        return this.stub.listWorkflowTemplatesPagedCallable();
    }

    public final UnaryCallable<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse> listWorkflowTemplatesCallable() {
        return this.stub.listWorkflowTemplatesCallable();
    }

    public final void deleteWorkflowTemplate(WorkflowTemplateName name) {
        DeleteWorkflowTemplateRequest request = DeleteWorkflowTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteWorkflowTemplate(request);
    }

    public final void deleteWorkflowTemplate(String name) {
        DeleteWorkflowTemplateRequest request = DeleteWorkflowTemplateRequest.newBuilder().setName(name).build();
        this.deleteWorkflowTemplate(request);
    }

    public final void deleteWorkflowTemplate(DeleteWorkflowTemplateRequest request) {
        this.deleteWorkflowTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteWorkflowTemplateRequest, Empty> deleteWorkflowTemplateCallable() {
        return this.stub.deleteWorkflowTemplateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListWorkflowTemplatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplate, ListWorkflowTemplatesPage, ListWorkflowTemplatesFixedSizeCollection> {
        private ListWorkflowTemplatesFixedSizeCollection(List<ListWorkflowTemplatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkflowTemplatesFixedSizeCollection createEmptyCollection() {
            return new ListWorkflowTemplatesFixedSizeCollection(null, 0);
        }

        protected ListWorkflowTemplatesFixedSizeCollection createCollection(List<ListWorkflowTemplatesPage> pages, int collectionSize) {
            return new ListWorkflowTemplatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkflowTemplatesPage
    extends AbstractPage<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplate, ListWorkflowTemplatesPage> {
        private ListWorkflowTemplatesPage(PageContext<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplate> context, ListWorkflowTemplatesResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkflowTemplatesPage createEmptyPage() {
            return new ListWorkflowTemplatesPage(null, null);
        }

        protected ListWorkflowTemplatesPage createPage(PageContext<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplate> context, ListWorkflowTemplatesResponse response) {
            return new ListWorkflowTemplatesPage(context, response);
        }

        public ApiFuture<ListWorkflowTemplatesPage> createPageAsync(PageContext<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplate> context, ApiFuture<ListWorkflowTemplatesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkflowTemplatesPagedResponse
    extends AbstractPagedListResponse<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplate, ListWorkflowTemplatesPage, ListWorkflowTemplatesFixedSizeCollection> {
        public static ApiFuture<ListWorkflowTemplatesPagedResponse> createAsync(PageContext<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplate> context, ApiFuture<ListWorkflowTemplatesResponse> futureResponse) {
            ApiFuture<ListWorkflowTemplatesPage> futurePage = ListWorkflowTemplatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListWorkflowTemplatesPage, ListWorkflowTemplatesPagedResponse>(){

                public ListWorkflowTemplatesPagedResponse apply(ListWorkflowTemplatesPage input) {
                    return new ListWorkflowTemplatesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkflowTemplatesPagedResponse(ListWorkflowTemplatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkflowTemplatesFixedSizeCollection.createEmptyCollection());
        }
    }
}

