/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.metastore.v1alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.metastore.v1alpha.CreateFederationRequest;
import com.google.cloud.metastore.v1alpha.DataprocMetastoreFederationClient;
import com.google.cloud.metastore.v1alpha.DeleteFederationRequest;
import com.google.cloud.metastore.v1alpha.Federation;
import com.google.cloud.metastore.v1alpha.GetFederationRequest;
import com.google.cloud.metastore.v1alpha.ListFederationsRequest;
import com.google.cloud.metastore.v1alpha.ListFederationsResponse;
import com.google.cloud.metastore.v1alpha.OperationMetadata;
import com.google.cloud.metastore.v1alpha.UpdateFederationRequest;
import com.google.cloud.metastore.v1alpha.stub.DataprocMetastoreFederationStub;
import com.google.cloud.metastore.v1alpha.stub.GrpcDataprocMetastoreFederationStub;
import com.google.cloud.metastore.v1alpha.stub.HttpJsonDataprocMetastoreFederationStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DataprocMetastoreFederationStubSettings
extends StubSettings<DataprocMetastoreFederationStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListFederationsRequest, ListFederationsResponse, DataprocMetastoreFederationClient.ListFederationsPagedResponse> listFederationsSettings;
    private final UnaryCallSettings<GetFederationRequest, Federation> getFederationSettings;
    private final UnaryCallSettings<CreateFederationRequest, Operation> createFederationSettings;
    private final OperationCallSettings<CreateFederationRequest, Federation, OperationMetadata> createFederationOperationSettings;
    private final UnaryCallSettings<UpdateFederationRequest, Operation> updateFederationSettings;
    private final OperationCallSettings<UpdateFederationRequest, Federation, OperationMetadata> updateFederationOperationSettings;
    private final UnaryCallSettings<DeleteFederationRequest, Operation> deleteFederationSettings;
    private final OperationCallSettings<DeleteFederationRequest, Empty, OperationMetadata> deleteFederationOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataprocMetastoreFederationClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListFederationsRequest, ListFederationsResponse, Federation> LIST_FEDERATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListFederationsRequest, ListFederationsResponse, Federation>(){

        public String emptyToken() {
            return "";
        }

        public ListFederationsRequest injectToken(ListFederationsRequest payload, String token) {
            return ListFederationsRequest.newBuilder((ListFederationsRequest)payload).setPageToken(token).build();
        }

        public ListFederationsRequest injectPageSize(ListFederationsRequest payload, int pageSize) {
            return ListFederationsRequest.newBuilder((ListFederationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFederationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFederationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Federation> extractResources(ListFederationsResponse payload) {
            return payload.getFederationsList() == null ? ImmutableList.of() : payload.getFederationsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListFederationsRequest, ListFederationsResponse, DataprocMetastoreFederationClient.ListFederationsPagedResponse> LIST_FEDERATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListFederationsRequest, ListFederationsResponse, DataprocMetastoreFederationClient.ListFederationsPagedResponse>(){

        public ApiFuture<DataprocMetastoreFederationClient.ListFederationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListFederationsRequest, ListFederationsResponse> callable, ListFederationsRequest request, ApiCallContext context, ApiFuture<ListFederationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FEDERATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataprocMetastoreFederationClient.ListFederationsPagedResponse.createAsync((PageContext<ListFederationsRequest, ListFederationsResponse, Federation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataprocMetastoreFederationClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataprocMetastoreFederationClient.ListLocationsPagedResponse>(){

        public ApiFuture<DataprocMetastoreFederationClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataprocMetastoreFederationClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListFederationsRequest, ListFederationsResponse, DataprocMetastoreFederationClient.ListFederationsPagedResponse> listFederationsSettings() {
        return this.listFederationsSettings;
    }

    public UnaryCallSettings<GetFederationRequest, Federation> getFederationSettings() {
        return this.getFederationSettings;
    }

    public UnaryCallSettings<CreateFederationRequest, Operation> createFederationSettings() {
        return this.createFederationSettings;
    }

    public OperationCallSettings<CreateFederationRequest, Federation, OperationMetadata> createFederationOperationSettings() {
        return this.createFederationOperationSettings;
    }

    public UnaryCallSettings<UpdateFederationRequest, Operation> updateFederationSettings() {
        return this.updateFederationSettings;
    }

    public OperationCallSettings<UpdateFederationRequest, Federation, OperationMetadata> updateFederationOperationSettings() {
        return this.updateFederationOperationSettings;
    }

    public UnaryCallSettings<DeleteFederationRequest, Operation> deleteFederationSettings() {
        return this.deleteFederationSettings;
    }

    public OperationCallSettings<DeleteFederationRequest, Empty, OperationMetadata> deleteFederationOperationSettings() {
        return this.deleteFederationOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataprocMetastoreFederationClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public DataprocMetastoreFederationStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataprocMetastoreFederationStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDataprocMetastoreFederationStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "metastore";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "metastore.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "metastore.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataprocMetastoreFederationStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataprocMetastoreFederationStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataprocMetastoreFederationStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DataprocMetastoreFederationStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataprocMetastoreFederationStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listFederationsSettings = settingsBuilder.listFederationsSettings().build();
        this.getFederationSettings = settingsBuilder.getFederationSettings().build();
        this.createFederationSettings = settingsBuilder.createFederationSettings().build();
        this.createFederationOperationSettings = settingsBuilder.createFederationOperationSettings().build();
        this.updateFederationSettings = settingsBuilder.updateFederationSettings().build();
        this.updateFederationOperationSettings = settingsBuilder.updateFederationOperationSettings().build();
        this.deleteFederationSettings = settingsBuilder.deleteFederationSettings().build();
        this.deleteFederationOperationSettings = settingsBuilder.deleteFederationOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataprocMetastoreFederationStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListFederationsRequest, ListFederationsResponse, DataprocMetastoreFederationClient.ListFederationsPagedResponse> listFederationsSettings;
        private final UnaryCallSettings.Builder<GetFederationRequest, Federation> getFederationSettings;
        private final UnaryCallSettings.Builder<CreateFederationRequest, Operation> createFederationSettings;
        private final OperationCallSettings.Builder<CreateFederationRequest, Federation, OperationMetadata> createFederationOperationSettings;
        private final UnaryCallSettings.Builder<UpdateFederationRequest, Operation> updateFederationSettings;
        private final OperationCallSettings.Builder<UpdateFederationRequest, Federation, OperationMetadata> updateFederationOperationSettings;
        private final UnaryCallSettings.Builder<DeleteFederationRequest, Operation> deleteFederationSettings;
        private final OperationCallSettings.Builder<DeleteFederationRequest, Empty, OperationMetadata> deleteFederationOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataprocMetastoreFederationClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listFederationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FEDERATIONS_PAGE_STR_FACT);
            this.getFederationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFederationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFederationOperationSettings = OperationCallSettings.newBuilder();
            this.updateFederationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFederationOperationSettings = OperationCallSettings.newBuilder();
            this.deleteFederationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFederationOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listFederationsSettings, this.getFederationSettings, this.createFederationSettings, this.updateFederationSettings, this.deleteFederationSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DataprocMetastoreFederationStubSettings settings) {
            super((StubSettings)settings);
            this.listFederationsSettings = settings.listFederationsSettings.toBuilder();
            this.getFederationSettings = settings.getFederationSettings.toBuilder();
            this.createFederationSettings = settings.createFederationSettings.toBuilder();
            this.createFederationOperationSettings = settings.createFederationOperationSettings.toBuilder();
            this.updateFederationSettings = settings.updateFederationSettings.toBuilder();
            this.updateFederationOperationSettings = settings.updateFederationOperationSettings.toBuilder();
            this.deleteFederationSettings = settings.deleteFederationSettings.toBuilder();
            this.deleteFederationOperationSettings = settings.deleteFederationOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listFederationsSettings, this.getFederationSettings, this.createFederationSettings, this.updateFederationSettings, this.deleteFederationSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataprocMetastoreFederationStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataprocMetastoreFederationStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataprocMetastoreFederationStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DataprocMetastoreFederationStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DataprocMetastoreFederationStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DataprocMetastoreFederationStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DataprocMetastoreFederationStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataprocMetastoreFederationStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DataprocMetastoreFederationStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DataprocMetastoreFederationStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listFederationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getFederationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createFederationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateFederationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteFederationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createFederationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Federation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateFederationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Federation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteFederationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListFederationsRequest, ListFederationsResponse, DataprocMetastoreFederationClient.ListFederationsPagedResponse> listFederationsSettings() {
            return this.listFederationsSettings;
        }

        public UnaryCallSettings.Builder<GetFederationRequest, Federation> getFederationSettings() {
            return this.getFederationSettings;
        }

        public UnaryCallSettings.Builder<CreateFederationRequest, Operation> createFederationSettings() {
            return this.createFederationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateFederationRequest, Federation, OperationMetadata> createFederationOperationSettings() {
            return this.createFederationOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateFederationRequest, Operation> updateFederationSettings() {
            return this.updateFederationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateFederationRequest, Federation, OperationMetadata> updateFederationOperationSettings() {
            return this.updateFederationOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteFederationRequest, Operation> deleteFederationSettings() {
            return this.deleteFederationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteFederationRequest, Empty, OperationMetadata> deleteFederationOperationSettings() {
            return this.deleteFederationOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataprocMetastoreFederationClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public DataprocMetastoreFederationStubSettings build() throws IOException {
            return new DataprocMetastoreFederationStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

