/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.CreateDataScanRequest;
import com.google.cloud.dataplex.v1.DataScan;
import com.google.cloud.dataplex.v1.DataScanJob;
import com.google.cloud.dataplex.v1.DataScanServiceClient;
import com.google.cloud.dataplex.v1.DeleteDataScanRequest;
import com.google.cloud.dataplex.v1.GenerateDataQualityRulesRequest;
import com.google.cloud.dataplex.v1.GenerateDataQualityRulesResponse;
import com.google.cloud.dataplex.v1.GetDataScanJobRequest;
import com.google.cloud.dataplex.v1.GetDataScanRequest;
import com.google.cloud.dataplex.v1.ListDataScanJobsRequest;
import com.google.cloud.dataplex.v1.ListDataScanJobsResponse;
import com.google.cloud.dataplex.v1.ListDataScansRequest;
import com.google.cloud.dataplex.v1.ListDataScansResponse;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.RunDataScanRequest;
import com.google.cloud.dataplex.v1.RunDataScanResponse;
import com.google.cloud.dataplex.v1.UpdateDataScanRequest;
import com.google.cloud.dataplex.v1.stub.DataScanServiceStub;
import com.google.cloud.dataplex.v1.stub.DataScanServiceStubSettings;
import com.google.cloud.dataplex.v1.stub.HttpJsonDataScanServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonDataScanServiceStub
extends DataScanServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(DataScan.getDescriptor()).add(OperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateDataScanRequest, Operation> createDataScanMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.DataScanService/CreateDataScan").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/dataScans", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "dataScanId", (Object)request.getDataScanId());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("dataScan", (Message)request.getDataScan(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateDataScanRequest, Operation> updateDataScanMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.DataScanService/UpdateDataScan").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{dataScan.name=projects/*/locations/*/dataScans/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "dataScan.name", (Object)request.getDataScan().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("dataScan", (Message)request.getDataScan(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteDataScanRequest, Operation> deleteDataScanMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.DataScanService/DeleteDataScan").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/dataScans/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetDataScanRequest, DataScan> getDataScanMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.DataScanService/GetDataScan").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/dataScans/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DataScan.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListDataScansRequest, ListDataScansResponse> listDataScansMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.DataScanService/ListDataScans").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/dataScans", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListDataScansResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RunDataScanRequest, RunDataScanResponse> runDataScanMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.DataScanService/RunDataScan").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/dataScans/*}:run", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RunDataScanResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetDataScanJobRequest, DataScanJob> getDataScanJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.DataScanService/GetDataScanJob").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/dataScans/*/jobs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DataScanJob.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListDataScanJobsRequest, ListDataScanJobsResponse> listDataScanJobsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.DataScanService/ListDataScanJobs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/dataScans/*}/jobs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListDataScanJobsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GenerateDataQualityRulesRequest, GenerateDataQualityRulesResponse> generateDataQualityRulesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.DataScanService/GenerateDataQualityRules").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/dataScans/*}:generateDataQualityRules", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/locations/*/dataScans/*/jobs/*}:generateDataQualityRules"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GenerateDataQualityRulesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateDataScanRequest, Operation> createDataScanCallable;
    private final OperationCallable<CreateDataScanRequest, DataScan, OperationMetadata> createDataScanOperationCallable;
    private final UnaryCallable<UpdateDataScanRequest, Operation> updateDataScanCallable;
    private final OperationCallable<UpdateDataScanRequest, DataScan, OperationMetadata> updateDataScanOperationCallable;
    private final UnaryCallable<DeleteDataScanRequest, Operation> deleteDataScanCallable;
    private final OperationCallable<DeleteDataScanRequest, Empty, OperationMetadata> deleteDataScanOperationCallable;
    private final UnaryCallable<GetDataScanRequest, DataScan> getDataScanCallable;
    private final UnaryCallable<ListDataScansRequest, ListDataScansResponse> listDataScansCallable;
    private final UnaryCallable<ListDataScansRequest, DataScanServiceClient.ListDataScansPagedResponse> listDataScansPagedCallable;
    private final UnaryCallable<RunDataScanRequest, RunDataScanResponse> runDataScanCallable;
    private final UnaryCallable<GetDataScanJobRequest, DataScanJob> getDataScanJobCallable;
    private final UnaryCallable<ListDataScanJobsRequest, ListDataScanJobsResponse> listDataScanJobsCallable;
    private final UnaryCallable<ListDataScanJobsRequest, DataScanServiceClient.ListDataScanJobsPagedResponse> listDataScanJobsPagedCallable;
    private final UnaryCallable<GenerateDataQualityRulesRequest, GenerateDataQualityRulesResponse> generateDataQualityRulesCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DataScanServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDataScanServiceStub create(DataScanServiceStubSettings settings) throws IOException {
        return new HttpJsonDataScanServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDataScanServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDataScanServiceStub(DataScanServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDataScanServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDataScanServiceStub(DataScanServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDataScanServiceStub(DataScanServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDataScanServiceCallableFactory());
    }

    protected HttpJsonDataScanServiceStub(DataScanServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings createDataScanTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createDataScanMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateDataScanTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateDataScanMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("data_scan.name", String.valueOf(request.getDataScan().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteDataScanTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteDataScanMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getDataScanTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDataScanMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listDataScansTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listDataScansMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings runDataScanTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(runDataScanMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getDataScanJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDataScanJobMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listDataScanJobsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listDataScanJobsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings generateDataQualityRulesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(generateDataQualityRulesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createDataScanCallable = callableFactory.createUnaryCallable(createDataScanTransportSettings, settings.createDataScanSettings(), clientContext);
        this.createDataScanOperationCallable = callableFactory.createOperationCallable(createDataScanTransportSettings, settings.createDataScanOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateDataScanCallable = callableFactory.createUnaryCallable(updateDataScanTransportSettings, settings.updateDataScanSettings(), clientContext);
        this.updateDataScanOperationCallable = callableFactory.createOperationCallable(updateDataScanTransportSettings, settings.updateDataScanOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteDataScanCallable = callableFactory.createUnaryCallable(deleteDataScanTransportSettings, settings.deleteDataScanSettings(), clientContext);
        this.deleteDataScanOperationCallable = callableFactory.createOperationCallable(deleteDataScanTransportSettings, settings.deleteDataScanOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getDataScanCallable = callableFactory.createUnaryCallable(getDataScanTransportSettings, settings.getDataScanSettings(), clientContext);
        this.listDataScansCallable = callableFactory.createUnaryCallable(listDataScansTransportSettings, settings.listDataScansSettings(), clientContext);
        this.listDataScansPagedCallable = callableFactory.createPagedCallable(listDataScansTransportSettings, settings.listDataScansSettings(), clientContext);
        this.runDataScanCallable = callableFactory.createUnaryCallable(runDataScanTransportSettings, settings.runDataScanSettings(), clientContext);
        this.getDataScanJobCallable = callableFactory.createUnaryCallable(getDataScanJobTransportSettings, settings.getDataScanJobSettings(), clientContext);
        this.listDataScanJobsCallable = callableFactory.createUnaryCallable(listDataScanJobsTransportSettings, settings.listDataScanJobsSettings(), clientContext);
        this.listDataScanJobsPagedCallable = callableFactory.createPagedCallable(listDataScanJobsTransportSettings, settings.listDataScanJobsSettings(), clientContext);
        this.generateDataQualityRulesCallable = callableFactory.createUnaryCallable(generateDataQualityRulesTransportSettings, settings.generateDataQualityRulesSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createDataScanMethodDescriptor);
        methodDescriptors.add(updateDataScanMethodDescriptor);
        methodDescriptors.add(deleteDataScanMethodDescriptor);
        methodDescriptors.add(getDataScanMethodDescriptor);
        methodDescriptors.add(listDataScansMethodDescriptor);
        methodDescriptors.add(runDataScanMethodDescriptor);
        methodDescriptors.add(getDataScanJobMethodDescriptor);
        methodDescriptors.add(listDataScanJobsMethodDescriptor);
        methodDescriptors.add(generateDataQualityRulesMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateDataScanRequest, Operation> createDataScanCallable() {
        return this.createDataScanCallable;
    }

    @Override
    public OperationCallable<CreateDataScanRequest, DataScan, OperationMetadata> createDataScanOperationCallable() {
        return this.createDataScanOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateDataScanRequest, Operation> updateDataScanCallable() {
        return this.updateDataScanCallable;
    }

    @Override
    public OperationCallable<UpdateDataScanRequest, DataScan, OperationMetadata> updateDataScanOperationCallable() {
        return this.updateDataScanOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteDataScanRequest, Operation> deleteDataScanCallable() {
        return this.deleteDataScanCallable;
    }

    @Override
    public OperationCallable<DeleteDataScanRequest, Empty, OperationMetadata> deleteDataScanOperationCallable() {
        return this.deleteDataScanOperationCallable;
    }

    @Override
    public UnaryCallable<GetDataScanRequest, DataScan> getDataScanCallable() {
        return this.getDataScanCallable;
    }

    @Override
    public UnaryCallable<ListDataScansRequest, ListDataScansResponse> listDataScansCallable() {
        return this.listDataScansCallable;
    }

    @Override
    public UnaryCallable<ListDataScansRequest, DataScanServiceClient.ListDataScansPagedResponse> listDataScansPagedCallable() {
        return this.listDataScansPagedCallable;
    }

    @Override
    public UnaryCallable<RunDataScanRequest, RunDataScanResponse> runDataScanCallable() {
        return this.runDataScanCallable;
    }

    @Override
    public UnaryCallable<GetDataScanJobRequest, DataScanJob> getDataScanJobCallable() {
        return this.getDataScanJobCallable;
    }

    @Override
    public UnaryCallable<ListDataScanJobsRequest, ListDataScanJobsResponse> listDataScanJobsCallable() {
        return this.listDataScanJobsCallable;
    }

    @Override
    public UnaryCallable<ListDataScanJobsRequest, DataScanServiceClient.ListDataScanJobsPagedResponse> listDataScanJobsPagedCallable() {
        return this.listDataScanJobsPagedCallable;
    }

    @Override
    public UnaryCallable<GenerateDataQualityRulesRequest, GenerateDataQualityRulesResponse> generateDataQualityRulesCallable() {
        return this.generateDataQualityRulesCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DataScanServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

