/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.CreateDataAttributeBindingRequest;
import com.google.cloud.dataplex.v1.CreateDataAttributeRequest;
import com.google.cloud.dataplex.v1.CreateDataTaxonomyRequest;
import com.google.cloud.dataplex.v1.DataAttribute;
import com.google.cloud.dataplex.v1.DataAttributeBinding;
import com.google.cloud.dataplex.v1.DataTaxonomy;
import com.google.cloud.dataplex.v1.DataTaxonomyServiceClient;
import com.google.cloud.dataplex.v1.DeleteDataAttributeBindingRequest;
import com.google.cloud.dataplex.v1.DeleteDataAttributeRequest;
import com.google.cloud.dataplex.v1.DeleteDataTaxonomyRequest;
import com.google.cloud.dataplex.v1.GetDataAttributeBindingRequest;
import com.google.cloud.dataplex.v1.GetDataAttributeRequest;
import com.google.cloud.dataplex.v1.GetDataTaxonomyRequest;
import com.google.cloud.dataplex.v1.ListDataAttributeBindingsRequest;
import com.google.cloud.dataplex.v1.ListDataAttributeBindingsResponse;
import com.google.cloud.dataplex.v1.ListDataAttributesRequest;
import com.google.cloud.dataplex.v1.ListDataAttributesResponse;
import com.google.cloud.dataplex.v1.ListDataTaxonomiesRequest;
import com.google.cloud.dataplex.v1.ListDataTaxonomiesResponse;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.UpdateDataAttributeBindingRequest;
import com.google.cloud.dataplex.v1.UpdateDataAttributeRequest;
import com.google.cloud.dataplex.v1.UpdateDataTaxonomyRequest;
import com.google.cloud.dataplex.v1.stub.DataTaxonomyServiceStub;
import com.google.cloud.dataplex.v1.stub.GrpcDataTaxonomyServiceStub;
import com.google.cloud.dataplex.v1.stub.HttpJsonDataTaxonomyServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class DataTaxonomyServiceStubSettings
extends StubSettings<DataTaxonomyServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateDataTaxonomyRequest, Operation> createDataTaxonomySettings;
    private final OperationCallSettings<CreateDataTaxonomyRequest, DataTaxonomy, OperationMetadata> createDataTaxonomyOperationSettings;
    private final UnaryCallSettings<UpdateDataTaxonomyRequest, Operation> updateDataTaxonomySettings;
    private final OperationCallSettings<UpdateDataTaxonomyRequest, DataTaxonomy, OperationMetadata> updateDataTaxonomyOperationSettings;
    private final UnaryCallSettings<DeleteDataTaxonomyRequest, Operation> deleteDataTaxonomySettings;
    private final OperationCallSettings<DeleteDataTaxonomyRequest, Empty, OperationMetadata> deleteDataTaxonomyOperationSettings;
    private final PagedCallSettings<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomyServiceClient.ListDataTaxonomiesPagedResponse> listDataTaxonomiesSettings;
    private final UnaryCallSettings<GetDataTaxonomyRequest, DataTaxonomy> getDataTaxonomySettings;
    private final UnaryCallSettings<CreateDataAttributeBindingRequest, Operation> createDataAttributeBindingSettings;
    private final OperationCallSettings<CreateDataAttributeBindingRequest, DataAttributeBinding, OperationMetadata> createDataAttributeBindingOperationSettings;
    private final UnaryCallSettings<UpdateDataAttributeBindingRequest, Operation> updateDataAttributeBindingSettings;
    private final OperationCallSettings<UpdateDataAttributeBindingRequest, DataAttributeBinding, OperationMetadata> updateDataAttributeBindingOperationSettings;
    private final UnaryCallSettings<DeleteDataAttributeBindingRequest, Operation> deleteDataAttributeBindingSettings;
    private final OperationCallSettings<DeleteDataAttributeBindingRequest, Empty, OperationMetadata> deleteDataAttributeBindingOperationSettings;
    private final PagedCallSettings<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataTaxonomyServiceClient.ListDataAttributeBindingsPagedResponse> listDataAttributeBindingsSettings;
    private final UnaryCallSettings<GetDataAttributeBindingRequest, DataAttributeBinding> getDataAttributeBindingSettings;
    private final UnaryCallSettings<CreateDataAttributeRequest, Operation> createDataAttributeSettings;
    private final OperationCallSettings<CreateDataAttributeRequest, DataAttribute, OperationMetadata> createDataAttributeOperationSettings;
    private final UnaryCallSettings<UpdateDataAttributeRequest, Operation> updateDataAttributeSettings;
    private final OperationCallSettings<UpdateDataAttributeRequest, DataAttribute, OperationMetadata> updateDataAttributeOperationSettings;
    private final UnaryCallSettings<DeleteDataAttributeRequest, Operation> deleteDataAttributeSettings;
    private final OperationCallSettings<DeleteDataAttributeRequest, Empty, OperationMetadata> deleteDataAttributeOperationSettings;
    private final PagedCallSettings<ListDataAttributesRequest, ListDataAttributesResponse, DataTaxonomyServiceClient.ListDataAttributesPagedResponse> listDataAttributesSettings;
    private final UnaryCallSettings<GetDataAttributeRequest, DataAttribute> getDataAttributeSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataTaxonomyServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomy> LIST_DATA_TAXONOMIES_PAGE_STR_DESC = new PagedListDescriptor<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomy>(){

        public String emptyToken() {
            return "";
        }

        public ListDataTaxonomiesRequest injectToken(ListDataTaxonomiesRequest payload, String token) {
            return ListDataTaxonomiesRequest.newBuilder((ListDataTaxonomiesRequest)payload).setPageToken(token).build();
        }

        public ListDataTaxonomiesRequest injectPageSize(ListDataTaxonomiesRequest payload, int pageSize) {
            return ListDataTaxonomiesRequest.newBuilder((ListDataTaxonomiesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataTaxonomiesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataTaxonomiesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataTaxonomy> extractResources(ListDataTaxonomiesResponse payload) {
            return payload.getDataTaxonomiesList() == null ? ImmutableList.of() : payload.getDataTaxonomiesList();
        }
    };
    private static final PagedListDescriptor<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataAttributeBinding> LIST_DATA_ATTRIBUTE_BINDINGS_PAGE_STR_DESC = new PagedListDescriptor<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataAttributeBinding>(){

        public String emptyToken() {
            return "";
        }

        public ListDataAttributeBindingsRequest injectToken(ListDataAttributeBindingsRequest payload, String token) {
            return ListDataAttributeBindingsRequest.newBuilder((ListDataAttributeBindingsRequest)payload).setPageToken(token).build();
        }

        public ListDataAttributeBindingsRequest injectPageSize(ListDataAttributeBindingsRequest payload, int pageSize) {
            return ListDataAttributeBindingsRequest.newBuilder((ListDataAttributeBindingsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataAttributeBindingsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataAttributeBindingsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataAttributeBinding> extractResources(ListDataAttributeBindingsResponse payload) {
            return payload.getDataAttributeBindingsList() == null ? ImmutableList.of() : payload.getDataAttributeBindingsList();
        }
    };
    private static final PagedListDescriptor<ListDataAttributesRequest, ListDataAttributesResponse, DataAttribute> LIST_DATA_ATTRIBUTES_PAGE_STR_DESC = new PagedListDescriptor<ListDataAttributesRequest, ListDataAttributesResponse, DataAttribute>(){

        public String emptyToken() {
            return "";
        }

        public ListDataAttributesRequest injectToken(ListDataAttributesRequest payload, String token) {
            return ListDataAttributesRequest.newBuilder((ListDataAttributesRequest)payload).setPageToken(token).build();
        }

        public ListDataAttributesRequest injectPageSize(ListDataAttributesRequest payload, int pageSize) {
            return ListDataAttributesRequest.newBuilder((ListDataAttributesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataAttributesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataAttributesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataAttribute> extractResources(ListDataAttributesResponse payload) {
            return payload.getDataAttributesList() == null ? ImmutableList.of() : payload.getDataAttributesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomyServiceClient.ListDataTaxonomiesPagedResponse> LIST_DATA_TAXONOMIES_PAGE_STR_FACT = new PagedListResponseFactory<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomyServiceClient.ListDataTaxonomiesPagedResponse>(){

        public ApiFuture<DataTaxonomyServiceClient.ListDataTaxonomiesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse> callable, ListDataTaxonomiesRequest request, ApiCallContext context, ApiFuture<ListDataTaxonomiesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_TAXONOMIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTaxonomyServiceClient.ListDataTaxonomiesPagedResponse.createAsync((PageContext<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomy>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataTaxonomyServiceClient.ListDataAttributeBindingsPagedResponse> LIST_DATA_ATTRIBUTE_BINDINGS_PAGE_STR_FACT = new PagedListResponseFactory<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataTaxonomyServiceClient.ListDataAttributeBindingsPagedResponse>(){

        public ApiFuture<DataTaxonomyServiceClient.ListDataAttributeBindingsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse> callable, ListDataAttributeBindingsRequest request, ApiCallContext context, ApiFuture<ListDataAttributeBindingsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_ATTRIBUTE_BINDINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTaxonomyServiceClient.ListDataAttributeBindingsPagedResponse.createAsync((PageContext<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataAttributeBinding>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDataAttributesRequest, ListDataAttributesResponse, DataTaxonomyServiceClient.ListDataAttributesPagedResponse> LIST_DATA_ATTRIBUTES_PAGE_STR_FACT = new PagedListResponseFactory<ListDataAttributesRequest, ListDataAttributesResponse, DataTaxonomyServiceClient.ListDataAttributesPagedResponse>(){

        public ApiFuture<DataTaxonomyServiceClient.ListDataAttributesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataAttributesRequest, ListDataAttributesResponse> callable, ListDataAttributesRequest request, ApiCallContext context, ApiFuture<ListDataAttributesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_ATTRIBUTES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTaxonomyServiceClient.ListDataAttributesPagedResponse.createAsync((PageContext<ListDataAttributesRequest, ListDataAttributesResponse, DataAttribute>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataTaxonomyServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataTaxonomyServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<DataTaxonomyServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTaxonomyServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDataTaxonomyRequest, Operation> createDataTaxonomySettings() {
        return this.createDataTaxonomySettings;
    }

    public OperationCallSettings<CreateDataTaxonomyRequest, DataTaxonomy, OperationMetadata> createDataTaxonomyOperationSettings() {
        return this.createDataTaxonomyOperationSettings;
    }

    public UnaryCallSettings<UpdateDataTaxonomyRequest, Operation> updateDataTaxonomySettings() {
        return this.updateDataTaxonomySettings;
    }

    public OperationCallSettings<UpdateDataTaxonomyRequest, DataTaxonomy, OperationMetadata> updateDataTaxonomyOperationSettings() {
        return this.updateDataTaxonomyOperationSettings;
    }

    public UnaryCallSettings<DeleteDataTaxonomyRequest, Operation> deleteDataTaxonomySettings() {
        return this.deleteDataTaxonomySettings;
    }

    public OperationCallSettings<DeleteDataTaxonomyRequest, Empty, OperationMetadata> deleteDataTaxonomyOperationSettings() {
        return this.deleteDataTaxonomyOperationSettings;
    }

    public PagedCallSettings<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomyServiceClient.ListDataTaxonomiesPagedResponse> listDataTaxonomiesSettings() {
        return this.listDataTaxonomiesSettings;
    }

    public UnaryCallSettings<GetDataTaxonomyRequest, DataTaxonomy> getDataTaxonomySettings() {
        return this.getDataTaxonomySettings;
    }

    public UnaryCallSettings<CreateDataAttributeBindingRequest, Operation> createDataAttributeBindingSettings() {
        return this.createDataAttributeBindingSettings;
    }

    public OperationCallSettings<CreateDataAttributeBindingRequest, DataAttributeBinding, OperationMetadata> createDataAttributeBindingOperationSettings() {
        return this.createDataAttributeBindingOperationSettings;
    }

    public UnaryCallSettings<UpdateDataAttributeBindingRequest, Operation> updateDataAttributeBindingSettings() {
        return this.updateDataAttributeBindingSettings;
    }

    public OperationCallSettings<UpdateDataAttributeBindingRequest, DataAttributeBinding, OperationMetadata> updateDataAttributeBindingOperationSettings() {
        return this.updateDataAttributeBindingOperationSettings;
    }

    public UnaryCallSettings<DeleteDataAttributeBindingRequest, Operation> deleteDataAttributeBindingSettings() {
        return this.deleteDataAttributeBindingSettings;
    }

    public OperationCallSettings<DeleteDataAttributeBindingRequest, Empty, OperationMetadata> deleteDataAttributeBindingOperationSettings() {
        return this.deleteDataAttributeBindingOperationSettings;
    }

    public PagedCallSettings<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataTaxonomyServiceClient.ListDataAttributeBindingsPagedResponse> listDataAttributeBindingsSettings() {
        return this.listDataAttributeBindingsSettings;
    }

    public UnaryCallSettings<GetDataAttributeBindingRequest, DataAttributeBinding> getDataAttributeBindingSettings() {
        return this.getDataAttributeBindingSettings;
    }

    public UnaryCallSettings<CreateDataAttributeRequest, Operation> createDataAttributeSettings() {
        return this.createDataAttributeSettings;
    }

    public OperationCallSettings<CreateDataAttributeRequest, DataAttribute, OperationMetadata> createDataAttributeOperationSettings() {
        return this.createDataAttributeOperationSettings;
    }

    public UnaryCallSettings<UpdateDataAttributeRequest, Operation> updateDataAttributeSettings() {
        return this.updateDataAttributeSettings;
    }

    public OperationCallSettings<UpdateDataAttributeRequest, DataAttribute, OperationMetadata> updateDataAttributeOperationSettings() {
        return this.updateDataAttributeOperationSettings;
    }

    public UnaryCallSettings<DeleteDataAttributeRequest, Operation> deleteDataAttributeSettings() {
        return this.deleteDataAttributeSettings;
    }

    public OperationCallSettings<DeleteDataAttributeRequest, Empty, OperationMetadata> deleteDataAttributeOperationSettings() {
        return this.deleteDataAttributeOperationSettings;
    }

    public PagedCallSettings<ListDataAttributesRequest, ListDataAttributesResponse, DataTaxonomyServiceClient.ListDataAttributesPagedResponse> listDataAttributesSettings() {
        return this.listDataAttributesSettings;
    }

    public UnaryCallSettings<GetDataAttributeRequest, DataAttribute> getDataAttributeSettings() {
        return this.getDataAttributeSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataTaxonomyServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public DataTaxonomyServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataTaxonomyServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDataTaxonomyServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return DataTaxonomyServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "dataplex";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dataplex.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dataplex.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataTaxonomyServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataTaxonomyServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataTaxonomyServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DataTaxonomyServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataTaxonomyServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDataTaxonomySettings = settingsBuilder.createDataTaxonomySettings().build();
        this.createDataTaxonomyOperationSettings = settingsBuilder.createDataTaxonomyOperationSettings().build();
        this.updateDataTaxonomySettings = settingsBuilder.updateDataTaxonomySettings().build();
        this.updateDataTaxonomyOperationSettings = settingsBuilder.updateDataTaxonomyOperationSettings().build();
        this.deleteDataTaxonomySettings = settingsBuilder.deleteDataTaxonomySettings().build();
        this.deleteDataTaxonomyOperationSettings = settingsBuilder.deleteDataTaxonomyOperationSettings().build();
        this.listDataTaxonomiesSettings = settingsBuilder.listDataTaxonomiesSettings().build();
        this.getDataTaxonomySettings = settingsBuilder.getDataTaxonomySettings().build();
        this.createDataAttributeBindingSettings = settingsBuilder.createDataAttributeBindingSettings().build();
        this.createDataAttributeBindingOperationSettings = settingsBuilder.createDataAttributeBindingOperationSettings().build();
        this.updateDataAttributeBindingSettings = settingsBuilder.updateDataAttributeBindingSettings().build();
        this.updateDataAttributeBindingOperationSettings = settingsBuilder.updateDataAttributeBindingOperationSettings().build();
        this.deleteDataAttributeBindingSettings = settingsBuilder.deleteDataAttributeBindingSettings().build();
        this.deleteDataAttributeBindingOperationSettings = settingsBuilder.deleteDataAttributeBindingOperationSettings().build();
        this.listDataAttributeBindingsSettings = settingsBuilder.listDataAttributeBindingsSettings().build();
        this.getDataAttributeBindingSettings = settingsBuilder.getDataAttributeBindingSettings().build();
        this.createDataAttributeSettings = settingsBuilder.createDataAttributeSettings().build();
        this.createDataAttributeOperationSettings = settingsBuilder.createDataAttributeOperationSettings().build();
        this.updateDataAttributeSettings = settingsBuilder.updateDataAttributeSettings().build();
        this.updateDataAttributeOperationSettings = settingsBuilder.updateDataAttributeOperationSettings().build();
        this.deleteDataAttributeSettings = settingsBuilder.deleteDataAttributeSettings().build();
        this.deleteDataAttributeOperationSettings = settingsBuilder.deleteDataAttributeOperationSettings().build();
        this.listDataAttributesSettings = settingsBuilder.listDataAttributesSettings().build();
        this.getDataAttributeSettings = settingsBuilder.getDataAttributeSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataTaxonomyServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDataTaxonomyRequest, Operation> createDataTaxonomySettings;
        private final OperationCallSettings.Builder<CreateDataTaxonomyRequest, DataTaxonomy, OperationMetadata> createDataTaxonomyOperationSettings;
        private final UnaryCallSettings.Builder<UpdateDataTaxonomyRequest, Operation> updateDataTaxonomySettings;
        private final OperationCallSettings.Builder<UpdateDataTaxonomyRequest, DataTaxonomy, OperationMetadata> updateDataTaxonomyOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDataTaxonomyRequest, Operation> deleteDataTaxonomySettings;
        private final OperationCallSettings.Builder<DeleteDataTaxonomyRequest, Empty, OperationMetadata> deleteDataTaxonomyOperationSettings;
        private final PagedCallSettings.Builder<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomyServiceClient.ListDataTaxonomiesPagedResponse> listDataTaxonomiesSettings;
        private final UnaryCallSettings.Builder<GetDataTaxonomyRequest, DataTaxonomy> getDataTaxonomySettings;
        private final UnaryCallSettings.Builder<CreateDataAttributeBindingRequest, Operation> createDataAttributeBindingSettings;
        private final OperationCallSettings.Builder<CreateDataAttributeBindingRequest, DataAttributeBinding, OperationMetadata> createDataAttributeBindingOperationSettings;
        private final UnaryCallSettings.Builder<UpdateDataAttributeBindingRequest, Operation> updateDataAttributeBindingSettings;
        private final OperationCallSettings.Builder<UpdateDataAttributeBindingRequest, DataAttributeBinding, OperationMetadata> updateDataAttributeBindingOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDataAttributeBindingRequest, Operation> deleteDataAttributeBindingSettings;
        private final OperationCallSettings.Builder<DeleteDataAttributeBindingRequest, Empty, OperationMetadata> deleteDataAttributeBindingOperationSettings;
        private final PagedCallSettings.Builder<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataTaxonomyServiceClient.ListDataAttributeBindingsPagedResponse> listDataAttributeBindingsSettings;
        private final UnaryCallSettings.Builder<GetDataAttributeBindingRequest, DataAttributeBinding> getDataAttributeBindingSettings;
        private final UnaryCallSettings.Builder<CreateDataAttributeRequest, Operation> createDataAttributeSettings;
        private final OperationCallSettings.Builder<CreateDataAttributeRequest, DataAttribute, OperationMetadata> createDataAttributeOperationSettings;
        private final UnaryCallSettings.Builder<UpdateDataAttributeRequest, Operation> updateDataAttributeSettings;
        private final OperationCallSettings.Builder<UpdateDataAttributeRequest, DataAttribute, OperationMetadata> updateDataAttributeOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDataAttributeRequest, Operation> deleteDataAttributeSettings;
        private final OperationCallSettings.Builder<DeleteDataAttributeRequest, Empty, OperationMetadata> deleteDataAttributeOperationSettings;
        private final PagedCallSettings.Builder<ListDataAttributesRequest, ListDataAttributesResponse, DataTaxonomyServiceClient.ListDataAttributesPagedResponse> listDataAttributesSettings;
        private final UnaryCallSettings.Builder<GetDataAttributeRequest, DataAttribute> getDataAttributeSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataTaxonomyServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDataTaxonomySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDataTaxonomyOperationSettings = OperationCallSettings.newBuilder();
            this.updateDataTaxonomySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDataTaxonomyOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDataTaxonomySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDataTaxonomyOperationSettings = OperationCallSettings.newBuilder();
            this.listDataTaxonomiesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_TAXONOMIES_PAGE_STR_FACT);
            this.getDataTaxonomySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDataAttributeBindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDataAttributeBindingOperationSettings = OperationCallSettings.newBuilder();
            this.updateDataAttributeBindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDataAttributeBindingOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDataAttributeBindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDataAttributeBindingOperationSettings = OperationCallSettings.newBuilder();
            this.listDataAttributeBindingsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_ATTRIBUTE_BINDINGS_PAGE_STR_FACT);
            this.getDataAttributeBindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDataAttributeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDataAttributeOperationSettings = OperationCallSettings.newBuilder();
            this.updateDataAttributeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDataAttributeOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDataAttributeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDataAttributeOperationSettings = OperationCallSettings.newBuilder();
            this.listDataAttributesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_ATTRIBUTES_PAGE_STR_FACT);
            this.getDataAttributeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDataTaxonomySettings, this.updateDataTaxonomySettings, this.deleteDataTaxonomySettings, this.listDataTaxonomiesSettings, this.getDataTaxonomySettings, this.createDataAttributeBindingSettings, this.updateDataAttributeBindingSettings, this.deleteDataAttributeBindingSettings, this.listDataAttributeBindingsSettings, this.getDataAttributeBindingSettings, this.createDataAttributeSettings, this.updateDataAttributeSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteDataAttributeSettings, this.listDataAttributesSettings, this.getDataAttributeSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DataTaxonomyServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createDataTaxonomySettings = settings.createDataTaxonomySettings.toBuilder();
            this.createDataTaxonomyOperationSettings = settings.createDataTaxonomyOperationSettings.toBuilder();
            this.updateDataTaxonomySettings = settings.updateDataTaxonomySettings.toBuilder();
            this.updateDataTaxonomyOperationSettings = settings.updateDataTaxonomyOperationSettings.toBuilder();
            this.deleteDataTaxonomySettings = settings.deleteDataTaxonomySettings.toBuilder();
            this.deleteDataTaxonomyOperationSettings = settings.deleteDataTaxonomyOperationSettings.toBuilder();
            this.listDataTaxonomiesSettings = settings.listDataTaxonomiesSettings.toBuilder();
            this.getDataTaxonomySettings = settings.getDataTaxonomySettings.toBuilder();
            this.createDataAttributeBindingSettings = settings.createDataAttributeBindingSettings.toBuilder();
            this.createDataAttributeBindingOperationSettings = settings.createDataAttributeBindingOperationSettings.toBuilder();
            this.updateDataAttributeBindingSettings = settings.updateDataAttributeBindingSettings.toBuilder();
            this.updateDataAttributeBindingOperationSettings = settings.updateDataAttributeBindingOperationSettings.toBuilder();
            this.deleteDataAttributeBindingSettings = settings.deleteDataAttributeBindingSettings.toBuilder();
            this.deleteDataAttributeBindingOperationSettings = settings.deleteDataAttributeBindingOperationSettings.toBuilder();
            this.listDataAttributeBindingsSettings = settings.listDataAttributeBindingsSettings.toBuilder();
            this.getDataAttributeBindingSettings = settings.getDataAttributeBindingSettings.toBuilder();
            this.createDataAttributeSettings = settings.createDataAttributeSettings.toBuilder();
            this.createDataAttributeOperationSettings = settings.createDataAttributeOperationSettings.toBuilder();
            this.updateDataAttributeSettings = settings.updateDataAttributeSettings.toBuilder();
            this.updateDataAttributeOperationSettings = settings.updateDataAttributeOperationSettings.toBuilder();
            this.deleteDataAttributeSettings = settings.deleteDataAttributeSettings.toBuilder();
            this.deleteDataAttributeOperationSettings = settings.deleteDataAttributeOperationSettings.toBuilder();
            this.listDataAttributesSettings = settings.listDataAttributesSettings.toBuilder();
            this.getDataAttributeSettings = settings.getDataAttributeSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDataTaxonomySettings, this.updateDataTaxonomySettings, this.deleteDataTaxonomySettings, this.listDataTaxonomiesSettings, this.getDataTaxonomySettings, this.createDataAttributeBindingSettings, this.updateDataAttributeBindingSettings, this.deleteDataAttributeBindingSettings, this.listDataAttributeBindingsSettings, this.getDataAttributeBindingSettings, this.createDataAttributeSettings, this.updateDataAttributeSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteDataAttributeSettings, this.listDataAttributesSettings, this.getDataAttributeSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataTaxonomyServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataTaxonomyServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataTaxonomyServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataTaxonomyServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DataTaxonomyServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DataTaxonomyServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataTaxonomyServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataTaxonomyServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDataTaxonomySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateDataTaxonomySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteDataTaxonomySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDataTaxonomiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDataTaxonomySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createDataAttributeBindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateDataAttributeBindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteDataAttributeBindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDataAttributeBindingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDataAttributeBindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createDataAttributeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateDataAttributeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteDataAttributeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDataAttributesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDataAttributeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createDataTaxonomyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DataTaxonomy.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateDataTaxonomyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DataTaxonomy.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDataTaxonomyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createDataAttributeBindingOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DataAttributeBinding.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateDataAttributeBindingOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DataAttributeBinding.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDataAttributeBindingOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createDataAttributeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DataAttribute.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateDataAttributeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DataAttribute.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDataAttributeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDataTaxonomyRequest, Operation> createDataTaxonomySettings() {
            return this.createDataTaxonomySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateDataTaxonomyRequest, DataTaxonomy, OperationMetadata> createDataTaxonomyOperationSettings() {
            return this.createDataTaxonomyOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateDataTaxonomyRequest, Operation> updateDataTaxonomySettings() {
            return this.updateDataTaxonomySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateDataTaxonomyRequest, DataTaxonomy, OperationMetadata> updateDataTaxonomyOperationSettings() {
            return this.updateDataTaxonomyOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDataTaxonomyRequest, Operation> deleteDataTaxonomySettings() {
            return this.deleteDataTaxonomySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteDataTaxonomyRequest, Empty, OperationMetadata> deleteDataTaxonomyOperationSettings() {
            return this.deleteDataTaxonomyOperationSettings;
        }

        public PagedCallSettings.Builder<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomyServiceClient.ListDataTaxonomiesPagedResponse> listDataTaxonomiesSettings() {
            return this.listDataTaxonomiesSettings;
        }

        public UnaryCallSettings.Builder<GetDataTaxonomyRequest, DataTaxonomy> getDataTaxonomySettings() {
            return this.getDataTaxonomySettings;
        }

        public UnaryCallSettings.Builder<CreateDataAttributeBindingRequest, Operation> createDataAttributeBindingSettings() {
            return this.createDataAttributeBindingSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateDataAttributeBindingRequest, DataAttributeBinding, OperationMetadata> createDataAttributeBindingOperationSettings() {
            return this.createDataAttributeBindingOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateDataAttributeBindingRequest, Operation> updateDataAttributeBindingSettings() {
            return this.updateDataAttributeBindingSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateDataAttributeBindingRequest, DataAttributeBinding, OperationMetadata> updateDataAttributeBindingOperationSettings() {
            return this.updateDataAttributeBindingOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDataAttributeBindingRequest, Operation> deleteDataAttributeBindingSettings() {
            return this.deleteDataAttributeBindingSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteDataAttributeBindingRequest, Empty, OperationMetadata> deleteDataAttributeBindingOperationSettings() {
            return this.deleteDataAttributeBindingOperationSettings;
        }

        public PagedCallSettings.Builder<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataTaxonomyServiceClient.ListDataAttributeBindingsPagedResponse> listDataAttributeBindingsSettings() {
            return this.listDataAttributeBindingsSettings;
        }

        public UnaryCallSettings.Builder<GetDataAttributeBindingRequest, DataAttributeBinding> getDataAttributeBindingSettings() {
            return this.getDataAttributeBindingSettings;
        }

        public UnaryCallSettings.Builder<CreateDataAttributeRequest, Operation> createDataAttributeSettings() {
            return this.createDataAttributeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateDataAttributeRequest, DataAttribute, OperationMetadata> createDataAttributeOperationSettings() {
            return this.createDataAttributeOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateDataAttributeRequest, Operation> updateDataAttributeSettings() {
            return this.updateDataAttributeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateDataAttributeRequest, DataAttribute, OperationMetadata> updateDataAttributeOperationSettings() {
            return this.updateDataAttributeOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDataAttributeRequest, Operation> deleteDataAttributeSettings() {
            return this.deleteDataAttributeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteDataAttributeRequest, Empty, OperationMetadata> deleteDataAttributeOperationSettings() {
            return this.deleteDataAttributeOperationSettings;
        }

        public PagedCallSettings.Builder<ListDataAttributesRequest, ListDataAttributesResponse, DataTaxonomyServiceClient.ListDataAttributesPagedResponse> listDataAttributesSettings() {
            return this.listDataAttributesSettings;
        }

        public UnaryCallSettings.Builder<GetDataAttributeRequest, DataAttribute> getDataAttributeSettings() {
            return this.getDataAttributeSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataTaxonomyServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return DataTaxonomyServiceStubSettings.getDefaultEndpoint();
        }

        public DataTaxonomyServiceStubSettings build() throws IOException {
            return new DataTaxonomyServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

