/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.Action;
import com.google.cloud.dataplex.v1.Asset;
import com.google.cloud.dataplex.v1.CancelJobRequest;
import com.google.cloud.dataplex.v1.CreateAssetRequest;
import com.google.cloud.dataplex.v1.CreateEnvironmentRequest;
import com.google.cloud.dataplex.v1.CreateLakeRequest;
import com.google.cloud.dataplex.v1.CreateTaskRequest;
import com.google.cloud.dataplex.v1.CreateZoneRequest;
import com.google.cloud.dataplex.v1.DataplexServiceClient;
import com.google.cloud.dataplex.v1.DeleteAssetRequest;
import com.google.cloud.dataplex.v1.DeleteEnvironmentRequest;
import com.google.cloud.dataplex.v1.DeleteLakeRequest;
import com.google.cloud.dataplex.v1.DeleteTaskRequest;
import com.google.cloud.dataplex.v1.DeleteZoneRequest;
import com.google.cloud.dataplex.v1.Environment;
import com.google.cloud.dataplex.v1.GetAssetRequest;
import com.google.cloud.dataplex.v1.GetEnvironmentRequest;
import com.google.cloud.dataplex.v1.GetJobRequest;
import com.google.cloud.dataplex.v1.GetLakeRequest;
import com.google.cloud.dataplex.v1.GetTaskRequest;
import com.google.cloud.dataplex.v1.GetZoneRequest;
import com.google.cloud.dataplex.v1.Job;
import com.google.cloud.dataplex.v1.Lake;
import com.google.cloud.dataplex.v1.ListActionsResponse;
import com.google.cloud.dataplex.v1.ListAssetActionsRequest;
import com.google.cloud.dataplex.v1.ListAssetsRequest;
import com.google.cloud.dataplex.v1.ListAssetsResponse;
import com.google.cloud.dataplex.v1.ListEnvironmentsRequest;
import com.google.cloud.dataplex.v1.ListEnvironmentsResponse;
import com.google.cloud.dataplex.v1.ListJobsRequest;
import com.google.cloud.dataplex.v1.ListJobsResponse;
import com.google.cloud.dataplex.v1.ListLakeActionsRequest;
import com.google.cloud.dataplex.v1.ListLakesRequest;
import com.google.cloud.dataplex.v1.ListLakesResponse;
import com.google.cloud.dataplex.v1.ListSessionsRequest;
import com.google.cloud.dataplex.v1.ListSessionsResponse;
import com.google.cloud.dataplex.v1.ListTasksRequest;
import com.google.cloud.dataplex.v1.ListTasksResponse;
import com.google.cloud.dataplex.v1.ListZoneActionsRequest;
import com.google.cloud.dataplex.v1.ListZonesRequest;
import com.google.cloud.dataplex.v1.ListZonesResponse;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.RunTaskRequest;
import com.google.cloud.dataplex.v1.RunTaskResponse;
import com.google.cloud.dataplex.v1.Session;
import com.google.cloud.dataplex.v1.Task;
import com.google.cloud.dataplex.v1.UpdateAssetRequest;
import com.google.cloud.dataplex.v1.UpdateEnvironmentRequest;
import com.google.cloud.dataplex.v1.UpdateLakeRequest;
import com.google.cloud.dataplex.v1.UpdateTaskRequest;
import com.google.cloud.dataplex.v1.UpdateZoneRequest;
import com.google.cloud.dataplex.v1.Zone;
import com.google.cloud.dataplex.v1.stub.DataplexServiceStub;
import com.google.cloud.dataplex.v1.stub.GrpcDataplexServiceStub;
import com.google.cloud.dataplex.v1.stub.HttpJsonDataplexServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class DataplexServiceStubSettings
extends StubSettings<DataplexServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateLakeRequest, Operation> createLakeSettings;
    private final OperationCallSettings<CreateLakeRequest, Lake, OperationMetadata> createLakeOperationSettings;
    private final UnaryCallSettings<UpdateLakeRequest, Operation> updateLakeSettings;
    private final OperationCallSettings<UpdateLakeRequest, Lake, OperationMetadata> updateLakeOperationSettings;
    private final UnaryCallSettings<DeleteLakeRequest, Operation> deleteLakeSettings;
    private final OperationCallSettings<DeleteLakeRequest, Empty, OperationMetadata> deleteLakeOperationSettings;
    private final PagedCallSettings<ListLakesRequest, ListLakesResponse, DataplexServiceClient.ListLakesPagedResponse> listLakesSettings;
    private final UnaryCallSettings<GetLakeRequest, Lake> getLakeSettings;
    private final PagedCallSettings<ListLakeActionsRequest, ListActionsResponse, DataplexServiceClient.ListLakeActionsPagedResponse> listLakeActionsSettings;
    private final UnaryCallSettings<CreateZoneRequest, Operation> createZoneSettings;
    private final OperationCallSettings<CreateZoneRequest, Zone, OperationMetadata> createZoneOperationSettings;
    private final UnaryCallSettings<UpdateZoneRequest, Operation> updateZoneSettings;
    private final OperationCallSettings<UpdateZoneRequest, Zone, OperationMetadata> updateZoneOperationSettings;
    private final UnaryCallSettings<DeleteZoneRequest, Operation> deleteZoneSettings;
    private final OperationCallSettings<DeleteZoneRequest, Empty, OperationMetadata> deleteZoneOperationSettings;
    private final PagedCallSettings<ListZonesRequest, ListZonesResponse, DataplexServiceClient.ListZonesPagedResponse> listZonesSettings;
    private final UnaryCallSettings<GetZoneRequest, Zone> getZoneSettings;
    private final PagedCallSettings<ListZoneActionsRequest, ListActionsResponse, DataplexServiceClient.ListZoneActionsPagedResponse> listZoneActionsSettings;
    private final UnaryCallSettings<CreateAssetRequest, Operation> createAssetSettings;
    private final OperationCallSettings<CreateAssetRequest, Asset, OperationMetadata> createAssetOperationSettings;
    private final UnaryCallSettings<UpdateAssetRequest, Operation> updateAssetSettings;
    private final OperationCallSettings<UpdateAssetRequest, Asset, OperationMetadata> updateAssetOperationSettings;
    private final UnaryCallSettings<DeleteAssetRequest, Operation> deleteAssetSettings;
    private final OperationCallSettings<DeleteAssetRequest, Empty, OperationMetadata> deleteAssetOperationSettings;
    private final PagedCallSettings<ListAssetsRequest, ListAssetsResponse, DataplexServiceClient.ListAssetsPagedResponse> listAssetsSettings;
    private final UnaryCallSettings<GetAssetRequest, Asset> getAssetSettings;
    private final PagedCallSettings<ListAssetActionsRequest, ListActionsResponse, DataplexServiceClient.ListAssetActionsPagedResponse> listAssetActionsSettings;
    private final UnaryCallSettings<CreateTaskRequest, Operation> createTaskSettings;
    private final OperationCallSettings<CreateTaskRequest, Task, OperationMetadata> createTaskOperationSettings;
    private final UnaryCallSettings<UpdateTaskRequest, Operation> updateTaskSettings;
    private final OperationCallSettings<UpdateTaskRequest, Task, OperationMetadata> updateTaskOperationSettings;
    private final UnaryCallSettings<DeleteTaskRequest, Operation> deleteTaskSettings;
    private final OperationCallSettings<DeleteTaskRequest, Empty, OperationMetadata> deleteTaskOperationSettings;
    private final PagedCallSettings<ListTasksRequest, ListTasksResponse, DataplexServiceClient.ListTasksPagedResponse> listTasksSettings;
    private final UnaryCallSettings<GetTaskRequest, Task> getTaskSettings;
    private final PagedCallSettings<ListJobsRequest, ListJobsResponse, DataplexServiceClient.ListJobsPagedResponse> listJobsSettings;
    private final UnaryCallSettings<RunTaskRequest, RunTaskResponse> runTaskSettings;
    private final UnaryCallSettings<GetJobRequest, Job> getJobSettings;
    private final UnaryCallSettings<CancelJobRequest, Empty> cancelJobSettings;
    private final UnaryCallSettings<CreateEnvironmentRequest, Operation> createEnvironmentSettings;
    private final OperationCallSettings<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings;
    private final UnaryCallSettings<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings;
    private final OperationCallSettings<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationSettings;
    private final UnaryCallSettings<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings;
    private final OperationCallSettings<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings;
    private final PagedCallSettings<ListEnvironmentsRequest, ListEnvironmentsResponse, DataplexServiceClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings;
    private final UnaryCallSettings<GetEnvironmentRequest, Environment> getEnvironmentSettings;
    private final PagedCallSettings<ListSessionsRequest, ListSessionsResponse, DataplexServiceClient.ListSessionsPagedResponse> listSessionsSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataplexServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListLakesRequest, ListLakesResponse, Lake> LIST_LAKES_PAGE_STR_DESC = new PagedListDescriptor<ListLakesRequest, ListLakesResponse, Lake>(){

        public String emptyToken() {
            return "";
        }

        public ListLakesRequest injectToken(ListLakesRequest payload, String token) {
            return ListLakesRequest.newBuilder((ListLakesRequest)payload).setPageToken(token).build();
        }

        public ListLakesRequest injectPageSize(ListLakesRequest payload, int pageSize) {
            return ListLakesRequest.newBuilder((ListLakesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLakesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLakesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Lake> extractResources(ListLakesResponse payload) {
            return payload.getLakesList() == null ? ImmutableList.of() : payload.getLakesList();
        }
    };
    private static final PagedListDescriptor<ListLakeActionsRequest, ListActionsResponse, Action> LIST_LAKE_ACTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLakeActionsRequest, ListActionsResponse, Action>(){

        public String emptyToken() {
            return "";
        }

        public ListLakeActionsRequest injectToken(ListLakeActionsRequest payload, String token) {
            return ListLakeActionsRequest.newBuilder((ListLakeActionsRequest)payload).setPageToken(token).build();
        }

        public ListLakeActionsRequest injectPageSize(ListLakeActionsRequest payload, int pageSize) {
            return ListLakeActionsRequest.newBuilder((ListLakeActionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLakeActionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListActionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Action> extractResources(ListActionsResponse payload) {
            return payload.getActionsList() == null ? ImmutableList.of() : payload.getActionsList();
        }
    };
    private static final PagedListDescriptor<ListZonesRequest, ListZonesResponse, Zone> LIST_ZONES_PAGE_STR_DESC = new PagedListDescriptor<ListZonesRequest, ListZonesResponse, Zone>(){

        public String emptyToken() {
            return "";
        }

        public ListZonesRequest injectToken(ListZonesRequest payload, String token) {
            return ListZonesRequest.newBuilder((ListZonesRequest)payload).setPageToken(token).build();
        }

        public ListZonesRequest injectPageSize(ListZonesRequest payload, int pageSize) {
            return ListZonesRequest.newBuilder((ListZonesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListZonesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListZonesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Zone> extractResources(ListZonesResponse payload) {
            return payload.getZonesList() == null ? ImmutableList.of() : payload.getZonesList();
        }
    };
    private static final PagedListDescriptor<ListZoneActionsRequest, ListActionsResponse, Action> LIST_ZONE_ACTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListZoneActionsRequest, ListActionsResponse, Action>(){

        public String emptyToken() {
            return "";
        }

        public ListZoneActionsRequest injectToken(ListZoneActionsRequest payload, String token) {
            return ListZoneActionsRequest.newBuilder((ListZoneActionsRequest)payload).setPageToken(token).build();
        }

        public ListZoneActionsRequest injectPageSize(ListZoneActionsRequest payload, int pageSize) {
            return ListZoneActionsRequest.newBuilder((ListZoneActionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListZoneActionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListActionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Action> extractResources(ListActionsResponse payload) {
            return payload.getActionsList() == null ? ImmutableList.of() : payload.getActionsList();
        }
    };
    private static final PagedListDescriptor<ListAssetsRequest, ListAssetsResponse, Asset> LIST_ASSETS_PAGE_STR_DESC = new PagedListDescriptor<ListAssetsRequest, ListAssetsResponse, Asset>(){

        public String emptyToken() {
            return "";
        }

        public ListAssetsRequest injectToken(ListAssetsRequest payload, String token) {
            return ListAssetsRequest.newBuilder((ListAssetsRequest)payload).setPageToken(token).build();
        }

        public ListAssetsRequest injectPageSize(ListAssetsRequest payload, int pageSize) {
            return ListAssetsRequest.newBuilder((ListAssetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAssetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAssetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Asset> extractResources(ListAssetsResponse payload) {
            return payload.getAssetsList() == null ? ImmutableList.of() : payload.getAssetsList();
        }
    };
    private static final PagedListDescriptor<ListAssetActionsRequest, ListActionsResponse, Action> LIST_ASSET_ACTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListAssetActionsRequest, ListActionsResponse, Action>(){

        public String emptyToken() {
            return "";
        }

        public ListAssetActionsRequest injectToken(ListAssetActionsRequest payload, String token) {
            return ListAssetActionsRequest.newBuilder((ListAssetActionsRequest)payload).setPageToken(token).build();
        }

        public ListAssetActionsRequest injectPageSize(ListAssetActionsRequest payload, int pageSize) {
            return ListAssetActionsRequest.newBuilder((ListAssetActionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAssetActionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListActionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Action> extractResources(ListActionsResponse payload) {
            return payload.getActionsList() == null ? ImmutableList.of() : payload.getActionsList();
        }
    };
    private static final PagedListDescriptor<ListTasksRequest, ListTasksResponse, Task> LIST_TASKS_PAGE_STR_DESC = new PagedListDescriptor<ListTasksRequest, ListTasksResponse, Task>(){

        public String emptyToken() {
            return "";
        }

        public ListTasksRequest injectToken(ListTasksRequest payload, String token) {
            return ListTasksRequest.newBuilder((ListTasksRequest)payload).setPageToken(token).build();
        }

        public ListTasksRequest injectPageSize(ListTasksRequest payload, int pageSize) {
            return ListTasksRequest.newBuilder((ListTasksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTasksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTasksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Task> extractResources(ListTasksResponse payload) {
            return payload.getTasksList() == null ? ImmutableList.of() : payload.getTasksList();
        }
    };
    private static final PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job> LIST_JOBS_PAGE_STR_DESC = new PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job>(){

        public String emptyToken() {
            return "";
        }

        public ListJobsRequest injectToken(ListJobsRequest payload, String token) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageToken(token).build();
        }

        public ListJobsRequest injectPageSize(ListJobsRequest payload, int pageSize) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Job> extractResources(ListJobsResponse payload) {
            return payload.getJobsList() == null ? ImmutableList.of() : payload.getJobsList();
        }
    };
    private static final PagedListDescriptor<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> LIST_ENVIRONMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment>(){

        public String emptyToken() {
            return "";
        }

        public ListEnvironmentsRequest injectToken(ListEnvironmentsRequest payload, String token) {
            return ListEnvironmentsRequest.newBuilder((ListEnvironmentsRequest)payload).setPageToken(token).build();
        }

        public ListEnvironmentsRequest injectPageSize(ListEnvironmentsRequest payload, int pageSize) {
            return ListEnvironmentsRequest.newBuilder((ListEnvironmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEnvironmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEnvironmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Environment> extractResources(ListEnvironmentsResponse payload) {
            return payload.getEnvironmentsList() == null ? ImmutableList.of() : payload.getEnvironmentsList();
        }
    };
    private static final PagedListDescriptor<ListSessionsRequest, ListSessionsResponse, Session> LIST_SESSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSessionsRequest, ListSessionsResponse, Session>(){

        public String emptyToken() {
            return "";
        }

        public ListSessionsRequest injectToken(ListSessionsRequest payload, String token) {
            return ListSessionsRequest.newBuilder((ListSessionsRequest)payload).setPageToken(token).build();
        }

        public ListSessionsRequest injectPageSize(ListSessionsRequest payload, int pageSize) {
            return ListSessionsRequest.newBuilder((ListSessionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSessionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSessionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Session> extractResources(ListSessionsResponse payload) {
            return payload.getSessionsList() == null ? ImmutableList.of() : payload.getSessionsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListLakesRequest, ListLakesResponse, DataplexServiceClient.ListLakesPagedResponse> LIST_LAKES_PAGE_STR_FACT = new PagedListResponseFactory<ListLakesRequest, ListLakesResponse, DataplexServiceClient.ListLakesPagedResponse>(){

        public ApiFuture<DataplexServiceClient.ListLakesPagedResponse> getFuturePagedResponse(UnaryCallable<ListLakesRequest, ListLakesResponse> callable, ListLakesRequest request, ApiCallContext context, ApiFuture<ListLakesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LAKES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataplexServiceClient.ListLakesPagedResponse.createAsync((PageContext<ListLakesRequest, ListLakesResponse, Lake>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLakeActionsRequest, ListActionsResponse, DataplexServiceClient.ListLakeActionsPagedResponse> LIST_LAKE_ACTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLakeActionsRequest, ListActionsResponse, DataplexServiceClient.ListLakeActionsPagedResponse>(){

        public ApiFuture<DataplexServiceClient.ListLakeActionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLakeActionsRequest, ListActionsResponse> callable, ListLakeActionsRequest request, ApiCallContext context, ApiFuture<ListActionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LAKE_ACTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataplexServiceClient.ListLakeActionsPagedResponse.createAsync((PageContext<ListLakeActionsRequest, ListActionsResponse, Action>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListZonesRequest, ListZonesResponse, DataplexServiceClient.ListZonesPagedResponse> LIST_ZONES_PAGE_STR_FACT = new PagedListResponseFactory<ListZonesRequest, ListZonesResponse, DataplexServiceClient.ListZonesPagedResponse>(){

        public ApiFuture<DataplexServiceClient.ListZonesPagedResponse> getFuturePagedResponse(UnaryCallable<ListZonesRequest, ListZonesResponse> callable, ListZonesRequest request, ApiCallContext context, ApiFuture<ListZonesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ZONES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataplexServiceClient.ListZonesPagedResponse.createAsync((PageContext<ListZonesRequest, ListZonesResponse, Zone>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListZoneActionsRequest, ListActionsResponse, DataplexServiceClient.ListZoneActionsPagedResponse> LIST_ZONE_ACTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListZoneActionsRequest, ListActionsResponse, DataplexServiceClient.ListZoneActionsPagedResponse>(){

        public ApiFuture<DataplexServiceClient.ListZoneActionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListZoneActionsRequest, ListActionsResponse> callable, ListZoneActionsRequest request, ApiCallContext context, ApiFuture<ListActionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ZONE_ACTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataplexServiceClient.ListZoneActionsPagedResponse.createAsync((PageContext<ListZoneActionsRequest, ListActionsResponse, Action>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAssetsRequest, ListAssetsResponse, DataplexServiceClient.ListAssetsPagedResponse> LIST_ASSETS_PAGE_STR_FACT = new PagedListResponseFactory<ListAssetsRequest, ListAssetsResponse, DataplexServiceClient.ListAssetsPagedResponse>(){

        public ApiFuture<DataplexServiceClient.ListAssetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAssetsRequest, ListAssetsResponse> callable, ListAssetsRequest request, ApiCallContext context, ApiFuture<ListAssetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ASSETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataplexServiceClient.ListAssetsPagedResponse.createAsync((PageContext<ListAssetsRequest, ListAssetsResponse, Asset>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAssetActionsRequest, ListActionsResponse, DataplexServiceClient.ListAssetActionsPagedResponse> LIST_ASSET_ACTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListAssetActionsRequest, ListActionsResponse, DataplexServiceClient.ListAssetActionsPagedResponse>(){

        public ApiFuture<DataplexServiceClient.ListAssetActionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAssetActionsRequest, ListActionsResponse> callable, ListAssetActionsRequest request, ApiCallContext context, ApiFuture<ListActionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ASSET_ACTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataplexServiceClient.ListAssetActionsPagedResponse.createAsync((PageContext<ListAssetActionsRequest, ListActionsResponse, Action>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTasksRequest, ListTasksResponse, DataplexServiceClient.ListTasksPagedResponse> LIST_TASKS_PAGE_STR_FACT = new PagedListResponseFactory<ListTasksRequest, ListTasksResponse, DataplexServiceClient.ListTasksPagedResponse>(){

        public ApiFuture<DataplexServiceClient.ListTasksPagedResponse> getFuturePagedResponse(UnaryCallable<ListTasksRequest, ListTasksResponse> callable, ListTasksRequest request, ApiCallContext context, ApiFuture<ListTasksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TASKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataplexServiceClient.ListTasksPagedResponse.createAsync((PageContext<ListTasksRequest, ListTasksResponse, Task>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListJobsRequest, ListJobsResponse, DataplexServiceClient.ListJobsPagedResponse> LIST_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<ListJobsRequest, ListJobsResponse, DataplexServiceClient.ListJobsPagedResponse>(){

        public ApiFuture<DataplexServiceClient.ListJobsPagedResponse> getFuturePagedResponse(UnaryCallable<ListJobsRequest, ListJobsResponse> callable, ListJobsRequest request, ApiCallContext context, ApiFuture<ListJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataplexServiceClient.ListJobsPagedResponse.createAsync((PageContext<ListJobsRequest, ListJobsResponse, Job>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEnvironmentsRequest, ListEnvironmentsResponse, DataplexServiceClient.ListEnvironmentsPagedResponse> LIST_ENVIRONMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEnvironmentsRequest, ListEnvironmentsResponse, DataplexServiceClient.ListEnvironmentsPagedResponse>(){

        public ApiFuture<DataplexServiceClient.ListEnvironmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> callable, ListEnvironmentsRequest request, ApiCallContext context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENVIRONMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataplexServiceClient.ListEnvironmentsPagedResponse.createAsync((PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSessionsRequest, ListSessionsResponse, DataplexServiceClient.ListSessionsPagedResponse> LIST_SESSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSessionsRequest, ListSessionsResponse, DataplexServiceClient.ListSessionsPagedResponse>(){

        public ApiFuture<DataplexServiceClient.ListSessionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSessionsRequest, ListSessionsResponse> callable, ListSessionsRequest request, ApiCallContext context, ApiFuture<ListSessionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SESSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataplexServiceClient.ListSessionsPagedResponse.createAsync((PageContext<ListSessionsRequest, ListSessionsResponse, Session>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataplexServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataplexServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<DataplexServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataplexServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateLakeRequest, Operation> createLakeSettings() {
        return this.createLakeSettings;
    }

    public OperationCallSettings<CreateLakeRequest, Lake, OperationMetadata> createLakeOperationSettings() {
        return this.createLakeOperationSettings;
    }

    public UnaryCallSettings<UpdateLakeRequest, Operation> updateLakeSettings() {
        return this.updateLakeSettings;
    }

    public OperationCallSettings<UpdateLakeRequest, Lake, OperationMetadata> updateLakeOperationSettings() {
        return this.updateLakeOperationSettings;
    }

    public UnaryCallSettings<DeleteLakeRequest, Operation> deleteLakeSettings() {
        return this.deleteLakeSettings;
    }

    public OperationCallSettings<DeleteLakeRequest, Empty, OperationMetadata> deleteLakeOperationSettings() {
        return this.deleteLakeOperationSettings;
    }

    public PagedCallSettings<ListLakesRequest, ListLakesResponse, DataplexServiceClient.ListLakesPagedResponse> listLakesSettings() {
        return this.listLakesSettings;
    }

    public UnaryCallSettings<GetLakeRequest, Lake> getLakeSettings() {
        return this.getLakeSettings;
    }

    public PagedCallSettings<ListLakeActionsRequest, ListActionsResponse, DataplexServiceClient.ListLakeActionsPagedResponse> listLakeActionsSettings() {
        return this.listLakeActionsSettings;
    }

    public UnaryCallSettings<CreateZoneRequest, Operation> createZoneSettings() {
        return this.createZoneSettings;
    }

    public OperationCallSettings<CreateZoneRequest, Zone, OperationMetadata> createZoneOperationSettings() {
        return this.createZoneOperationSettings;
    }

    public UnaryCallSettings<UpdateZoneRequest, Operation> updateZoneSettings() {
        return this.updateZoneSettings;
    }

    public OperationCallSettings<UpdateZoneRequest, Zone, OperationMetadata> updateZoneOperationSettings() {
        return this.updateZoneOperationSettings;
    }

    public UnaryCallSettings<DeleteZoneRequest, Operation> deleteZoneSettings() {
        return this.deleteZoneSettings;
    }

    public OperationCallSettings<DeleteZoneRequest, Empty, OperationMetadata> deleteZoneOperationSettings() {
        return this.deleteZoneOperationSettings;
    }

    public PagedCallSettings<ListZonesRequest, ListZonesResponse, DataplexServiceClient.ListZonesPagedResponse> listZonesSettings() {
        return this.listZonesSettings;
    }

    public UnaryCallSettings<GetZoneRequest, Zone> getZoneSettings() {
        return this.getZoneSettings;
    }

    public PagedCallSettings<ListZoneActionsRequest, ListActionsResponse, DataplexServiceClient.ListZoneActionsPagedResponse> listZoneActionsSettings() {
        return this.listZoneActionsSettings;
    }

    public UnaryCallSettings<CreateAssetRequest, Operation> createAssetSettings() {
        return this.createAssetSettings;
    }

    public OperationCallSettings<CreateAssetRequest, Asset, OperationMetadata> createAssetOperationSettings() {
        return this.createAssetOperationSettings;
    }

    public UnaryCallSettings<UpdateAssetRequest, Operation> updateAssetSettings() {
        return this.updateAssetSettings;
    }

    public OperationCallSettings<UpdateAssetRequest, Asset, OperationMetadata> updateAssetOperationSettings() {
        return this.updateAssetOperationSettings;
    }

    public UnaryCallSettings<DeleteAssetRequest, Operation> deleteAssetSettings() {
        return this.deleteAssetSettings;
    }

    public OperationCallSettings<DeleteAssetRequest, Empty, OperationMetadata> deleteAssetOperationSettings() {
        return this.deleteAssetOperationSettings;
    }

    public PagedCallSettings<ListAssetsRequest, ListAssetsResponse, DataplexServiceClient.ListAssetsPagedResponse> listAssetsSettings() {
        return this.listAssetsSettings;
    }

    public UnaryCallSettings<GetAssetRequest, Asset> getAssetSettings() {
        return this.getAssetSettings;
    }

    public PagedCallSettings<ListAssetActionsRequest, ListActionsResponse, DataplexServiceClient.ListAssetActionsPagedResponse> listAssetActionsSettings() {
        return this.listAssetActionsSettings;
    }

    public UnaryCallSettings<CreateTaskRequest, Operation> createTaskSettings() {
        return this.createTaskSettings;
    }

    public OperationCallSettings<CreateTaskRequest, Task, OperationMetadata> createTaskOperationSettings() {
        return this.createTaskOperationSettings;
    }

    public UnaryCallSettings<UpdateTaskRequest, Operation> updateTaskSettings() {
        return this.updateTaskSettings;
    }

    public OperationCallSettings<UpdateTaskRequest, Task, OperationMetadata> updateTaskOperationSettings() {
        return this.updateTaskOperationSettings;
    }

    public UnaryCallSettings<DeleteTaskRequest, Operation> deleteTaskSettings() {
        return this.deleteTaskSettings;
    }

    public OperationCallSettings<DeleteTaskRequest, Empty, OperationMetadata> deleteTaskOperationSettings() {
        return this.deleteTaskOperationSettings;
    }

    public PagedCallSettings<ListTasksRequest, ListTasksResponse, DataplexServiceClient.ListTasksPagedResponse> listTasksSettings() {
        return this.listTasksSettings;
    }

    public UnaryCallSettings<GetTaskRequest, Task> getTaskSettings() {
        return this.getTaskSettings;
    }

    public PagedCallSettings<ListJobsRequest, ListJobsResponse, DataplexServiceClient.ListJobsPagedResponse> listJobsSettings() {
        return this.listJobsSettings;
    }

    public UnaryCallSettings<RunTaskRequest, RunTaskResponse> runTaskSettings() {
        return this.runTaskSettings;
    }

    public UnaryCallSettings<GetJobRequest, Job> getJobSettings() {
        return this.getJobSettings;
    }

    public UnaryCallSettings<CancelJobRequest, Empty> cancelJobSettings() {
        return this.cancelJobSettings;
    }

    public UnaryCallSettings<CreateEnvironmentRequest, Operation> createEnvironmentSettings() {
        return this.createEnvironmentSettings;
    }

    public OperationCallSettings<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings() {
        return this.createEnvironmentOperationSettings;
    }

    public UnaryCallSettings<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings() {
        return this.updateEnvironmentSettings;
    }

    public OperationCallSettings<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationSettings() {
        return this.updateEnvironmentOperationSettings;
    }

    public UnaryCallSettings<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings() {
        return this.deleteEnvironmentSettings;
    }

    public OperationCallSettings<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings() {
        return this.deleteEnvironmentOperationSettings;
    }

    public PagedCallSettings<ListEnvironmentsRequest, ListEnvironmentsResponse, DataplexServiceClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings() {
        return this.listEnvironmentsSettings;
    }

    public UnaryCallSettings<GetEnvironmentRequest, Environment> getEnvironmentSettings() {
        return this.getEnvironmentSettings;
    }

    public PagedCallSettings<ListSessionsRequest, ListSessionsResponse, DataplexServiceClient.ListSessionsPagedResponse> listSessionsSettings() {
        return this.listSessionsSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataplexServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public DataplexServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataplexServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDataplexServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dataplex.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dataplex.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataplexServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataplexServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataplexServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DataplexServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataplexServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createLakeSettings = settingsBuilder.createLakeSettings().build();
        this.createLakeOperationSettings = settingsBuilder.createLakeOperationSettings().build();
        this.updateLakeSettings = settingsBuilder.updateLakeSettings().build();
        this.updateLakeOperationSettings = settingsBuilder.updateLakeOperationSettings().build();
        this.deleteLakeSettings = settingsBuilder.deleteLakeSettings().build();
        this.deleteLakeOperationSettings = settingsBuilder.deleteLakeOperationSettings().build();
        this.listLakesSettings = settingsBuilder.listLakesSettings().build();
        this.getLakeSettings = settingsBuilder.getLakeSettings().build();
        this.listLakeActionsSettings = settingsBuilder.listLakeActionsSettings().build();
        this.createZoneSettings = settingsBuilder.createZoneSettings().build();
        this.createZoneOperationSettings = settingsBuilder.createZoneOperationSettings().build();
        this.updateZoneSettings = settingsBuilder.updateZoneSettings().build();
        this.updateZoneOperationSettings = settingsBuilder.updateZoneOperationSettings().build();
        this.deleteZoneSettings = settingsBuilder.deleteZoneSettings().build();
        this.deleteZoneOperationSettings = settingsBuilder.deleteZoneOperationSettings().build();
        this.listZonesSettings = settingsBuilder.listZonesSettings().build();
        this.getZoneSettings = settingsBuilder.getZoneSettings().build();
        this.listZoneActionsSettings = settingsBuilder.listZoneActionsSettings().build();
        this.createAssetSettings = settingsBuilder.createAssetSettings().build();
        this.createAssetOperationSettings = settingsBuilder.createAssetOperationSettings().build();
        this.updateAssetSettings = settingsBuilder.updateAssetSettings().build();
        this.updateAssetOperationSettings = settingsBuilder.updateAssetOperationSettings().build();
        this.deleteAssetSettings = settingsBuilder.deleteAssetSettings().build();
        this.deleteAssetOperationSettings = settingsBuilder.deleteAssetOperationSettings().build();
        this.listAssetsSettings = settingsBuilder.listAssetsSettings().build();
        this.getAssetSettings = settingsBuilder.getAssetSettings().build();
        this.listAssetActionsSettings = settingsBuilder.listAssetActionsSettings().build();
        this.createTaskSettings = settingsBuilder.createTaskSettings().build();
        this.createTaskOperationSettings = settingsBuilder.createTaskOperationSettings().build();
        this.updateTaskSettings = settingsBuilder.updateTaskSettings().build();
        this.updateTaskOperationSettings = settingsBuilder.updateTaskOperationSettings().build();
        this.deleteTaskSettings = settingsBuilder.deleteTaskSettings().build();
        this.deleteTaskOperationSettings = settingsBuilder.deleteTaskOperationSettings().build();
        this.listTasksSettings = settingsBuilder.listTasksSettings().build();
        this.getTaskSettings = settingsBuilder.getTaskSettings().build();
        this.listJobsSettings = settingsBuilder.listJobsSettings().build();
        this.runTaskSettings = settingsBuilder.runTaskSettings().build();
        this.getJobSettings = settingsBuilder.getJobSettings().build();
        this.cancelJobSettings = settingsBuilder.cancelJobSettings().build();
        this.createEnvironmentSettings = settingsBuilder.createEnvironmentSettings().build();
        this.createEnvironmentOperationSettings = settingsBuilder.createEnvironmentOperationSettings().build();
        this.updateEnvironmentSettings = settingsBuilder.updateEnvironmentSettings().build();
        this.updateEnvironmentOperationSettings = settingsBuilder.updateEnvironmentOperationSettings().build();
        this.deleteEnvironmentSettings = settingsBuilder.deleteEnvironmentSettings().build();
        this.deleteEnvironmentOperationSettings = settingsBuilder.deleteEnvironmentOperationSettings().build();
        this.listEnvironmentsSettings = settingsBuilder.listEnvironmentsSettings().build();
        this.getEnvironmentSettings = settingsBuilder.getEnvironmentSettings().build();
        this.listSessionsSettings = settingsBuilder.listSessionsSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataplexServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateLakeRequest, Operation> createLakeSettings;
        private final OperationCallSettings.Builder<CreateLakeRequest, Lake, OperationMetadata> createLakeOperationSettings;
        private final UnaryCallSettings.Builder<UpdateLakeRequest, Operation> updateLakeSettings;
        private final OperationCallSettings.Builder<UpdateLakeRequest, Lake, OperationMetadata> updateLakeOperationSettings;
        private final UnaryCallSettings.Builder<DeleteLakeRequest, Operation> deleteLakeSettings;
        private final OperationCallSettings.Builder<DeleteLakeRequest, Empty, OperationMetadata> deleteLakeOperationSettings;
        private final PagedCallSettings.Builder<ListLakesRequest, ListLakesResponse, DataplexServiceClient.ListLakesPagedResponse> listLakesSettings;
        private final UnaryCallSettings.Builder<GetLakeRequest, Lake> getLakeSettings;
        private final PagedCallSettings.Builder<ListLakeActionsRequest, ListActionsResponse, DataplexServiceClient.ListLakeActionsPagedResponse> listLakeActionsSettings;
        private final UnaryCallSettings.Builder<CreateZoneRequest, Operation> createZoneSettings;
        private final OperationCallSettings.Builder<CreateZoneRequest, Zone, OperationMetadata> createZoneOperationSettings;
        private final UnaryCallSettings.Builder<UpdateZoneRequest, Operation> updateZoneSettings;
        private final OperationCallSettings.Builder<UpdateZoneRequest, Zone, OperationMetadata> updateZoneOperationSettings;
        private final UnaryCallSettings.Builder<DeleteZoneRequest, Operation> deleteZoneSettings;
        private final OperationCallSettings.Builder<DeleteZoneRequest, Empty, OperationMetadata> deleteZoneOperationSettings;
        private final PagedCallSettings.Builder<ListZonesRequest, ListZonesResponse, DataplexServiceClient.ListZonesPagedResponse> listZonesSettings;
        private final UnaryCallSettings.Builder<GetZoneRequest, Zone> getZoneSettings;
        private final PagedCallSettings.Builder<ListZoneActionsRequest, ListActionsResponse, DataplexServiceClient.ListZoneActionsPagedResponse> listZoneActionsSettings;
        private final UnaryCallSettings.Builder<CreateAssetRequest, Operation> createAssetSettings;
        private final OperationCallSettings.Builder<CreateAssetRequest, Asset, OperationMetadata> createAssetOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAssetRequest, Operation> updateAssetSettings;
        private final OperationCallSettings.Builder<UpdateAssetRequest, Asset, OperationMetadata> updateAssetOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAssetRequest, Operation> deleteAssetSettings;
        private final OperationCallSettings.Builder<DeleteAssetRequest, Empty, OperationMetadata> deleteAssetOperationSettings;
        private final PagedCallSettings.Builder<ListAssetsRequest, ListAssetsResponse, DataplexServiceClient.ListAssetsPagedResponse> listAssetsSettings;
        private final UnaryCallSettings.Builder<GetAssetRequest, Asset> getAssetSettings;
        private final PagedCallSettings.Builder<ListAssetActionsRequest, ListActionsResponse, DataplexServiceClient.ListAssetActionsPagedResponse> listAssetActionsSettings;
        private final UnaryCallSettings.Builder<CreateTaskRequest, Operation> createTaskSettings;
        private final OperationCallSettings.Builder<CreateTaskRequest, Task, OperationMetadata> createTaskOperationSettings;
        private final UnaryCallSettings.Builder<UpdateTaskRequest, Operation> updateTaskSettings;
        private final OperationCallSettings.Builder<UpdateTaskRequest, Task, OperationMetadata> updateTaskOperationSettings;
        private final UnaryCallSettings.Builder<DeleteTaskRequest, Operation> deleteTaskSettings;
        private final OperationCallSettings.Builder<DeleteTaskRequest, Empty, OperationMetadata> deleteTaskOperationSettings;
        private final PagedCallSettings.Builder<ListTasksRequest, ListTasksResponse, DataplexServiceClient.ListTasksPagedResponse> listTasksSettings;
        private final UnaryCallSettings.Builder<GetTaskRequest, Task> getTaskSettings;
        private final PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, DataplexServiceClient.ListJobsPagedResponse> listJobsSettings;
        private final UnaryCallSettings.Builder<RunTaskRequest, RunTaskResponse> runTaskSettings;
        private final UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings;
        private final UnaryCallSettings.Builder<CancelJobRequest, Empty> cancelJobSettings;
        private final UnaryCallSettings.Builder<CreateEnvironmentRequest, Operation> createEnvironmentSettings;
        private final OperationCallSettings.Builder<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings;
        private final UnaryCallSettings.Builder<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings;
        private final OperationCallSettings.Builder<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationSettings;
        private final UnaryCallSettings.Builder<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings;
        private final OperationCallSettings.Builder<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings;
        private final PagedCallSettings.Builder<ListEnvironmentsRequest, ListEnvironmentsResponse, DataplexServiceClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings;
        private final UnaryCallSettings.Builder<GetEnvironmentRequest, Environment> getEnvironmentSettings;
        private final PagedCallSettings.Builder<ListSessionsRequest, ListSessionsResponse, DataplexServiceClient.ListSessionsPagedResponse> listSessionsSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataplexServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createLakeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createLakeOperationSettings = OperationCallSettings.newBuilder();
            this.updateLakeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateLakeOperationSettings = OperationCallSettings.newBuilder();
            this.deleteLakeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteLakeOperationSettings = OperationCallSettings.newBuilder();
            this.listLakesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LAKES_PAGE_STR_FACT);
            this.getLakeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLakeActionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LAKE_ACTIONS_PAGE_STR_FACT);
            this.createZoneSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createZoneOperationSettings = OperationCallSettings.newBuilder();
            this.updateZoneSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateZoneOperationSettings = OperationCallSettings.newBuilder();
            this.deleteZoneSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteZoneOperationSettings = OperationCallSettings.newBuilder();
            this.listZonesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ZONES_PAGE_STR_FACT);
            this.getZoneSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listZoneActionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ZONE_ACTIONS_PAGE_STR_FACT);
            this.createAssetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAssetOperationSettings = OperationCallSettings.newBuilder();
            this.updateAssetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAssetOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAssetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAssetOperationSettings = OperationCallSettings.newBuilder();
            this.listAssetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ASSETS_PAGE_STR_FACT);
            this.getAssetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAssetActionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ASSET_ACTIONS_PAGE_STR_FACT);
            this.createTaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTaskOperationSettings = OperationCallSettings.newBuilder();
            this.updateTaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTaskOperationSettings = OperationCallSettings.newBuilder();
            this.deleteTaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTaskOperationSettings = OperationCallSettings.newBuilder();
            this.listTasksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TASKS_PAGE_STR_FACT);
            this.getTaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_JOBS_PAGE_STR_FACT);
            this.runTaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cancelJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEnvironmentOperationSettings = OperationCallSettings.newBuilder();
            this.updateEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEnvironmentOperationSettings = OperationCallSettings.newBuilder();
            this.deleteEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEnvironmentOperationSettings = OperationCallSettings.newBuilder();
            this.listEnvironmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENVIRONMENTS_PAGE_STR_FACT);
            this.getEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSessionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SESSIONS_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createLakeSettings, this.updateLakeSettings, this.deleteLakeSettings, this.listLakesSettings, this.getLakeSettings, this.listLakeActionsSettings, this.createZoneSettings, this.updateZoneSettings, this.deleteZoneSettings, this.listZonesSettings, this.getZoneSettings, this.listZoneActionsSettings, (Object[])new UnaryCallSettings.Builder[]{this.createAssetSettings, this.updateAssetSettings, this.deleteAssetSettings, this.listAssetsSettings, this.getAssetSettings, this.listAssetActionsSettings, this.createTaskSettings, this.updateTaskSettings, this.deleteTaskSettings, this.listTasksSettings, this.getTaskSettings, this.listJobsSettings, this.runTaskSettings, this.getJobSettings, this.cancelJobSettings, this.createEnvironmentSettings, this.updateEnvironmentSettings, this.deleteEnvironmentSettings, this.listEnvironmentsSettings, this.getEnvironmentSettings, this.listSessionsSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DataplexServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createLakeSettings = settings.createLakeSettings.toBuilder();
            this.createLakeOperationSettings = settings.createLakeOperationSettings.toBuilder();
            this.updateLakeSettings = settings.updateLakeSettings.toBuilder();
            this.updateLakeOperationSettings = settings.updateLakeOperationSettings.toBuilder();
            this.deleteLakeSettings = settings.deleteLakeSettings.toBuilder();
            this.deleteLakeOperationSettings = settings.deleteLakeOperationSettings.toBuilder();
            this.listLakesSettings = settings.listLakesSettings.toBuilder();
            this.getLakeSettings = settings.getLakeSettings.toBuilder();
            this.listLakeActionsSettings = settings.listLakeActionsSettings.toBuilder();
            this.createZoneSettings = settings.createZoneSettings.toBuilder();
            this.createZoneOperationSettings = settings.createZoneOperationSettings.toBuilder();
            this.updateZoneSettings = settings.updateZoneSettings.toBuilder();
            this.updateZoneOperationSettings = settings.updateZoneOperationSettings.toBuilder();
            this.deleteZoneSettings = settings.deleteZoneSettings.toBuilder();
            this.deleteZoneOperationSettings = settings.deleteZoneOperationSettings.toBuilder();
            this.listZonesSettings = settings.listZonesSettings.toBuilder();
            this.getZoneSettings = settings.getZoneSettings.toBuilder();
            this.listZoneActionsSettings = settings.listZoneActionsSettings.toBuilder();
            this.createAssetSettings = settings.createAssetSettings.toBuilder();
            this.createAssetOperationSettings = settings.createAssetOperationSettings.toBuilder();
            this.updateAssetSettings = settings.updateAssetSettings.toBuilder();
            this.updateAssetOperationSettings = settings.updateAssetOperationSettings.toBuilder();
            this.deleteAssetSettings = settings.deleteAssetSettings.toBuilder();
            this.deleteAssetOperationSettings = settings.deleteAssetOperationSettings.toBuilder();
            this.listAssetsSettings = settings.listAssetsSettings.toBuilder();
            this.getAssetSettings = settings.getAssetSettings.toBuilder();
            this.listAssetActionsSettings = settings.listAssetActionsSettings.toBuilder();
            this.createTaskSettings = settings.createTaskSettings.toBuilder();
            this.createTaskOperationSettings = settings.createTaskOperationSettings.toBuilder();
            this.updateTaskSettings = settings.updateTaskSettings.toBuilder();
            this.updateTaskOperationSettings = settings.updateTaskOperationSettings.toBuilder();
            this.deleteTaskSettings = settings.deleteTaskSettings.toBuilder();
            this.deleteTaskOperationSettings = settings.deleteTaskOperationSettings.toBuilder();
            this.listTasksSettings = settings.listTasksSettings.toBuilder();
            this.getTaskSettings = settings.getTaskSettings.toBuilder();
            this.listJobsSettings = settings.listJobsSettings.toBuilder();
            this.runTaskSettings = settings.runTaskSettings.toBuilder();
            this.getJobSettings = settings.getJobSettings.toBuilder();
            this.cancelJobSettings = settings.cancelJobSettings.toBuilder();
            this.createEnvironmentSettings = settings.createEnvironmentSettings.toBuilder();
            this.createEnvironmentOperationSettings = settings.createEnvironmentOperationSettings.toBuilder();
            this.updateEnvironmentSettings = settings.updateEnvironmentSettings.toBuilder();
            this.updateEnvironmentOperationSettings = settings.updateEnvironmentOperationSettings.toBuilder();
            this.deleteEnvironmentSettings = settings.deleteEnvironmentSettings.toBuilder();
            this.deleteEnvironmentOperationSettings = settings.deleteEnvironmentOperationSettings.toBuilder();
            this.listEnvironmentsSettings = settings.listEnvironmentsSettings.toBuilder();
            this.getEnvironmentSettings = settings.getEnvironmentSettings.toBuilder();
            this.listSessionsSettings = settings.listSessionsSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createLakeSettings, this.updateLakeSettings, this.deleteLakeSettings, this.listLakesSettings, this.getLakeSettings, this.listLakeActionsSettings, this.createZoneSettings, this.updateZoneSettings, this.deleteZoneSettings, this.listZonesSettings, this.getZoneSettings, this.listZoneActionsSettings, (Object[])new UnaryCallSettings.Builder[]{this.createAssetSettings, this.updateAssetSettings, this.deleteAssetSettings, this.listAssetsSettings, this.getAssetSettings, this.listAssetActionsSettings, this.createTaskSettings, this.updateTaskSettings, this.deleteTaskSettings, this.listTasksSettings, this.getTaskSettings, this.listJobsSettings, this.runTaskSettings, this.getJobSettings, this.cancelJobSettings, this.createEnvironmentSettings, this.updateEnvironmentSettings, this.deleteEnvironmentSettings, this.listEnvironmentsSettings, this.getEnvironmentSettings, this.listSessionsSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataplexServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataplexServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataplexServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DataplexServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DataplexServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DataplexServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DataplexServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataplexServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DataplexServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DataplexServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createLakeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.updateLakeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.deleteLakeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.listLakesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getLakeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLakeActionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createZoneSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.updateZoneSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.deleteZoneSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.listZonesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getZoneSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listZoneActionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createAssetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.updateAssetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.deleteAssetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.listAssetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getAssetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAssetActionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createTaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.updateTaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.deleteTaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.listTasksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getTaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.runTaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.cancelJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.createEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.updateEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.deleteEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.listEnvironmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSessionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createLakeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Lake.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateLakeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Lake.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteLakeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createZoneOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Zone.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateZoneOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Zone.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteZoneOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createAssetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Asset.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateAssetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Asset.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteAssetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createTaskOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Task.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateTaskOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Task.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteTaskOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createEnvironmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Environment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateEnvironmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Environment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteEnvironmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateLakeRequest, Operation> createLakeSettings() {
            return this.createLakeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateLakeRequest, Lake, OperationMetadata> createLakeOperationSettings() {
            return this.createLakeOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateLakeRequest, Operation> updateLakeSettings() {
            return this.updateLakeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateLakeRequest, Lake, OperationMetadata> updateLakeOperationSettings() {
            return this.updateLakeOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteLakeRequest, Operation> deleteLakeSettings() {
            return this.deleteLakeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteLakeRequest, Empty, OperationMetadata> deleteLakeOperationSettings() {
            return this.deleteLakeOperationSettings;
        }

        public PagedCallSettings.Builder<ListLakesRequest, ListLakesResponse, DataplexServiceClient.ListLakesPagedResponse> listLakesSettings() {
            return this.listLakesSettings;
        }

        public UnaryCallSettings.Builder<GetLakeRequest, Lake> getLakeSettings() {
            return this.getLakeSettings;
        }

        public PagedCallSettings.Builder<ListLakeActionsRequest, ListActionsResponse, DataplexServiceClient.ListLakeActionsPagedResponse> listLakeActionsSettings() {
            return this.listLakeActionsSettings;
        }

        public UnaryCallSettings.Builder<CreateZoneRequest, Operation> createZoneSettings() {
            return this.createZoneSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateZoneRequest, Zone, OperationMetadata> createZoneOperationSettings() {
            return this.createZoneOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateZoneRequest, Operation> updateZoneSettings() {
            return this.updateZoneSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateZoneRequest, Zone, OperationMetadata> updateZoneOperationSettings() {
            return this.updateZoneOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteZoneRequest, Operation> deleteZoneSettings() {
            return this.deleteZoneSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteZoneRequest, Empty, OperationMetadata> deleteZoneOperationSettings() {
            return this.deleteZoneOperationSettings;
        }

        public PagedCallSettings.Builder<ListZonesRequest, ListZonesResponse, DataplexServiceClient.ListZonesPagedResponse> listZonesSettings() {
            return this.listZonesSettings;
        }

        public UnaryCallSettings.Builder<GetZoneRequest, Zone> getZoneSettings() {
            return this.getZoneSettings;
        }

        public PagedCallSettings.Builder<ListZoneActionsRequest, ListActionsResponse, DataplexServiceClient.ListZoneActionsPagedResponse> listZoneActionsSettings() {
            return this.listZoneActionsSettings;
        }

        public UnaryCallSettings.Builder<CreateAssetRequest, Operation> createAssetSettings() {
            return this.createAssetSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateAssetRequest, Asset, OperationMetadata> createAssetOperationSettings() {
            return this.createAssetOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAssetRequest, Operation> updateAssetSettings() {
            return this.updateAssetSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateAssetRequest, Asset, OperationMetadata> updateAssetOperationSettings() {
            return this.updateAssetOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAssetRequest, Operation> deleteAssetSettings() {
            return this.deleteAssetSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteAssetRequest, Empty, OperationMetadata> deleteAssetOperationSettings() {
            return this.deleteAssetOperationSettings;
        }

        public PagedCallSettings.Builder<ListAssetsRequest, ListAssetsResponse, DataplexServiceClient.ListAssetsPagedResponse> listAssetsSettings() {
            return this.listAssetsSettings;
        }

        public UnaryCallSettings.Builder<GetAssetRequest, Asset> getAssetSettings() {
            return this.getAssetSettings;
        }

        public PagedCallSettings.Builder<ListAssetActionsRequest, ListActionsResponse, DataplexServiceClient.ListAssetActionsPagedResponse> listAssetActionsSettings() {
            return this.listAssetActionsSettings;
        }

        public UnaryCallSettings.Builder<CreateTaskRequest, Operation> createTaskSettings() {
            return this.createTaskSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateTaskRequest, Task, OperationMetadata> createTaskOperationSettings() {
            return this.createTaskOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateTaskRequest, Operation> updateTaskSettings() {
            return this.updateTaskSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateTaskRequest, Task, OperationMetadata> updateTaskOperationSettings() {
            return this.updateTaskOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteTaskRequest, Operation> deleteTaskSettings() {
            return this.deleteTaskSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteTaskRequest, Empty, OperationMetadata> deleteTaskOperationSettings() {
            return this.deleteTaskOperationSettings;
        }

        public PagedCallSettings.Builder<ListTasksRequest, ListTasksResponse, DataplexServiceClient.ListTasksPagedResponse> listTasksSettings() {
            return this.listTasksSettings;
        }

        public UnaryCallSettings.Builder<GetTaskRequest, Task> getTaskSettings() {
            return this.getTaskSettings;
        }

        public PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, DataplexServiceClient.ListJobsPagedResponse> listJobsSettings() {
            return this.listJobsSettings;
        }

        public UnaryCallSettings.Builder<RunTaskRequest, RunTaskResponse> runTaskSettings() {
            return this.runTaskSettings;
        }

        public UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings() {
            return this.getJobSettings;
        }

        public UnaryCallSettings.Builder<CancelJobRequest, Empty> cancelJobSettings() {
            return this.cancelJobSettings;
        }

        public UnaryCallSettings.Builder<CreateEnvironmentRequest, Operation> createEnvironmentSettings() {
            return this.createEnvironmentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings() {
            return this.createEnvironmentOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings() {
            return this.updateEnvironmentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationSettings() {
            return this.updateEnvironmentOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings() {
            return this.deleteEnvironmentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings() {
            return this.deleteEnvironmentOperationSettings;
        }

        public PagedCallSettings.Builder<ListEnvironmentsRequest, ListEnvironmentsResponse, DataplexServiceClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings() {
            return this.listEnvironmentsSettings;
        }

        public UnaryCallSettings.Builder<GetEnvironmentRequest, Environment> getEnvironmentSettings() {
            return this.getEnvironmentSettings;
        }

        public PagedCallSettings.Builder<ListSessionsRequest, ListSessionsResponse, DataplexServiceClient.ListSessionsPagedResponse> listSessionsSettings() {
            return this.listSessionsSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataplexServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public DataplexServiceStubSettings build() throws IOException {
            return new DataplexServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_6_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_6_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

