/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.Content;
import com.google.cloud.dataplex.v1.ContentServiceClient;
import com.google.cloud.dataplex.v1.CreateContentRequest;
import com.google.cloud.dataplex.v1.DeleteContentRequest;
import com.google.cloud.dataplex.v1.GetContentRequest;
import com.google.cloud.dataplex.v1.ListContentRequest;
import com.google.cloud.dataplex.v1.ListContentResponse;
import com.google.cloud.dataplex.v1.UpdateContentRequest;
import com.google.cloud.dataplex.v1.stub.ContentServiceStub;
import com.google.cloud.dataplex.v1.stub.ContentServiceStubSettings;
import com.google.cloud.dataplex.v1.stub.GrpcContentServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcContentServiceStub
extends ContentServiceStub {
    private static final MethodDescriptor<CreateContentRequest, Content> createContentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.ContentService/CreateContent").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateContentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Content.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateContentRequest, Content> updateContentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.ContentService/UpdateContent").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateContentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Content.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteContentRequest, Empty> deleteContentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.ContentService/DeleteContent").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteContentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetContentRequest, Content> getContentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.ContentService/GetContent").setRequestMarshaller(ProtoUtils.marshaller((Message)GetContentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Content.getDefaultInstance())).build();
    private static final MethodDescriptor<ListContentRequest, ListContentResponse> listContentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.ContentService/ListContent").setRequestMarshaller(ProtoUtils.marshaller((Message)ListContentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListContentResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateContentRequest, Content> createContentCallable;
    private final UnaryCallable<UpdateContentRequest, Content> updateContentCallable;
    private final UnaryCallable<DeleteContentRequest, Empty> deleteContentCallable;
    private final UnaryCallable<GetContentRequest, Content> getContentCallable;
    private final UnaryCallable<ListContentRequest, ListContentResponse> listContentCallable;
    private final UnaryCallable<ListContentRequest, ContentServiceClient.ListContentPagedResponse> listContentPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcContentServiceStub create(ContentServiceStubSettings settings) throws IOException {
        return new GrpcContentServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcContentServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcContentServiceStub(ContentServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcContentServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcContentServiceStub(ContentServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcContentServiceStub(ContentServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcContentServiceCallableFactory());
    }

    protected GrpcContentServiceStub(ContentServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createContentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createContentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateContentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateContentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"content.name", (Object)String.valueOf(request.getContent().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteContentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteContentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getContentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getContentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listContentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listContentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        this.createContentCallable = callableFactory.createUnaryCallable(createContentTransportSettings, settings.createContentSettings(), clientContext);
        this.updateContentCallable = callableFactory.createUnaryCallable(updateContentTransportSettings, settings.updateContentSettings(), clientContext);
        this.deleteContentCallable = callableFactory.createUnaryCallable(deleteContentTransportSettings, settings.deleteContentSettings(), clientContext);
        this.getContentCallable = callableFactory.createUnaryCallable(getContentTransportSettings, settings.getContentSettings(), clientContext);
        this.listContentCallable = callableFactory.createUnaryCallable(listContentTransportSettings, settings.listContentSettings(), clientContext);
        this.listContentPagedCallable = callableFactory.createPagedCallable(listContentTransportSettings, settings.listContentSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateContentRequest, Content> createContentCallable() {
        return this.createContentCallable;
    }

    @Override
    public UnaryCallable<UpdateContentRequest, Content> updateContentCallable() {
        return this.updateContentCallable;
    }

    @Override
    public UnaryCallable<DeleteContentRequest, Empty> deleteContentCallable() {
        return this.deleteContentCallable;
    }

    @Override
    public UnaryCallable<GetContentRequest, Content> getContentCallable() {
        return this.getContentCallable;
    }

    @Override
    public UnaryCallable<ListContentRequest, ListContentResponse> listContentCallable() {
        return this.listContentCallable;
    }

    @Override
    public UnaryCallable<ListContentRequest, ContentServiceClient.ListContentPagedResponse> listContentPagedCallable() {
        return this.listContentPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

