/*
 * Decompiled with CFR 0.152.
 */
package com.google.dataflow.v1beta3.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.dataflow.v1beta3.CheckActiveJobsRequest;
import com.google.dataflow.v1beta3.CheckActiveJobsResponse;
import com.google.dataflow.v1beta3.CreateJobRequest;
import com.google.dataflow.v1beta3.GetJobRequest;
import com.google.dataflow.v1beta3.Job;
import com.google.dataflow.v1beta3.JobsV1Beta3Client;
import com.google.dataflow.v1beta3.ListJobsRequest;
import com.google.dataflow.v1beta3.ListJobsResponse;
import com.google.dataflow.v1beta3.Snapshot;
import com.google.dataflow.v1beta3.SnapshotJobRequest;
import com.google.dataflow.v1beta3.UpdateJobRequest;
import com.google.dataflow.v1beta3.stub.HttpJsonJobsV1Beta3CallableFactory;
import com.google.dataflow.v1beta3.stub.JobsV1Beta3Stub;
import com.google.dataflow.v1beta3.stub.JobsV1Beta3StubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonJobsV1Beta3Stub
extends JobsV1Beta3Stub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateJobRequest, Job> createJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.dataflow.v1beta3.JobsV1Beta3/CreateJob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1b3/projects/{projectId}/locations/{location}/jobs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "location", (Object)request.getLocation());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1b3/projects/{projectId}/jobs"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "replaceJobId", (Object)request.getReplaceJobId());
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("job", (Message)request.getJob(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetJobRequest, Job> getJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.dataflow.v1beta3.JobsV1Beta3/GetJob").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "jobId", (Object)request.getJobId());
        serializer.putPathParam(fields, "location", (Object)request.getLocation());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1b3/projects/{projectId}/jobs/{jobId}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateJobRequest, Job> updateJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.dataflow.v1beta3.JobsV1Beta3/UpdateJob").setHttpMethod("PUT").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "jobId", (Object)request.getJobId());
        serializer.putPathParam(fields, "location", (Object)request.getLocation());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1b3/projects/{projectId}/jobs/{jobId}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("job", (Message)request.getJob(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListJobsRequest, ListJobsResponse> listJobsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.dataflow.v1beta3.JobsV1Beta3/ListJobs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1b3/projects/{projectId}/locations/{location}/jobs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "location", (Object)request.getLocation());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1b3/projects/{projectId}/jobs"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilterValue());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListJobsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListJobsRequest, ListJobsResponse> aggregatedListJobsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.dataflow.v1beta3.JobsV1Beta3/AggregatedListJobs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1b3/projects/{projectId}/jobs:aggregated", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilterValue());
        serializer.putQueryParam(fields, "location", (Object)request.getLocation());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListJobsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SnapshotJobRequest, Snapshot> snapshotJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.dataflow.v1beta3.JobsV1Beta3/SnapshotJob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}:snapshot", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "jobId", (Object)request.getJobId());
        serializer.putPathParam(fields, "location", (Object)request.getLocation());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1b3/projects/{projectId}/jobs/{jobId}:snapshot"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearJobId().clearLocation().clearProjectId().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Snapshot.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateJobRequest, Job> createJobCallable;
    private final UnaryCallable<GetJobRequest, Job> getJobCallable;
    private final UnaryCallable<UpdateJobRequest, Job> updateJobCallable;
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable;
    private final UnaryCallable<ListJobsRequest, JobsV1Beta3Client.ListJobsPagedResponse> listJobsPagedCallable;
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> aggregatedListJobsCallable;
    private final UnaryCallable<ListJobsRequest, JobsV1Beta3Client.AggregatedListJobsPagedResponse> aggregatedListJobsPagedCallable;
    private final UnaryCallable<SnapshotJobRequest, Snapshot> snapshotJobCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonJobsV1Beta3Stub create(JobsV1Beta3StubSettings settings) throws IOException {
        return new HttpJsonJobsV1Beta3Stub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonJobsV1Beta3Stub create(ClientContext clientContext) throws IOException {
        return new HttpJsonJobsV1Beta3Stub(JobsV1Beta3StubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonJobsV1Beta3Stub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonJobsV1Beta3Stub(JobsV1Beta3StubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonJobsV1Beta3Stub(JobsV1Beta3StubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonJobsV1Beta3CallableFactory());
    }

    protected HttpJsonJobsV1Beta3Stub(JobsV1Beta3StubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listJobsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listJobsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings aggregatedListJobsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListJobsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings snapshotJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(snapshotJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createJobCallable = callableFactory.createUnaryCallable(createJobTransportSettings, settings.createJobSettings(), clientContext);
        this.getJobCallable = callableFactory.createUnaryCallable(getJobTransportSettings, settings.getJobSettings(), clientContext);
        this.updateJobCallable = callableFactory.createUnaryCallable(updateJobTransportSettings, settings.updateJobSettings(), clientContext);
        this.listJobsCallable = callableFactory.createUnaryCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.listJobsPagedCallable = callableFactory.createPagedCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.aggregatedListJobsCallable = callableFactory.createUnaryCallable(aggregatedListJobsTransportSettings, settings.aggregatedListJobsSettings(), clientContext);
        this.aggregatedListJobsPagedCallable = callableFactory.createPagedCallable(aggregatedListJobsTransportSettings, settings.aggregatedListJobsSettings(), clientContext);
        this.snapshotJobCallable = callableFactory.createUnaryCallable(snapshotJobTransportSettings, settings.snapshotJobSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createJobMethodDescriptor);
        methodDescriptors.add(getJobMethodDescriptor);
        methodDescriptors.add(updateJobMethodDescriptor);
        methodDescriptors.add(listJobsMethodDescriptor);
        methodDescriptors.add(aggregatedListJobsMethodDescriptor);
        methodDescriptors.add(snapshotJobMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.createJobCallable;
    }

    @Override
    public UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.getJobCallable;
    }

    @Override
    public UnaryCallable<UpdateJobRequest, Job> updateJobCallable() {
        return this.updateJobCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.listJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, JobsV1Beta3Client.ListJobsPagedResponse> listJobsPagedCallable() {
        return this.listJobsPagedCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> aggregatedListJobsCallable() {
        return this.aggregatedListJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, JobsV1Beta3Client.AggregatedListJobsPagedResponse> aggregatedListJobsPagedCallable() {
        return this.aggregatedListJobsPagedCallable;
    }

    @Override
    public UnaryCallable<SnapshotJobRequest, Snapshot> snapshotJobCallable() {
        return this.snapshotJobCallable;
    }

    @Override
    public UnaryCallable<CheckActiveJobsRequest, CheckActiveJobsResponse> checkActiveJobsCallable() {
        throw new UnsupportedOperationException("Not implemented: checkActiveJobsCallable(). REST transport is not implemented for this method yet.");
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

