/*
 * Decompiled with CFR 0.152.
 */
package com.google.dataflow.v1beta3.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.dataflow.v1beta3.CheckActiveJobsRequest;
import com.google.dataflow.v1beta3.CheckActiveJobsResponse;
import com.google.dataflow.v1beta3.CreateJobRequest;
import com.google.dataflow.v1beta3.GetJobRequest;
import com.google.dataflow.v1beta3.Job;
import com.google.dataflow.v1beta3.JobsV1Beta3Client;
import com.google.dataflow.v1beta3.ListJobsRequest;
import com.google.dataflow.v1beta3.ListJobsResponse;
import com.google.dataflow.v1beta3.Snapshot;
import com.google.dataflow.v1beta3.SnapshotJobRequest;
import com.google.dataflow.v1beta3.UpdateJobRequest;
import com.google.dataflow.v1beta3.stub.GrpcJobsV1Beta3CallableFactory;
import com.google.dataflow.v1beta3.stub.JobsV1Beta3Stub;
import com.google.dataflow.v1beta3.stub.JobsV1Beta3StubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcJobsV1Beta3Stub
extends JobsV1Beta3Stub {
    private static final MethodDescriptor<CreateJobRequest, Job> createJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.dataflow.v1beta3.JobsV1Beta3/CreateJob").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<GetJobRequest, Job> getJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.dataflow.v1beta3.JobsV1Beta3/GetJob").setRequestMarshaller(ProtoUtils.marshaller((Message)GetJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateJobRequest, Job> updateJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.dataflow.v1beta3.JobsV1Beta3/UpdateJob").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<ListJobsRequest, ListJobsResponse> listJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.dataflow.v1beta3.JobsV1Beta3/ListJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListJobsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListJobsRequest, ListJobsResponse> aggregatedListJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.dataflow.v1beta3.JobsV1Beta3/AggregatedListJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListJobsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CheckActiveJobsRequest, CheckActiveJobsResponse> checkActiveJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.dataflow.v1beta3.JobsV1Beta3/CheckActiveJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)CheckActiveJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CheckActiveJobsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SnapshotJobRequest, Snapshot> snapshotJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.dataflow.v1beta3.JobsV1Beta3/SnapshotJob").setRequestMarshaller(ProtoUtils.marshaller((Message)SnapshotJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Snapshot.getDefaultInstance())).build();
    private final UnaryCallable<CreateJobRequest, Job> createJobCallable;
    private final UnaryCallable<GetJobRequest, Job> getJobCallable;
    private final UnaryCallable<UpdateJobRequest, Job> updateJobCallable;
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable;
    private final UnaryCallable<ListJobsRequest, JobsV1Beta3Client.ListJobsPagedResponse> listJobsPagedCallable;
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> aggregatedListJobsCallable;
    private final UnaryCallable<ListJobsRequest, JobsV1Beta3Client.AggregatedListJobsPagedResponse> aggregatedListJobsPagedCallable;
    private final UnaryCallable<CheckActiveJobsRequest, CheckActiveJobsResponse> checkActiveJobsCallable;
    private final UnaryCallable<SnapshotJobRequest, Snapshot> snapshotJobCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcJobsV1Beta3Stub create(JobsV1Beta3StubSettings settings) throws IOException {
        return new GrpcJobsV1Beta3Stub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcJobsV1Beta3Stub create(ClientContext clientContext) throws IOException {
        return new GrpcJobsV1Beta3Stub(JobsV1Beta3StubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcJobsV1Beta3Stub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcJobsV1Beta3Stub(JobsV1Beta3StubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcJobsV1Beta3Stub(JobsV1Beta3StubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcJobsV1Beta3CallableFactory());
    }

    protected GrpcJobsV1Beta3Stub(JobsV1Beta3StubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createJobMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"location", (Object)String.valueOf(request.getLocation()));
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            return params.build();
        }).build();
        GrpcCallSettings getJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getJobMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"job_id", (Object)String.valueOf(request.getJobId()));
            params.put((Object)"location", (Object)String.valueOf(request.getLocation()));
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            return params.build();
        }).build();
        GrpcCallSettings updateJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateJobMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"job_id", (Object)String.valueOf(request.getJobId()));
            params.put((Object)"location", (Object)String.valueOf(request.getLocation()));
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            return params.build();
        }).build();
        GrpcCallSettings listJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listJobsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"location", (Object)String.valueOf(request.getLocation()));
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            return params.build();
        }).build();
        GrpcCallSettings aggregatedListJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(aggregatedListJobsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            return params.build();
        }).build();
        GrpcCallSettings checkActiveJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(checkActiveJobsMethodDescriptor).build();
        GrpcCallSettings snapshotJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(snapshotJobMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"job_id", (Object)String.valueOf(request.getJobId()));
            params.put((Object)"location", (Object)String.valueOf(request.getLocation()));
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            return params.build();
        }).build();
        this.createJobCallable = callableFactory.createUnaryCallable(createJobTransportSettings, settings.createJobSettings(), clientContext);
        this.getJobCallable = callableFactory.createUnaryCallable(getJobTransportSettings, settings.getJobSettings(), clientContext);
        this.updateJobCallable = callableFactory.createUnaryCallable(updateJobTransportSettings, settings.updateJobSettings(), clientContext);
        this.listJobsCallable = callableFactory.createUnaryCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.listJobsPagedCallable = callableFactory.createPagedCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.aggregatedListJobsCallable = callableFactory.createUnaryCallable(aggregatedListJobsTransportSettings, settings.aggregatedListJobsSettings(), clientContext);
        this.aggregatedListJobsPagedCallable = callableFactory.createPagedCallable(aggregatedListJobsTransportSettings, settings.aggregatedListJobsSettings(), clientContext);
        this.checkActiveJobsCallable = callableFactory.createUnaryCallable(checkActiveJobsTransportSettings, settings.checkActiveJobsSettings(), clientContext);
        this.snapshotJobCallable = callableFactory.createUnaryCallable(snapshotJobTransportSettings, settings.snapshotJobSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.createJobCallable;
    }

    @Override
    public UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.getJobCallable;
    }

    @Override
    public UnaryCallable<UpdateJobRequest, Job> updateJobCallable() {
        return this.updateJobCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.listJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, JobsV1Beta3Client.ListJobsPagedResponse> listJobsPagedCallable() {
        return this.listJobsPagedCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> aggregatedListJobsCallable() {
        return this.aggregatedListJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, JobsV1Beta3Client.AggregatedListJobsPagedResponse> aggregatedListJobsPagedCallable() {
        return this.aggregatedListJobsPagedCallable;
    }

    @Override
    public UnaryCallable<CheckActiveJobsRequest, CheckActiveJobsResponse> checkActiveJobsCallable() {
        return this.checkActiveJobsCallable;
    }

    @Override
    public UnaryCallable<SnapshotJobRequest, Snapshot> snapshotJobCallable() {
        return this.snapshotJobCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

