/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.datacatalog.v1beta1.CreateEntryGroupRequest;
import com.google.cloud.datacatalog.v1beta1.CreateEntryRequest;
import com.google.cloud.datacatalog.v1beta1.CreateTagRequest;
import com.google.cloud.datacatalog.v1beta1.CreateTagTemplateFieldRequest;
import com.google.cloud.datacatalog.v1beta1.CreateTagTemplateRequest;
import com.google.cloud.datacatalog.v1beta1.DataCatalogSettings;
import com.google.cloud.datacatalog.v1beta1.DeleteEntryGroupRequest;
import com.google.cloud.datacatalog.v1beta1.DeleteEntryRequest;
import com.google.cloud.datacatalog.v1beta1.DeleteTagRequest;
import com.google.cloud.datacatalog.v1beta1.DeleteTagTemplateFieldRequest;
import com.google.cloud.datacatalog.v1beta1.DeleteTagTemplateRequest;
import com.google.cloud.datacatalog.v1beta1.Entry;
import com.google.cloud.datacatalog.v1beta1.EntryGroup;
import com.google.cloud.datacatalog.v1beta1.EntryGroupName;
import com.google.cloud.datacatalog.v1beta1.EntryName;
import com.google.cloud.datacatalog.v1beta1.GetEntryGroupRequest;
import com.google.cloud.datacatalog.v1beta1.GetEntryRequest;
import com.google.cloud.datacatalog.v1beta1.GetTagTemplateRequest;
import com.google.cloud.datacatalog.v1beta1.ListEntriesRequest;
import com.google.cloud.datacatalog.v1beta1.ListEntriesResponse;
import com.google.cloud.datacatalog.v1beta1.ListEntryGroupsRequest;
import com.google.cloud.datacatalog.v1beta1.ListEntryGroupsResponse;
import com.google.cloud.datacatalog.v1beta1.ListTagsRequest;
import com.google.cloud.datacatalog.v1beta1.ListTagsResponse;
import com.google.cloud.datacatalog.v1beta1.LocationName;
import com.google.cloud.datacatalog.v1beta1.LookupEntryRequest;
import com.google.cloud.datacatalog.v1beta1.RenameTagTemplateFieldRequest;
import com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest;
import com.google.cloud.datacatalog.v1beta1.SearchCatalogResponse;
import com.google.cloud.datacatalog.v1beta1.SearchCatalogResult;
import com.google.cloud.datacatalog.v1beta1.Tag;
import com.google.cloud.datacatalog.v1beta1.TagName;
import com.google.cloud.datacatalog.v1beta1.TagTemplate;
import com.google.cloud.datacatalog.v1beta1.TagTemplateField;
import com.google.cloud.datacatalog.v1beta1.TagTemplateFieldName;
import com.google.cloud.datacatalog.v1beta1.TagTemplateName;
import com.google.cloud.datacatalog.v1beta1.UpdateEntryGroupRequest;
import com.google.cloud.datacatalog.v1beta1.UpdateEntryRequest;
import com.google.cloud.datacatalog.v1beta1.UpdateTagRequest;
import com.google.cloud.datacatalog.v1beta1.UpdateTagTemplateFieldRequest;
import com.google.cloud.datacatalog.v1beta1.UpdateTagTemplateRequest;
import com.google.cloud.datacatalog.v1beta1.stub.DataCatalogStub;
import com.google.cloud.datacatalog.v1beta1.stub.DataCatalogStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DataCatalogClient
implements BackgroundResource {
    private final DataCatalogSettings settings;
    private final DataCatalogStub stub;

    public static final DataCatalogClient create() throws IOException {
        return DataCatalogClient.create(DataCatalogSettings.newBuilder().build());
    }

    public static final DataCatalogClient create(DataCatalogSettings settings) throws IOException {
        return new DataCatalogClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DataCatalogClient create(DataCatalogStub stub) {
        return new DataCatalogClient(stub);
    }

    protected DataCatalogClient(DataCatalogSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataCatalogStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DataCatalogClient(DataCatalogStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DataCatalogSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DataCatalogStub getStub() {
        return this.stub;
    }

    public final SearchCatalogPagedResponse searchCatalog(SearchCatalogRequest.Scope scope, String query) {
        SearchCatalogRequest request = SearchCatalogRequest.newBuilder().setScope(scope).setQuery(query).build();
        return this.searchCatalog(request);
    }

    public final SearchCatalogPagedResponse searchCatalog(SearchCatalogRequest request) {
        return (SearchCatalogPagedResponse)((Object)this.searchCatalogPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchCatalogRequest, SearchCatalogPagedResponse> searchCatalogPagedCallable() {
        return this.stub.searchCatalogPagedCallable();
    }

    public final UnaryCallable<SearchCatalogRequest, SearchCatalogResponse> searchCatalogCallable() {
        return this.stub.searchCatalogCallable();
    }

    public final EntryGroup createEntryGroup(LocationName parent, String entryGroupId, EntryGroup entryGroup) {
        CreateEntryGroupRequest request = CreateEntryGroupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEntryGroupId(entryGroupId).setEntryGroup(entryGroup).build();
        return this.createEntryGroup(request);
    }

    public final EntryGroup createEntryGroup(String parent, String entryGroupId, EntryGroup entryGroup) {
        CreateEntryGroupRequest request = CreateEntryGroupRequest.newBuilder().setParent(parent).setEntryGroupId(entryGroupId).setEntryGroup(entryGroup).build();
        return this.createEntryGroup(request);
    }

    public final EntryGroup createEntryGroup(CreateEntryGroupRequest request) {
        return (EntryGroup)this.createEntryGroupCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEntryGroupRequest, EntryGroup> createEntryGroupCallable() {
        return this.stub.createEntryGroupCallable();
    }

    public final EntryGroup updateEntryGroup(EntryGroup entryGroup) {
        UpdateEntryGroupRequest request = UpdateEntryGroupRequest.newBuilder().setEntryGroup(entryGroup).build();
        return this.updateEntryGroup(request);
    }

    public final EntryGroup updateEntryGroup(EntryGroup entryGroup, FieldMask updateMask) {
        UpdateEntryGroupRequest request = UpdateEntryGroupRequest.newBuilder().setEntryGroup(entryGroup).setUpdateMask(updateMask).build();
        return this.updateEntryGroup(request);
    }

    public final EntryGroup updateEntryGroup(UpdateEntryGroupRequest request) {
        return (EntryGroup)this.updateEntryGroupCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEntryGroupRequest, EntryGroup> updateEntryGroupCallable() {
        return this.stub.updateEntryGroupCallable();
    }

    public final EntryGroup getEntryGroup(EntryGroupName name) {
        GetEntryGroupRequest request = GetEntryGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEntryGroup(request);
    }

    public final EntryGroup getEntryGroup(String name) {
        GetEntryGroupRequest request = GetEntryGroupRequest.newBuilder().setName(name).build();
        return this.getEntryGroup(request);
    }

    public final EntryGroup getEntryGroup(EntryGroupName name, FieldMask readMask) {
        GetEntryGroupRequest request = GetEntryGroupRequest.newBuilder().setName(name == null ? null : name.toString()).setReadMask(readMask).build();
        return this.getEntryGroup(request);
    }

    public final EntryGroup getEntryGroup(String name, FieldMask readMask) {
        GetEntryGroupRequest request = GetEntryGroupRequest.newBuilder().setName(name).setReadMask(readMask).build();
        return this.getEntryGroup(request);
    }

    public final EntryGroup getEntryGroup(GetEntryGroupRequest request) {
        return (EntryGroup)this.getEntryGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntryGroupRequest, EntryGroup> getEntryGroupCallable() {
        return this.stub.getEntryGroupCallable();
    }

    public final void deleteEntryGroup(EntryGroupName name) {
        DeleteEntryGroupRequest request = DeleteEntryGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteEntryGroup(request);
    }

    public final void deleteEntryGroup(String name) {
        DeleteEntryGroupRequest request = DeleteEntryGroupRequest.newBuilder().setName(name).build();
        this.deleteEntryGroup(request);
    }

    public final void deleteEntryGroup(DeleteEntryGroupRequest request) {
        this.deleteEntryGroupCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEntryGroupRequest, Empty> deleteEntryGroupCallable() {
        return this.stub.deleteEntryGroupCallable();
    }

    public final ListEntryGroupsPagedResponse listEntryGroups(EntryGroupName parent) {
        ListEntryGroupsRequest request = ListEntryGroupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntryGroups(request);
    }

    public final ListEntryGroupsPagedResponse listEntryGroups(String parent) {
        ListEntryGroupsRequest request = ListEntryGroupsRequest.newBuilder().setParent(parent).build();
        return this.listEntryGroups(request);
    }

    public final ListEntryGroupsPagedResponse listEntryGroups(ListEntryGroupsRequest request) {
        return (ListEntryGroupsPagedResponse)((Object)this.listEntryGroupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntryGroupsRequest, ListEntryGroupsPagedResponse> listEntryGroupsPagedCallable() {
        return this.stub.listEntryGroupsPagedCallable();
    }

    public final UnaryCallable<ListEntryGroupsRequest, ListEntryGroupsResponse> listEntryGroupsCallable() {
        return this.stub.listEntryGroupsCallable();
    }

    public final Entry createEntry(EntryGroupName parent, String entryId, Entry entry) {
        CreateEntryRequest request = CreateEntryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEntryId(entryId).setEntry(entry).build();
        return this.createEntry(request);
    }

    public final Entry createEntry(String parent, String entryId, Entry entry) {
        CreateEntryRequest request = CreateEntryRequest.newBuilder().setParent(parent).setEntryId(entryId).setEntry(entry).build();
        return this.createEntry(request);
    }

    public final Entry createEntry(CreateEntryRequest request) {
        return (Entry)this.createEntryCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEntryRequest, Entry> createEntryCallable() {
        return this.stub.createEntryCallable();
    }

    public final Entry updateEntry(Entry entry) {
        UpdateEntryRequest request = UpdateEntryRequest.newBuilder().setEntry(entry).build();
        return this.updateEntry(request);
    }

    public final Entry updateEntry(Entry entry, FieldMask updateMask) {
        UpdateEntryRequest request = UpdateEntryRequest.newBuilder().setEntry(entry).setUpdateMask(updateMask).build();
        return this.updateEntry(request);
    }

    public final Entry updateEntry(UpdateEntryRequest request) {
        return (Entry)this.updateEntryCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEntryRequest, Entry> updateEntryCallable() {
        return this.stub.updateEntryCallable();
    }

    public final void deleteEntry(EntryName name) {
        DeleteEntryRequest request = DeleteEntryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteEntry(request);
    }

    public final void deleteEntry(String name) {
        DeleteEntryRequest request = DeleteEntryRequest.newBuilder().setName(name).build();
        this.deleteEntry(request);
    }

    public final void deleteEntry(DeleteEntryRequest request) {
        this.deleteEntryCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEntryRequest, Empty> deleteEntryCallable() {
        return this.stub.deleteEntryCallable();
    }

    public final Entry getEntry(EntryName name) {
        GetEntryRequest request = GetEntryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEntry(request);
    }

    public final Entry getEntry(String name) {
        GetEntryRequest request = GetEntryRequest.newBuilder().setName(name).build();
        return this.getEntry(request);
    }

    public final Entry getEntry(GetEntryRequest request) {
        return (Entry)this.getEntryCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntryRequest, Entry> getEntryCallable() {
        return this.stub.getEntryCallable();
    }

    public final Entry lookupEntry(LookupEntryRequest request) {
        return (Entry)this.lookupEntryCallable().call((Object)request);
    }

    public final UnaryCallable<LookupEntryRequest, Entry> lookupEntryCallable() {
        return this.stub.lookupEntryCallable();
    }

    public final ListEntriesPagedResponse listEntries(EntryGroupName parent) {
        ListEntriesRequest request = ListEntriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntries(request);
    }

    public final ListEntriesPagedResponse listEntries(String parent) {
        ListEntriesRequest request = ListEntriesRequest.newBuilder().setParent(parent).build();
        return this.listEntries(request);
    }

    public final ListEntriesPagedResponse listEntries(ListEntriesRequest request) {
        return (ListEntriesPagedResponse)((Object)this.listEntriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntriesRequest, ListEntriesPagedResponse> listEntriesPagedCallable() {
        return this.stub.listEntriesPagedCallable();
    }

    public final UnaryCallable<ListEntriesRequest, ListEntriesResponse> listEntriesCallable() {
        return this.stub.listEntriesCallable();
    }

    public final TagTemplate createTagTemplate(LocationName parent, String tagTemplateId, TagTemplate tagTemplate) {
        CreateTagTemplateRequest request = CreateTagTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTagTemplateId(tagTemplateId).setTagTemplate(tagTemplate).build();
        return this.createTagTemplate(request);
    }

    public final TagTemplate createTagTemplate(String parent, String tagTemplateId, TagTemplate tagTemplate) {
        CreateTagTemplateRequest request = CreateTagTemplateRequest.newBuilder().setParent(parent).setTagTemplateId(tagTemplateId).setTagTemplate(tagTemplate).build();
        return this.createTagTemplate(request);
    }

    public final TagTemplate createTagTemplate(CreateTagTemplateRequest request) {
        return (TagTemplate)this.createTagTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTagTemplateRequest, TagTemplate> createTagTemplateCallable() {
        return this.stub.createTagTemplateCallable();
    }

    public final TagTemplate getTagTemplate(TagTemplateName name) {
        GetTagTemplateRequest request = GetTagTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTagTemplate(request);
    }

    public final TagTemplate getTagTemplate(String name) {
        GetTagTemplateRequest request = GetTagTemplateRequest.newBuilder().setName(name).build();
        return this.getTagTemplate(request);
    }

    public final TagTemplate getTagTemplate(GetTagTemplateRequest request) {
        return (TagTemplate)this.getTagTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<GetTagTemplateRequest, TagTemplate> getTagTemplateCallable() {
        return this.stub.getTagTemplateCallable();
    }

    public final TagTemplate updateTagTemplate(TagTemplate tagTemplate) {
        UpdateTagTemplateRequest request = UpdateTagTemplateRequest.newBuilder().setTagTemplate(tagTemplate).build();
        return this.updateTagTemplate(request);
    }

    public final TagTemplate updateTagTemplate(TagTemplate tagTemplate, FieldMask updateMask) {
        UpdateTagTemplateRequest request = UpdateTagTemplateRequest.newBuilder().setTagTemplate(tagTemplate).setUpdateMask(updateMask).build();
        return this.updateTagTemplate(request);
    }

    public final TagTemplate updateTagTemplate(UpdateTagTemplateRequest request) {
        return (TagTemplate)this.updateTagTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTagTemplateRequest, TagTemplate> updateTagTemplateCallable() {
        return this.stub.updateTagTemplateCallable();
    }

    public final void deleteTagTemplate(TagTemplateName name, boolean force) {
        DeleteTagTemplateRequest request = DeleteTagTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).setForce(force).build();
        this.deleteTagTemplate(request);
    }

    public final void deleteTagTemplate(String name, boolean force) {
        DeleteTagTemplateRequest request = DeleteTagTemplateRequest.newBuilder().setName(name).setForce(force).build();
        this.deleteTagTemplate(request);
    }

    public final void deleteTagTemplate(DeleteTagTemplateRequest request) {
        this.deleteTagTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTagTemplateRequest, Empty> deleteTagTemplateCallable() {
        return this.stub.deleteTagTemplateCallable();
    }

    public final TagTemplateField createTagTemplateField(TagTemplateName parent, String tagTemplateFieldId, TagTemplateField tagTemplateField) {
        CreateTagTemplateFieldRequest request = CreateTagTemplateFieldRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTagTemplateFieldId(tagTemplateFieldId).setTagTemplateField(tagTemplateField).build();
        return this.createTagTemplateField(request);
    }

    public final TagTemplateField createTagTemplateField(String parent, String tagTemplateFieldId, TagTemplateField tagTemplateField) {
        CreateTagTemplateFieldRequest request = CreateTagTemplateFieldRequest.newBuilder().setParent(parent).setTagTemplateFieldId(tagTemplateFieldId).setTagTemplateField(tagTemplateField).build();
        return this.createTagTemplateField(request);
    }

    public final TagTemplateField createTagTemplateField(CreateTagTemplateFieldRequest request) {
        return (TagTemplateField)this.createTagTemplateFieldCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTagTemplateFieldRequest, TagTemplateField> createTagTemplateFieldCallable() {
        return this.stub.createTagTemplateFieldCallable();
    }

    public final TagTemplateField updateTagTemplateField(TagTemplateFieldName name, TagTemplateField tagTemplateField) {
        UpdateTagTemplateFieldRequest request = UpdateTagTemplateFieldRequest.newBuilder().setName(name == null ? null : name.toString()).setTagTemplateField(tagTemplateField).build();
        return this.updateTagTemplateField(request);
    }

    public final TagTemplateField updateTagTemplateField(String name, TagTemplateField tagTemplateField) {
        UpdateTagTemplateFieldRequest request = UpdateTagTemplateFieldRequest.newBuilder().setName(name).setTagTemplateField(tagTemplateField).build();
        return this.updateTagTemplateField(request);
    }

    public final TagTemplateField updateTagTemplateField(TagTemplateFieldName name, TagTemplateField tagTemplateField, FieldMask updateMask) {
        UpdateTagTemplateFieldRequest request = UpdateTagTemplateFieldRequest.newBuilder().setName(name == null ? null : name.toString()).setTagTemplateField(tagTemplateField).setUpdateMask(updateMask).build();
        return this.updateTagTemplateField(request);
    }

    public final TagTemplateField updateTagTemplateField(String name, TagTemplateField tagTemplateField, FieldMask updateMask) {
        UpdateTagTemplateFieldRequest request = UpdateTagTemplateFieldRequest.newBuilder().setName(name).setTagTemplateField(tagTemplateField).setUpdateMask(updateMask).build();
        return this.updateTagTemplateField(request);
    }

    public final TagTemplateField updateTagTemplateField(UpdateTagTemplateFieldRequest request) {
        return (TagTemplateField)this.updateTagTemplateFieldCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTagTemplateFieldRequest, TagTemplateField> updateTagTemplateFieldCallable() {
        return this.stub.updateTagTemplateFieldCallable();
    }

    public final TagTemplateField renameTagTemplateField(TagTemplateFieldName name, String newTagTemplateFieldId) {
        RenameTagTemplateFieldRequest request = RenameTagTemplateFieldRequest.newBuilder().setName(name == null ? null : name.toString()).setNewTagTemplateFieldId(newTagTemplateFieldId).build();
        return this.renameTagTemplateField(request);
    }

    public final TagTemplateField renameTagTemplateField(String name, String newTagTemplateFieldId) {
        RenameTagTemplateFieldRequest request = RenameTagTemplateFieldRequest.newBuilder().setName(name).setNewTagTemplateFieldId(newTagTemplateFieldId).build();
        return this.renameTagTemplateField(request);
    }

    public final TagTemplateField renameTagTemplateField(RenameTagTemplateFieldRequest request) {
        return (TagTemplateField)this.renameTagTemplateFieldCallable().call((Object)request);
    }

    public final UnaryCallable<RenameTagTemplateFieldRequest, TagTemplateField> renameTagTemplateFieldCallable() {
        return this.stub.renameTagTemplateFieldCallable();
    }

    public final void deleteTagTemplateField(TagTemplateFieldName name, boolean force) {
        DeleteTagTemplateFieldRequest request = DeleteTagTemplateFieldRequest.newBuilder().setName(name == null ? null : name.toString()).setForce(force).build();
        this.deleteTagTemplateField(request);
    }

    public final void deleteTagTemplateField(String name, boolean force) {
        DeleteTagTemplateFieldRequest request = DeleteTagTemplateFieldRequest.newBuilder().setName(name).setForce(force).build();
        this.deleteTagTemplateField(request);
    }

    public final void deleteTagTemplateField(DeleteTagTemplateFieldRequest request) {
        this.deleteTagTemplateFieldCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTagTemplateFieldRequest, Empty> deleteTagTemplateFieldCallable() {
        return this.stub.deleteTagTemplateFieldCallable();
    }

    public final Tag createTag(TagName parent, Tag tag) {
        CreateTagRequest request = CreateTagRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTag(tag).build();
        return this.createTag(request);
    }

    public final Tag createTag(String parent, Tag tag) {
        CreateTagRequest request = CreateTagRequest.newBuilder().setParent(parent).setTag(tag).build();
        return this.createTag(request);
    }

    public final Tag createTag(CreateTagRequest request) {
        return (Tag)this.createTagCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTagRequest, Tag> createTagCallable() {
        return this.stub.createTagCallable();
    }

    public final Tag updateTag(Tag tag) {
        UpdateTagRequest request = UpdateTagRequest.newBuilder().setTag(tag).build();
        return this.updateTag(request);
    }

    public final Tag updateTag(Tag tag, FieldMask updateMask) {
        UpdateTagRequest request = UpdateTagRequest.newBuilder().setTag(tag).setUpdateMask(updateMask).build();
        return this.updateTag(request);
    }

    public final Tag updateTag(UpdateTagRequest request) {
        return (Tag)this.updateTagCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTagRequest, Tag> updateTagCallable() {
        return this.stub.updateTagCallable();
    }

    public final void deleteTag(EntryName name) {
        DeleteTagRequest request = DeleteTagRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTag(request);
    }

    public final void deleteTag(String name) {
        DeleteTagRequest request = DeleteTagRequest.newBuilder().setName(name).build();
        this.deleteTag(request);
    }

    public final void deleteTag(DeleteTagRequest request) {
        this.deleteTagCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTagRequest, Empty> deleteTagCallable() {
        return this.stub.deleteTagCallable();
    }

    public final ListTagsPagedResponse listTags(EntryName parent) {
        ListTagsRequest request = ListTagsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTags(request);
    }

    public final ListTagsPagedResponse listTags(String parent) {
        ListTagsRequest request = ListTagsRequest.newBuilder().setParent(parent).build();
        return this.listTags(request);
    }

    public final ListTagsPagedResponse listTags(ListTagsRequest request) {
        return (ListTagsPagedResponse)((Object)this.listTagsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTagsRequest, ListTagsPagedResponse> listTagsPagedCallable() {
        return this.stub.listTagsPagedCallable();
    }

    public final UnaryCallable<ListTagsRequest, ListTagsResponse> listTagsCallable() {
        return this.stub.listTagsCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTagsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTagsRequest, ListTagsResponse, Tag, ListTagsPage, ListTagsFixedSizeCollection> {
        private ListTagsFixedSizeCollection(List<ListTagsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTagsFixedSizeCollection createEmptyCollection() {
            return new ListTagsFixedSizeCollection(null, 0);
        }

        protected ListTagsFixedSizeCollection createCollection(List<ListTagsPage> pages, int collectionSize) {
            return new ListTagsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTagsPage
    extends AbstractPage<ListTagsRequest, ListTagsResponse, Tag, ListTagsPage> {
        private ListTagsPage(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ListTagsResponse response) {
            super(context, (Object)response);
        }

        private static ListTagsPage createEmptyPage() {
            return new ListTagsPage(null, null);
        }

        protected ListTagsPage createPage(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ListTagsResponse response) {
            return new ListTagsPage(context, response);
        }

        public ApiFuture<ListTagsPage> createPageAsync(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ApiFuture<ListTagsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTagsPagedResponse
    extends AbstractPagedListResponse<ListTagsRequest, ListTagsResponse, Tag, ListTagsPage, ListTagsFixedSizeCollection> {
        public static ApiFuture<ListTagsPagedResponse> createAsync(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ApiFuture<ListTagsResponse> futureResponse) {
            ApiFuture<ListTagsPage> futurePage = ListTagsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTagsPage, ListTagsPagedResponse>(){

                public ListTagsPagedResponse apply(ListTagsPage input) {
                    return new ListTagsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTagsPagedResponse(ListTagsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTagsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEntriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEntriesRequest, ListEntriesResponse, Entry, ListEntriesPage, ListEntriesFixedSizeCollection> {
        private ListEntriesFixedSizeCollection(List<ListEntriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEntriesFixedSizeCollection createEmptyCollection() {
            return new ListEntriesFixedSizeCollection(null, 0);
        }

        protected ListEntriesFixedSizeCollection createCollection(List<ListEntriesPage> pages, int collectionSize) {
            return new ListEntriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEntriesPage
    extends AbstractPage<ListEntriesRequest, ListEntriesResponse, Entry, ListEntriesPage> {
        private ListEntriesPage(PageContext<ListEntriesRequest, ListEntriesResponse, Entry> context, ListEntriesResponse response) {
            super(context, (Object)response);
        }

        private static ListEntriesPage createEmptyPage() {
            return new ListEntriesPage(null, null);
        }

        protected ListEntriesPage createPage(PageContext<ListEntriesRequest, ListEntriesResponse, Entry> context, ListEntriesResponse response) {
            return new ListEntriesPage(context, response);
        }

        public ApiFuture<ListEntriesPage> createPageAsync(PageContext<ListEntriesRequest, ListEntriesResponse, Entry> context, ApiFuture<ListEntriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEntriesPagedResponse
    extends AbstractPagedListResponse<ListEntriesRequest, ListEntriesResponse, Entry, ListEntriesPage, ListEntriesFixedSizeCollection> {
        public static ApiFuture<ListEntriesPagedResponse> createAsync(PageContext<ListEntriesRequest, ListEntriesResponse, Entry> context, ApiFuture<ListEntriesResponse> futureResponse) {
            ApiFuture<ListEntriesPage> futurePage = ListEntriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListEntriesPage, ListEntriesPagedResponse>(){

                public ListEntriesPagedResponse apply(ListEntriesPage input) {
                    return new ListEntriesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListEntriesPagedResponse(ListEntriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEntriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEntryGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup, ListEntryGroupsPage, ListEntryGroupsFixedSizeCollection> {
        private ListEntryGroupsFixedSizeCollection(List<ListEntryGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEntryGroupsFixedSizeCollection createEmptyCollection() {
            return new ListEntryGroupsFixedSizeCollection(null, 0);
        }

        protected ListEntryGroupsFixedSizeCollection createCollection(List<ListEntryGroupsPage> pages, int collectionSize) {
            return new ListEntryGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEntryGroupsPage
    extends AbstractPage<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup, ListEntryGroupsPage> {
        private ListEntryGroupsPage(PageContext<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup> context, ListEntryGroupsResponse response) {
            super(context, (Object)response);
        }

        private static ListEntryGroupsPage createEmptyPage() {
            return new ListEntryGroupsPage(null, null);
        }

        protected ListEntryGroupsPage createPage(PageContext<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup> context, ListEntryGroupsResponse response) {
            return new ListEntryGroupsPage(context, response);
        }

        public ApiFuture<ListEntryGroupsPage> createPageAsync(PageContext<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup> context, ApiFuture<ListEntryGroupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEntryGroupsPagedResponse
    extends AbstractPagedListResponse<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup, ListEntryGroupsPage, ListEntryGroupsFixedSizeCollection> {
        public static ApiFuture<ListEntryGroupsPagedResponse> createAsync(PageContext<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup> context, ApiFuture<ListEntryGroupsResponse> futureResponse) {
            ApiFuture<ListEntryGroupsPage> futurePage = ListEntryGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListEntryGroupsPage, ListEntryGroupsPagedResponse>(){

                public ListEntryGroupsPagedResponse apply(ListEntryGroupsPage input) {
                    return new ListEntryGroupsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListEntryGroupsPagedResponse(ListEntryGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEntryGroupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchCatalogFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult, SearchCatalogPage, SearchCatalogFixedSizeCollection> {
        private SearchCatalogFixedSizeCollection(List<SearchCatalogPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchCatalogFixedSizeCollection createEmptyCollection() {
            return new SearchCatalogFixedSizeCollection(null, 0);
        }

        protected SearchCatalogFixedSizeCollection createCollection(List<SearchCatalogPage> pages, int collectionSize) {
            return new SearchCatalogFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchCatalogPage
    extends AbstractPage<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult, SearchCatalogPage> {
        private SearchCatalogPage(PageContext<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult> context, SearchCatalogResponse response) {
            super(context, (Object)response);
        }

        private static SearchCatalogPage createEmptyPage() {
            return new SearchCatalogPage(null, null);
        }

        protected SearchCatalogPage createPage(PageContext<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult> context, SearchCatalogResponse response) {
            return new SearchCatalogPage(context, response);
        }

        public ApiFuture<SearchCatalogPage> createPageAsync(PageContext<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult> context, ApiFuture<SearchCatalogResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchCatalogPagedResponse
    extends AbstractPagedListResponse<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult, SearchCatalogPage, SearchCatalogFixedSizeCollection> {
        public static ApiFuture<SearchCatalogPagedResponse> createAsync(PageContext<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult> context, ApiFuture<SearchCatalogResponse> futureResponse) {
            ApiFuture<SearchCatalogPage> futurePage = SearchCatalogPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<SearchCatalogPage, SearchCatalogPagedResponse>(){

                public SearchCatalogPagedResponse apply(SearchCatalogPage input) {
                    return new SearchCatalogPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private SearchCatalogPagedResponse(SearchCatalogPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchCatalogFixedSizeCollection.createEmptyCollection());
        }
    }
}

