/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.datacatalog.Entry;
import com.google.cloud.datacatalog.LookupEntryRequest;
import com.google.cloud.datacatalog.v1beta1.DataCatalogSettings;
import com.google.cloud.datacatalog.v1beta1.stub.DataCatalogStub;
import com.google.cloud.datacatalog.v1beta1.stub.DataCatalogStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DataCatalogClient
implements BackgroundResource {
    private final DataCatalogSettings settings;
    private final DataCatalogStub stub;
    private static final PathTemplate ENTRY_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}");
    private static final PathTemplate LOCATION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}");

    @Deprecated
    public static final String formatEntryName(String project, String location, String entryGroup, String entry) {
        return ENTRY_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "entry_group", entryGroup, "entry", entry});
    }

    @Deprecated
    public static final String formatLocationName(String project, String location) {
        return LOCATION_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location});
    }

    @Deprecated
    public static final String parseProjectFromEntryName(String entryName) {
        return ENTRY_PATH_TEMPLATE.parse(entryName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromEntryName(String entryName) {
        return ENTRY_PATH_TEMPLATE.parse(entryName).get((Object)"location");
    }

    @Deprecated
    public static final String parseEntryGroupFromEntryName(String entryName) {
        return ENTRY_PATH_TEMPLATE.parse(entryName).get((Object)"entry_group");
    }

    @Deprecated
    public static final String parseEntryFromEntryName(String entryName) {
        return ENTRY_PATH_TEMPLATE.parse(entryName).get((Object)"entry");
    }

    @Deprecated
    public static final String parseProjectFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"location");
    }

    public static final DataCatalogClient create() throws IOException {
        return DataCatalogClient.create(DataCatalogSettings.newBuilder().build());
    }

    public static final DataCatalogClient create(DataCatalogSettings settings) throws IOException {
        return new DataCatalogClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DataCatalogClient create(DataCatalogStub stub) {
        return new DataCatalogClient(stub);
    }

    protected DataCatalogClient(DataCatalogSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataCatalogStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DataCatalogClient(DataCatalogStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DataCatalogSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DataCatalogStub getStub() {
        return this.stub;
    }

    public final Entry lookupEntry(LookupEntryRequest request) {
        return (Entry)this.lookupEntryCallable().call((Object)request);
    }

    public final UnaryCallable<LookupEntryRequest, Entry> lookupEntryCallable() {
        return this.stub.lookupEntryCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

